% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairmi.R
\name{pairmi}
\alias{pairmi}
\title{pairmi}
\usage{
pairmi(data, alpha = 0.05, MI.threshold = NULL, n_elements = 5, sep = "_")
}
\arguments{
\item{data}{A data frame containing the variables to be paired/combined.
Columns should be binary.}

\item{alpha}{Numeric p-value threshold for significance (default used by the
implementation if not supplied).}

\item{MI.threshold}{Numeric mutual information threshold. If provided, it
overrides `alpha`-based filtering.}

\item{n_elements}{Integer giving the maximum size of sets to evaluate (e.g.,
`2` for pairs, `3` for triplets). Must be >= 2.}

\item{sep}{String used to join variable names when forming set identifiers
(e.g., `"_"`).}
}
\value{
A list with the following components:
\describe{
  \item{expanded.data}{A data frame containing the original variables and the
    columns for significant sets (e.g., pair/triplet indicators).}
  \item{original.variables}{Character vector of the original variable names.}
  \item{sets}{A data frame describing significant sets, including their
    members, size, MI, G statistic, p-value, and constructed name.}
}
}
\description{
A function that calculates the mutual information for sets of
  variables, calculates the G statistic, determines the significance of the
  sets, and only keeps those that are significant.
}
\examples{
pairmi(misimdata[,2:6])
}
