% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_prob.R
\name{plot_prob}
\alias{plot_prob}
\title{plot_prob}
\usage{
plot_prob(
  data,
  y_var,
  x_vars,
  var_labels = NULL,
  prob_digits = 2,
  method = "conditional",
  title = NULL,
  vertex_color = "lightblue",
  vertex_frame_color = "darkblue",
  vertex_label_color = "black",
  edge_color = "darkgrey",
  edge_label_color = "black",
  min_arrow_width = 1,
  max_arrow_width = 10,
  node_size = 45,
  label_cex = 0.8
)
}
\arguments{
\item{data}{A data frame containing the outcome (`y_var`) and predictors
(`x_vars`).}

\item{y_var}{Character string giving the name of the outcome variable in
`data`.}

\item{x_vars}{Character vector of predictor variable names in `data`.}

\item{var_labels}{Optional character vector of display labels for the
predictors. Must match the length of `x_vars`.}

\item{prob_digits}{Integer; number of decimal places to round conditional
probabilities. Defaults to `2`.}

\item{method}{Character string indicating how to quantify associations:
`"prob"` for conditional probabilities or `"logistic"` for logistic
regression effects.}

\item{title}{Character string; title of the plot.}

\item{vertex_color}{Character string giving the fill color of nodes.}

\item{vertex_frame_color}{Character string giving the color of node borders.}

\item{vertex_label_color}{Character string giving the color of node labels.}

\item{edge_color}{Character string giving the color of edges.}

\item{edge_label_color}{Character string giving the color of edge labels.}

\item{min_arrow_width}{Numeric value for the minimum edge width.}

\item{max_arrow_width}{Numeric value for the maximum edge width.}

\item{node_size}{Numeric value controlling the size of nodes.}

\item{label_cex}{Numeric value controlling the size of node labels.}
}
\value{
A graph object (typically an [`igraph::igraph`] object or similar) is
returned and plotted. Nodes represent variables and edges represent
associations. Node labels include variable names and marginal probabilities.
Edge labels display either conditional probabilities or logistic regression
effects.
}
\description{
Creates a network-style graph showing how a set of predictors
(`x_vars`) are related to an outcome (`y_var`). Relationships can be
displayed either as conditional probabilities or as effects estimated by
logistic regression.
}
\examples{
plot_prob(misimdata,'y',colnames(misimdata[,3:6]),method='logistic')
}
