% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approach_vaeac.R
\name{vaeac_get_save_file_names}
\alias{vaeac_get_save_file_names}
\title{Function that creates the save file names for the \code{vaeac} model}
\usage{
vaeac_get_save_file_names(
  model_description,
  n_features,
  n_train,
  depth,
  width,
  latent_dim,
  lr,
  epochs,
  save_every_nth_epoch,
  folder_to_save_model = NULL
)
}
\arguments{
\item{model_description}{String (default is \code{make.names(Sys.time())}). String containing, e.g., the name of the
data distribution or additional parameter information. Used in the save name of the fitted model. If not provided,
then a name will be generated based on \code{\link[base:Sys.time]{base::Sys.time()}} to ensure a unique name. We use \code{\link[base:make.names]{base::make.names()}} to
ensure a valid file name for all operating systems.}

\item{depth}{Positive integer (default is \code{3}). The number of hidden layers
in the neural networks of the masked encoder, full encoder, and decoder.}

\item{width}{Positive integer (default is \code{32}). The number of neurons in each
hidden layer in the neural networks of the masked encoder, full encoder, and decoder.}

\item{latent_dim}{Positive integer (default is \code{8}). The number of dimensions in the latent space.}

\item{lr}{Positive numeric (default is \code{0.001}). The learning rate used in the \code{\link[torch:optim_adam]{torch::optim_adam()}} optimizer.}

\item{epochs}{Positive integer (default is \code{100}). The number of epochs to train the final vaeac model.
This includes \code{epochs_initiation_phase}, where the default is \code{2}.}

\item{save_every_nth_epoch}{Positive integer (default is \code{NULL}). If provided, then the vaeac model after
every \code{save_every_nth_epoch}th epoch will be saved.}

\item{folder_to_save_model}{String (default is \code{\link[base:tempfile]{base::tempdir()}}). String specifying a path to a folder where
the function is to save the fitted vaeac model. Note that  the path will be removed from the returned
\code{\link[=explain]{explain()}} object if \code{vaeac.save_model = FALSE}.}
}
\value{
Array of string containing the save files to use when training the \code{vaeac} model. The first three names
corresponds to the best, best_running, and last epochs, in that order.
}
\description{
Function that creates the save file names for the \code{vaeac} model
}
\author{
Lars Henry Berge Olsen
}
\keyword{internal}
