% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.R
\name{controlMethod}
\alias{controlMethod}
\title{Control parameters for regression}
\usage{
controlMethod(
  epsilon = 1e-08,
  maxiter = 1000,
  verbose = 0,
  printEveryN = 1L,
  coefStart = NULL,
  etaStart = NULL,
  optimMethod = "Nelder-Mead",
  silent = FALSE,
  optimPass = FALSE,
  stepsize = 1,
  checkDiagWeights = TRUE,
  weightsEpsilon = 1e-08,
  momentumFactor = 0,
  saveIRLSlogs = FALSE,
  momentumActivation = 5,
  criterion = c("coef", "abstol", "reltol")
)
}
\arguments{
\item{epsilon}{a tolerance level for fitting algorithms by default \code{1e-8}.}

\item{maxiter}{a maximum number of iterations.}

\item{verbose}{a numeric value indicating whether to trace steps of fitting algorithm for
\code{IRLS} fitting method different values of verbose give the following information:
\itemize{
\item 1 -- Returns information on the number of current
iteration and current log-likelihood.
\item 2 -- Returns information on vector of regression parameters
at current iteration (and all of the above).
\item 3 -- Returns information on reduction of log-likelihood
at current iteration (and all of the above).
\item 4 -- Returns information on value of log-likelihood function gradient
at current iteration (and all of the above).
\item 5 -- Returns information on convergence criterion and values that are
taken into account when considering convergence (and all of the above).
}
if \code{optim} method was chosen verbose will be passed to \code{\link[stats:optim]{stats::optim()}} as trace.}

\item{printEveryN}{an integer value indicating how often to print information
specified in \code{verbose}, by default set to \code{1}.}

\item{coefStart, etaStart}{initial parameters for regression coefficients
or linear predictors if \code{NULL}. For \code{IRLS} fitting only \code{etaStart}
is needed so if \code{coefStart} is provided it will be converted to \code{etaStart},
for \code{optim} fitting \code{coefStart} is necessary and argument \code{etaStart}
will be ignored.}

\item{optimMethod}{a method of \code{\link[stats:optim]{stats::optim()}} used  \code{"Nelder-Mead"} is the default .}

\item{silent}{a logical value, indicating whether warnings in \code{IRLS} method should be suppressed.}

\item{optimPass}{an optional list of parameters passed to \code{stats::optim(..., control = optimPass)}
if FALSE then list of control parameters will be inferred from other parameters.}

\item{stepsize}{only for \code{IRLS}, scaling of updates to \code{beta} vector
lower value means slower convergence but more accuracy by default 1.
In general if fitting algorithm fails lowering this value tends to
be most effective at correcting it.}

\item{checkDiagWeights}{a logical value indicating whether to check if diagonal
elements of working weights matrixes in \code{IRLS} are sufficiently positive
so that these matrixes are positive defined. By default \code{TRUE}.}

\item{weightsEpsilon}{a small number to ensure positive definedness of weights matrixes.
Only matters if \code{checkDiagWeights} is set to \code{TRUE}.
By default \code{1e-8}.}

\item{momentumFactor}{an experimental parameter in \code{IRLS} only allowing for
taking previous step into account at current step, i.e instead of
updating regression parameters as:
\mjsdeqn{\boldsymbol{\beta}_{(a)} = 
\boldsymbol{\beta}_{(a-1)} + \text{stepsize} \cdot \text{step}_{(a)}}
the update will be made as:
\mjsdeqn{
\boldsymbol{\beta}_{(a)} = \boldsymbol{\beta}_{(a-1)} + \text{stepsize} 
\cdot (\text{step}_{(a)} + \text{momentum}\cdot\text{step}_{(a-1)})}}

\item{saveIRLSlogs}{a logical value indicating if information specified in
\code{verbose} should be saved to output object, by default \code{FALSE}.}

\item{momentumActivation}{the value of log-likelihood reduction bellow
which momentum will apply.}

\item{criterion}{a criterion used to determine convergence in \code{IRLS},
multiple values may be provided. By default \code{c("coef", "abstol")}.}
}
\value{
List with selected parameters, it is also possible to call list directly.
}
\description{
\code{controlMethod} constructs a list with all necessary
control parameters for regression fitting in
\code{estimatePopsizeFit} and \code{estimatePopsize}.
}
\seealso{
\code{\link[=estimatePopsize]{estimatePopsize()}} \code{\link[=estimatePopsizeFit]{estimatePopsizeFit()}}
\code{\link[=controlModel]{controlModel()}} \code{\link[=controlPopVar]{controlPopVar()}}
}
\author{
Piotr Chlebicki, Maciej Beręsewicz
\loadmathjax
}
