% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_lstm_fcn.R
\name{sits_lstm_fcn}
\alias{sits_lstm_fcn}
\title{Train a Long Short Term Memory Fully Convolutional Network}
\usage{
sits_lstm_fcn(
  samples = NULL,
  samples_validation = NULL,
  cnn_layers = c(128, 256, 128),
  cnn_kernels = c(8, 5, 3),
  lstm_width = 8,
  lstm_dropout = 0.8,
  epochs = 50,
  batch_size = 64,
  validation_split = 0.2,
  optimizer = torch::optim_adamw,
  opt_hparams = list(lr = 5e-04, eps = 1e-08, weight_decay = 1e-06),
  lr_decay_epochs = 1,
  lr_decay_rate = 0.95,
  patience = 20,
  min_delta = 0.01,
  seed = NULL,
  verbose = FALSE
)
}
\arguments{
\item{samples}{Time series with the training samples.}

\item{samples_validation}{Time series with the validation samples. if the
\code{samples_validation} parameter is provided,
the \code{validation_split} parameter is ignored.}

\item{cnn_layers}{Number of 1D convolutional filters per layer}

\item{cnn_kernels}{Size of the 1D convolutional kernels.}

\item{lstm_width}{Number of neurons in the lstm hidden layer.}

\item{lstm_dropout}{Dropout rate of the lstm layer.}

\item{epochs}{Number of iterations to train the model.}

\item{batch_size}{Number of samples per gradient update.}

\item{validation_split}{Fraction of training data to be used for
validation.}

\item{optimizer}{Optimizer function to be used.}

\item{opt_hparams}{Hyperparameters for optimizer:
lr : Learning rate of the optimizer
eps: Term added to the denominator
     to improve numerical stability.
weight_decay:       L2 regularization}

\item{lr_decay_epochs}{Number of epochs to reduce learning rate.}

\item{lr_decay_rate}{Decay factor for reducing learning rate.}

\item{patience}{Number of epochs without improvements until
training stops.}

\item{min_delta}{Minimum improvement in loss function
to reset the patience counter.}

\item{seed}{Seed for random values.}

\item{verbose}{Verbosity mode (TRUE/FALSE). Default is FALSE.}
}
\value{
A fitted model to be used for classification.
}
\description{
Uses a branched neural network consisting of
 a lstm (long short term memory) branch and a three-layer fully
 convolutional branch (FCN)
 followed by concatenation to classify time series data.

This function is based on the paper by Fazle Karim, Somshubra Majumdar,
and Houshang Darabi. If you use this method, please cite the original
LSTM with FCN paper.

The original python code is available at the website
\url{https://github.com/titu1994/LSTM-FCN}. This code is licensed as GPL-3.
}
\references{
F. Karim, S. Majumdar, H. Darabi and S. Chen,
"LSTM Fully Convolutional Networks for Time Series Classification,"
 in IEEE Access, vol. 6, pp. 1662-1669, 2018,
 \doi{10.1109/ACCESS.2017.2779939}.
}
\author{
Alexandre Assuncao, \email{alexcarssuncao@gmail.com}
}
