% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-stage1.R
\name{get_sampling_clusters}
\alias{get_sampling_clusters}
\alias{get_sampling_list}
\title{Select sampling clusters using systematic sampling}
\usage{
get_sampling_clusters(N_clusters, n_clusters)

get_sampling_list(cluster_list, n_clusters)
}
\arguments{
\item{N_clusters}{Total number of clusters in survey area.}

\item{n_clusters}{Number of sampling clusters to be selected.}

\item{cluster_list}{A data.frame containing at least the name or any other
identifier for the entire set of clusters to sample from.}
}
\value{
An integer vector for \code{\link[=get_sampling_clusters]{get_sampling_clusters()}} giving the row
index for selected clusters. A data.frame for \verb{[get_sampling_list()]} which
is a subset of \code{cluster_list}.
}
\description{
Select sampling clusters using systematic sampling
}
\examples{
get_sampling_clusters(N_clusters = 211, n_clusters = 35)
get_sampling_list(cluster_list = village_list, n_clusters = 70)

}
