% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_parameters.R
\name{extract_parameters}
\alias{extract_parameters}
\title{Extract information from a compiled model or a simulated tree sequence}
\usage{
extract_parameters(data)
}
\arguments{
\item{data}{Either an object of the class \code{slendr_ts} or \code{slendr_model}}
}
\value{
A list of data frames containing parameters of the model used when
compiling a model object
}
\description{
This function extract a slendr model parameters used to compile a given model
object or simulate a tree sequence
}
\examples{
\dontshow{check_dependencies(python = TRUE, quit = TRUE) # dependencies must be present
}
init_env()

# load an example model and simulate a tree sequence from it
model <- read_model(path = system.file("extdata/models/introgression", package = "slendr"))
ts <- msprime(model, sequence_length = 1e5, recombination_rate = 0)

# extract model parameters from a compiled model object as a list of data frames
extract_parameters(model)

# the function can also extract parameters of a model which simulated a
# tree sequence
extract_parameters(ts)

}
