% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{conidia}
\alias{conidia}
\title{Conidial release experiment}
\format{
A data frame with 7 variables: \code{ID}, \code{Run}, \code{DUnit}, \code{Source}, \code{Time}, \code{Period}, \code{Conidia}.
\describe{
  \item{ID}{Factor. Unique identifier for each observation.}
  \item{Run}{Factor. Experimental run indicator (each time period and source combination is repeated in two separate runs).}
  \item{DUnit}{Factor. Identifier for each experimental unit within a run.}
  \item{Source}{Factor. Source of sporulating cadaver ("Clone" or "Standard") providing the fungal conidia.}
  \item{Time}{Integer. Duration of exposure (in minutes) to the conidia shower (excluding zero-time controls).}
  \item{Period}{Integer. Index for the time period (e.g., 1 for the first non-zero time, 2 for the second, etc.).}
  \item{Conidia}{Integer. Number of conidia (spores) counted on slides for the corresponding experimental unit.}
}
}
\source{
Welham, S. J., Gezan, S. A., Clark, S. J., and Mead, A. (2015) \emph{Statistical Methods in Biology: Design and analysis of experiments and regression}
}
\usage{
conidia
}
\description{
This experiment was designed to measure aphid infection rates in response to varying fungal conidia doses, as delivered by sporulating cadavers of two different sources: a clone or a standard source (Source). Inoculation chambers containing aphids were exposed to conidial showers for one of eight time periods, ranging from 0 to 80 minutes (Time). The actual conidial dose received in each treatment was estimated by counting spores deposited on slides (Conidia) placed in the chambers. Each combination of time period and source was replicated across two experimental runs (Run), with separate sources used for each replicate. The time zero category served as a negative control and, as no conidia should be present at this time, resulting zero counts confirm the absence of slide contamination; this category is excluded from analysis. The resulting dataset supports investigation of the relationship between exposure time, conidial dose, and source type under replicated experimental conditions.
}
\examples{
glm(Conidia ~ Run + (log(Time) + Period) * Source,
    data = conidia |>
      transform(Period = factor(Period)),
    family = poisson())

}
\keyword{datasets}
