% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls.summary.R
\name{pls.summary}
\alias{pls.summary}
\title{Format PLS Model Output as LaTeX Tables}
\usage{
pls.summary(x, ..., include.scores = TRUE)
}
\arguments{
\item{x}{A list returned by \code{\link{pls.regression}()} (class \code{"pls"}) containing PLS model components.}

\item{...}{Further arguments passed to or from methods (unused).}

\item{include.scores}{Logical. Whether to include score matrices (T and U). Default is \code{TRUE}.}
}
\value{
Returns a \code{knitr::asis_output} object (LaTeX code) for PDF rendering.
}
\description{
Formats and displays Partial Least Squares (PLS) model output from \code{pls.regression()}
as LaTeX tables for PDF rendering.
}
\examples{
# Load example data
data(mtcars)

# Prepare data for PLS regression
X <- mtcars[, c("wt", "hp", "disp")]
Y <- mtcars[, "mpg", drop = FALSE]

# Fit PLS model with 2 components
pls.fit <- pls.regression(X, Y, n.components = 2)

# Print a LaTeX-formatted summary
pls.summary(pls.fit, include.scores = FALSE)
}
