% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percent_slowing.R
\name{percent_slowing_using_change_from_bl}
\alias{percent_slowing_using_change_from_bl}
\title{Calculates Percent Slowing from a Data Frame of Change-from-Baseline Data}
\usage{
percent_slowing_using_change_from_bl(
  change_from_bl_tbl,
  time_observed_continuous,
  arm,
  control_group,
  subgroup = NULL,
  est = "estimate",
  se = "SE",
  conf.level = 0.95
)
}
\arguments{
\item{change_from_bl_tbl}{(data frame)\cr a data frame of
change-from-baseline data whose columns include \code{time_observed_continuous},
\code{arm}, (optionally) \code{subgroup}, \code{est}, and \code{se}.}

\item{time_observed_continuous, arm, subgroup, est, se}{(\code{string})\cr strings
identifying the columns in \code{change_from_bl_tbl} that contain the continuous
time variable, the study arm, (optionally) the subgroup, the
change-from-baseline estimate, and the change-from-baseline standard error.}

\item{control_group}{(\code{string})\cr the value in the \code{arm} column of
\code{change_from_bl_tbl} denoting the control group.}

\item{conf.level}{(scalar \code{numeric})\cr confidence level for the calculation
of p-values. Defaults to \code{0.95}.}
}
\value{
A data frame with a row for each combination of the unique values of
\code{change_from_bl_tbl[[time_observed_continuous]]},
\code{change_from_bl_tbl[[arm]]} (except the value denoted in \code{control_group}),
and \code{change_from_bl_tbl[[subgroup]]} (if \code{subgroup} is not \code{NULL}). It will
contain the following columns:
\enumerate{
\item \{column name will be the value of the \code{arm} argument\}: the study arm.
\item \{column name will be the value of the \code{time_observed_continuous}
argument\}: the \emph{observed} continuous time variable.
\item \{column name will be the value of the \code{subgroup} argument\}: the
subgroup. Only present if \code{subgroup} is not \code{NULL}.
\item \code{percent_slowing_est}: the percent slowing estimate
\item \code{percent_slowing_lower}: the lower bound of the confidence interval for
\code{percent_slowing_est}.
\item \code{percent_slowing_lower}: the upper bound of the confidence interval for
\code{percent_slowing_est}.
}
}
\description{
Accepts a data frame of change-from-baseline data (probably
created with \code{\link[=change_from_baseline]{change_from_baseline()}}) and returns a table of percent
slowing results.
}
\details{
For each study arm that is not the control group,

\deqn{
\text{Let } \theta = \frac{\text{treatment estimate}}{\text{control estimate}}
}\deqn{
\text{Let } \alpha = 1 - \code{conf.level}
}\deqn{
\text{Let MOE} = 100 \times z_{1 - \alpha/2} \times \frac{\sqrt{\text{treatment SE}^2 + (\theta \times \text{control SE})^2}}{|\text{control estimate}|}
}

Therefore, the percent slowing estimates and their respective confidence
intervals are calculated thus:

\deqn{
\text{Percent slowing estimate} = (1 - \theta) \times 100
}\deqn{
\text{Percent slowing CI} = \text{Percent slowing estimate} \pm \text{MOE}
}
}
\examples{
# Create a usable data set out of mmrm::fev_data
fev_mod <- mmrm::fev_data
fev_mod$VISITN <- fev_mod$VISITN * 10
fev_mod$time_cont <- fev_mod$VISITN + rnorm(nrow(fev_mod))
fev_mod$obs_visit_index <- round(fev_mod$time_cont)

fit <-
  ncs_mmrm_fit(
    data = fev_mod,
    type = "subgroup_full",
    response = FEV1,
    subject = USUBJID,
    cov_structs = c("ar1", "us"),
    time_observed_continuous = time_cont,
    df = 2,
    time_observed_index = obs_visit_index,
    arm = ARMCD,
    control_group = "PBO",
    subgroup = SEX,
    subgroup_comparator = "Male",
    covariates = ~ FEV1_BL + RACE
  )

marginal_means <-
  ncs_emmeans(
    fit = fit,
    observed_time = "time_cont",
    scheduled_time = "VISITN",
    arm = "ARMCD",
    subgroup = "SEX"
  )

change_from_bl_tbl <-
  change_from_baseline(
    emmeans = marginal_means,
    time_observed_continuous = "time_cont",
    time_scheduled_baseline = 10,
    arm = "ARMCD",
    subgroup = "SEX",
    as_tibble = TRUE
  )

percent_slowing_using_change_from_bl(
  change_from_bl_tbl = change_from_bl_tbl,
  time_observed_continuous = "time_cont",
  arm = "ARMCD",
  control_group = "PBO",
  subgroup = "SEX"
)
}
