% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{ci.cor2}
\alias{ci.cor2}
\title{Confidence interval for a 2-group Pearson correlation difference}
\usage{
ci.cor2(alpha, cor1, cor2, n1, n2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{cor1}{estimated Pearson correlation for group 1}

\item{cor2}{estimated Pearson correlation for group 2}

\item{n1}{sample size for group 1}

\item{n2}{sample size for group 2}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated correlation difference
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a difference in population Pearson
correlations in a 2-group design. A bias adjustment is used to
reduce the bias of each Fisher transformed correlation.

For more details, see Section 2.17 of Bonett (2021, Volume 2)
}
\examples{
ci.cor2(.05, .64, .31, 200, 200)

# Should return:
# Estimate      SE      LL     UL
#     0.33 0.07692  0.1797 0.4814
 

}
\references{
\insertRef{Zou2007}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
