% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.mann}
\alias{ci.mann}
\title{Confidence interval for a Mann-Whitney parameter}
\usage{
ci.mann(alpha, y1, y2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y1}{vector of scores for group 1}

\item{y2}{vector of scores for group 2}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated proportion
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a distribution-free confidence interval for the Mann-Whitney
parameter (a "common language effect size"). In a 2-group experiment, this
parameter is the proportion of members in the population with scores that
would be higher under treatment 1 than treatment 2. In a 2-group
nonexperiment where participants are sampled from two subpopulations of
sizes N1 and N2, the parameter is the proportion of all N1 x N2 pairs in
which a member from subpopulation 1 has a larger score than a member from
subpopulation 2.

For more details, see Section 2.12 of Bonett (2021, Volume 1)
}
\examples{
y1 <- c(9.4, 10.3, 58.3, 106.0, 31.0, 46.2, 12.0, 19.0, 135.0, 159.0)
y2 <- c(14.6, 5.1, 8.1, 22.7, 6.4, 4.4, 19.0, 3.2)
ci.mann(.05, y1, y2)

# Should return:
# Estimate        SE        LL UL
#  0.86875 0.1222202 0.6292028  1


}
\references{
\insertRef{Sen1967}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
