% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subniche.R
\name{subniche}
\alias{subniche}
\alias{print.subniche}
\alias{summary.subniche}
\alias{refparam}
\alias{rtest.subniche}
\alias{subparam.refor}
\alias{rtestrefor}
\alias{subparam.subor}
\alias{rtestsubor}
\alias{print.subkrandtest}
\alias{print.subnikrandtest}
\alias{subkrandtest}
\alias{subnikrandtest}
\title{The Within Outlying Mean Indexes calculation}
\usage{
subniche(nic, factor)

\method{print}{subkrandtest}(x, ...)

\method{print}{subnikrandtest}(x, ...)

\method{print}{subniche}(x, ...)

\method{summary}{subniche}(object, ...)

refparam(x)

\method{rtest}{subniche}(xtest, nrepet = 99, ...)

subparam.refor(x)

rtestrefor(x, nrepet)

subparam.subor(x)

rtestsubor(x, nrepet)

subkrandtest(
  sim,
  obs,
  alter = "greater",
  call = match.call(),
  names = colnames(sim),
  p.adjust.method = "none"
)

subnikrandtest(
  sim,
  obs,
  alter = "greater",
  subpvalue,
  call = match.call(),
  names = colnames(sim),
  p.adjust.method = "none"
)
}
\arguments{
\item{nic}{an object of class \code{niche}.}

\item{factor}{a factor which will defined the subsets within which the subniches will be calculated (the same length of the number of sites)}

\item{x}{an object of class \code{subniche}.}

\item{...}{further arguments passed to or from other methods}

\item{object}{an object of class \code{subniche}.}

\item{xtest}{an object of class \code{subniche}.}

\item{nrepet}{the number of permutations for the testing procedure}

\item{sim}{a numeric vector of simulated values}

\item{obs}{a numeric vector of an observed value}

\item{alter}{a character string specifying the alternative hypothesis, must be one of "greater" (default), "less" or "two-sided".he length must be equal to the length of the vector obs, values are recycled if shorter.}

\item{call}{a call order}

\item{names}{a vector of names for tests}

\item{p.adjust.method}{a string indicating a method for multiple adjustment, see \link[stats:p.adjust]{p.adjust.methods} for possible choices.}

\item{subpvalue}{the subset pvalue resulting from \code{subkrandtest} function}
}
\value{
Adds items in the niche list and changing the class into \code{subniche} containing:

\code{factor} the factor use to divide the environmental and species matrix into submatrices.

\code{G_k} a dataframe with the sub-origins, \emph{G_k}.

\code{sub} a dataframe with the species subniche coordinates
}
\description{
The indexes allows to divide the niche, estimated from the \link[ade4]{niche} function in the \pkg{ade4} package into subniches defined by a factor, which creates the
subsets. See details for more information.
}
\details{
The Within Outlying Mean Index analysis is a statistical exploratory niche analysis which provides observation of niche shift and/or conservatism, of an entire community,at different subcales
(temporal ,spatial and/or finer biological organisation level), and comparable under the same environmental gradients. This hindcasting multivariate analysis is based on the OMI analysis (Doledec \emph{et al.} 2000) which is used as reference.
The niches refinement is inspired by the K-select (Calenge \emph{et al.} 2005) which emphasizes the limiting factors in habitat use in design II and III (Thomas and Taylor, 1990).The different estimations should help understand:

1. the environmental factors defining a species' reference niche, under on the full scale, within a community.

2. the environmental factors defining a species' subniches, under each subsets, within a community.

The subniches parameters can be calculated from both the reference origin,\emph{G}, which corresponds to the reference plan origin, and from \emph{G_k}, which corresponds to the
suborigins. \emph{G} is the graphical representation of the mean environmental conditions encountered over the full scale of the data. \emph{G_k} is the mean environmental conditions
encountered at a subset defined by the factor. They are complementary has you can compare:

1. a single species' subniches to \emph{G}.

2. the community' subniches to \emph{G_k} at a specific subset.

 The subniches of a single species can only be compared to \emph{G} as it is the common origin to all subsets. Whereas \emph{G_k} is only common to the species found within the
subset. So comparing different subniches of one species, found within different subsets, is only relevant to \emph{G}. The community's subniches can be compared to both \emph{G}
and \emph{G_k}, but \emph{G}, being the mean environmental conditions found within the full scale, will not express the specificity of the environmental conditions that the species
encountered at the subset. \emph{G_k}, being the mean environmental conditions of the subset, will reflect the atypical value of the environmental condition, making the
comparison of the community's subniches parameters more relevant. More information on the ecological concept can be found in Karasiewicz \emph{et al.} 2017.

For more details description on the package use:\url{https://github.com/KarasiewiczStephane/WitOMI}.
}
\examples{
library(ade4)
library(subniche)
data(doubs)
dudi1 <- dudi.pca(doubs$env, scale = TRUE, scan = FALSE, nf = 3)
nic1 <- niche(dudi1, doubs$fish, scann = FALSE)
# number of sites
N <- dim(nic1$ls)[1]
#Create a factor which defines the subsets
fact <- factor(c(rep(1,N/2),rep(2,N/2)))
# nic1 will be use as reference and fact will be use to define the subniches environment
subnic1 <- subniche(nic1, fact)
# the following two functions do the same display, plot.refniche is adapted to subniche objects
plot(nic1)
plot(subnic1)
#Display the marginality vector of the suborigins and the species subniche
#Display the subset's polygon, found within the overall environment's chull,
#and the corresponding species positions
subplot(subnic1)
# The following two functions do the same display, refparam is adapted to subniche objects
niche.param(nic1)
refparam(subnic1)
# The following two functions do the same display, rtest is adapted to subniche objects
rtest(nic1,10)
rtest(subnic1,10)
#Calculates the subniches' parameters from G with the corresponding rtest
subparam.refor(subnic1)
rtestrefor(subnic1,10)
#Calculates the subniches' parameters from G_k with the corresponding rtest
subparam.subor(subnic1)
rtestsubor(subnic1,10)
}
\references{
Karasiewicz S.,Doledec S.and Lefebvre S. (2017). Within outlying mean indexes: refining the OMI analysis for the realized niche decomposition. \emph{PeerJ} 5:e3364. \doi{10.7717/peerj.3364}.

Calenge C., Dufour A.B. and Maillard D. (2005). K-select analysis: a new method to analyze habitat selection in radio-tracking studies. \emph{Ecological modelling}, \bold{186}, 143-153. \doi{10.1016/j.ecolmodel.2004.12.005}.

Doledec S., Chessel D. and Gimaret C. (2000). Niche separation in community analysis: a new method. \emph{Ecology},\bold{81}, 2914-1927. \doi{10.2307/177351}

Thomas, D.L., Taylor, E.J. (1990). Study Designs and Tests for Comparing Resource Use and Availability II. \emph{Natl. Widl.} \bold{54}(2), 322-330.
}
\seealso{
\link[ade4]{niche} \link[ade4:niche]{niche.param}
}
\author{
Stephane Karasiewicz, \email{skaraz.science@gmail.fr}
}
\keyword{subniche}
