% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxon_names.R
\name{taxon_names}
\alias{taxon_names}
\alias{taxon_names.taxlist}
\alias{taxon_names,taxlist-method}
\alias{taxon_names<-}
\alias{taxon_names<-.taxlist}
\alias{taxon_names<-,taxlist-method}
\alias{add_synonym}
\alias{add_synonym.taxlist}
\alias{add_synonym,taxlist-method}
\alias{update_name}
\alias{update_name.taxlist}
\alias{update_name,taxlist-method}
\alias{delete_name}
\alias{delete_name.taxlist}
\alias{delete_name,taxlist-method}
\title{Handle information on taxon usage names.}
\usage{
taxon_names(taxlist, ...)

\method{taxon_names}{taxlist}(taxlist, ...)

taxon_names(taxlist, ...) <- value

\method{taxon_names}{taxlist}(taxlist, ...) <- value

add_synonym(taxlist, ...)

\method{add_synonym}{taxlist}(taxlist, ConceptID, TaxonName, AuthorName, ...)

update_name(taxlist, ...)

\method{update_name}{taxlist}(taxlist, UsageID, ...)

delete_name(taxlist, ...)

\method{delete_name}{taxlist}(taxlist, UsageID, ...)
}
\arguments{
\item{taxlist}{A \linkS4class{taxlist} object to be modified.}

\item{...}{Further arguments passed among methods. In \code{update_name} are
vectors including the variables to be updated for the respective taxon
usage ID.}

\item{value}{A data frame used as new slot \code{taxonNames} in \code{taxlist}.}

\item{ConceptID}{Numeric vector indicating the concept ID to which the
synonyms will be added.}

\item{TaxonName, AuthorName}{Character values used for the new names
(synonyms).}

\item{UsageID}{Numeric vector indicating the taxon usage IDs to be updated.}
}
\value{
A data frame or, in the case of the replacement method, a
\linkS4class{taxlist} object with modified slot \code{taxonNames}.
}
\description{
The slot \code{taxonNames} in \linkS4class{taxlist} objects contains
taxon usage names for the respective taxon.
These functions assist on the access and modification of entries for names.
}
\details{
The replacement method \verb{taxon_names<-} is a quick alternative to include
names in empty \linkS4class{taxlist} objects.

The function \code{add_synonym()} works only for adding names to existing
taxon concepts.
For adding new taxon concepts as well you should use \code{\link[=add_concept]{add_concept()}}.
}
\examples{
## Display of slot 'taxonNames'
Euclea <- subset(x = Easplist, subset = charmatch("Euclea", TaxonName),
  slot = "names", keep_children = TRUE)
Euclea
taxon_names(Euclea)

## Insert a synonym to Diospyros scabra
summary(Easplist, "Diospyros scabra")
sp_list <- add_synonym(taxlist = Easplist, ConceptID = 51793,
  TaxonName = "Maba scabra", AuthorName = "Chiov.")
summary(sp_list, "Diospyros scabra")

## Delete a synonym of Launaea cornuta
summary(sp_list, "Launaea cornuta")
sp_list <- delete_name(sp_list, 53821)
summary(sp_list, "Launaea cornuta")

## Hypothetical correction in author name in Launaea cornuta
sp_list <- update_name(taxlist = sp_list, UsageID = 355, AuthorName = "L.")
summary(sp_list, "Launaea cornuta")
}
\seealso{
\linkS4class{taxlist}
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
