% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{distances}
\alias{distances}
\alias{dist2}
\alias{pdist2}
\title{Pairwise Distance Matrix Computation}
\usage{
dist2(x, y = NULL, method = c("cosine", "euclidean", "jaccard"),
  norm = c("l2", "l1", "none"))

pdist2(x, y, method = c("cosine", "euclidean", "jaccard"),
  norm = c("l2", "l1", "none"))
}
\arguments{
\item{x}{first matrix.}

\item{y}{second matrix. For \code{dist2} \code{y = NULL} set by default.
This means that we will assume \code{y = x} and calculate distances/similarities between all rows of the \code{x}.}

\item{method}{usually \code{character} or instance of \code{tet2vec_distance} class.
The distances/similarity measure to be used. One of \code{c("cosine", "euclidean", "jaccard")} or \link{RWMD}.
\code{RWMD} works only on bag-of-words matrices.
\bold{In case of \code{"cosine"} distance max distance will be 1 - (-1) = 2}}

\item{norm}{\code{character = c("l2", "l1", "none")} - how to scale input matrices.
If they already scaled - use \code{"none"}}
}
\value{
\code{dist2} returns \code{matrix} of distances/similarities between each row of
matrix \code{x} and each row of matrix \code{y}.

\code{pdist2} returns \code{vector} of "parallel" distances between rows
of \code{x} and \code{y}.
}
\description{
\code{dist2} calculates pairwise distances/similarities between the
rows of two data matrices. \bold{Note} that some methods work only on sparse matrices and
others work only on dense matrices.

\code{pdist2} calculates "parallel" distances between the rows of two data matrices.
}
\details{
Computes the distance matrix computed by using the specified method.
Similar to \link{dist} function, but works with two matrices.

\code{pdist2} takes two matrices and return a single vector.
giving the ‘parallel’ distances of the vectors.
}
