% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hy_db.R
\name{hy_set_default_db}
\alias{hy_set_default_db}
\title{Set the default database path}
\usage{
hy_set_default_db(hydat_path = NULL)
}
\arguments{
\item{hydat_path}{The path to the a HYDAT sqlite3 database file
(e.g., \link{hy_test_db})}
}
\value{
returns the previous value of \link{hy_default_db}.
}
\description{
For many reasons, it may be convenient to set the default
database location to somewhere other than the global default. Users
may wish to use a previously downloaded version of the database for
reproducibility purposes, store hydat somewhere other than hy_dir().
}
\examples{
\dontrun{
# set default to the test database
hy_set_default_db(hy_test_db())

# get the default value
hy_default_db()

# set back to the default db location
hy_set_default_db(NULL)
}

}
