% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary-functions}
\alias{summary-functions}
\alias{mean}
\alias{sum}
\alias{prod}
\alias{sd}
\alias{var}
\alias{median}
\alias{quantile}
\title{NA-aware Summary Functions}
\usage{
mean(x, na.rm = TRUE, all_na = NULL, ...)

sum(x, na.rm = TRUE, all_na = NULL, ...)

prod(x, na.rm = TRUE, all_na = NULL, ...)

sd(x, na.rm = TRUE, all_na = NULL, ...)

var(x, na.rm = TRUE, all_na = NULL, ...)

median(x, na.rm = TRUE, all_na = NULL, ...)

quantile(x, na.rm = TRUE, all_na = NULL, ...)
}
\arguments{
\item{x}{A numeric vector.}

\item{na.rm}{Logical. Should missing values be removed? Default \code{TRUE}.}

\item{all_na}{Character. What to do when all values are NA:
\code{"error"} (default) throws an error, \code{"base"} returns what base R does
with \code{na.rm = TRUE} (e.g., \code{NaN} for \code{mean()}, \code{0} for \code{sum()}),
\code{"na"} returns \code{NA}. If \code{NULL}, uses \code{getOption("tidyna.all_na", "error")}.}

\item{...}{Additional arguments passed to the base function.}
}
\value{
The computed summary statistic.
}
\description{
Drop-in replacements for summary functions that default to \code{na.rm = TRUE}
and warn when missing values are removed.
}
\examples{
x <- c(1, 2, NA, 4)
mean(x)

# Suppress warnings
options(tidyna.warn = FALSE)
mean(x)
options(tidyna.warn = TRUE)

# Control all-NA behavior
mean(c(NA, NA), all_na = "na")

}
