% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_tidyee.R
\name{as_tidyee}
\alias{as_tidyee}
\title{as_tidy_ee}
\usage{
as_tidyee(x, time_end = FALSE)
}
\arguments{
\item{x}{ee$Image or ee$ImageCollection}

\item{time_end}{\code{logical} include time_end ("system:time_end") in vrt (default=F)}
}
\value{
tidyee class object which contains a list with two components ("x","vrt")
}
\description{
The function returns a list containing the original object (Image/ImageCollection)as well
as a "virtual data.frame (vrt)" which is a data.frame holding key properties of the
ee$Image/ee$ImageCollection. The returned list has been assigned a new class "tidyee".
}
\examples{
\dontrun{
library(tidyrgee)
library(rgee)
ee_Initialize()
modis_ic <- ee$ImageCollection("MODIS/006/MOD13Q1")
modis_ic_tidy <- as_tidyee(modis_ic)


}
}
