% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/required-pkgs-Spat.R
\name{required_pkgs.Spat}
\alias{required_pkgs.Spat}
\alias{required_pkgs.SpatRaster}
\alias{required_pkgs.SpatVector}
\alias{required_pkgs.SpatGraticule}
\alias{required_pkgs.SpatExtent}
\title{Determine packages required by \verb{Spat*} objects}
\usage{
\method{required_pkgs}{SpatRaster}(x, ...)

\method{required_pkgs}{SpatVector}(x, ...)

\method{required_pkgs}{SpatGraticule}(x, ...)

\method{required_pkgs}{SpatExtent}(x, ...)
}
\arguments{
\item{x}{A \code{SpatRaster} created with \code{\link[terra:rast]{terra::rast()}} or a \code{SpatVector}
created with \code{\link[terra:vect]{terra::vect()}}. Also support \code{SpatGraticule}
(see \code{\link[terra:graticule]{terra::graticule()}}) and \code{SpatExtent} (see \code{\link[terra:ext]{terra::ext()}}).}

\item{...}{Ignored by these methods.}
}
\value{
A character string of packages that are required.
}
\description{
Determine packages required by \verb{Spat*} objects.
}
\section{Methods}{


Implementation of \code{\link[generics:required_pkgs]{generics::required_pkgs()}} method.
}

\examples{
file_path <- system.file("extdata/cyl_temp.tif", package = "tidyterra")


library(terra)

r <- rast(file_path)

# With rasters
r
required_pkgs(r)

#  With vectors
v <- vect(system.file("extdata/cyl.gpkg", package = "tidyterra"))
v
required_pkgs(v)

}
\seealso{
\code{\link[generics:required_pkgs]{generics::required_pkgs()}}.

Other \CRANpkg{generics} methods:
\code{\link{glance.Spat}},
\code{\link{tidy.Spat}}
}
\concept{generics.methods}
