% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get_wikipedia_category_members.R
\name{tw_get_wikipedia_category_members_single}
\alias{tw_get_wikipedia_category_members_single}
\title{Get all Wikidata Q identifiers of all Wikipedia pages that appear in a given page}
\usage{
tw_get_wikipedia_category_members_single(
  url = NULL,
  category = NULL,
  type = "page",
  language = tidywikidatar::tw_get_language(),
  cache = NULL,
  overwrite_cache = FALSE,
  cache_connection = NULL,
  disconnect_db = TRUE,
  wait = 1,
  attempts = 10
)
}
\arguments{
\item{url}{Full URL to a Wikipedia category page. If given, title and
language can be left empty.}

\item{category}{Title of a Wikipedia category page or final parts of its url.
Must include "Category:", or equivalent in other languages. If given, url
can be left empty, but language must be provided.}

\item{type}{Defaults to "page", defines which kind of members of a category
are returned. Valid values include "page", "file", and "subcat" (for
sub-category). Corresponds to \code{cmtype}. For details, see
\href{https://www.mediawiki.org/wiki/API:Categorymembers}{the relevant page
of the official documentation}.}

\item{language}{Defaults to language set with \code{\link[=tw_set_language]{tw_set_language()}}; if not
set, "en". Use "all_available" to keep all languages. For available
language values, see
\href{https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}{the
dedicated Wikimedia page}.}

\item{cache}{Defaults to \code{NULL}. If given, it should be given either \code{TRUE}
or \code{FALSE}. Typically set with \code{\link[=tw_enable_cache]{tw_enable_cache()}} or \code{\link[=tw_disable_cache]{tw_disable_cache()}}.}

\item{overwrite_cache}{Logical, defaults to \code{FALSE}. If \code{TRUE}, it overwrites
the table in the local sqlite database. Useful if the original Wikidata
object has been updated.}

\item{cache_connection}{Defaults to \code{NULL}. If \code{NULL}, and caching is
enabled, \code{tidywikidatar} will use a local sqlite database. A custom
connection to other databases can be given (see vignette \code{caching} for
details).}

\item{disconnect_db}{Defaults to \code{TRUE}. If \code{FALSE}, leaves the connection to
cache open.}

\item{wait}{In seconds, defaults to 0. Time to wait between queries to
Wikidata. If data are cached locally, wait time is not applied. If you are
running many queries systematically you may want to add some waiting time
between queries.}

\item{attempts}{Defaults to 10. Number of times it re-attempts to reach the
API before failing.}
}
\value{
A data frame (a tibble) with four columns: \code{wikipedia_title}, \code{wikipedia_id}, \code{wikidata_id}, \code{wikidata_description}.
}
\description{
Get all Wikidata Q identifiers of all Wikipedia pages that appear in a given page
}
\examples{
if (interactive()) {
  tidywikidatar:::tw_get_wikipedia_category_members_single(
    category = "Category:American women anthropologists",
    type = "subcat"
  )

  tidywikidatar:::tw_get_wikipedia_category_members_single(
    category = "Category:Puerto Rican women anthropologists",
    type = "page"
  )
}
}
