% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_conv_transpose3d}
\alias{torch_conv_transpose3d}
\title{Conv_transpose3d}
\usage{
torch_conv_transpose3d(
  input,
  weight,
  bias = list(),
  stride = 1L,
  padding = 0L,
  output_padding = 0L,
  groups = 1L,
  dilation = 1L
)
}
\arguments{
\item{input}{input tensor of shape \eqn{(\mbox{minibatch} , \mbox{in\_channels} , iT , iH , iW)}}

\item{weight}{filters of shape \eqn{(\mbox{in\_channels} , \frac{\mbox{out\_channels}}{\mbox{groups}} , kT , kH , kW)}}

\item{bias}{optional bias of shape \eqn{(\mbox{out\_channels})}. Default: NULL}

\item{stride}{the stride of the convolving kernel. Can be a single number or a      tuple \verb{(sT, sH, sW)}. Default: 1}

\item{padding}{\code{dilation * (kernel_size - 1) - padding} zero-padding will be added to both      sides of each dimension in the input. Can be a single number or a tuple      \verb{(padT, padH, padW)}. Default: 0}

\item{output_padding}{additional size added to one side of each dimension in the      output shape. Can be a single number or a tuple      \verb{(out_padT, out_padH, out_padW)}. Default: 0}

\item{groups}{split input into groups, \eqn{\mbox{in\_channels}} should be divisible by the      number of groups. Default: 1}

\item{dilation}{the spacing between kernel elements. Can be a single number or      a tuple \verb{(dT, dH, dW)}. Default: 1}
}
\description{
Conv_transpose3d
}
\section{conv_transpose3d(input, weight, bias=NULL, stride=1, padding=0, output_padding=0, groups=1, dilation=1) -> Tensor }{


Applies a 3D transposed convolution operator over an input image
composed of several input planes, sometimes also called "deconvolution"

See \code{\link[=nn_conv_transpose3d]{nn_conv_transpose3d()}} for details and output shape.
}

\examples{
if (torch_is_installed()) {
\dontrun{
inputs = torch_randn(c(20, 16, 50, 10, 20))
weights = torch_randn(c(16, 33, 3, 3, 3))
nnf_conv_transpose3d(inputs, weights)
}
}
}
