% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uplot_cluster.R
\name{uplot_cluster}
\alias{uplot_cluster}
\title{uplot_cluster}
\usage{
uplot_cluster(mfd, grp = "file_id", int_col = "norm_int", ...)
}
\arguments{
\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{grp}{Character vector. Names of columns (e.g., sample or file identifiers)
used to aggregate results.}

\item{int_col}{Character. The name of the column that contains the intensity values
to be used (e.g. for clustering or color coding). Default usually is "norm_int" for normalized intensity values.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A named list with two elements:

\describe{
\item{\code{dendrogram}}{
A \code{recordedplot} object containing the hierarchical clustering
dendrogram generated from the Bray–Curtis dissimilarity matrix.
}

\item{\code{mds}}{
A \code{plotly} object representing the two-dimensional
Multi-Dimensional Scaling (MDS) scatter plot.
This can be rendered interactively in HTML or converted to
a static ggplot object if needed.
}
}

The function always returns a list with these two components.
}
\description{
This function plots the results of a cluster analysis and a multi-dimensional scaling (MDS) plot based on the input data.
It first creates a hierarchical cluster dendrogram using the Bray-Curtis dissimilarity index, followed by an MDS plot for dimensionality reduction.
The function outputs both plots side by side.
}
\details{
Plot Cluster Analysis and Multi-Dimensional Scaling
}
\note{
This function requires the \code{vegan} package for the Bray-Curtis
dissimilarity and MDS calculations.
}
\examples{
# Example with demo data
  out <- uplot_cluster(mfd = mf_data_demo, grp = "file", int_col = "norm_int")
  out$dendrogram
  out$mds

}
\seealso{
Other plots: 
\code{\link{uplot_cvm}()},
\code{\link{uplot_dbe_minus_o_freq}()},
\code{\link{uplot_dbe_vs_c}()},
\code{\link{uplot_freq_ma}()},
\code{\link{uplot_freq_vs_ppm}()},
\code{\link{uplot_hc_vs_m}()},
\code{\link{uplot_heteroatoms}()},
\code{\link{uplot_isotope_precision}()},
\code{\link{uplot_kmd}()},
\code{\link{uplot_lcms}()},
\code{\link{uplot_ma_vs_mz}()},
\code{\link{uplot_ms}()},
\code{\link{uplot_n_mf_per_sample}()},
\code{\link{uplot_pca}()},
\code{\link{uplot_ratios}()},
\code{\link{uplot_reproducibility}()},
\code{\link{uplot_ri_vs_sample}()},
\code{\link{uplot_vk}()}
}
\concept{plots}
