% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trellis_vismi.R
\name{trellis_vismi}
\alias{trellis_vismi}
\title{Trelliscope Visualisation of Distributional Characteristics}
\usage{
trellis_vismi(
  data,
  imp_list,
  m = NULL,
  imp_idx = NULL,
  integerAsFactor = FALSE,
  title = "auto",
  subtitle = "auto",
  color_pal = NULL,
  marginal_x = "box+rug",
  nrow = 2,
  ncol = 4,
  path = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{data}{A data frame containing the original data with missing values.}

\item{imp_list}{A list of imputed data frames.}

\item{m}{An integer specifying the number of imputed datasets to plot. It should be smaller than \code{length(imp_list)}. Default is NULL (plot all).}

\item{imp_idx}{A vector of integers specifying the indices of imputed datasets to plot. Default is NULL (plot all).}

\item{integerAsFactor}{A logical value indicating whether to treat integer variables as factors
(TRUE) or numeric (FALSE). Default is FALSE.}

\item{title}{A string specifying the title of the plot. Default is "auto" (automatic title based on \code{x,y,z} input). If NULL, no title is shown.}

\item{subtitle}{A string specifying the subtitle of the plot. Default is "auto" (automatic subtitle based on \code{x,y,z} input). If NULL, no subtitle is shown.}

\item{color_pal}{A named vector of colors for different imputation sets. If NULL
(default), a default color palette is used.}

\item{marginal_x}{A character string specifying the type of marginal plot to add
for the x variable in 2D plots. Options are "hist", "box", "rug", "box+rug", or NULL
(default, no marginal plot) when interactive = TRUE. Options are "box", "rug", "box+rug", or NULL
(default, no marginal plot) when interactive = FALSE.}

\item{nrow}{Number of rows in the Trelliscope display. Default is 2.}

\item{ncol}{Number of columns in the Trelliscope display. Default is 4.}

\item{path}{Optional path to save the Trelliscope display. If NULL, the display will not be saved to disk.}

\item{verbose}{A logical value indicating whether to print extra information. Default is FALSE.}

\item{...}{Additional arguments passed to the underlying plotting functions, such as point_size, alpha, nbins, width, and boxpoints.}
}
\value{
A Trelliscope display object visualising distributional characteristics for all variables.
}
\description{
Generates a Trelliscope display for distributional characteristics across all variables.
}
\examples{
trellis_vismi(data = nhanes3, imp_list = imp_nhanes3, marginal_x = "box")
}
