% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrds-connect.R
\name{wrds_connect}
\alias{wrds_connect}
\title{Connect to WRDS}
\usage{
wrds_connect(user_key = "wrds_user", password_key = "wrds_pw", keyring = NULL)
}
\arguments{
\item{user_key}{Name of the keyring entry storing the WRDS username.
Defaults to \code{"wrds_user"}.}

\item{password_key}{Name of the keyring entry storing the WRDS password.
Defaults to \code{"wrds_pw"}.}

\item{keyring}{Optional keyring name. If \code{NULL} (default), uses the
default keyring.}
}
\value{
A \code{DBIConnection} object for the WRDS PostgreSQL database.
}
\description{
Establishes a connection to the WRDS PostgreSQL server using credentials
stored securely in the system keyring.
}
\details{
Credentials must be set up before first use with \code{\link[=wrds_set_credentials]{wrds_set_credentials()}}.
The connection uses \code{bigint = "integer"} for compatibility with R's
integer type.
}
\examples{
\dontrun{
wrds <- wrds_connect()
list_libraries(wrds)
wrds_disconnect(wrds)
}
}
\seealso{
\code{\link[=wrds_disconnect]{wrds_disconnect()}}, \code{\link[=wrds_set_credentials]{wrds_set_credentials()}}
}
