% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MC_summarize_mc_ci.R
\name{summarize_mc_ci}
\alias{summarize_mc_ci}
\title{Summarize Monte Carlo Simulation Results}
\usage{
summarize_mc_ci(mc_result, alpha = 0.05)
}
\arguments{
\item{mc_result}{A data frame where each column corresponds to a parameter, and each row
represents one Monte Carlo replication of that parameter's estimate.}

\item{alpha}{Numeric. Significance level used to compute the (1 - alpha) confidence interval.
Default is 0.05 for a 95\% confidence interval.}
}
\value{
A data frame with one row per parameter and the following columns:
\describe{
\item{Parameter}{The name of the parameter.}
\item{Estimate}{The average estimate across all Monte Carlo replications.}
\item{SE}{The standard deviation of the estimates (standard error).}
\item{CI_lower}{The lower bound of the confidence interval.}
\item{CI_upper}{The upper bound of the confidence interval.}
}
}
\description{
Computes summary statistics for Monte Carlo simulation results, including
the mean estimate, standard error (SE), and confidence intervals (CIs).
}
\keyword{internal}
