# helper: strip Alpha coefs (keep names!)
#' @noRd
.xhaz_strip_alpha <- function(mod) {
  if (!is.null(mod$coef)) {
    nm   <- names(mod$coef)
    kill <- grepl("alpha", nm, ignore.case = TRUE)
    if (any(kill)) {
      keep       <- !kill
      mod$coef   <- mod$coef[keep]               # keeps names
      if (!is.null(mod$vcov)) {
        mod$vcov <- mod$vcov[keep, keep, drop=FALSE]
        # also keep dimnames consistent if present
        dn <- dimnames(mod$vcov)
        if (!is.null(dn)) dimnames(mod$vcov) <- list(nm[keep], nm[keep])
      }
    }
  }
  mod
}

#' @export
#' @method predict xhaz
predict.xhaz <- function(object, ..., time.pts=NULL, data.val=NULL, marginal=FALSE) {
  object2 <- .xhaz_strip_alpha(object)
  # delegate to mexhaz predict by prepending its class on the copy
  class(object2) <- unique(c("mexhaz", class(object2)))
  stats::predict(object2, time.pts=time.pts, data.val=data.val, marginal=marginal, ...)
}
