#' @keywords internal
#' @noRd
without_breakpoint_without_cut <- function(
    formula = formula,
    data = data,
    ratetable = NULL,
    rmap = rmap,
    baseline = baseline,
    pophaz = pophaz,
    only_ehazard = only_ehazard,
    add.rmap = NULL,
    add.rmap.cut = NULL,
    interval = interval,
    splitting = FALSE,
    ratedata = NULL,
    subset = subset,
    na.action = na.action,
    init = init,
    control = control,
    optim = optim,
    scale = 365.241,
    trace = trace,
    speedy = speedy,
    nghq = nghq,
    m_int = m_int,
    rcall = rcall,
    method = method,    ...){

  time_elapsed0 <- as.numeric(base::proc.time()[3])
  Call <- match.call()
  m <- match.call(expand.dots = FALSE)

  indx <- match(c("formula", "data"), names(Call), nomatch = 0)
  if (indx[1] == 0) stop("A formula argument is required")
  temp <- Call[c(1, indx)]; temp[[1L]] <- as.name("model.frame")

  special <- c("strata")
  Terms <- if (missing(data)) terms(formula, special) else terms(formula, special, data = data)
  temp$formula <- Terms
  m <- eval(temp, sys.parent())

  if (missing(na.action)) {
    na.action <- NULL
  } else if (length(attr(m, "na.action"))) {
    temp$na.action <- na.pass
    m <- eval(temp, sys.parent())
  }

  ehazardInt <- NULL

  if (!is.null(pophaz)) {
    pophaz <- match.arg(pophaz, c("classic", "rescaled", "corrected"))
  }

  has_ratetable <- (!missing(ratetable)) && survival::is.ratetable(ratetable)
  has_ratedata  <- !is.null(ratedata)
  if (!has_ratetable & !has_ratedata) {
    stop("Provide either 'ratetable' (e.g., survival::survexp.us) or 'ratedata' (pre-tabulated).")
  }
  if (has_ratetable & has_ratedata) {
    stop("Provide only one of 'ratetable' or 'ratedata', not both.")
  }

  if (missing(data)) {
    stop("Missing 'data' (data frame in which to interpret variables named in the formula).")
  } else if (has_ratetable) {
    if (is.na(match(rmap$age,  names(data)))) stop("Must have information for 'age' in the data set.")
    if (is.na(match(rmap$sex,  names(data)))) stop("Must have information for 'sex' in the data set.")
    if (is.na(match(rmap$year, names(data)))) stop("Must have information for 'year' (Date) in the data set.")

    if (survival::is.ratetable(ratetable)) {
      varlist <- attr(ratetable, "dimid")
      if (is.null(varlist)) varlist <- names(attr(ratetable, "dimnames"))
      if (is.null(attributes(ratetable)$dimid)) attributes(ratetable)$dimid <- varlist
    } else stop("Invalid rate table")

    varsexID <- which(varlist == 'sex')
    rt_sex_levels <- attr(ratetable, "dimnames")[[varsexID]]
    data_sex_vals <- unique(data[, rmap$sex])
    if (is.character(data_sex_vals)) {
      if (!all(tolower(data_sex_vals) %in% tolower(rt_sex_levels))) {
        stop("Levels of 'sex' in data do not match ratetable.")
      }
    }

    if (!missing(rmap)) {
      condition2 <- isTRUE(add.rmap.cut$breakpoint) && is.na(add.rmap.cut$cut[1]) && !is.null(add.rmap.cut$probs)
      if ((!splitting & missing(rcall)) || condition2) {
        rcall <- substitute(rmap)
      } else if (!splitting & !missing(rcall)) {
        rmap <- eval(rmap)
      }
      if (!is.call(rcall) || rcall[[1]] != as.name("list")) stop("Invalid rcall argument")
    } else {
      rcall <- NULL
    }

    temp01 <- match(names(rcall)[-1], varlist)

    if (any(is.na(temp01)))
      stop("Variable not found in the ratetable: ", paste0(names(rcall)[-1][is.na(temp01)], collapse = ", "))

    temp02 <- match(as.vector(unlist(rmap)), names(data))
    if (any(is.na(temp02))) {
      miss <- as.vector(unlist(rmap))[is.na(temp02)]
      stop("Variable not found in 'data': ", paste0(miss, collapse = ", "))
    }
  } else { # ratedata path
    if (is.null(pophaz)) {
      ehazardInt <- rep(0, nrow(data))
      ehazard <- rep(0, nrow(data))
    } else {
      stop("Check if you want to fit an excess hazard model or overall hazard model!")
    }
  }

  if (control$iter.max < 0) stop("Invalid value for iterations.")
  if (control$eps <= 0)     stop("Invalid convergence criteria.")
  if (control$level < 0 | control$level > 1) stop("Invalid confidence level.")

  if (missing(init)) init <- NULL
  if (missing(interval)) stop("Missing cutpoints definition for intervals.")
  if (!is.numeric(interval)) stop("Wrong 'interval' values; must be numeric.")

  if (min(interval, na.rm = TRUE) != 0) stop("First interval must start at 0.")
  if (any(interval < 0, na.rm = TRUE))  stop("Negative value not allowed in 'interval'.")

  myvarnames <- colnames(model.matrix(Terms, m)[, -1, drop = FALSE])
  qbs_id <- which(stringr::str_detect(myvarnames, "qbs"))
  if (length(qbs_id) > 0) {
    if (length(interval) > 4)
      stop("Interval must have 4 values using bsplines (2 internal knots plus '0' and end of study).")
  } else if (baseline == "bsplines") {
    if (length(interval) > 4)
      stop("Interval must have 4 values using bsplines (2 internal knots plus '0' and end of study).")
  }

  Y <- model.extract(m, "response")
  if (!inherits(Y, "Surv")) stop("Response must be a survival object.")

  strats <- attr(Terms, "specials")$strata
  dropx <- NULL

  if (length(strats)) {
    if (length(qbs_id) > 0) stop("Strata() not yet implemented for the B-splines model.")

    # survival:::untangle.specials(Terms, "strata", 1)
    sp <- attr(Terms, "specials")$strata
    if (is.null(sp)) sp <- integer(0)

    ord <- attr(Terms, "order")
    if (!is.null(ord) && length(sp)) sp <- sp[ord[sp] == 1L]

    tl <- attr(Terms, "term.labels")
    strata_labels <- if (length(sp)) tl[sp] else character(0)

    vars_names <- unique(unlist(lapply(strata_labels, function(lbl) {
      v <- all.vars(str2lang(lbl))
      setdiff(v, "strata")
    })))

    vars_idx <- integer(0)
    if (length(vars_names)) {
      vars_idx <- match(vars_names, names(m))
      vars_idx <- vars_idx[!is.na(vars_idx)]
    }

    tempS <- list(terms = sp, vars = vars_idx)

    dropx <- c(dropx, tempS$terms)

    if (length(tempS$vars) == 1) {
      strata.keep <- m[[tempS$vars]]
    } else {
      strata.keep <- survival::strata(m[, tempS$vars, drop = FALSE], shortlabel = TRUE)
    }

    strats <- as.numeric(strata.keep)
    attr(Terms, "nstrata") <- max(strats)
  }


  attr(Terms, "intercept") <- 1

  X <- if (length(dropx)) model.matrix(Terms[-dropx], m)[, -1, drop = FALSE] else model.matrix(Terms, m)[, -1, drop = FALSE]

  if (length(qbs_id) > 0) {
    z_bsplines <- as.data.frame(model.matrix(Terms, m)[, -1, drop = FALSE][, qbs_id, drop = FALSE])
    z_bsplines_names <- stringr::str_remove(myvarnames[qbs_id], "qbs")
    colnames(z_bsplines) <- gsub("\\(|\\)", "", as.character(z_bsplines_names))
    colnames(X)[qbs_id] <- colnames(z_bsplines)
    z_bsplines <- as.matrix(z_bsplines)
    z_bsplines_vect <- rep(TRUE, ncol(z_bsplines))
    z_X_vect <- rep(FALSE, ncol(X)); z_X_vect[qbs_id] <- z_bsplines_vect
    covtest <- z_X_vect
  } else {
    covtest <- rep(FALSE, ncol(X))
  }

  type <- attr(Y, "type")
  if (ncol(Y) == 2) {
    time  <- Y[, 1]
    event <- Y[, 2]
  } else {
    time  <- Y[, 2] - Y[, 1]
    event <- Y[, 3]
  }
  event[time > max(interval, na.rm = TRUE)] <- 0
  time[ time > max(interval, na.rm = TRUE)] <- max(interval, na.rm = TRUE)
  if (length(qbs_id) > 0) Y[, 1] <- time

  if (is.null(data$break_interval)) {
    ageDiag <- data[, rmap$age]
    ageDC   <- ageDiag + time
  } else {
    ageDiag <- data$tstart
    ageDC   <- data$tstop
  }

  if (!is.null(pophaz)) {
    if (pophaz == "corrected") {
      if (is.null(add.rmap.cut$breakpoint)) stop("Missing breakpoint information")
      if (isTRUE(add.rmap.cut$breakpoint) && !is.na(add.rmap.cut$cut[1])) {
        min_ok <- min(c(data[, rmap$age], data[, rmap$age] + time))
        max_ok <- max(c(data[, rmap$age], data[, rmap$age] + time))
        if (min(add.rmap.cut$cut) < min_ok) stop("Breakpoint(s) smaller than the minimum age")
        if (max(add.rmap.cut$cut) > max_ok) stop("Breakpoint(s) greater than the maximum age")
      }
    }

    if (pophaz == "corrected") {
      if (!is.null(add.rmap)) {
        add.rmap.var <- add.rmap
        add.rmap <- data[, add.rmap]
      } else stop("Additional demographic variable must be specified for 'corrected' pophaz")
    } else if (pophaz == "rescaled") {
      if (!is.null(add.rmap)) stop("Additional demographic variable is not required for 'rescaled'")
      add.rmap <- as.factor(rep(1, nrow(data)))
    } else if (pophaz == "classic") {
      if (!is.null(add.rmap)) stop("Additional demographic variable is not required for 'classic'")
    }

    if (isTRUE(only_ehazard) && pophaz != "classic") {
      stop("Cumulative expected hazard is also required for this type of model.")
    }

    if (!is.null(data$break_interval)) {
      if (has_ratetable) {
        exphaz <- exphaz_years(ageDiag = data$tstart, time = time, data = data,
                               rmap = rmap, ratetable = ratetable,
                               varlist = varlist, temp01 = temp01,
                               scale = scale, pophaz = pophaz, only_ehazard = only_ehazard)
      } else {
        exphaz <- exphaz_years(ageDiag = data$tstart, time = time, data = data,
                               rmap = rmap, ratedata = ratedata,
                               scale = scale, pophaz = pophaz, add.rmap = add.rmap,
                               only_ehazard = only_ehazard)
      }
      ehazard    <- exphaz$ehazard
      ehazardInt <- exphaz$ehazardInt %||% rep(NA_real_, length(time))
      if (has_ratetable) dateDiag <- exphaz$dateDiag
    } else {
      if (has_ratetable) {
        exphaz <- exphaz_years(ageDiag = ageDiag, time = time, data = data,
                               rmap = rmap, ratetable = ratetable,
                               varlist = varlist, temp01 = temp01,
                               scale = scale, pophaz = pophaz, only_ehazard = only_ehazard)
      } else {
        exphaz <- exphaz_years(ageDiag = ageDiag, time = time, data = data,
                               rmap = rmap, ratedata = ratedata,
                               scale = scale, pophaz = pophaz, add.rmap = add.rmap,
                               only_ehazard = only_ehazard)
      }
      ehazard    <- exphaz$ehazard
      ehazardInt <- exphaz$ehazardInt %||% rep(NA_real_, length(time))
      if (has_ratetable) dateDiag <- exphaz$dateDiag
    }
  }

  if (sum(is.na(interval)) > 0) {
    n.cut <- sum(is.na(interval))
    q.values <- cumsum(rep(1 / (n.cut + 1), n.cut))
    if (baseline == "bsplines" & (n.cut != 2)) {
      if (n.cut != 3) q.values <- c(0.05, 0.95) else stop("Must have 2 internal knots using bsplines.")
    }
    l.cut <- stats::quantile(time[which(event %in% 1)], q.values)
    names(l.cut) <- NULL
    interval <- c(min(interval, na.rm = TRUE), l.cut, max(interval, na.rm = TRUE))
  }
  if ((length(interval) - 1) != sum(sapply(1:(length(interval) - 1),
                                           function(i, interval) (interval[i + 1] > interval[i]),
                                           interval = interval)))
    stop("Interval values are not in ascending order.")

  if (length(qbs_id) == 0) {
    z_X_vect <- covtest <- rep(FALSE, ncol(X))
    if ((length(z_X_vect) != ncol(X)) || (!is.logical(z_X_vect)) || any(is.na(z_X_vect)))
      stop("Invalid values for 'bsplines': must be a logical vector matching the covariates.")
    if (ncol(Y) > 2) stop("Time-dependent covariate not yet implemented for non-PH with bsplines.")
  } else {
    if (ncol(Y) > 2) stop("Time-dependent covariate not yet implemented for non-PH situation.")
  }

  baseline <- match.arg(baseline, c("constant", "bsplines"))

  if (baseline == "constant") {
    fitter <- get("esteve.ph.fit")
    if (!isTRUE(add.rmap.cut$breakpoint)) {
      fit <- fitter(X, Y, ehazard, ehazardInt, int = interval, covtest,
                    bsplines = z_X_vect, init, control, event, Terms, strats,
                    add.rmap, add.rmap.cut, ageDiag, ageDC, optim, trace, speedy, method)
    } else if (isTRUE(add.rmap.cut$breakpoint) && !is.na(add.rmap.cut$cut[1]) && is.null(add.rmap.cut$probs)) {
      fit <- fitter(X, Y, ehazard, ehazardInt, int = interval, covtest,
                    bsplines = z_X_vect, init, control, event, Terms, strats,
                    add.rmap, add.rmap.cut, ageDiag, ageDC, optim, trace, speedy, method)
    } else if (isTRUE(add.rmap.cut$breakpoint) && is.na(add.rmap.cut$cut[1]) && !is.null(add.rmap.cut$probs)) {
      fitter <- get("esteve.ph.fit")
      if (splitting) {
        nbreak <- length(add.rmap.cut$cut)
        allpos_break <- with(data, stats::quantile(ageDC[event == 1], probs = c(add.rmap.cut$probs)))
        cuted <- gtools::permutations(n = length(allpos_break), r = nbreak, v = allpos_break)
        cut2 <- if (nbreak > 1) unique(t(sapply(1:nrow(cuted), function(i) sort(cuted[i, ]))))
        else unique(matrix(sapply(1:nrow(cuted), function(i) sort(cuted[i, ])), ncol = 1))
        nmodels <- nrow(cut2)

        tofit <- lapply(1:nmodels, function(i) {
          add.rmap.cut$cut <- cut2[i, ]
          newdata2 <- tosplit(formula = formula, add.rmap.cut = add.rmap.cut, data = data,
                              rmap = rmap, interval = interval, subset = subset)
          data <- newdata2$tdata2
          if (is.null(data$break_interval)) {
            ageDiag <- data[, rmap$age]; ageDC <- ageDiag + time
          } else {
            ageDiag <- data$tstart; ageDC <- data$tstop; time <- with(data, c(tstop - tstart))
            add.rmap <- data[, add.rmap.var]
          }

          if (has_ratetable) {
            exphaz2 <- exphaz_years(ageDiag = ageDiag, time = time, data = data,
                                    rmap = rmap, ratetable = ratetable,
                                    varlist = varlist, temp01 = temp01,
                                    scale = scale, pophaz = pophaz, only_ehazard = only_ehazard)
            ehazard2    <- exphaz2$ehazard
            ehazardInt2 <- exphaz2$ehazardInt
            dateDiag2   <- exphaz2$dateDiag
          } else {
            exphaz2 <- exphaz_years(ageDiag = ageDiag, time = time, data = data,
                                    rmap = rmap, ratedata = ratedata,
                                    scale = scale, pophaz = pophaz, add.rmap = add.rmap,
                                    only_ehazard = only_ehazard)
            ehazard2    <- exphaz2$ehazard
            ehazardInt2 <- exphaz2$ehazardInt %||% rep(NA_real_, length(time))
          }

          newfit <- xhaz_split(formula = formula, data = data, ratetable = ratetable, rmap = rmap,
                               baseline  = baseline, pophaz = pophaz, only_ehazard = only_ehazard,
                               add.rmap = add.rmap, add.rmap.cut = add.rmap.cut, splitting  = splitting,
                               interval = interval, covtest = covtest, init = init, control = control,
                               optim = optim, scale = scale , trace = trace, speedy = speedy, nghq = nghq,
                               rcall = rcall, ...)
          X <- newfit$X; Y <- newfit$Y; event <- newfit$event; ageDC <- newfit$ageDC; ageDiag <- newfit$ageDiag

          testM(X, Y, ehazard = ehazard2, ehazardInt = ehazardInt2, int = interval, covtest,
                bsplines = z_X_vect, init, control, event, Terms, strats,
                add.rmap, add.rmap.cut, ageDiag = ageDiag, ageDC = ageDC, optim, trace, speedy, data)
        })

        if (length(which(stringr::str_detect(names(unlist(add.rmap.cut)), "print_stepwise"))) > 0) {
          if (add.rmap.cut$print_stepwise) {
            sapply(1:length(tofit), function(i) { cat("Model:", i, "\n"); print(tofit[[i]]); cat("\n") })
            cat("\n")
          }
        }

        allAIC <- suppressWarnings(sapply(1:length(tofit), function(i) as.numeric(try(tofit[[i]]$AIC, TRUE))))
        allBIC <- suppressWarnings(sapply(1:length(tofit), function(i) as.numeric(try(tofit[[i]]$BIC, TRUE))))
        if (add.rmap.cut$criterion == "AIC") {
          fit <- tofit[[which.min(allAIC)]]; fit$add.rmap.cut$cut <- c(cut2[which.min(allAIC), ])
        } else if (add.rmap.cut$criterion == "BIC") {
          fit <- tofit[[which.min(allBIC)]]; fit$add.rmap.cut$cut <- c(cut2[which.min(allBIC), ])
        }
        fit$data <- data
      } else {
        nbreak <- length(add.rmap.cut$cut)
        age_time <- ageDiag + time
        allpos_break <- with(data, stats::quantile(age_time[event == 1], probs = c(add.rmap.cut$probs)))
        cuted <- gtools::permutations(n = length(allpos_break), r = nbreak, v = allpos_break)
        cut2 <- if (nbreak > 1) unique(t(sapply(1:nrow(cuted), function(i) sort(cuted[i, ]))))
        else unique(matrix(sapply(1:nrow(cuted), function(i) sort(cuted[i, ])), ncol = 1))
        nmodels <- nrow(cut2)

        tofit <- lapply(1:nmodels, function(i) {
          add.rmap.cut$cut <- cut2[i, ]
          testM(X, Y, ehazard, ehazardInt, int = interval, covtest,
                bsplines = z_X_vect, init, control, event, Terms, strats,
                add.rmap, add.rmap.cut, ageDiag, ageDC, optim, trace, speedy, data)
        })

        if (length(which(stringr::str_detect(names(unlist(add.rmap.cut)), "print_stepwise"))) > 0) {
          if (add.rmap.cut$print_stepwise) {
            sapply(1:length(tofit), function(i) { cat("Model:", i, "\n"); print(tofit[[i]]); cat("\n") })
            cat("\n")
          }
        }

        allAIC <- suppressWarnings(sapply(1:length(tofit), function(i) as.numeric(try(tofit[[i]]$AIC, TRUE))))
        allBIC <- suppressWarnings(sapply(1:length(tofit), function(i) as.numeric(try(tofit[[i]]$BIC, TRUE))))
        if (which.min(allAIC) < 1) stop("No convergence with the proposed breakpoints")
        if (add.rmap.cut$criterion == "AIC") {
          fit <- tofit[[which.min(allAIC)]]; fit$add.rmap.cut$cut <- c(cut2[which.min(allAIC), ])
        } else if (add.rmap.cut$criterion == "BIC") {
          fit <- tofit[[which.min(allBIC)]]; fit$add.rmap.cut$cut <- c(cut2[which.min(allBIC), ])
        }
      }
    }
    oldClass(fit) <- "constant"
  } else {
    fitter <- get("giorgi.tdph.fit")
    fit <- fitter(X, Y, ehazard, ehazardInt, int = interval, covtest,
                  bsplines = z_X_vect, init, control, event, Terms, strats,
                  add.rmap, add.rmap.cut, ageDiag, ageDC, optim, trace, speedy,
                  nghq, pophaz, method)
    oldClass(fit) <- "bsplines"
    fit$z_bsplines <- z_X_vect
  }

  time_elapsed1 <- as.numeric(base::proc.time()[3])

  if (isTRUE(add.rmap.cut$breakpoint) && !is.na(add.rmap.cut$cut[1])) {
    fit$break.levels <- levels(cut(ageDC, breaks = c(min(ageDC), add.rmap.cut$cut, max(ageDC))))
  } else if (isTRUE(add.rmap.cut$breakpoint) && is.na(add.rmap.cut$cut[1])) {
    fit$break.levels <- levels(cut(ageDC, breaks = c(min(ageDC), fit$add.rmap.cut$cut, max(ageDC))))
  }

  fit$level <- control$level
  fit$interval <- interval
  fit$na.action <- na.action
  fit$n <- nrow(Y)
  fit$n.events <- sum(event, na.rm = TRUE)
  fit$formula <- as.vector(attr(Terms, "formula"))
  fit$call <- m_int
  fit$varcov <- fit$var; fit[["var"]] <- NULL
  fit$pophaz <- pophaz
  fit$method <- method
  fit$baseline <- baseline
  fit$add.rmap <- add.rmap
  fit$ehazard <- ehazard
  fit$ehazardInt <- ehazardInt
  fit$add.rmap.cut  <- add.rmap.cut
  fit$time_elapsed <- time_elapsed1 - time_elapsed0

  if (!splitting) {
    fit$data <- data
    fit$terms <- Terms
    fit$assign <- attr(X, "assign")
  }
  return(fit)
}

`%||%` <- function(a, b) if (is.null(a)) b else a

