% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIC.bsplines.R
\name{BIC.bsplines}
\alias{BIC.bsplines}
\title{Bayesian Information Criterion for excess hazard model with
baseline hazard following a B-splines functions}
\usage{
\method{BIC}{bsplines}(object, ...)
}
\arguments{
\item{object}{a fitted model object obtained from \code{xhaz} function}

\item{...}{optionally more fitted model objects obtained from \code{xhaz} function}
}
\value{
the value corresponds to the BIC calculated from the total
log-likelihood of the fitted model if just one object is provided.
If multiple objects are provided, a data.frame with columns corresponding to the
objects and rows representing the number of parameters in the model (df) and the BIC.
}
\description{
Calculates the Bayesian Information Criterion' for fitted
models from \code{xhaz}.
}
\examples{
\donttest{
library("xhaz")

#Giorgi et al model: baseline excess hazard is a quadratic Bsplines
#                    function with two interior knots and allow here a
#                    linear and proportional effects for the covariates on
#                    baseline excess hazard.

fitphBS <- xhaz(formula = survival::Surv(time_year, status) ~ agec + race,
                data = simuData,
                ratetable = survival::survexp.us,
                interval = c(0, NA, NA, 6),
                rmap = list(age = 'age', sex = 'sex', year = 'date'),
                baseline = "bsplines", pophaz = "classic")

fitphBS
BIC(fitphBS)
}

}
\keyword{internal}
