% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlmixr2.R
\name{nlmixr2_as_xtra}
\alias{nlmixr2_as_xtra}
\title{Convenience function for ingesting an nlmixr2 model to xpose and xpose.xtras}
\usage{
nlmixr2_as_xtra(obj, ..., .skip_assoc = FALSE)
}
\arguments{
\item{obj}{nlmixr2 fit object}

\item{...}{Passed to \link[xpose.nlmixr2:xpose_data_nlmixr2]{xpose_data_nlmixr2}}

\item{.skip_assoc}{<\code{logical}> If the model is relatively uncomplicated, \code{\link[=nlmixr2_prm_associations]{nlmixr2_prm_associations()}}
may be able to recognize relationships between random effects and fixed effect parameters. If the default
(\code{FALSE}) fails then try to rerun with the association step skipped.}
}
\value{
An <\code{xp_xtra}> object with fit attached
}
\description{
A wrapper that executes the pipeline:

\preformatted{
obj |>
 xpose.nlmixr2::xpose_data_nlmixr2() |>
 attach_nlmixr2() |>
 as_xp_xtras() |>
 backfill_nlmixr2_props() %>%
 `if`(.skip_assoc, ., nlmixr2_prm_associations(.))
}
}
\seealso{
\code{\link[=attach_nlmixr2]{attach_nlmixr2()}}
}
