% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapframe.R
\name{mapframe.ggplot}
\alias{mapframe.ggplot}
\title{Coerce ggplot Mappings to Dataframe}
\usage{
\method{mapframe}{ggplot}(x, ...)
}
\arguments{
\item{x}{ggplot}

\item{...}{ignored}
}
\value{
data.frame
}
\description{
Coerces ggplot mappings to 'data.frame'.
}
\details{
* 'aesthetic' captures each aesthetic label as a string.
* 'map' captures each map (typ. a column name) as a string.
* 'layer' is zero for the default mapping, else the layer number.
* 'data' is NA for default data if missing. Else zero for x$data,
    zero for layers with no data, and layer number for layers with data.
}
\examples{
library(ggplot2)
mapframe(ggplot(mapping = aes(conc, time, shape = factor(dose))))
}
\seealso{
Other decorated_ggplot: 
\code{\link{data_context}()},
\code{\link{data_context.ggplot}()},
\code{\link{ggplot.decorated}()},
\code{\link{ggplot_build.decorated_ggplot}()},
\code{\link{mapframe}()},
\code{\link{mapframe.default}()}
}
\concept{decorated_ggplot}
\keyword{internal}
