% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_types.R
\docType{class}
\name{zarr_data_type}
\alias{zarr_data_type}
\title{Zarr data types}
\description{
This class implements a Zarr data type as an extension point.
This class also manages the "fill_value" attribute associated with the data
type.
}
\section{Super class}{
\code{\link[zarr:zarr_extension]{zarr::zarr_extension}} -> \code{zarr_data_type}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{data_type}}{The data type for the Zarr array, a single character
string. Setting the data type will also set the fill value to its
default value.}

\item{\code{Rtype}}{(read-only) The R data type corresponding to the Zarr data
type.}

\item{\code{signed}}{(read-only) Flag that indicates if the Zarr data type is
signed or not.}

\item{\code{size}}{(read-only) The size of the data type, in bytes.}

\item{\code{fill_value}}{The fill value for the Zarr array, a single value that
agrees with the range of the \code{data_type}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-zarr_data_type-new}{\code{zarr_data_type$new()}}
\item \href{#method-zarr_data_type-print}{\code{zarr_data_type$print()}}
\item \href{#method-zarr_data_type-metadata_fragment}{\code{zarr_data_type$metadata_fragment()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_data_type-new"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_data_type-new}{}}}
\subsection{Method \code{new()}}{
Create a new data type object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_data_type$new(data_type, fill_value = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_type}}{The name of the data type, a single character string.}

\item{\code{fill_value}}{Optionally, the fill value for the data type.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An instance of this class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_data_type-print"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_data_type-print}{}}}
\subsection{Method \code{print()}}{
Print a summary of the data type to the console.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_data_type$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_data_type-metadata_fragment"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_data_type-metadata_fragment}{}}}
\subsection{Method \code{metadata_fragment()}}{
Return the metadata fragment for this data type and its fill
value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_data_type$metadata_fragment()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list with the metadata fragment.
}
}
}
