







use alloc::slice;
#[allow(unused_imports)]
use rawpointer::PointerExt;
use std::mem::MaybeUninit;

use crate::imp_prelude::*;

use crate::{Baseiter, ElementsBase, ElementsBaseMut, Iter, IterMut};

use crate::dimension::offset_from_low_addr_ptr_to_logical_ptr;
use crate::iter::{self, AxisIter, AxisIterMut};
use crate::math_cell::MathCell;
use crate::IndexLonger;


impl<'a, A, D> ArrayView<'a, A, D>
where D: Dimension
{
    
    
    pub fn reborrow<'b>(self) -> ArrayView<'b, A, D>
    where 'a: 'b
    {
        unsafe { ArrayView::new(self.ptr, self.dim, self.strides) }
    }

    
    
    
    
    
    pub fn to_slice(&self) -> Option<&'a [A]>
    {
        if self.is_standard_layout() {
            unsafe { Some(slice::from_raw_parts(self.ptr.as_ptr(), self.len())) }
        } else {
            None
        }
    }

    
    
    
    
    
    
    pub fn to_slice_memory_order(&self) -> Option<&'a [A]>
    {
        if self.is_contiguous() {
            let offset = offset_from_low_addr_ptr_to_logical_ptr(&self.dim, &self.strides);
            unsafe { Some(slice::from_raw_parts(self.ptr.sub(offset).as_ptr(), self.len())) }
        } else {
            None
        }
    }

    
    #[inline]
    pub(crate) fn into_raw_view(self) -> RawArrayView<A, D>
    {
        unsafe { RawArrayView::new(self.ptr, self.dim, self.strides) }
    }
}




impl<'a, A> ArrayView<'a, A, Ix0>
{
    
    
    
    
    
    
    
    
    
    /// #[derive(Debug, Eq, PartialEq)]
    
    
    
    
    
    
    
    pub fn into_scalar(self) -> &'a A
    {
        self.index(Ix0())
    }
}




impl<'a, A> ArrayViewMut<'a, A, Ix0>
{
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    pub fn into_scalar(self) -> &'a mut A
    {
        self.index(Ix0())
    }
}


impl<'a, A, D> ArrayViewMut<'a, A, D>
where D: Dimension
{
    
    
    
    
    
    pub fn into_slice(self) -> Option<&'a mut [A]>
    {
        self.try_into_slice().ok()
    }

    
    
    
    
    
    
    pub fn into_slice_memory_order(self) -> Option<&'a mut [A]>
    {
        self.try_into_slice_memory_order().ok()
    }

    
    
    
    
    
    
    pub fn into_cell_view(self) -> ArrayView<'a, MathCell<A>, D>
    {
        
        
        
        unsafe {
            self.into_raw_view_mut()
                .cast::<MathCell<A>>()
                .deref_into_view()
        }
    }

    
    
    
    
    
    
    
    
    /// # Safety
    
    
    
    
    pub(crate) unsafe fn into_maybe_uninit(self) -> ArrayViewMut<'a, MaybeUninit<A>, D>
    {
        
        
        
        
        self.into_raw_view_mut()
            .cast::<MaybeUninit<A>>()
            .deref_into_view_mut()
    }
}


impl<A, D> RawArrayView<A, D>
where D: Dimension
{
    #[inline]
    pub(crate) fn into_base_iter(self) -> Baseiter<A, D>
    {
        unsafe { Baseiter::new(self.ptr, self.dim, self.strides) }
    }
}

impl<A, D> RawArrayViewMut<A, D>
where D: Dimension
{
    #[inline]
    pub(crate) fn into_base_iter(self) -> Baseiter<A, D>
    {
        unsafe { Baseiter::new(self.ptr, self.dim, self.strides) }
    }
}


impl<'a, A, D> ArrayView<'a, A, D>
where D: Dimension
{
    #[inline]
    pub(crate) fn into_base_iter(self) -> Baseiter<A, D>
    {
        unsafe { Baseiter::new(self.ptr, self.dim, self.strides) }
    }

    #[inline]
    pub(crate) fn into_elements_base(self) -> ElementsBase<'a, A, D>
    {
        ElementsBase::new(self)
    }

    pub(crate) fn into_iter_(self) -> Iter<'a, A, D>
    {
        Iter::new(self)
    }

    
    #[doc(hidden)] // not official
    #[deprecated(note = "This method will be replaced.")]
    pub fn into_outer_iter(self) -> iter::AxisIter<'a, A, D::Smaller>
    where D: RemoveAxis
    {
        AxisIter::new(self, Axis(0))
    }
}

impl<'a, A, D> ArrayViewMut<'a, A, D>
where D: Dimension
{
    
    pub(crate) fn into_view(self) -> ArrayView<'a, A, D>
    {
        unsafe { ArrayView::new(self.ptr, self.dim, self.strides) }
    }

    
    pub(crate) fn into_raw_view_mut(self) -> RawArrayViewMut<A, D>
    {
        unsafe { RawArrayViewMut::new(self.ptr, self.dim, self.strides) }
    }

    #[inline]
    pub(crate) fn into_base_iter(self) -> Baseiter<A, D>
    {
        unsafe { Baseiter::new(self.ptr, self.dim, self.strides) }
    }

    #[inline]
    pub(crate) fn into_elements_base(self) -> ElementsBaseMut<'a, A, D>
    {
        ElementsBaseMut::new(self)
    }

    
    
    pub(crate) fn try_into_slice(self) -> Result<&'a mut [A], Self>
    {
        if self.is_standard_layout() {
            unsafe { Ok(slice::from_raw_parts_mut(self.ptr.as_ptr(), self.len())) }
        } else {
            Err(self)
        }
    }

    
    
    fn try_into_slice_memory_order(self) -> Result<&'a mut [A], Self>
    {
        if self.is_contiguous() {
            let offset = offset_from_low_addr_ptr_to_logical_ptr(&self.dim, &self.strides);
            unsafe { Ok(slice::from_raw_parts_mut(self.ptr.sub(offset).as_ptr(), self.len())) }
        } else {
            Err(self)
        }
    }

    pub(crate) fn into_iter_(self) -> IterMut<'a, A, D>
    {
        IterMut::new(self)
    }

    
    #[doc(hidden)] // not official
    #[deprecated(note = "This method will be replaced.")]
    pub fn into_outer_iter(self) -> iter::AxisIterMut<'a, A, D::Smaller>
    where D: RemoveAxis
    {
        AxisIterMut::new(self, Axis(0))
    }
}
