-- $Id: fntbuild-doc.lua 10769 2025-02-05 20:41:12Z cfrees $
-------------------------------------------------
-- fntbuild-doc
-------------------------------------------------
-------------------------------------------------
-- redefine l3build fn
-------------------------------------------------
-- local doc_init {{{
---Additional setup for typesetting tailored to font packages with optional 
---creation of template-based docs e.g. font tables.
---@return 0 on success, error level otherwise
---@see l3build
---@usage N/A
local function doc_init ()
  -- local fdfiles = filelist(fnt.keepdir, "*.fd")
  local fdfiles = filelist(unpackdir, "*.fd")
  local filename = fnt.tablestemp 
  local targname = ctanpkg .. "-tables.tex"
  local file = unpackdir .. "/" .. filename
  local targfile = unpackdir .. "/" .. targname
  local coll = ""
  -- local fnttestdir = maindir .. "/fnt-tests"
  local maps = ""
  local mapfiles=filelist(unpackdir, "*.map")
  local yy = 0
  for i, j in ipairs(mapfiles) do
    maps = maps .. "\n\\pdfmapfile{-" .. j .. "}\n\\pdfmapfile{+" .. j .. "}"
  end
  if not fileexists(unpackdir .. "/" .. filename) then
    if fileexists(typesetdir .. "/" .. filename) then
      cp(filename,typesetdir,unpackdir)
      print("Using " .. filename .. " from " .. typesetdir .. ".")
    elseif fileexists(localdir .. "/" .. filename) then
      cp(filename,localdir,unpackdir)
      print("Using " .. filename .. " from " .. localdir .. ".")
    else
      local ffeil = kpse.find_file(filename)
      if ffeil ~= nil then 
        cp(filename,dirname(ffeil),unpackdir)
        print("Using " .. filename .. " from " .. dirname(ffeil) .. ".")
      else
        print("Skipping font tables.\n")
        filename = nil
      end
    end
  else
    print("Using " .. filename .. " from " .. unpackdir .. ".")
  end
  if filename then
    print("Creating font tables ...\n")
    -- need to get content here
    -- copy this from l3build-tagging.lua
    local f = assert(io.open(file,"rb"))
    local content = f:read("*all")
    f:close()
    -- ought to normalise line endings here 
    -- copied from l3build
    -- but I don't understand why the first subs is needed
    -- is it a problem if the file doesn't end with a newline?
    content = string.gsub(content .. (string.match(content,"\n$") and "" 
    or "\n"), "\r\n", "\n") 
    content = string.gsub(content, 
    "\\RequirePackage%{svn%-prov%}\n\\ProvidesFileSVN%{[^%}]*%}%[[^%]]*%]%[[^%]]*%]\n", 
    "")
    -- l3build-tagging.lua
    for i, j in ipairs(fdfiles) do
      if string.match(j,"^ly1") then
        yy = 1
      end
      j = unpackdir .. "/" .. j
      for line in io.lines(j) do
        if string.match(line,
          "^\\DeclareFontShape%{[^%}]*%}%{[^%}]*%}%{[^%}]*%}%{[^%}]*%}%{$"
        ) then
        coll = (coll .. string.gsub(string.gsub(line,"%{$","%%%%"),
        "^\\DeclareFontShape","\n\\sampletable"))
      end
    end
  end
  if yy == 1 then
    maps = "\n\\input{ly1enc.def}\n" .. maps
  end
  coll = maps .. "\n\\begin{document}\n" .. coll .. "\n\\end{document}\n"
  local new_content =  
  "%% Do not edit this file as changes will be overwritten.\n%% It was generated by l3build on " 
  .. os.date("%Y-%M-%d %H:%m:%S") .. ".\n" .. string.gsub(content, 
  "\n%s*TABLES%s*\n", coll)
  local f = assert(io.open(targfile,"w"))
  f:write((string.gsub(new_content,"\n",fnt.os_newline_cp)))
  f:close()
  rm(unpackdir,filename)
  cp(targname,unpackdir,typesetdir)
  end
  return 0
end
-- }}}
-------------------------------------------------
-------------------------------------------------
-- exports {{{
fnt.docinit_hook = doc_init
-- }}}
-------------------------------------------------
-------------------------------------------------
-- vim: ts=2:sw=2:et:foldmethod=marker:
