# Gujarati (gu) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                  | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ------------------------------------------------ | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987                                             | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                                | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987                                             | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 4                                                | 0003-12-29T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | Q1                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Q2                                               | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1લો ત્રિમાસ                                      | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2જો ત્રિમાસ                                      | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | Q1                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Q2                                               | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1લો ત્રિમાસ                                      | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2જો ત્રિમાસ                                      | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2                                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | ફેબ્રુ                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | જુલાઈ                                            | 2019-07-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | ફેબ્રુઆરી                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | જુલાઇ                                            | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | ફે                                               | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | જુ                                               | Invalid Date             |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2                                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | ફેબ્રુ                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | જુલાઈ                                            | 2019-07-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | ફેબ્રુઆરી                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | જુલાઇ                                            | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | ફે                                               | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | જુ                                               | Invalid Date             |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1                                                | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                               | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1                                                | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                               | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28                                               | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365                                              | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | સોમ                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | શુક્ર                                            | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | સોમ                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | શુક્ર                                            | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | સોમ                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | શુક્ર                                            | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | સોમવાર                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | શુક્રવાર                                         | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | સો                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | શુ                                               | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | સો                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | શુ                                               | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                                | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | સોમ                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | શુક્ર                                            | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | સોમવાર                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | શુક્રવાર                                         | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | સો                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | શુ                                               | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | સો                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | શુ                                               | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                                | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | સોમ                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | શુક્ર                                            | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | સોમવાર                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | શુક્રવાર                                         | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | સો                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | શુ                                               | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | સો                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | શુ                                               | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                                | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | સોમ                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | શુક્ર                                            | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | સોમવાર                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | શુક્રવાર                                         | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | સો                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | શુ                                               | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | સો                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | શુ                                               | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | AM                                               | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                               | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                               | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                               | Invalid Date             |
|                                 | aa           | 2019-02-11T11:13:14.015Z | AM                                               | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                               | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                               | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                               | Invalid Date             |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | am                                               | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                               | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                               | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                               | Invalid Date             |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | AM                                               | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                               | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                               | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                               | Invalid Date             |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | AM                                               | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                               | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                               | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                               | Invalid Date             |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | AM                                               | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                               | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                               | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                               | Invalid Date             |
|                                 | bb           | 2019-02-11T11:13:14.015Z | AM                                               | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                               | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                               | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                               | Invalid Date             |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | am                                               | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                               | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                               | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                               | Invalid Date             |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | AM                                               | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                               | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                               | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                               | Invalid Date             |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | AM                                               | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                               | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                               | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                               | Invalid Date             |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | સવારે                                            | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | બપોરે                                            | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | સાંજે                                            | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | રાત્રે                                           | Invalid Date             |
|                                 | BB           | 2019-02-11T11:13:14.015Z | સવારે                                            | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | બપોરે                                            | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | સાંજે                                            | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | રાત્રે                                           | Invalid Date             |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | સવારે                                            | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | બપોરે                                            | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | સાંજે                                            | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | રાત્રે                                           | Invalid Date             |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | સવારે                                            | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | બપોરે                                            | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | સાંજે                                            | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | રાત્રે                                           | Invalid Date             |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | સવારે                                            | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | બપોરે                                            | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | સાંજે                                            | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | રાત્રે                                           | Invalid Date             |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11                                               | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                               | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11                                               | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                               | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11                                               | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                               | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11                                               | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                               | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1                                                | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55                                               | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1                                                | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55                                               | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 11/2/87                                          | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/5/53                                          | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 11 ફેબ્રુ, 1987                                  | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 મે, 1453                                      | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | 11 ફેબ્રુઆરી, 1987                               | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 મે, 1453                                      | 1453-05-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | બુધવાર, 11 ફેબ્રુઆરી, 1987                       | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | રવિવાર, 29 મે, 1453                              | 1453-05-29T00:00:00.000Z |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13 PM                                         | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59 PM                                         | Invalid Date             |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14 PM                                      | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 PM                                      | Invalid Date             |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 PM GMT+0                                | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 PM GMT+0                                | Invalid Date             |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12:13:14 PM GMT+00:00                            | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 PM GMT+00:00                            | Invalid Date             |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 11/2/87 12:13 PM                                 | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/5/53 11:59 PM                                 | Invalid Date             |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 11 ફેબ્રુ, 1987 12:13:14 PM                      | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 મે, 1453 11:59:59 PM                          | Invalid Date             |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | 11 ફેબ્રુઆરી, 1987 12:13:14 PM GMT+0             | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 મે, 1453 11:59:59 PM GMT+0                    | Invalid Date             |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | બુધવાર, 11 ફેબ્રુઆરી, 1987 12:13:14 PM GMT+00:00 | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | રવિવાર, 29 મે, 1453 11:59:59 PM GMT+00:00        | Invalid Date             |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result       | `includeSeconds: true` | `addSuffix: true`   |
| ------------------------ | ------------ | ---------------------- | ------------------- |
| 2006-01-01T00:00:00.000Z | આશરે 6 વર્ષ  | આશરે 6 વર્ષ            | આશરે 6 વર્ષમાં      |
| 2005-01-01T00:00:00.000Z | આશરે 5 વર્ષ  | આશરે 5 વર્ષ            | આશરે 5 વર્ષમાં      |
| 2004-01-01T00:00:00.000Z | આશરે 4 વર્ષ  | આશરે 4 વર્ષ            | આશરે 4 વર્ષમાં      |
| 2003-01-01T00:00:00.000Z | આશરે 3 વર્ષ  | આશરે 3 વર્ષ            | આશરે 3 વર્ષમાં      |
| 2002-01-01T00:00:00.000Z | આશરે 2 વર્ષ  | આશરે 2 વર્ષ            | આશરે 2 વર્ષમાં      |
| 2001-06-01T00:00:00.000Z | 1 વર્ષથી વધુ | 1 વર્ષથી વધુ           | 1 વર્ષથી વધુમાં     |
| 2001-02-01T00:00:00.000Z | આશરે 1 વર્ષ  | આશરે 1 વર્ષ            | આશરે 1 વર્ષમાં      |
| 2001-01-01T00:00:00.000Z | આશરે 1 વર્ષ  | આશરે 1 વર્ષ            | આશરે 1 વર્ષમાં      |
| 2000-06-01T00:00:00.000Z | 5 મહિના      | 5 મહિના                | 5 મહિનામાં          |
| 2000-03-01T00:00:00.000Z | 2 મહિના      | 2 મહિના                | 2 મહિનામાં          |
| 2000-02-01T00:00:00.000Z | આશરે 1 મહિનો | આશરે 1 મહિનો           | આશરે 1 મહિનોમાં     |
| 2000-01-15T00:00:00.000Z | 14 દિવસ      | 14 દિવસ                | 14 દિવસમાં          |
| 2000-01-02T00:00:00.000Z | 1 દિવસ       | 1 દિવસ                 | 1 દિવસમાં           |
| 2000-01-01T06:00:00.000Z | ​આશરે 6 કલાક | ​આશરે 6 કલાક           | ​આશરે 6 કલાકમાં     |
| 2000-01-01T01:00:00.000Z | ​આશરે 1 કલાક | ​આશરે 1 કલાક           | ​આશરે 1 કલાકમાં     |
| 2000-01-01T00:45:00.000Z | ​આશરે 1 કલાક | ​આશરે 1 કલાક           | ​આશરે 1 કલાકમાં     |
| 2000-01-01T00:30:00.000Z | 30 મિનિટ     | 30 મિનિટ               | 30 મિનિટમાં         |
| 2000-01-01T00:15:00.000Z | 15 મિનિટ     | 15 મિનિટ               | 15 મિનિટમાં         |
| 2000-01-01T00:01:00.000Z | 1 મિનિટ      | 1 મિનિટ                | 1 મિનિટમાં          |
| 2000-01-01T00:00:25.000Z | આ મિનિટ      | અડધી મિનિટ             | આ મિનિટમાં          |
| 2000-01-01T00:00:15.000Z | આ મિનિટ      | ​આશરે 20 સેકંડ         | આ મિનિટમાં          |
| 2000-01-01T00:00:05.000Z | આ મિનિટ      | ​આશરે 10 સેકંડ         | આ મિનિટમાં          |
| 2000-01-01T00:00:00.000Z | આ મિનિટ      | ​આશરે 5 સેકંડ          | આ મિનિટ પહેલાં      |
| 1999-12-31T23:59:55.000Z | આ મિનિટ      | ​આશરે 10 સેકંડ         | આ મિનિટ પહેલાં      |
| 1999-12-31T23:59:45.000Z | આ મિનિટ      | ​આશરે 20 સેકંડ         | આ મિનિટ પહેલાં      |
| 1999-12-31T23:59:35.000Z | આ મિનિટ      | અડધી મિનિટ             | આ મિનિટ પહેલાં      |
| 1999-12-31T23:59:00.000Z | 1 મિનિટ      | 1 મિનિટ                | 1 મિનિટ પહેલાં      |
| 1999-12-31T23:45:00.000Z | 15 મિનિટ     | 15 મિનિટ               | 15 મિનિટ પહેલાં     |
| 1999-12-31T23:30:00.000Z | 30 મિનિટ     | 30 મિનિટ               | 30 મિનિટ પહેલાં     |
| 1999-12-31T23:15:00.000Z | ​આશરે 1 કલાક | ​આશરે 1 કલાક           | ​આશરે 1 કલાક પહેલાં |
| 1999-12-31T23:00:00.000Z | ​આશરે 1 કલાક | ​આશરે 1 કલાક           | ​આશરે 1 કલાક પહેલાં |
| 1999-12-31T18:00:00.000Z | ​આશરે 6 કલાક | ​આશરે 6 કલાક           | ​આશરે 6 કલાક પહેલાં |
| 1999-12-30T00:00:00.000Z | 2 દિવસ       | 2 દિવસ                 | 2 દિવસ પહેલાં       |
| 1999-12-15T00:00:00.000Z | 17 દિવસ      | 17 દિવસ                | 17 દિવસ પહેલાં      |
| 1999-12-01T00:00:00.000Z | આશરે 1 મહિનો | આશરે 1 મહિનો           | આશરે 1 મહિનો પહેલાં |
| 1999-11-01T00:00:00.000Z | 2 મહિના      | 2 મહિના                | 2 મહિના પહેલાં      |
| 1999-06-01T00:00:00.000Z | 7 મહિના      | 7 મહિના                | 7 મહિના પહેલાં      |
| 1999-01-01T00:00:00.000Z | આશરે 1 વર્ષ  | આશરે 1 વર્ષ            | આશરે 1 વર્ષ પહેલાં  |
| 1998-12-01T00:00:00.000Z | આશરે 1 વર્ષ  | આશરે 1 વર્ષ            | આશરે 1 વર્ષ પહેલાં  |
| 1998-06-01T00:00:00.000Z | 1 વર્ષથી વધુ | 1 વર્ષથી વધુ           | 1 વર્ષથી વધુ પહેલાં |
| 1998-01-01T00:00:00.000Z | આશરે 2 વર્ષ  | આશરે 2 વર્ષ            | આશરે 2 વર્ષ પહેલાં  |
| 1997-01-01T00:00:00.000Z | આશરે 3 વર્ષ  | આશરે 3 વર્ષ            | આશરે 3 વર્ષ પહેલાં  |
| 1996-01-01T00:00:00.000Z | આશરે 4 વર્ષ  | આશરે 4 વર્ષ            | આશરે 4 વર્ષ પહેલાં  |
| 1995-01-01T00:00:00.000Z | આશરે 5 વર્ષ  | આશરે 5 વર્ષ            | આશરે 5 વર્ષ પહેલાં  |
| 1994-01-01T00:00:00.000Z | આશરે 6 વર્ષ  | આશરે 6 વર્ષ            | આશરે 6 વર્ષ પહેલાં  |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result   | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | -------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 વર્ષ   | 6 વર્ષમાં         | 52608 કલાક                     |
| 2005-01-01T00:00:00.000Z | 5 વર્ષ   | 5 વર્ષમાં         | 43848 કલાક                     |
| 2004-01-01T00:00:00.000Z | 4 વર્ષ   | 4 વર્ષમાં         | 35064 કલાક                     |
| 2003-01-01T00:00:00.000Z | 3 વર્ષ   | 3 વર્ષમાં         | 26304 કલાક                     |
| 2002-01-01T00:00:00.000Z | 2 વર્ષ   | 2 વર્ષમાં         | 17544 કલાક                     |
| 2001-06-01T00:00:00.000Z | 1 વર્ષ   | 1 વર્ષમાં         | 12408 કલાક                     |
| 2001-02-01T00:00:00.000Z | 1 વર્ષ   | 1 વર્ષમાં         | 9528 કલાક                      |
| 2001-01-01T00:00:00.000Z | 1 વર્ષ   | 1 વર્ષમાં         | 8784 કલાક                      |
| 2000-06-01T00:00:00.000Z | 5 મહિના  | 5 મહિનામાં        | 3648 કલાક                      |
| 2000-03-01T00:00:00.000Z | 2 મહિના  | 2 મહિનામાં        | 1440 કલાક                      |
| 2000-02-01T00:00:00.000Z | 1 મહિનો  | 1 મહિનોમાં        | 744 કલાક                       |
| 2000-01-15T00:00:00.000Z | 14 દિવસ  | 14 દિવસમાં        | 336 કલાક                       |
| 2000-01-02T00:00:00.000Z | 1 દિવસ   | 1 દિવસમાં         | 24 કલાક                        |
| 2000-01-01T06:00:00.000Z | 6 કલાક   | 6 કલાકમાં         | 6 કલાક                         |
| 2000-01-01T01:00:00.000Z | 1 કલાક   | 1 કલાકમાં         | 1 કલાક                         |
| 2000-01-01T00:45:00.000Z | 45 મિનિટ | 45 મિનિટમાં       | 1 કલાક                         |
| 2000-01-01T00:30:00.000Z | 30 મિનિટ | 30 મિનિટમાં       | 1 કલાક                         |
| 2000-01-01T00:15:00.000Z | 15 મિનિટ | 15 મિનિટમાં       | 0 કલાક                         |
| 2000-01-01T00:01:00.000Z | 1 મિનિટ  | 1 મિનિટમાં        | 0 કલાક                         |
| 2000-01-01T00:00:25.000Z | 25 સેકંડ | 25 સેકંડમાં       | 0 કલાક                         |
| 2000-01-01T00:00:15.000Z | 15 સેકંડ | 15 સેકંડમાં       | 0 કલાક                         |
| 2000-01-01T00:00:05.000Z | 5 સેકંડ  | 5 સેકંડમાં        | 0 કલાક                         |
| 2000-01-01T00:00:00.000Z | 0 સેકંડ  | 0 સેકંડ પહેલાં    | 0 કલાક                         |
| 1999-12-31T23:59:55.000Z | 5 સેકંડ  | 5 સેકંડ પહેલાં    | 0 કલાક                         |
| 1999-12-31T23:59:45.000Z | 15 સેકંડ | 15 સેકંડ પહેલાં   | 0 કલાક                         |
| 1999-12-31T23:59:35.000Z | 25 સેકંડ | 25 સેકંડ પહેલાં   | 0 કલાક                         |
| 1999-12-31T23:59:00.000Z | 1 મિનિટ  | 1 મિનિટ પહેલાં    | 0 કલાક                         |
| 1999-12-31T23:45:00.000Z | 15 મિનિટ | 15 મિનિટ પહેલાં   | 0 કલાક                         |
| 1999-12-31T23:30:00.000Z | 30 મિનિટ | 30 મિનિટ પહેલાં   | 1 કલાક                         |
| 1999-12-31T23:15:00.000Z | 45 મિનિટ | 45 મિનિટ પહેલાં   | 1 કલાક                         |
| 1999-12-31T23:00:00.000Z | 1 કલાક   | 1 કલાક પહેલાં     | 1 કલાક                         |
| 1999-12-31T18:00:00.000Z | 6 કલાક   | 6 કલાક પહેલાં     | 6 કલાક                         |
| 1999-12-30T00:00:00.000Z | 2 દિવસ   | 2 દિવસ પહેલાં     | 48 કલાક                        |
| 1999-12-15T00:00:00.000Z | 17 દિવસ  | 17 દિવસ પહેલાં    | 408 કલાક                       |
| 1999-12-01T00:00:00.000Z | 1 મહિનો  | 1 મહિનો પહેલાં    | 744 કલાક                       |
| 1999-11-01T00:00:00.000Z | 2 મહિના  | 2 મહિના પહેલાં    | 1464 કલાક                      |
| 1999-06-01T00:00:00.000Z | 7 મહિના  | 7 મહિના પહેલાં    | 5136 કલાક                      |
| 1999-01-01T00:00:00.000Z | 1 વર્ષ   | 1 વર્ષ પહેલાં     | 8760 કલાક                      |
| 1998-12-01T00:00:00.000Z | 1 વર્ષ   | 1 વર્ષ પહેલાં     | 9504 કલાક                      |
| 1998-06-01T00:00:00.000Z | 2 વર્ષ   | 2 વર્ષ પહેલાં     | 13896 કલાક                     |
| 1998-01-01T00:00:00.000Z | 2 વર્ષ   | 2 વર્ષ પહેલાં     | 17520 કલાક                     |
| 1997-01-01T00:00:00.000Z | 3 વર્ષ   | 3 વર્ષ પહેલાં     | 26280 કલાક                     |
| 1996-01-01T00:00:00.000Z | 4 વર્ષ   | 4 વર્ષ પહેલાં     | 35064 કલાક                     |
| 1995-01-01T00:00:00.000Z | 5 વર્ષ   | 5 વર્ષ પહેલાં     | 43824 કલાક                     |
| 1994-01-01T00:00:00.000Z | 6 વર્ષ   | 6 વર્ષ પહેલાં     | 52584 કલાક                     |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                |
| ------------------------ | --------------------- |
| 2000-01-10T00:00:00.000Z | 10/1/00               |
| 2000-01-05T00:00:00.000Z | બુધવાર 12:00 AM       |
| 2000-01-02T00:00:00.000Z | આવતીકાલે 12:00 AM     |
| 2000-01-01T00:00:00.000Z | આજે 12:00 AM          |
| 1999-12-31T00:00:00.000Z | ગઈકાલે 12:00 AM       |
| 1999-12-27T00:00:00.000Z | પાછલા સોમવાર 12:00 AM |
| 1999-12-21T00:00:00.000Z | 21/12/99              |
