/*
 This file is part of GNU Taler
 (C) 2025 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU Affero Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU Affero Public License for more details.

 You should have received a copy of the GNU Affero Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import {
  DoubleColumnFormDesign,
  FormMetadata,
  InternationalizationAPI,
} from "../../index.browser.js";

export interface MultiUploadContext {
  REQUESTED_FILES: {
    REQUESTED_FILE_ID: string;
    REQUESTED_FILE_TITLE: string;
    REQUESTED_FILE_DESCRIPTION: string;
    REQUESTED_FILE_REQUIRED?: boolean;
  }[];
}

export const form_multi_upload = (
  i18n: InternationalizationAPI,
): FormMetadata => ({
  label: i18n.str`Upload multiple documents`,
  description: i18n.str`Upload multiple documents.`,
  id: "multi_upload",
  version: 1,
  config: (context: any) => design_multi_upload(i18n, context),
});

/**
 * Form for uploading multiple documents.
 */
export function design_multi_upload(
  i18n: InternationalizationAPI,
  context: MultiUploadContext,
): DoubleColumnFormDesign {
  return {
    type: "double-column",
    sections: context.REQUESTED_FILES.map((x, i) => {
      let fileId: string;
      if (x.REQUESTED_FILE_ID != null) {
        fileId = x.REQUESTED_FILE_ID;
      } else {
        fileId = `file_${String(i).padStart(4, "0")}`;
      }
      return {
        title: i18n.str`Document upload (${x.REQUESTED_FILE_TITLE})`,
        description: x.REQUESTED_FILE_DESCRIPTION ?? undefined,
        fields: [
          {
            id: `FILE_MAP.${fileId}`,
            label: i18n.str`File (PDF)`,
            type: "file",
            accept: "application/pdf",
            required: x.REQUESTED_FILE_REQUIRED ?? true,
          },
        ],
      };
    }),
  };
}
