/*
 This file is part of GNU Taler
 (C) 2023 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 * Implementation for the wallet-core IPC protocol.
 *
 * Currently the protocol is completely unstable and only used internally
 * by the wallet for testing purposes.
 */

// Platform-specific implementation
export { connectRpc, runRpcServer } from "#twrpc-impl";

export type JsonMessage =
  | string
  | number
  | boolean
  | null
  | JsonMessage[]
  | { [key: string]: JsonMessage };

export interface RpcServerClientHandlers {
  onMessage(msg: JsonMessage): void;
  onDisconnect(): void;
}

export interface RpcServerClient {
  sendResponse(message: JsonMessage): void;
}

export interface RpcServerArgs {
  socketFilename: string;
  onConnect(client: RpcServerClient): RpcServerClientHandlers;
}

export interface RpcClientServerConnection {
  sendMessage(m: JsonMessage): void;
  close(): void;
}

export interface RpcConnectArgs<T> {
  socketFilename: string;
  onEstablished(connection: RpcClientServerConnection): {
    result: T;
    onDisconnect(): void;
    onMessage(m: JsonMessage): void;
  };
}
