/* src/bazaar.p/bz-root-blocklist.c
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "src/bazaar.p/bz-root-blocklist.h"



struct _BzRootBlocklist
{
  GObject parent_instance;

  GListModel *blocklists;
};

G_DEFINE_FINAL_TYPE (BzRootBlocklist, bz_root_blocklist, G_TYPE_OBJECT);

enum
{
  PROP_0,

  PROP_BLOCKLISTS,

  LAST_PROP
};
static GParamSpec *props[LAST_PROP] = { 0 };

static void
bz_root_blocklist_dispose (GObject *object)
{
  BzRootBlocklist *self = BZ_ROOT_BLOCKLIST (object);

  g_clear_pointer (&self->blocklists, g_object_unref);

  G_OBJECT_CLASS (bz_root_blocklist_parent_class)->dispose (object);
}

static void
bz_root_blocklist_get_property (GObject    *object,
                       guint       prop_id,
                       GValue     *value,
                       GParamSpec *pspec)
{
  BzRootBlocklist *self = BZ_ROOT_BLOCKLIST (object);

  switch (prop_id)
    {
    case PROP_BLOCKLISTS:
      g_value_set_object (value, bz_root_blocklist_get_blocklists (self));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_root_blocklist_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  BzRootBlocklist *self = BZ_ROOT_BLOCKLIST (object);

  switch (prop_id)
    {
    case PROP_BLOCKLISTS:
      bz_root_blocklist_set_blocklists (self, g_value_get_object (value));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_root_blocklist_class_init (BzRootBlocklistClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  g_type_ensure (BZ_TYPE_BLOCKLIST);

  object_class->set_property = bz_root_blocklist_set_property;
  object_class->get_property = bz_root_blocklist_get_property;
  object_class->dispose      = bz_root_blocklist_dispose;

  props[PROP_BLOCKLISTS] =
      g_param_spec_object (
          "blocklists",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  g_object_class_install_properties (object_class, LAST_PROP, props);
}

static void
bz_root_blocklist_init (BzRootBlocklist *self)
{
}

BzRootBlocklist *
bz_root_blocklist_new (void){
  return g_object_new (BZ_TYPE_ROOT_BLOCKLIST, NULL);
}

GListModel *
bz_root_blocklist_get_blocklists (BzRootBlocklist *self){
  g_return_val_if_fail (BZ_IS_ROOT_BLOCKLIST (self), NULL);
  return self->blocklists;
}

void
bz_root_blocklist_set_blocklists (BzRootBlocklist *self,
    GListModel *blocklists){
  g_return_if_fail (BZ_IS_ROOT_BLOCKLIST (self));

  if (blocklists == self->blocklists)
    return;

  g_clear_pointer (&self->blocklists, g_object_unref);
  if (blocklists != NULL)
    self->blocklists = g_object_ref (blocklists);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_BLOCKLISTS]);
}

/* End of src/bazaar.p/bz-root-blocklist.c */
