// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        (unknown)
// source: buf/compiler/v1alpha1/symtab.proto

package compilerv1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Symbol_Kind int32

const (
	// Numbers synced with those in symbol_kind.go
	Symbol_KIND_UNSPECIFIED Symbol_Kind = 0
	Symbol_KIND_PACKAGE     Symbol_Kind = 1
	Symbol_KIND_SCALAR      Symbol_Kind = 2
	Symbol_KIND_MESSAGE     Symbol_Kind = 3
	Symbol_KIND_ENUM        Symbol_Kind = 4
	Symbol_KIND_FIELD       Symbol_Kind = 5
	Symbol_KIND_ENUM_VALUE  Symbol_Kind = 6
	Symbol_KIND_EXTENSION   Symbol_Kind = 7
	Symbol_KIND_ONEOF       Symbol_Kind = 8
)

// Enum value maps for Symbol_Kind.
var (
	Symbol_Kind_name = map[int32]string{
		0: "KIND_UNSPECIFIED",
		1: "KIND_PACKAGE",
		2: "KIND_SCALAR",
		3: "KIND_MESSAGE",
		4: "KIND_ENUM",
		5: "KIND_FIELD",
		6: "KIND_ENUM_VALUE",
		7: "KIND_EXTENSION",
		8: "KIND_ONEOF",
	}
	Symbol_Kind_value = map[string]int32{
		"KIND_UNSPECIFIED": 0,
		"KIND_PACKAGE":     1,
		"KIND_SCALAR":      2,
		"KIND_MESSAGE":     3,
		"KIND_ENUM":        4,
		"KIND_FIELD":       5,
		"KIND_ENUM_VALUE":  6,
		"KIND_EXTENSION":   7,
		"KIND_ONEOF":       8,
	}
)

func (x Symbol_Kind) Enum() *Symbol_Kind {
	p := new(Symbol_Kind)
	*p = x
	return p
}

func (x Symbol_Kind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Symbol_Kind) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_compiler_v1alpha1_symtab_proto_enumTypes[0].Descriptor()
}

func (Symbol_Kind) Type() protoreflect.EnumType {
	return &file_buf_compiler_v1alpha1_symtab_proto_enumTypes[0]
}

func (x Symbol_Kind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Symbol_Kind.Descriptor instead.
func (Symbol_Kind) EnumDescriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_symtab_proto_rawDescGZIP(), []int{4, 0}
}

// A set of symbol tables.
type SymbolSet struct {
	state         protoimpl.MessageState  `protogen:"open.v1"`
	Tables        map[string]*SymbolTable `protobuf:"bytes,1,rep,name=tables,proto3" json:"tables,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SymbolSet) Reset() {
	*x = SymbolSet{}
	mi := &file_buf_compiler_v1alpha1_symtab_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SymbolSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SymbolSet) ProtoMessage() {}

func (x *SymbolSet) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_symtab_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SymbolSet.ProtoReflect.Descriptor instead.
func (*SymbolSet) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_symtab_proto_rawDescGZIP(), []int{0}
}

func (x *SymbolSet) GetTables() map[string]*SymbolTable {
	if x != nil {
		return x.Tables
	}
	return nil
}

// Symbol information for a particular Protobuf file.
type SymbolTable struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Imports       []*Import              `protobuf:"bytes,1,rep,name=imports,proto3" json:"imports,omitempty"`
	Features      []*Feature             `protobuf:"bytes,4,rep,name=features,proto3" json:"features,omitempty"`
	Symbols       []*Symbol              `protobuf:"bytes,2,rep,name=symbols,proto3" json:"symbols,omitempty"`
	Options       *Value                 `protobuf:"bytes,3,opt,name=options,proto3" json:"options,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SymbolTable) Reset() {
	*x = SymbolTable{}
	mi := &file_buf_compiler_v1alpha1_symtab_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SymbolTable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SymbolTable) ProtoMessage() {}

func (x *SymbolTable) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_symtab_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SymbolTable.ProtoReflect.Descriptor instead.
func (*SymbolTable) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_symtab_proto_rawDescGZIP(), []int{1}
}

func (x *SymbolTable) GetImports() []*Import {
	if x != nil {
		return x.Imports
	}
	return nil
}

func (x *SymbolTable) GetFeatures() []*Feature {
	if x != nil {
		return x.Features
	}
	return nil
}

func (x *SymbolTable) GetSymbols() []*Symbol {
	if x != nil {
		return x.Symbols
	}
	return nil
}

func (x *SymbolTable) GetOptions() *Value {
	if x != nil {
		return x.Options
	}
	return nil
}

// Metadata associated with a transitive import.
type Import struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Path          string                 `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Public        bool                   `protobuf:"varint,2,opt,name=public,proto3" json:"public,omitempty"`
	Weak          bool                   `protobuf:"varint,3,opt,name=weak,proto3" json:"weak,omitempty"`
	Transitive    bool                   `protobuf:"varint,4,opt,name=transitive,proto3" json:"transitive,omitempty"`
	Visible       bool                   `protobuf:"varint,5,opt,name=visible,proto3" json:"visible,omitempty"`
	Used          bool                   `protobuf:"varint,6,opt,name=used,proto3" json:"used,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Import) Reset() {
	*x = Import{}
	mi := &file_buf_compiler_v1alpha1_symtab_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Import) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Import) ProtoMessage() {}

func (x *Import) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_symtab_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Import.ProtoReflect.Descriptor instead.
func (*Import) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_symtab_proto_rawDescGZIP(), []int{2}
}

func (x *Import) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *Import) GetPublic() bool {
	if x != nil {
		return x.Public
	}
	return false
}

func (x *Import) GetWeak() bool {
	if x != nil {
		return x.Weak
	}
	return false
}

func (x *Import) GetTransitive() bool {
	if x != nil {
		return x.Transitive
	}
	return false
}

func (x *Import) GetVisible() bool {
	if x != nil {
		return x.Visible
	}
	return false
}

func (x *Import) GetUsed() bool {
	if x != nil {
		return x.Used
	}
	return false
}

// A feature associated with a symbol.
type Feature struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Extn  string                 `protobuf:"bytes,1,opt,name=extn,proto3" json:"extn,omitempty"`
	Name  string                 `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The value as a textproto string.
	Value string `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	// Whether this feature is set explicitly.
	Explicit      bool `protobuf:"varint,4,opt,name=explicit,proto3" json:"explicit,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Feature) Reset() {
	*x = Feature{}
	mi := &file_buf_compiler_v1alpha1_symtab_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Feature) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Feature) ProtoMessage() {}

func (x *Feature) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_symtab_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Feature.ProtoReflect.Descriptor instead.
func (*Feature) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_symtab_proto_rawDescGZIP(), []int{3}
}

func (x *Feature) GetExtn() string {
	if x != nil {
		return x.Extn
	}
	return ""
}

func (x *Feature) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Feature) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *Feature) GetExplicit() bool {
	if x != nil {
		return x.Explicit
	}
	return false
}

// A symbol in a file.
type Symbol struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Fqn   string                 `protobuf:"bytes,1,opt,name=fqn,proto3" json:"fqn,omitempty"`
	Kind  Symbol_Kind            `protobuf:"varint,2,opt,name=kind,proto3,enum=buf.compiler.v1alpha1.Symbol_Kind" json:"kind,omitempty"`
	// The file this symbol came from.
	File string `protobuf:"bytes,3,opt,name=file,proto3" json:"file,omitempty"`
	// The index of this kind of entity in that file.
	Index uint32 `protobuf:"varint,4,opt,name=index,proto3" json:"index,omitempty"`
	// Whether this symbol can be validly referenced in the current file.
	Visible       bool       `protobuf:"varint,5,opt,name=visible,proto3" json:"visible,omitempty"`
	OptionOnly    bool       `protobuf:"varint,8,opt,name=option_only,json=optionOnly,proto3" json:"option_only,omitempty"`
	Options       *Value     `protobuf:"bytes,6,opt,name=options,proto3" json:"options,omitempty"`
	Features      []*Feature `protobuf:"bytes,7,rep,name=features,proto3" json:"features,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Symbol) Reset() {
	*x = Symbol{}
	mi := &file_buf_compiler_v1alpha1_symtab_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Symbol) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Symbol) ProtoMessage() {}

func (x *Symbol) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_symtab_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Symbol.ProtoReflect.Descriptor instead.
func (*Symbol) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_symtab_proto_rawDescGZIP(), []int{4}
}

func (x *Symbol) GetFqn() string {
	if x != nil {
		return x.Fqn
	}
	return ""
}

func (x *Symbol) GetKind() Symbol_Kind {
	if x != nil {
		return x.Kind
	}
	return Symbol_KIND_UNSPECIFIED
}

func (x *Symbol) GetFile() string {
	if x != nil {
		return x.File
	}
	return ""
}

func (x *Symbol) GetIndex() uint32 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *Symbol) GetVisible() bool {
	if x != nil {
		return x.Visible
	}
	return false
}

func (x *Symbol) GetOptionOnly() bool {
	if x != nil {
		return x.OptionOnly
	}
	return false
}

func (x *Symbol) GetOptions() *Value {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *Symbol) GetFeatures() []*Feature {
	if x != nil {
		return x.Features
	}
	return nil
}

// An option value attached to a symbol.
type Value struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Value:
	//
	//	*Value_I32
	//	*Value_U32
	//	*Value_F32
	//	*Value_I64
	//	*Value_U64
	//	*Value_F64
	//	*Value_Bool
	//	*Value_String_
	//	*Value_Repeated_
	//	*Value_Message_
	//	*Value_Any_
	//	*Value_Cycle
	Value         isValue_Value `protobuf_oneof:"value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Value) Reset() {
	*x = Value{}
	mi := &file_buf_compiler_v1alpha1_symtab_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value) ProtoMessage() {}

func (x *Value) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_symtab_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value.ProtoReflect.Descriptor instead.
func (*Value) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_symtab_proto_rawDescGZIP(), []int{5}
}

func (x *Value) GetValue() isValue_Value {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *Value) GetI32() int32 {
	if x != nil {
		if x, ok := x.Value.(*Value_I32); ok {
			return x.I32
		}
	}
	return 0
}

func (x *Value) GetU32() uint32 {
	if x != nil {
		if x, ok := x.Value.(*Value_U32); ok {
			return x.U32
		}
	}
	return 0
}

func (x *Value) GetF32() float32 {
	if x != nil {
		if x, ok := x.Value.(*Value_F32); ok {
			return x.F32
		}
	}
	return 0
}

func (x *Value) GetI64() int64 {
	if x != nil {
		if x, ok := x.Value.(*Value_I64); ok {
			return x.I64
		}
	}
	return 0
}

func (x *Value) GetU64() uint64 {
	if x != nil {
		if x, ok := x.Value.(*Value_U64); ok {
			return x.U64
		}
	}
	return 0
}

func (x *Value) GetF64() float64 {
	if x != nil {
		if x, ok := x.Value.(*Value_F64); ok {
			return x.F64
		}
	}
	return 0
}

func (x *Value) GetBool() bool {
	if x != nil {
		if x, ok := x.Value.(*Value_Bool); ok {
			return x.Bool
		}
	}
	return false
}

func (x *Value) GetString_() []byte {
	if x != nil {
		if x, ok := x.Value.(*Value_String_); ok {
			return x.String_
		}
	}
	return nil
}

func (x *Value) GetRepeated() *Value_Repeated {
	if x != nil {
		if x, ok := x.Value.(*Value_Repeated_); ok {
			return x.Repeated
		}
	}
	return nil
}

func (x *Value) GetMessage() *Value_Message {
	if x != nil {
		if x, ok := x.Value.(*Value_Message_); ok {
			return x.Message
		}
	}
	return nil
}

func (x *Value) GetAny() *Value_Any {
	if x != nil {
		if x, ok := x.Value.(*Value_Any_); ok {
			return x.Any
		}
	}
	return nil
}

func (x *Value) GetCycle() int32 {
	if x != nil {
		if x, ok := x.Value.(*Value_Cycle); ok {
			return x.Cycle
		}
	}
	return 0
}

type isValue_Value interface {
	isValue_Value()
}

type Value_I32 struct {
	I32 int32 `protobuf:"varint,1,opt,name=i32,proto3,oneof"`
}

type Value_U32 struct {
	U32 uint32 `protobuf:"varint,2,opt,name=u32,proto3,oneof"`
}

type Value_F32 struct {
	F32 float32 `protobuf:"fixed32,3,opt,name=f32,proto3,oneof"`
}

type Value_I64 struct {
	I64 int64 `protobuf:"varint,4,opt,name=i64,proto3,oneof"`
}

type Value_U64 struct {
	U64 uint64 `protobuf:"varint,5,opt,name=u64,proto3,oneof"`
}

type Value_F64 struct {
	F64 float64 `protobuf:"fixed64,6,opt,name=f64,proto3,oneof"`
}

type Value_Bool struct {
	Bool bool `protobuf:"varint,7,opt,name=bool,proto3,oneof"`
}

type Value_String_ struct {
	String_ []byte `protobuf:"bytes,8,opt,name=string,proto3,oneof"`
}

type Value_Repeated_ struct {
	Repeated *Value_Repeated `protobuf:"bytes,9,opt,name=repeated,proto3,oneof"`
}

type Value_Message_ struct {
	Message *Value_Message `protobuf:"bytes,10,opt,name=message,proto3,oneof"`
}

type Value_Any_ struct {
	Any *Value_Any `protobuf:"bytes,11,opt,name=any,proto3,oneof"`
}

type Value_Cycle struct {
	// Cyclic message. This is how many uprefs away the cycle element is.
	Cycle int32 `protobuf:"varint,20,opt,name=cycle,proto3,oneof"`
}

func (*Value_I32) isValue_Value() {}

func (*Value_U32) isValue_Value() {}

func (*Value_F32) isValue_Value() {}

func (*Value_I64) isValue_Value() {}

func (*Value_U64) isValue_Value() {}

func (*Value_F64) isValue_Value() {}

func (*Value_Bool) isValue_Value() {}

func (*Value_String_) isValue_Value() {}

func (*Value_Repeated_) isValue_Value() {}

func (*Value_Message_) isValue_Value() {}

func (*Value_Any_) isValue_Value() {}

func (*Value_Cycle) isValue_Value() {}

type Value_Message struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Fields        map[string]*Value      `protobuf:"bytes,1,rep,name=fields,proto3" json:"fields,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Extns         map[string]*Value      `protobuf:"bytes,2,rep,name=extns,proto3" json:"extns,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Value_Message) Reset() {
	*x = Value_Message{}
	mi := &file_buf_compiler_v1alpha1_symtab_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Value_Message) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value_Message) ProtoMessage() {}

func (x *Value_Message) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_symtab_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value_Message.ProtoReflect.Descriptor instead.
func (*Value_Message) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_symtab_proto_rawDescGZIP(), []int{5, 0}
}

func (x *Value_Message) GetFields() map[string]*Value {
	if x != nil {
		return x.Fields
	}
	return nil
}

func (x *Value_Message) GetExtns() map[string]*Value {
	if x != nil {
		return x.Extns
	}
	return nil
}

type Value_Repeated struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Values        []*Value               `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Value_Repeated) Reset() {
	*x = Value_Repeated{}
	mi := &file_buf_compiler_v1alpha1_symtab_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Value_Repeated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value_Repeated) ProtoMessage() {}

func (x *Value_Repeated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_symtab_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value_Repeated.ProtoReflect.Descriptor instead.
func (*Value_Repeated) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_symtab_proto_rawDescGZIP(), []int{5, 1}
}

func (x *Value_Repeated) GetValues() []*Value {
	if x != nil {
		return x.Values
	}
	return nil
}

type Value_Any struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Url           string                 `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	Value         *Value                 `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Value_Any) Reset() {
	*x = Value_Any{}
	mi := &file_buf_compiler_v1alpha1_symtab_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Value_Any) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value_Any) ProtoMessage() {}

func (x *Value_Any) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_symtab_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value_Any.ProtoReflect.Descriptor instead.
func (*Value_Any) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_symtab_proto_rawDescGZIP(), []int{5, 2}
}

func (x *Value_Any) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *Value_Any) GetValue() *Value {
	if x != nil {
		return x.Value
	}
	return nil
}

var File_buf_compiler_v1alpha1_symtab_proto protoreflect.FileDescriptor

const file_buf_compiler_v1alpha1_symtab_proto_rawDesc = "" +
	"\n" +
	"\"buf/compiler/v1alpha1/symtab.proto\x12\x15buf.compiler.v1alpha1\"\xb0\x01\n" +
	"\tSymbolSet\x12D\n" +
	"\x06tables\x18\x01 \x03(\v2,.buf.compiler.v1alpha1.SymbolSet.TablesEntryR\x06tables\x1a]\n" +
	"\vTablesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x128\n" +
	"\x05value\x18\x02 \x01(\v2\".buf.compiler.v1alpha1.SymbolTableR\x05value:\x028\x01\"\xf3\x01\n" +
	"\vSymbolTable\x127\n" +
	"\aimports\x18\x01 \x03(\v2\x1d.buf.compiler.v1alpha1.ImportR\aimports\x12:\n" +
	"\bfeatures\x18\x04 \x03(\v2\x1e.buf.compiler.v1alpha1.FeatureR\bfeatures\x127\n" +
	"\asymbols\x18\x02 \x03(\v2\x1d.buf.compiler.v1alpha1.SymbolR\asymbols\x126\n" +
	"\aoptions\x18\x03 \x01(\v2\x1c.buf.compiler.v1alpha1.ValueR\aoptions\"\x96\x01\n" +
	"\x06Import\x12\x12\n" +
	"\x04path\x18\x01 \x01(\tR\x04path\x12\x16\n" +
	"\x06public\x18\x02 \x01(\bR\x06public\x12\x12\n" +
	"\x04weak\x18\x03 \x01(\bR\x04weak\x12\x1e\n" +
	"\n" +
	"transitive\x18\x04 \x01(\bR\n" +
	"transitive\x12\x18\n" +
	"\avisible\x18\x05 \x01(\bR\avisible\x12\x12\n" +
	"\x04used\x18\x06 \x01(\bR\x04used\"c\n" +
	"\aFeature\x12\x12\n" +
	"\x04extn\x18\x01 \x01(\tR\x04extn\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x12\x14\n" +
	"\x05value\x18\x03 \x01(\tR\x05value\x12\x1a\n" +
	"\bexplicit\x18\x04 \x01(\bR\bexplicit\"\xd7\x03\n" +
	"\x06Symbol\x12\x10\n" +
	"\x03fqn\x18\x01 \x01(\tR\x03fqn\x126\n" +
	"\x04kind\x18\x02 \x01(\x0e2\".buf.compiler.v1alpha1.Symbol.KindR\x04kind\x12\x12\n" +
	"\x04file\x18\x03 \x01(\tR\x04file\x12\x14\n" +
	"\x05index\x18\x04 \x01(\rR\x05index\x12\x18\n" +
	"\avisible\x18\x05 \x01(\bR\avisible\x12\x1f\n" +
	"\voption_only\x18\b \x01(\bR\n" +
	"optionOnly\x126\n" +
	"\aoptions\x18\x06 \x01(\v2\x1c.buf.compiler.v1alpha1.ValueR\aoptions\x12:\n" +
	"\bfeatures\x18\a \x03(\v2\x1e.buf.compiler.v1alpha1.FeatureR\bfeatures\"\xa9\x01\n" +
	"\x04Kind\x12\x14\n" +
	"\x10KIND_UNSPECIFIED\x10\x00\x12\x10\n" +
	"\fKIND_PACKAGE\x10\x01\x12\x0f\n" +
	"\vKIND_SCALAR\x10\x02\x12\x10\n" +
	"\fKIND_MESSAGE\x10\x03\x12\r\n" +
	"\tKIND_ENUM\x10\x04\x12\x0e\n" +
	"\n" +
	"KIND_FIELD\x10\x05\x12\x13\n" +
	"\x0fKIND_ENUM_VALUE\x10\x06\x12\x12\n" +
	"\x0eKIND_EXTENSION\x10\a\x12\x0e\n" +
	"\n" +
	"KIND_ONEOF\x10\b\"\xea\x06\n" +
	"\x05Value\x12\x12\n" +
	"\x03i32\x18\x01 \x01(\x05H\x00R\x03i32\x12\x12\n" +
	"\x03u32\x18\x02 \x01(\rH\x00R\x03u32\x12\x12\n" +
	"\x03f32\x18\x03 \x01(\x02H\x00R\x03f32\x12\x12\n" +
	"\x03i64\x18\x04 \x01(\x03H\x00R\x03i64\x12\x12\n" +
	"\x03u64\x18\x05 \x01(\x04H\x00R\x03u64\x12\x12\n" +
	"\x03f64\x18\x06 \x01(\x01H\x00R\x03f64\x12\x14\n" +
	"\x04bool\x18\a \x01(\bH\x00R\x04bool\x12\x18\n" +
	"\x06string\x18\b \x01(\fH\x00R\x06string\x12C\n" +
	"\brepeated\x18\t \x01(\v2%.buf.compiler.v1alpha1.Value.RepeatedH\x00R\brepeated\x12@\n" +
	"\amessage\x18\n" +
	" \x01(\v2$.buf.compiler.v1alpha1.Value.MessageH\x00R\amessage\x124\n" +
	"\x03any\x18\v \x01(\v2 .buf.compiler.v1alpha1.Value.AnyH\x00R\x03any\x12\x16\n" +
	"\x05cycle\x18\x14 \x01(\x05H\x00R\x05cycle\x1a\xcb\x02\n" +
	"\aMessage\x12H\n" +
	"\x06fields\x18\x01 \x03(\v20.buf.compiler.v1alpha1.Value.Message.FieldsEntryR\x06fields\x12E\n" +
	"\x05extns\x18\x02 \x03(\v2/.buf.compiler.v1alpha1.Value.Message.ExtnsEntryR\x05extns\x1aW\n" +
	"\vFieldsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x122\n" +
	"\x05value\x18\x02 \x01(\v2\x1c.buf.compiler.v1alpha1.ValueR\x05value:\x028\x01\x1aV\n" +
	"\n" +
	"ExtnsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x122\n" +
	"\x05value\x18\x02 \x01(\v2\x1c.buf.compiler.v1alpha1.ValueR\x05value:\x028\x01\x1a@\n" +
	"\bRepeated\x124\n" +
	"\x06values\x18\x01 \x03(\v2\x1c.buf.compiler.v1alpha1.ValueR\x06values\x1aK\n" +
	"\x03Any\x12\x10\n" +
	"\x03url\x18\x01 \x01(\tR\x03url\x122\n" +
	"\x05value\x18\x02 \x01(\v2\x1c.buf.compiler.v1alpha1.ValueR\x05valueB\a\n" +
	"\x05valueB\xf4\x01\n" +
	"\x19com.buf.compiler.v1alpha1B\vSymtabProtoP\x01ZTgithub.com/bufbuild/protocompile/internal/gen/buf/compiler/v1alpha1;compilerv1alpha1\xa2\x02\x03BCX\xaa\x02\x15Buf.Compiler.V1alpha1\xca\x02\x15Buf\\Compiler\\V1alpha1\xe2\x02!Buf\\Compiler\\V1alpha1\\GPBMetadata\xea\x02\x17Buf::Compiler::V1alpha1b\x06proto3"

var (
	file_buf_compiler_v1alpha1_symtab_proto_rawDescOnce sync.Once
	file_buf_compiler_v1alpha1_symtab_proto_rawDescData []byte
)

func file_buf_compiler_v1alpha1_symtab_proto_rawDescGZIP() []byte {
	file_buf_compiler_v1alpha1_symtab_proto_rawDescOnce.Do(func() {
		file_buf_compiler_v1alpha1_symtab_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_buf_compiler_v1alpha1_symtab_proto_rawDesc), len(file_buf_compiler_v1alpha1_symtab_proto_rawDesc)))
	})
	return file_buf_compiler_v1alpha1_symtab_proto_rawDescData
}

var file_buf_compiler_v1alpha1_symtab_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_compiler_v1alpha1_symtab_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_buf_compiler_v1alpha1_symtab_proto_goTypes = []any{
	(Symbol_Kind)(0),       // 0: buf.compiler.v1alpha1.Symbol.Kind
	(*SymbolSet)(nil),      // 1: buf.compiler.v1alpha1.SymbolSet
	(*SymbolTable)(nil),    // 2: buf.compiler.v1alpha1.SymbolTable
	(*Import)(nil),         // 3: buf.compiler.v1alpha1.Import
	(*Feature)(nil),        // 4: buf.compiler.v1alpha1.Feature
	(*Symbol)(nil),         // 5: buf.compiler.v1alpha1.Symbol
	(*Value)(nil),          // 6: buf.compiler.v1alpha1.Value
	nil,                    // 7: buf.compiler.v1alpha1.SymbolSet.TablesEntry
	(*Value_Message)(nil),  // 8: buf.compiler.v1alpha1.Value.Message
	(*Value_Repeated)(nil), // 9: buf.compiler.v1alpha1.Value.Repeated
	(*Value_Any)(nil),      // 10: buf.compiler.v1alpha1.Value.Any
	nil,                    // 11: buf.compiler.v1alpha1.Value.Message.FieldsEntry
	nil,                    // 12: buf.compiler.v1alpha1.Value.Message.ExtnsEntry
}
var file_buf_compiler_v1alpha1_symtab_proto_depIdxs = []int32{
	7,  // 0: buf.compiler.v1alpha1.SymbolSet.tables:type_name -> buf.compiler.v1alpha1.SymbolSet.TablesEntry
	3,  // 1: buf.compiler.v1alpha1.SymbolTable.imports:type_name -> buf.compiler.v1alpha1.Import
	4,  // 2: buf.compiler.v1alpha1.SymbolTable.features:type_name -> buf.compiler.v1alpha1.Feature
	5,  // 3: buf.compiler.v1alpha1.SymbolTable.symbols:type_name -> buf.compiler.v1alpha1.Symbol
	6,  // 4: buf.compiler.v1alpha1.SymbolTable.options:type_name -> buf.compiler.v1alpha1.Value
	0,  // 5: buf.compiler.v1alpha1.Symbol.kind:type_name -> buf.compiler.v1alpha1.Symbol.Kind
	6,  // 6: buf.compiler.v1alpha1.Symbol.options:type_name -> buf.compiler.v1alpha1.Value
	4,  // 7: buf.compiler.v1alpha1.Symbol.features:type_name -> buf.compiler.v1alpha1.Feature
	9,  // 8: buf.compiler.v1alpha1.Value.repeated:type_name -> buf.compiler.v1alpha1.Value.Repeated
	8,  // 9: buf.compiler.v1alpha1.Value.message:type_name -> buf.compiler.v1alpha1.Value.Message
	10, // 10: buf.compiler.v1alpha1.Value.any:type_name -> buf.compiler.v1alpha1.Value.Any
	2,  // 11: buf.compiler.v1alpha1.SymbolSet.TablesEntry.value:type_name -> buf.compiler.v1alpha1.SymbolTable
	11, // 12: buf.compiler.v1alpha1.Value.Message.fields:type_name -> buf.compiler.v1alpha1.Value.Message.FieldsEntry
	12, // 13: buf.compiler.v1alpha1.Value.Message.extns:type_name -> buf.compiler.v1alpha1.Value.Message.ExtnsEntry
	6,  // 14: buf.compiler.v1alpha1.Value.Repeated.values:type_name -> buf.compiler.v1alpha1.Value
	6,  // 15: buf.compiler.v1alpha1.Value.Any.value:type_name -> buf.compiler.v1alpha1.Value
	6,  // 16: buf.compiler.v1alpha1.Value.Message.FieldsEntry.value:type_name -> buf.compiler.v1alpha1.Value
	6,  // 17: buf.compiler.v1alpha1.Value.Message.ExtnsEntry.value:type_name -> buf.compiler.v1alpha1.Value
	18, // [18:18] is the sub-list for method output_type
	18, // [18:18] is the sub-list for method input_type
	18, // [18:18] is the sub-list for extension type_name
	18, // [18:18] is the sub-list for extension extendee
	0,  // [0:18] is the sub-list for field type_name
}

func init() { file_buf_compiler_v1alpha1_symtab_proto_init() }
func file_buf_compiler_v1alpha1_symtab_proto_init() {
	if File_buf_compiler_v1alpha1_symtab_proto != nil {
		return
	}
	file_buf_compiler_v1alpha1_symtab_proto_msgTypes[5].OneofWrappers = []any{
		(*Value_I32)(nil),
		(*Value_U32)(nil),
		(*Value_F32)(nil),
		(*Value_I64)(nil),
		(*Value_U64)(nil),
		(*Value_F64)(nil),
		(*Value_Bool)(nil),
		(*Value_String_)(nil),
		(*Value_Repeated_)(nil),
		(*Value_Message_)(nil),
		(*Value_Any_)(nil),
		(*Value_Cycle)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_compiler_v1alpha1_symtab_proto_rawDesc), len(file_buf_compiler_v1alpha1_symtab_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_compiler_v1alpha1_symtab_proto_goTypes,
		DependencyIndexes: file_buf_compiler_v1alpha1_symtab_proto_depIdxs,
		EnumInfos:         file_buf_compiler_v1alpha1_symtab_proto_enumTypes,
		MessageInfos:      file_buf_compiler_v1alpha1_symtab_proto_msgTypes,
	}.Build()
	File_buf_compiler_v1alpha1_symtab_proto = out.File
	file_buf_compiler_v1alpha1_symtab_proto_goTypes = nil
	file_buf_compiler_v1alpha1_symtab_proto_depIdxs = nil
}
