/* Generated by wayland-scanner 1.24.0 */

#ifndef TREELAND_DDM_CLIENT_PROTOCOL_H
#define TREELAND_DDM_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_treeland_ddm The treeland_ddm protocol
 * @section page_ifaces_treeland_ddm Interfaces
 * - @subpage page_iface_treeland_ddm - core global for treeland - ddm connection
 * @section page_copyright_treeland_ddm Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2025 UnionTech Software Technology Co., Ltd.
 * SPDX-License-Identifier: MIT
 * </pre>
 */
struct treeland_ddm;
struct wl_callback;

#ifndef TREELAND_DDM_INTERFACE
#define TREELAND_DDM_INTERFACE
/**
 * @page page_iface_treeland_ddm treeland_ddm
 * @section page_iface_treeland_ddm_desc Description
 *
 * This object is primarily used for establish connection between
 * treeland and ddm.
 * @section page_iface_treeland_ddm_api API
 * See @ref iface_treeland_ddm.
 */
/**
 * @defgroup iface_treeland_ddm The treeland_ddm interface
 *
 * This object is primarily used for establish connection between
 * treeland and ddm.
 */
extern const struct wl_interface treeland_ddm_interface;
#endif

/**
 * @ingroup iface_treeland_ddm
 * @struct treeland_ddm_listener
 */
struct treeland_ddm_listener {
	/**
	 * switch to virtual terminal
	 *
	 * Call ddm to switch current virtual terminal to vtnr. ddm
	 * should take care of the switch and call ioctl respectively.
	 */
	void (*switch_to_vt)(void *data,
			     struct treeland_ddm *treeland_ddm,
			     int32_t vtnr);
	/**
	 * acquire control of virtual terminal
	 *
	 * Call ddm to acquire control of VT at vtnr. ddm should call
	 * VT_SETMODE respectively.
	 */
	void (*acquire_vt)(void *data,
			   struct treeland_ddm *treeland_ddm,
			   int32_t vtnr);
};

/**
 * @ingroup iface_treeland_ddm
 */
static inline int
treeland_ddm_add_listener(struct treeland_ddm *treeland_ddm,
			  const struct treeland_ddm_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) treeland_ddm,
				     (void (**)(void)) listener, data);
}

#define TREELAND_DDM_SWITCH_TO_GREETER 0
#define TREELAND_DDM_SWITCH_TO_USER 1
#define TREELAND_DDM_ACTIVATE_SESSION 2
#define TREELAND_DDM_DEACTIVATE_SESSION 3
#define TREELAND_DDM_ENABLE_RENDER 4
#define TREELAND_DDM_DISABLE_RENDER 5

/**
 * @ingroup iface_treeland_ddm
 */
#define TREELAND_DDM_SWITCH_TO_VT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_ddm
 */
#define TREELAND_DDM_ACQUIRE_VT_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_ddm
 */
#define TREELAND_DDM_SWITCH_TO_GREETER_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_ddm
 */
#define TREELAND_DDM_SWITCH_TO_USER_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_ddm
 */
#define TREELAND_DDM_ACTIVATE_SESSION_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_ddm
 */
#define TREELAND_DDM_DEACTIVATE_SESSION_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_ddm
 */
#define TREELAND_DDM_ENABLE_RENDER_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_ddm
 */
#define TREELAND_DDM_DISABLE_RENDER_SINCE_VERSION 1

/** @ingroup iface_treeland_ddm */
static inline void
treeland_ddm_set_user_data(struct treeland_ddm *treeland_ddm, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_ddm, user_data);
}

/** @ingroup iface_treeland_ddm */
static inline void *
treeland_ddm_get_user_data(struct treeland_ddm *treeland_ddm)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_ddm);
}

static inline uint32_t
treeland_ddm_get_version(struct treeland_ddm *treeland_ddm)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_ddm);
}

/** @ingroup iface_treeland_ddm */
static inline void
treeland_ddm_destroy(struct treeland_ddm *treeland_ddm)
{
	wl_proxy_destroy((struct wl_proxy *) treeland_ddm);
}

/**
 * @ingroup iface_treeland_ddm
 *
 * Send treeland to Greeter mode.
 */
static inline void
treeland_ddm_switch_to_greeter(struct treeland_ddm *treeland_ddm)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_ddm,
			 TREELAND_DDM_SWITCH_TO_GREETER, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_ddm), 0);
}

/**
 * @ingroup iface_treeland_ddm
 *
 * Set lockscreen user to username. Ignore when username is "ddm".
 */
static inline void
treeland_ddm_switch_to_user(struct treeland_ddm *treeland_ddm, const char *username)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_ddm,
			 TREELAND_DDM_SWITCH_TO_USER, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_ddm), 0, username);
}

/**
 * @ingroup iface_treeland_ddm
 *
 * Activate treeland session. This will makes treeland try to take
 * control of screen.
 */
static inline void
treeland_ddm_activate_session(struct treeland_ddm *treeland_ddm)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_ddm,
			 TREELAND_DDM_ACTIVATE_SESSION, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_ddm), 0);
}

/**
 * @ingroup iface_treeland_ddm
 *
 * Deactivate treeland session. This will release control of the
 * screen, but not to close the current seats.
 */
static inline void
treeland_ddm_deactivate_session(struct treeland_ddm *treeland_ddm)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_ddm,
			 TREELAND_DDM_DEACTIVATE_SESSION, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_ddm), 0);
}

/**
 * @ingroup iface_treeland_ddm
 *
 * Enable treeland rendering. This is primarily called after
 * disable_render to resume treeland.
 */
static inline void
treeland_ddm_enable_render(struct treeland_ddm *treeland_ddm)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_ddm,
			 TREELAND_DDM_ENABLE_RENDER, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_ddm), 0);
}

/**
 * @ingroup iface_treeland_ddm
 *
 * Disable treeland rendering. This will prevent treeland from
 * output to DRM device.
 */
static inline struct wl_callback *
treeland_ddm_disable_render(struct treeland_ddm *treeland_ddm)
{
	struct wl_proxy *callback;

	callback = wl_proxy_marshal_flags((struct wl_proxy *) treeland_ddm,
			 TREELAND_DDM_DISABLE_RENDER, &wl_callback_interface, wl_proxy_get_version((struct wl_proxy *) treeland_ddm), 0, NULL);

	return (struct wl_callback *) callback;
}

#ifdef  __cplusplus
}
#endif

#endif
