
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "datapaths_wrapper.h"

// Argument includes
#include <QString>
#include <QStringList>
#include <datapaths.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_DataPaths_Type = nullptr;
static PyTypeObject *Sbk_DataPaths_TypeF(void)
{
    return _Sbk_DataPaths_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_DataPaths_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::DataPaths >()))
        return -1;

    ::DataPaths *cptr{};
    Shiboken::PythonContextMarker pcm;


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_DataPaths_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {

        // DataPaths()
        cptr = new ::DataPaths();
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::DataPaths >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_DataPathsFunc_allPaths(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static DataPaths::allPaths(DataPaths::Path)->QStringList
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DataPaths_Path_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // allPaths(DataPaths::Path)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "allPaths", errInfo, SbkPyFalkonTypeStructs[SBK_DataPaths_IDX]);

    // Call function/method
    {
        ::DataPaths::Path cppArg0{DataPaths::AppData};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // allPaths(DataPaths::Path)
            QStringList cppResult = ::DataPaths::allPaths(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_DataPathsFunc_currentProfilePath(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // currentProfilePath()
        QString cppResult = ::DataPaths::currentProfilePath();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_DataPathsFunc_locate(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "locate", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static DataPaths::locate(DataPaths::Path,QString)->QString
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DataPaths_Path_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // locate(DataPaths::Path,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "locate", errInfo, SbkPyFalkonTypeStructs[SBK_DataPaths_IDX]);

    // Call function/method
    {
        ::DataPaths::Path cppArg0{DataPaths::AppData};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // locate(DataPaths::Path,QString)
            QString cppResult = ::DataPaths::locate(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_DataPathsFunc_path(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static DataPaths::path(DataPaths::Path)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DataPaths_Path_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // path(DataPaths::Path)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "path", errInfo, SbkPyFalkonTypeStructs[SBK_DataPaths_IDX]);

    // Call function/method
    {
        ::DataPaths::Path cppArg0{DataPaths::AppData};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // path(DataPaths::Path)
            QString cppResult = ::DataPaths::path(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_DataPathsFunc_setCurrentProfilePath(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static DataPaths::setCurrentProfilePath(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setCurrentProfilePath(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCurrentProfilePath", errInfo, SbkPyFalkonTypeStructs[SBK_DataPaths_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCurrentProfilePath(QString)
            ::DataPaths::setCurrentProfilePath(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_DataPathsFunc_setPortableVersion(PyObject *self)
{
    SBK_UNUSED(self)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // setPortableVersion()
        ::DataPaths::setPortableVersion();
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_DataPaths_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_DataPaths_EnumFlagInfo[] = {
    "Path:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_DataPaths_methods[] = {
    {"allPaths", reinterpret_cast<PyCFunction>(Sbk_DataPathsFunc_allPaths), METH_O|METH_STATIC, nullptr},
    {"currentProfilePath", reinterpret_cast<PyCFunction>(Sbk_DataPathsFunc_currentProfilePath), METH_NOARGS|METH_STATIC, nullptr},
    {"locate", reinterpret_cast<PyCFunction>(Sbk_DataPathsFunc_locate), METH_VARARGS|METH_STATIC, nullptr},
    {"path", reinterpret_cast<PyCFunction>(Sbk_DataPathsFunc_path), METH_O|METH_STATIC, nullptr},
    {"setCurrentProfilePath", reinterpret_cast<PyCFunction>(Sbk_DataPathsFunc_setCurrentProfilePath), METH_O|METH_STATIC, nullptr},
    {"setPortableVersion", reinterpret_cast<PyCFunction>(Sbk_DataPathsFunc_setPortableVersion), METH_NOARGS|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_DataPaths_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_DataPaths_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_DataPaths_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_DataPaths_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_DataPaths_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_DataPaths_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_DataPaths_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_DataPaths_spec = {
    "1:PyFalkon.DataPaths",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_DataPaths_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_DataPaths_Path(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::DataPaths::Path>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::DataPaths::Path *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_DataPaths_Path_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DataPaths_Path_IDX])))
        return Enum_PythonToCpp_DataPaths_Path;
    return {};
}

static PyObject *DataPaths_Path_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::DataPaths::Path>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::DataPaths::Path *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void DataPaths_PythonToCpp_DataPaths_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_DataPaths_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_DataPaths_PythonToCpp_DataPaths_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_DataPaths_TypeF()))
        return DataPaths_PythonToCpp_DataPaths_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *DataPaths_PTR_CppToPython_DataPaths(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_DataPaths_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_DataPaths_TypeF(), const_cast<void *>(cppIn), false);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *DataPaths_SignatureStrings[] = {
    "PyFalkon.DataPaths(self)",
    "PyFalkon.DataPaths.allPaths(type:PyFalkon.DataPaths.Path)->QStringList",
    "PyFalkon.DataPaths.currentProfilePath()->QString",
    "PyFalkon.DataPaths.locate(type:PyFalkon.DataPaths.Path,file:QString)->QString",
    "PyFalkon.DataPaths.path(type:PyFalkon.DataPaths.Path)->QString",
    "PyFalkon.DataPaths.setCurrentProfilePath(profilePath:QString)",
    "PyFalkon.DataPaths.setPortableVersion()",
    nullptr}; // Sentinel
#else
static constexpr size_t DataPaths_SignatureByteSize = 144;
static constexpr uint8_t DataPaths_SignatureBytes[144] = {
    0x78, 0xda, 0x8d, 0x8f, 0xb1, 0x0a, 0xc2, 0x40, 0x0c, 0x86, 0xf7, 0x3e, 0xc9, 0x1d, 0x68, 0x1f,
    0xa0, 0x83, 0x8b, 0xe2, 0xe4, 0x10, 0x11, 0xdc, 0x63, 0x49, 0xf5, 0x30, 0x5c, 0x8e, 0x5c, 0x3a,
    0xf4, 0xed, 0xe5, 0x50, 0xec, 0xd0, 0xb3, 0xb8, 0x84, 0x90, 0xfc, 0xff, 0xf7, 0x27, 0x30, 0x1d,
    0x91, 0x9f, 0x12, 0xdb, 0x03, 0x1a, 0x02, 0xda, 0x23, 0xbb, 0x4c, 0x3c, 0xf8, 0x06, 0x16, 0x8b,
    0x16, 0x99, 0xdf, 0x0a, 0x9b, 0x12, 0x75, 0x15, 0x41, 0xa9, 0x7e, 0xbb, 0x3b, 0x5f, 0x4c, 0x43,
    0xbc, 0x9f, 0x42, 0xb6, 0x1a, 0xa6, 0x1f, 0x55, 0x29, 0x1a, 0xa8, 0x0c, 0x81, 0xa9, 0xcc, 0xdc,
    0x6c, 0xaa, 0x19, 0x58, 0x7a, 0x34, 0x5a, 0x4d, 0xdd, 0x14, 0x54, 0xf7, 0x61, 0xac, 0xd3, 0x52,
    0x09, 0xfc, 0xef, 0x83, 0x9a, 0x3d, 0x93, 0xed, 0x97, 0x0f, 0xa4, 0xb9, 0xff, 0x5e, 0xf1, 0xc3,
    0x0d, 0xa2, 0x86, 0x37, 0xa6, 0x2b, 0x69, 0x0e, 0x12, 0x9d, 0x6f, 0x5e, 0x74, 0x7f, 0x8d, 0xc6
};
#endif

PyTypeObject *init_DataPaths(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_DataPaths_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_DataPaths_IDX].type;

    Shiboken::AutoDecRef Sbk_DataPaths_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_DataPaths_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "DataPaths",
        "DataPaths*",
        &Sbk_DataPaths_spec,
        &Shiboken::callCppDestructor< ::DataPaths >,
        Sbk_DataPaths_Type_bases.object(),
        0);
    auto *pyType = _Sbk_DataPaths_Type; // references _Sbk_DataPaths_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, DataPaths_SignatureStrings);
#else
    InitSignatureBytes(pyType, DataPaths_SignatureBytes, DataPaths_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_DataPaths_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_DataPaths_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        DataPaths_PythonToCpp_DataPaths_PTR,
        is_DataPaths_PythonToCpp_DataPaths_PTR_Convertible,
        DataPaths_PTR_CppToPython_DataPaths);

    Shiboken::Conversions::registerConverterName(converter, "DataPaths");
    Shiboken::Conversions::registerConverterName(converter, "DataPaths*");
    Shiboken::Conversions::registerConverterName(converter, "DataPaths&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::DataPaths).name());

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_DataPaths_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Path'.
    const char *Path_Initializer[] = {
        "AppData",
        "Themes",
        "Plugins",
        "Config",
        "Profiles",
        "CurrentProfile",
        "Temp",
        "Cache",
        "Sessions",
        "LastPath",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Path_InitializerValues[] = {
        uint8_t(DataPaths::Path::AppData),        //  0x00  0
        uint8_t(DataPaths::Path::Themes),         //  0x01  1
        uint8_t(DataPaths::Path::Plugins),        //  0x02  2
        uint8_t(DataPaths::Path::Config),         //  0x03  3
        uint8_t(DataPaths::Path::Profiles),       //  0x04  4
        uint8_t(DataPaths::Path::CurrentProfile), //  0x05  5
        uint8_t(DataPaths::Path::Temp),           //  0x06  6
        uint8_t(DataPaths::Path::Cache),          //  0x07  7
        uint8_t(DataPaths::Path::Sessions),       //  0x08  8
        uint8_t(DataPaths::Path::LastPath)        //  0x09  9
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_DataPaths_TypeF(),
        "1:PyFalkon.DataPaths.Path",
        Path_Initializer, Path_InitializerValues);
    SbkPyFalkonTypeStructs[SBK_DataPaths_Path_IDX].type = EType;
    // Register converter for enum 'DataPaths::Path'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            DataPaths_Path_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_DataPaths_Path,
            is_Enum_PythonToCpp_DataPaths_Path_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "DataPaths::Path");
        Shiboken::Conversions::registerConverterAlias(converter, "Path");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'Path' enum.

    qRegisterMetaType< ::DataPaths *>();
    qRegisterMetaType< ::DataPaths::Path >("DataPaths::Path");

    return pyType;
}
