
#include <sbkpep.h>
#include <shiboken.h>
#include <sbkbindingutils.h>
#include <algorithm>
#include <signature.h>
#include <sbkcontainer.h>
#include <sbkstaticstrings.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysidecleanup.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include <pysidestaticstrings.h>
#include "pyfalkon_python.h"

#include <QHash>
#include <QList>
#include <QMap>
#include <QString>
#include <QTextLayout>
#include <bookmarkitem.h>
#include <browserwindow.h>
#include <history.h>
#include <passwordbackends/passwordbackend.h>
#include <passwordmanager.h>
#include <plugininterface.h>
#include <plugins.h>
#include <qabstractitemmodel.h>
#include <qaction.h>
#include <qbytearray.h>
#include <qnetworkcookie.h>
#include <qsqlrecord.h>
#include <qurl.h>
#include <qvariant.h>
#include <qwebenginecertificateerror.h>
#include <qwebenginepage.h>
#include <qwebenginesettings.h>
#include <searchenginesmanager.h>
#include <sitesettingsmanager.h>
#include <utility>
#include <webtab.h>


// Current module's type array.
Shiboken::Module::TypeInitStruct *SbkPyFalkonTypeStructs = nullptr;
// Backwards compatible structure with identical indexing.
PyTypeObject **SbkPyFalkonTypes = nullptr;
// Current module's converter array.
SbkConverter **SbkPyFalkonTypeConverters = nullptr;

// Begin code injection
#include <pythonplugin.h>
// End of code injection

void cleanTypesAttributes() {
    static PyObject *attrName = Shiboken::PyName::qtStaticMetaObject();
    const int imax = SBK_PyFalkon_IDX_COUNT;
    for (int i = 0; i < imax && SbkPyFalkonTypeStructs[i].fullName != nullptr; ++i) {
        auto *pyType = reinterpret_cast<PyObject *>(SbkPyFalkonTypeStructs[i].type);
        if (pyType != nullptr && PyObject_HasAttr(pyType, attrName))
            PyObject_SetAttr(pyType, attrName, Py_None);
    }
}

// Global functions ------------------------------------------------------------
static PyObject *SbkPyFalkonModule_registerPlugin(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    static const char fullName[] = "PyFalkon.registerPlugin";
    SBK_UNUSED(fullName)
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: registerPlugin(PluginInterface*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]), (pyArg)))) {
        overloadId = 0; // registerPlugin(PluginInterface*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, fullName, errInfo);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::PluginInterface *cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (Shiboken::Errors::occurred() == nullptr) {
            // registerPlugin(PluginInterface*)
            // Begin code injection
            Py_INCREF(pyArg);
            pyfalkon_register_plugin(cppArg0);
            // End of code injection

        }
    }

     return Sbk_ReturnFromPython_None();
}


static PyMethodDef PyFalkonMethods[] = {
    {"registerPlugin", reinterpret_cast<PyCFunction>(SbkPyFalkonModule_registerPlugin), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
PyTypeObject *init_WheelHelper(PyObject *enclosing);
PyTypeObject *init_WebView(PyObject *enclosing);
PyTypeObject *init_WebTab(PyObject *enclosing);
PyTypeObject *init_WebPage(PyObject *enclosing);
PyTypeObject *init_WebInspector(PyObject *enclosing);
PyTypeObject *init_WebHitTestResult(PyObject *enclosing);
PyTypeObject *init_UrlInterceptor(PyObject *enclosing);
PyTypeObject *init_ToolButton(PyObject *enclosing);
PyTypeObject *init_TabbedWebView(PyObject *enclosing);
PyTypeObject *init_TabTreeModel(PyObject *enclosing);
PyTypeObject *init_TabStackedWidget(PyObject *enclosing);
PyTypeObject *init_TabWidget(PyObject *enclosing);
PyTypeObject *init_TabMruModel(PyObject *enclosing);
PyTypeObject *init_TabModel(PyObject *enclosing);
PyTypeObject *init_TabIcon(PyObject *enclosing);
PyTypeObject *init_TabIcon_Data(PyObject *enclosing);
PyTypeObject *init_TabContextMenu(PyObject *enclosing);
PyTypeObject *init_StatusBar(PyObject *enclosing);
PyTypeObject *init_SqueezeLabelV2(PyObject *enclosing);
PyTypeObject *init_SqueezeLabelV1(PyObject *enclosing);
PyTypeObject *init_SqlQueryJob(PyObject *enclosing);
PyTypeObject *init_SqlDatabase(PyObject *enclosing);
PyTypeObject *init_SiteSettingsManager(PyObject *enclosing);
PyTypeObject *init_SiteSettingsManager_SiteSettings(PyObject *enclosing);
PyTypeObject *init_SideWidget(PyObject *enclosing);
PyTypeObject *init_SideBarManager(PyObject *enclosing);
PyTypeObject *init_SideBarInterface(PyObject *enclosing);
PyTypeObject *init_Settings(PyObject *enclosing);
PyTypeObject *init_SearchToolBar(PyObject *enclosing);
PyTypeObject *init_SearchEnginesManager(PyObject *enclosing);
PyTypeObject *init_SearchEnginesManager_Engine(PyObject *enclosing);
PyTypeObject *init_SearchEnginesDialog(PyObject *enclosing);
PyTypeObject *init_QzTools(PyObject *enclosing);
PyTypeObject *init_QzSettings(PyObject *enclosing);
PyTypeObject *init_PyFalkonQz(PyObject *enclosing);
PyTypeObject *init_PyFalkonQzStaticFields(PyObject *module);
PyTypeObject *init_QtSingleApplication(PyObject *enclosing);
PyTypeObject *init_Plugins(PyObject *enclosing);
PyTypeObject *init_PluginSpec(PyObject *enclosing);
PyTypeObject *init_PluginProxy(PyObject *enclosing);
PyTypeObject *init_PluginInterface(PyObject *enclosing);
PyTypeObject *init_Plugins_Plugin(PyObject *enclosing);
PyTypeObject *init_PasswordManager(PyObject *enclosing);
PyTypeObject *init_PasswordEntry(PyObject *enclosing);
PyTypeObject *init_PasswordBackend(PyObject *enclosing);
PyTypeObject *init_PageFormData(PyObject *enclosing);
PyTypeObject *init_NetworkManager(PyObject *enclosing);
PyTypeObject *init_NavigationBar(PyObject *enclosing);
PyTypeObject *init_Menu(PyObject *enclosing);
PyTypeObject *init_MainApplication(PyObject *enclosing);
PyTypeObject *init_LoadRequest(PyObject *enclosing);
PyTypeObject *init_LineEdit(PyObject *enclosing);
PyTypeObject *init_LocationBar(PyObject *enclosing);
PyTypeObject *init_IconProvider(PyObject *enclosing);
PyTypeObject *init_HistoryModel(PyObject *enclosing);
PyTypeObject *init_History(PyObject *enclosing);
PyTypeObject *init_History_HistoryEntry(PyObject *enclosing);
PyTypeObject *init_HistoryItem(PyObject *enclosing);
PyTypeObject *init_ExternalJsObject(PyObject *enclosing);
PyTypeObject *init_ExtensionSchemeHandler(PyObject *enclosing);
PyTypeObject *init_DownloadManager(PyObject *enclosing);
PyTypeObject *init_DownloadManager_DownloadInfo(PyObject *enclosing);
PyTypeObject *init_DownloadItem(PyObject *enclosing);
PyTypeObject *init_DesktopNotificationsFactory(PyObject *enclosing);
PyTypeObject *init_DesktopFile(PyObject *enclosing);
PyTypeObject *init_DelayedFileWatcher(PyObject *enclosing);
PyTypeObject *init_DataPaths(PyObject *enclosing);
PyTypeObject *init_CookieManager(PyObject *enclosing);
PyTypeObject *init_CookieJar(PyObject *enclosing);
PyTypeObject *init_ComboTabBar(PyObject *enclosing);
PyTypeObject *init_TabBar(PyObject *enclosing);
PyTypeObject *init_ClickableLabel(PyObject *enclosing);
PyTypeObject *init_CheckBoxDialog(PyObject *enclosing);
PyTypeObject *init_BrowserWindow(PyObject *enclosing);
PyTypeObject *init_BookmarksTools(PyObject *enclosing);
PyTypeObject *init_BookmarksModel(PyObject *enclosing);
PyTypeObject *init_BookmarksFoldersMenu(PyObject *enclosing);
PyTypeObject *init_BookmarksFoldersButton(PyObject *enclosing);
PyTypeObject *init_Bookmarks(PyObject *enclosing);
PyTypeObject *init_BookmarkItem(PyObject *enclosing);
PyTypeObject *init_LocationBar_LoadAction(PyObject *enclosing);
PyTypeObject *init_AutoSaver(PyObject *enclosing);
PyTypeObject *init_AutoFill(PyObject *enclosing);
PyTypeObject *init_Action(PyObject *enclosing);
PyTypeObject *init_AbstractButtonInterface(PyObject *enclosing);
PyTypeObject *init_AbstractButtonInterface_ClickController(PyObject *enclosing);

// Required modules' type and converter arrays.
Shiboken::Module::TypeInitStruct *SbkPySide6_QtWebEngineCoreTypeStructs;
SbkConverter **SbkPySide6_QtWebEngineCoreTypeConverters;
Shiboken::Module::TypeInitStruct *SbkPySide6_QtCoreTypeStructs;
SbkConverter **SbkPySide6_QtCoreTypeConverters;
Shiboken::Module::TypeInitStruct *SbkPySide6_QtGuiTypeStructs;
SbkConverter **SbkPySide6_QtGuiTypeConverters;
Shiboken::Module::TypeInitStruct *SbkPySide6_QtNetworkTypeStructs;
SbkConverter **SbkPySide6_QtNetworkTypeConverters;
Shiboken::Module::TypeInitStruct *SbkPySide6_QtPrintSupportTypeStructs;
SbkConverter **SbkPySide6_QtPrintSupportTypeConverters;
Shiboken::Module::TypeInitStruct *SbkPySide6_QtWidgetsTypeStructs;
SbkConverter **SbkPySide6_QtWidgetsTypeConverters;
Shiboken::Module::TypeInitStruct *SbkPySide6_QtWebChannelTypeStructs;
SbkConverter **SbkPySide6_QtWebChannelTypeConverters;
Shiboken::Module::TypeInitStruct *SbkPySide6_QtWebEngineWidgetsTypeStructs;
SbkConverter **SbkPySide6_QtWebEngineWidgetsTypeConverters;
Shiboken::Module::TypeInitStruct *SbkPySide6_QtSqlTypeStructs;
SbkConverter **SbkPySide6_QtSqlTypeConverters;

// Module initialization ------------------------------------------------------------
// Container Type converters.

// C++ to Python conversion for container type 'QList<int>'.
static PyObject *_QList_int__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<int> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        ShibokenContainerStdVectorValueType<int>::Type cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_int_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<int> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        int cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_int__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn))
        return PySequence_PythonToCpp__QList_int_;
    return {};
}


// Binding for QList<int>

template <>
struct ShibokenContainerValueConverter<int>
{
    static bool checkValue(PyObject *pyArg)
    {
        return PyLong_Check(pyArg);
    }

    static PyObject *convertValueToPython(int cppArg)
    {
        return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppArg);
    }

    static std::optional<int> convertValueToCpp(PyObject *pyArg)
    {
        Shiboken::Conversions::PythonToCppConversion pythonToCpp;
        if (!(PyLong_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg))))) {
            Shiboken::Errors::setWrongContainerType();
            return {};
        }
        int cppArg;
        pythonToCpp(pyArg, &cppArg);
        return cppArg;
    }
};

static PyMethodDef QIntList_methods[] = {
    {"push_back", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::push_back), METH_O, "push_back"},
    {"append", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::push_back), METH_O, "append"},
    {"clear", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::clear), METH_NOARGS, "clear"},
    {"pop_back", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::pop_back), METH_NOARGS, "pop_back"},
    {"removeLast", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::pop_back), METH_NOARGS, "removeLast"},
    {"push_front", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::push_front), METH_O, "push_front"},
    {"prepend", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::push_front), METH_O, "prepend"},
    {"pop_front", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::pop_front), METH_NOARGS, "pop_front"},
    {"removeFirst", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::pop_front), METH_O, "removeFirst"},
    {"reserve", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::reserve), METH_O, "reserve"},
    {"capacity", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::capacity), METH_NOARGS, "capacity"},
    {"data", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::data), METH_NOARGS, "data"},
    {"constData", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::constData), METH_NOARGS, "constData"},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static PyType_Slot QIntList_slots[] = {
    {Py_tp_init, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::tpInit)},
    {Py_tp_new, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::tpNew)},
    {Py_tp_free, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::tpFree)},
    {Py_tp_dealloc, reinterpret_cast<void *>(Sbk_object_dealloc)},
    {Py_tp_methods, reinterpret_cast<void *>(QIntList_methods)},
    {Py_sq_ass_item, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::sqSetItem)},
    {Py_sq_length, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::sqLen)},
    {Py_sq_item, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::sqGetItem)},
    {0, nullptr}
};

static PyType_Spec QIntList_spec = {
    "1:PyFalkon.QIntList",
    sizeof(ShibokenContainer),
    0,
    Py_TPFLAGS_DEFAULT,
    QIntList_slots
};

static inline PyTypeObject *createQIntListType()
{
    auto *result = SbkType_FromSpec(&QIntList_spec);
    Py_INCREF(Py_True);
    Shiboken::AutoDecRef tpDict(PepType_GetDict(result));
    PyDict_SetItem(tpDict.object(), Shiboken::PyMagicName::opaque_container(), Py_True);
    return result;
}

static PyTypeObject *QIntList_TypeF()
{
    static PyTypeObject *type = createQIntListType();
    return type;
}

extern "C" PyObject *createQIntList(QList<int>* ct)
{
    auto *container = PyObject_New(ShibokenContainer, QIntList_TypeF());
    auto *d = new ShibokenSequenceContainerPrivate<QList<int>>();
    d->m_list = ct;
    container->d = d;
    return reinterpret_cast<PyObject *>(container);
}

extern "C" PyObject *createConstQIntList(const QList<int>* ct)
{
    auto *container = PyObject_New(ShibokenContainer, QIntList_TypeF());
    auto *d = new ShibokenSequenceContainerPrivate<QList<int>>();
    d->m_list = const_cast<QList<int> *>(ct);
    d->m_const = true;
    container->d = d;
    return reinterpret_cast<PyObject *>(container);
}

extern "C" int QIntList_Check(PyObject *pyArg)
{
    return pyArg != nullptr && pyArg != Py_None && pyArg->ob_type == QIntList_TypeF();
}

extern "C" void PythonToCppQIntList(PyObject *pyArg, void *cppOut)
{
    auto *d = ShibokenSequenceContainerPrivate<QList<int>>::get(pyArg);
    *reinterpret_cast<QList<int>**>(cppOut) = d->m_list;
}

extern "C" PythonToCppFunc isQIntListPythonToCppConvertible(PyObject *pyArg)
{
    if (QIntList_Check(pyArg))
        return PythonToCppQIntList;
    return {};
}

extern "C" void PythonToQVariantQIntList(PyObject *pyArg, void *cppOut)
{
    auto *d = ShibokenSequenceContainerPrivate<QList<int>>::get(pyArg);
    *reinterpret_cast<QVariant *>(cppOut) = QVariant::fromValue(*d->m_list);
}

extern "C" PythonToCppFunc isQIntListPythonToQVariantConvertible(PyObject *pyArg)
{
    if (QIntList_Check(pyArg))
        return PythonToQVariantQIntList;
    return {};
}

// C++ to Python conversion for container type 'QList<WebTab*>'.
static PyObject *_QList_WebTabPTR__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<WebTab*> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        ShibokenContainerStdVectorValueType<::WebTab*>::Type cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_WebTabPTR_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<WebTab*> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::WebTab* cppItem{nullptr};
    Shiboken::Conversions::pythonToCppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_WebTabPTR__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::checkSequenceTypes(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_WebTabPTR_;
    return {};
}

// C++ to Python conversion for container type 'QHash<QString,QVariant>'.
static PyObject *_QHash_QString_QVariant__CppToPython_PyDict(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QHash<QString,QVariant> *>(cppIn);
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - START
    PyObject *pyOut = PyDict_New();
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it) {
        const auto &key = it.key();
        const auto &value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - END

}
static void PyDict_PythonToCpp__QHash_QString_QVariant_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QHash<QString,QVariant> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - START
    PyObject *key{};
    PyObject *value{};
    cppOutRef.clear();
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], key, &(cppKey));
        ::QVariant cppValue;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - END

}
static PythonToCppFunc is_PyDict_PythonToCpp__QHash_QString_QVariant__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], false, SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], false, pyIn))
        return PyDict_PythonToCpp__QHash_QString_QVariant_;
    return {};
}

// C++ to Python conversion for container type 'std::pair<bool,QString>'.
static PyObject *std_pair_bool_QString__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const std::pair<bool,QString> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cpppair_to_pytuple - START
    PyObject *pyOut = PyTuple_New(2);
    PyTuple_SetItem(pyOut, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppInRef.first));
    PyTuple_SetItem(pyOut, 1, Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppInRef.second));
    return pyOut;
    // TEMPLATE - shiboken_conversion_cpppair_to_pytuple - END

}
static void PySequence_PythonToCpp_std_pair_bool_QString_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<std::pair<bool,QString> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pysequence_to_cpppair - START
    Shiboken::AutoDecRef objfirst(PySequence_GetItem(pyIn, 0));
    Shiboken::AutoDecRef objsecond(PySequence_GetItem(pyIn, 1));
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), objfirst, &(cppOutRef.first));
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], objsecond, &(cppOutRef.second));
    // TEMPLATE - shiboken_conversion_pysequence_to_cpppair - END

}
static PythonToCppFunc is_PySequence_PythonToCpp_std_pair_bool_QString__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertiblePairTypes(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), false, SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], false, pyIn))
        return PySequence_PythonToCpp_std_pair_bool_QString_;
    return {};
}

// C++ to Python conversion for container type 'QMap<QString,QVariant>'.
static PyObject *_QMap_QString_QVariant__CppToPython_PyDict(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QMap<QString,QVariant> *>(cppIn);
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - START
    PyObject *pyOut = PyDict_New();
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it) {
        const auto &key = it.key();
        const auto &value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - END

}
static void PyDict_PythonToCpp__QMap_QString_QVariant_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QMap<QString,QVariant> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - START
    PyObject *key{};
    PyObject *value{};
    cppOutRef.clear();
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], key, &(cppKey));
        ::QVariant cppValue;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - END

}
static PythonToCppFunc is_PyDict_PythonToCpp__QMap_QString_QVariant__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], false, SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], false, pyIn))
        return PyDict_PythonToCpp__QMap_QString_QVariant_;
    return {};
}

// C++ to Python conversion for container type 'QMap<int,QVariant>'.
static PyObject *_QMap_int_QVariant__CppToPython_PyDict(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QMap<int,QVariant> *>(cppIn);
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - START
    PyObject *pyOut = PyDict_New();
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it) {
        const auto &key = it.key();
        const auto &value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - END

}
static void PyDict_PythonToCpp__QMap_int_QVariant_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QMap<int,QVariant> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - START
    PyObject *key{};
    PyObject *value{};
    cppOutRef.clear();
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        int cppKey;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), key, &(cppKey));
        ::QVariant cppValue;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - END

}
static PythonToCppFunc is_PyDict_PythonToCpp__QMap_int_QVariant__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleDictTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), false, SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], false, pyIn))
        return PyDict_PythonToCpp__QMap_int_QVariant_;
    return {};
}

// C++ to Python conversion for container type 'QList<QModelIndex>'.
static PyObject *_QList_QModelIndex__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QModelIndex> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        ShibokenContainerStdVectorValueType<::QModelIndex>::Type cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QModelIndex_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QModelIndex> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QModelIndex cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QModelIndex__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_QModelIndex_;
    return {};
}

// C++ to Python conversion for container type 'QHash<int,QByteArray>'.
static PyObject *_QHash_int_QByteArray__CppToPython_PyDict(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QHash<int,QByteArray> *>(cppIn);
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - START
    PyObject *pyOut = PyDict_New();
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it) {
        const auto &key = it.key();
        const auto &value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - END

}
static void PyDict_PythonToCpp__QHash_int_QByteArray_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QHash<int,QByteArray> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - START
    PyObject *key{};
    PyObject *value{};
    cppOutRef.clear();
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        int cppKey;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), key, &(cppKey));
        ::QByteArray cppValue;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - END

}
static PythonToCppFunc is_PyDict_PythonToCpp__QHash_int_QByteArray__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleDictTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), false, PepType_SOTP(reinterpret_cast<PyTypeObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX])))->converter, false, pyIn))
        return PyDict_PythonToCpp__QHash_int_QByteArray_;
    return {};
}

// C++ to Python conversion for container type 'QList<QSqlRecord>'.
static PyObject *_QList_QSqlRecord__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QSqlRecord> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        ShibokenContainerStdVectorValueType<::QSqlRecord>::Type cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtSqlTypeStructs[SBK_QSqlRecord_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QSqlRecord_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QSqlRecord> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QSqlRecord cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkPySide6_QtSqlTypeStructs[SBK_QSqlRecord_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QSqlRecord__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Module::get(SbkPySide6_QtSqlTypeStructs[SBK_QSqlRecord_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_QSqlRecord_;
    return {};
}

// C++ to Python conversion for container type 'QMap<QString,SiteSettingsManager::Permission>'.
static PyObject *_QMap_QString_SiteSettingsManager_Permission__CppToPython_PyDict(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QMap<QString,SiteSettingsManager::Permission> *>(cppIn);
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - START
    PyObject *pyOut = PyDict_New();
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it) {
        const auto &key = it.key();
        const auto &value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX])))->converter, &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - END

}
static void PyDict_PythonToCpp__QMap_QString_SiteSettingsManager_Permission_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QMap<QString,SiteSettingsManager::Permission> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - START
    PyObject *key{};
    PyObject *value{};
    cppOutRef.clear();
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], key, &(cppKey));
        ::SiteSettingsManager::Permission cppValue{SiteSettingsManager::Default};
    Shiboken::Conversions::pythonToCppCopy(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX])))->converter, value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - END

}
static PythonToCppFunc is_PyDict_PythonToCpp__QMap_QString_SiteSettingsManager_Permission__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], false, PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX])))->converter, false, pyIn))
        return PyDict_PythonToCpp__QMap_QString_SiteSettingsManager_Permission_;
    return {};
}

// C++ to Python conversion for container type 'QList<QWebEngineSettings::WebAttribute>'.
static PyObject *_QList_QWebEngineSettings_WebAttribute__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QWebEngineSettings::WebAttribute> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        ShibokenContainerStdVectorValueType<::QWebEngineSettings::WebAttribute>::Type cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineSettings_WebAttribute_IDX])))->converter, &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QWebEngineSettings_WebAttribute_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QWebEngineSettings::WebAttribute> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QWebEngineSettings::WebAttribute cppItem{QWebEngineSettings::AutoLoadImages};
    Shiboken::Conversions::pythonToCppCopy(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineSettings_WebAttribute_IDX])))->converter, pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QWebEngineSettings_WebAttribute__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineSettings_WebAttribute_IDX])))->converter, pyIn))
        return PySequence_PythonToCpp__QList_QWebEngineSettings_WebAttribute_;
    return {};
}

// C++ to Python conversion for container type 'QList<QWebEnginePage::Feature>'.
static PyObject *_QList_QWebEnginePage_Feature__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QWebEnginePage::Feature> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        ShibokenContainerStdVectorValueType<::QWebEnginePage::Feature>::Type cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEnginePage_Feature_IDX])))->converter, &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QWebEnginePage_Feature_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QWebEnginePage::Feature> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QWebEnginePage::Feature cppItem{QWebEnginePage::Notifications};
    Shiboken::Conversions::pythonToCppCopy(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEnginePage_Feature_IDX])))->converter, pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QWebEnginePage_Feature__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEnginePage_Feature_IDX])))->converter, pyIn))
        return PySequence_PythonToCpp__QList_QWebEnginePage_Feature_;
    return {};
}

// C++ to Python conversion for container type 'QHash<QWebEngineSettings::WebAttribute,bool>'.
static PyObject *_QHash_QWebEngineSettings_WebAttribute_bool__CppToPython_PyDict(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QHash<QWebEngineSettings::WebAttribute,bool> *>(cppIn);
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - START
    PyObject *pyOut = PyDict_New();
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it) {
        const auto &key = it.key();
        const auto &value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineSettings_WebAttribute_IDX])))->converter, &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - END

}
static void PyDict_PythonToCpp__QHash_QWebEngineSettings_WebAttribute_bool_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QHash<QWebEngineSettings::WebAttribute,bool> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - START
    PyObject *key{};
    PyObject *value{};
    cppOutRef.clear();
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QWebEngineSettings::WebAttribute cppKey{QWebEngineSettings::AutoLoadImages};
    Shiboken::Conversions::pythonToCppCopy(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineSettings_WebAttribute_IDX])))->converter, key, &(cppKey));
        bool cppValue;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - END

}
static PythonToCppFunc is_PyDict_PythonToCpp__QHash_QWebEngineSettings_WebAttribute_bool__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleDictTypes(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineSettings_WebAttribute_IDX])))->converter, false, Shiboken::Conversions::PrimitiveTypeConverter<bool>(), false, pyIn))
        return PyDict_PythonToCpp__QHash_QWebEngineSettings_WebAttribute_bool_;
    return {};
}

// C++ to Python conversion for container type 'QMap<QWebEngineSettings::WebAttribute,SiteSettingsManager::Permission>'.
static PyObject *_QMap_QWebEngineSettings_WebAttribute_SiteSettingsManager_Permission__CppToPython_PyDict(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QMap<QWebEngineSettings::WebAttribute,SiteSettingsManager::Permission> *>(cppIn);
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - START
    PyObject *pyOut = PyDict_New();
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it) {
        const auto &key = it.key();
        const auto &value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineSettings_WebAttribute_IDX])))->converter, &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX])))->converter, &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - END

}
static void PyDict_PythonToCpp__QMap_QWebEngineSettings_WebAttribute_SiteSettingsManager_Permission_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QMap<QWebEngineSettings::WebAttribute,SiteSettingsManager::Permission> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - START
    PyObject *key{};
    PyObject *value{};
    cppOutRef.clear();
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QWebEngineSettings::WebAttribute cppKey{QWebEngineSettings::AutoLoadImages};
    Shiboken::Conversions::pythonToCppCopy(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineSettings_WebAttribute_IDX])))->converter, key, &(cppKey));
        ::SiteSettingsManager::Permission cppValue{SiteSettingsManager::Default};
    Shiboken::Conversions::pythonToCppCopy(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX])))->converter, value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - END

}
static PythonToCppFunc is_PyDict_PythonToCpp__QMap_QWebEngineSettings_WebAttribute_SiteSettingsManager_Permission__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleDictTypes(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineSettings_WebAttribute_IDX])))->converter, false, PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX])))->converter, false, pyIn))
        return PyDict_PythonToCpp__QMap_QWebEngineSettings_WebAttribute_SiteSettingsManager_Permission_;
    return {};
}

// C++ to Python conversion for container type 'QMap<QWebEnginePage::Feature,SiteSettingsManager::Permission>'.
static PyObject *_QMap_QWebEnginePage_Feature_SiteSettingsManager_Permission__CppToPython_PyDict(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QMap<QWebEnginePage::Feature,SiteSettingsManager::Permission> *>(cppIn);
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - START
    PyObject *pyOut = PyDict_New();
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it) {
        const auto &key = it.key();
        const auto &value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEnginePage_Feature_IDX])))->converter, &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX])))->converter, &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - END

}
static void PyDict_PythonToCpp__QMap_QWebEnginePage_Feature_SiteSettingsManager_Permission_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QMap<QWebEnginePage::Feature,SiteSettingsManager::Permission> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - START
    PyObject *key{};
    PyObject *value{};
    cppOutRef.clear();
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QWebEnginePage::Feature cppKey{QWebEnginePage::Notifications};
    Shiboken::Conversions::pythonToCppCopy(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEnginePage_Feature_IDX])))->converter, key, &(cppKey));
        ::SiteSettingsManager::Permission cppValue{SiteSettingsManager::Default};
    Shiboken::Conversions::pythonToCppCopy(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX])))->converter, value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - END

}
static PythonToCppFunc is_PyDict_PythonToCpp__QMap_QWebEnginePage_Feature_SiteSettingsManager_Permission__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleDictTypes(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEnginePage_Feature_IDX])))->converter, false, PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX])))->converter, false, pyIn))
        return PyDict_PythonToCpp__QMap_QWebEnginePage_Feature_SiteSettingsManager_Permission_;
    return {};
}

// C++ to Python conversion for container type 'QList<SearchEnginesManager::Engine>'.
static PyObject *_QList_SearchEnginesManager_Engine__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<SearchEnginesManager::Engine> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        ShibokenContainerStdVectorValueType<::SearchEnginesManager::Engine>::Type cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_SearchEnginesManager_Engine_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<SearchEnginesManager::Engine> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::SearchEnginesManager::Engine cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_SearchEnginesManager_Engine__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_SearchEnginesManager_Engine_;
    return {};
}

// C++ to Python conversion for container type 'QList<Plugins::Plugin>'.
static PyObject *_QList_Plugins_Plugin__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<Plugins::Plugin> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        ShibokenContainerStdVectorValueType<::Plugins::Plugin>::Type cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_Plugins_Plugin_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<Plugins::Plugin> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Plugins::Plugin cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_Plugins_Plugin__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_Plugins_Plugin_;
    return {};
}

// C++ to Python conversion for container type 'QList<PluginInterface*>'.
static PyObject *_QList_PluginInterfacePTR__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<PluginInterface*> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        ShibokenContainerStdVectorValueType<::PluginInterface*>::Type cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_PluginInterfacePTR_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<PluginInterface*> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::PluginInterface* cppItem{nullptr};
    Shiboken::Conversions::pythonToCppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_PluginInterfacePTR__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::checkSequenceTypes(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_PluginInterfacePTR_;
    return {};
}

// C++ to Python conversion for container type 'QHash<QString,PasswordBackend*>'.
static PyObject *_QHash_QString_PasswordBackendPTR__CppToPython_PyDict(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QHash<QString,PasswordBackend*> *>(cppIn);
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - START
    PyObject *pyOut = PyDict_New();
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it) {
        const auto &key = it.key();
        const auto &value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]), value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - END

}
static void PyDict_PythonToCpp__QHash_QString_PasswordBackendPTR_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QHash<QString,PasswordBackend*> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - START
    PyObject *key{};
    PyObject *value{};
    cppOutRef.clear();
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], key, &(cppKey));
        ::PasswordBackend* cppValue{nullptr};
    Shiboken::Conversions::pythonToCppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]), value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - END

}
static PythonToCppFunc is_PyDict_PythonToCpp__QHash_QString_PasswordBackendPTR__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], false, PepType_SOTP(reinterpret_cast<PyTypeObject *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX])))->converter, true, pyIn))
        return PyDict_PythonToCpp__QHash_QString_PasswordBackendPTR_;
    return {};
}

// C++ to Python conversion for container type 'QList<PasswordEntry>'.
static PyObject *_QList_PasswordEntry__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<PasswordEntry> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        ShibokenContainerStdVectorValueType<::PasswordEntry>::Type cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_PasswordEntry_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<PasswordEntry> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::PasswordEntry cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_PasswordEntry__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_PasswordEntry_;
    return {};
}

// C++ to Python conversion for container type 'QHash<QString,QWebEngineCertificateError::Type>'.
static PyObject *_QHash_QString_QWebEngineCertificateError_Type__CppToPython_PyDict(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QHash<QString,QWebEngineCertificateError::Type> *>(cppIn);
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - START
    PyObject *pyOut = PyDict_New();
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it) {
        const auto &key = it.key();
        const auto &value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineCertificateError_Type_IDX])))->converter, &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - END

}
static void PyDict_PythonToCpp__QHash_QString_QWebEngineCertificateError_Type_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QHash<QString,QWebEngineCertificateError::Type> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - START
    PyObject *key{};
    PyObject *value{};
    cppOutRef.clear();
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], key, &(cppKey));
        ::QWebEngineCertificateError::Type cppValue{QWebEngineCertificateError::Ok};
    Shiboken::Conversions::pythonToCppCopy(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineCertificateError_Type_IDX])))->converter, value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - END

}
static PythonToCppFunc is_PyDict_PythonToCpp__QHash_QString_QWebEngineCertificateError_Type__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], false, PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineCertificateError_Type_IDX])))->converter, false, pyIn))
        return PyDict_PythonToCpp__QHash_QString_QWebEngineCertificateError_Type_;
    return {};
}

// C++ to Python conversion for container type 'QList<QUrl>'.
static PyObject *_QList_QUrl__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QUrl> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        ShibokenContainerStdVectorValueType<::QUrl>::Type cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QUrl_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QUrl> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QUrl cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QUrl__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_QUrl_;
    return {};
}

// C++ to Python conversion for container type 'QList<BrowserWindow*>'.
static PyObject *_QList_BrowserWindowPTR__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<BrowserWindow*> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        ShibokenContainerStdVectorValueType<::BrowserWindow*>::Type cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_BrowserWindowPTR_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<BrowserWindow*> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::BrowserWindow* cppItem{nullptr};
    Shiboken::Conversions::pythonToCppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_BrowserWindowPTR__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::checkSequenceTypes(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_BrowserWindowPTR_;
    return {};
}

// C++ to Python conversion for container type 'QList<QTextLayout::FormatRange>'.
static PyObject *_QList_QTextLayout_FormatRange__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QTextLayout::FormatRange> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        ShibokenContainerStdVectorValueType<::QTextLayout::FormatRange>::Type cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QTextLayout_FormatRange_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QTextLayout_FormatRange_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QTextLayout::FormatRange> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QTextLayout::FormatRange cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QTextLayout_FormatRange_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QTextLayout_FormatRange__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QTextLayout_FormatRange_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_QTextLayout_FormatRange_;
    return {};
}

// C++ to Python conversion for container type 'QList<QPersistentModelIndex>'.
static PyObject *_QList_QPersistentModelIndex__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QPersistentModelIndex> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        ShibokenContainerStdVectorValueType<::QPersistentModelIndex>::Type cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPersistentModelIndex_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QPersistentModelIndex_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QPersistentModelIndex> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPersistentModelIndex cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPersistentModelIndex_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QPersistentModelIndex__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPersistentModelIndex_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_QPersistentModelIndex_;
    return {};
}

// C++ to Python conversion for container type 'QList<History::HistoryEntry>'.
static PyObject *_QList_History_HistoryEntry__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<History::HistoryEntry> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        ShibokenContainerStdVectorValueType<::History::HistoryEntry>::Type cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_History_HistoryEntry_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<History::HistoryEntry> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::History::HistoryEntry cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_History_HistoryEntry__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_History_HistoryEntry_;
    return {};
}

// C++ to Python conversion for container type 'QList<QNetworkCookie>'.
static PyObject *_QList_QNetworkCookie__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QNetworkCookie> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        ShibokenContainerStdVectorValueType<::QNetworkCookie>::Type cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtNetworkTypeStructs[SBK_QNetworkCookie_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QNetworkCookie_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QNetworkCookie> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QNetworkCookie cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkPySide6_QtNetworkTypeStructs[SBK_QNetworkCookie_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QNetworkCookie__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Module::get(SbkPySide6_QtNetworkTypeStructs[SBK_QNetworkCookie_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_QNetworkCookie_;
    return {};
}

// C++ to Python conversion for container type 'QList<QAction*>'.
static PyObject *_QList_QActionPTR__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QAction*> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        ShibokenContainerStdVectorValueType<::QAction*>::Type cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QActionPTR_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QAction*> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QAction* cppItem{nullptr};
    Shiboken::Conversions::pythonToCppPointer(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QActionPTR__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::checkSequenceTypes(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_QActionPTR_;
    return {};
}

// C++ to Python conversion for container type 'QList<QVariant>'.
static PyObject *_QList_QVariant__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QVariant> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        ShibokenContainerStdVectorValueType<::QVariant>::Type cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QVariant_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QVariant> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QVariant cppItem;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QVariant__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], pyIn))
        return PySequence_PythonToCpp__QList_QVariant_;
    return {};
}

// C++ to Python conversion for container type 'QList<BookmarkItem*>'.
static PyObject *_QList_BookmarkItemPTR__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<BookmarkItem*> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        ShibokenContainerStdVectorValueType<::BookmarkItem*>::Type cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_BookmarkItemPTR_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<BookmarkItem*> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::BookmarkItem* cppItem{nullptr};
    Shiboken::Conversions::pythonToCppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_BookmarkItemPTR__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::checkSequenceTypes(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_BookmarkItemPTR_;
    return {};
}

// C++ to Python conversion for container type 'QList<QString>'.
static PyObject *_QList_QString__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QString> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        ShibokenContainerStdVectorValueType<::QString>::Type cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QString_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QString> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QString cppItem;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QString__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], pyIn))
        return PySequence_PythonToCpp__QList_QString_;
    return {};
}


// The signatures string for the global functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *PyFalkon_SignatureStrings[] = {
    "PyFalkon.registerPlugin(arg__1:PyFalkon.PluginInterface)",
    nullptr}; // Sentinel
#else
static constexpr size_t PyFalkon_SignatureByteSize = 53;
static constexpr uint8_t PyFalkon_SignatureBytes[53] = {
    0x78, 0xda, 0x0b, 0xa8, 0x74, 0x4b, 0xcc, 0xc9, 0xce, 0xcf, 0xd3, 0x2b, 0x4a, 0x4d, 0xcf, 0x2c,
    0x2e, 0x49, 0x2d, 0x0a, 0xc8, 0x29, 0x4d, 0xcf, 0xcc, 0xd3, 0x48, 0x2c, 0x4a, 0x8f, 0x8f, 0x37,
    0xb4, 0x0a, 0x80, 0x49, 0x43, 0x84, 0x3d, 0xf3, 0x80, 0x2a, 0xd2, 0x12, 0x93, 0x53, 0x35, 0xb9,
    0x00, 0x76, 0x0c, 0x15, 0x37
};
#endif

static void initInheritance()
{
    auto &bm = Shiboken::BindingManager::instance();
    SBK_UNUSED(bm)
    bm.addClassInheritance(&SbkPySide6_QtWebEngineWidgetsTypeStructs[SBK_QWebEngineView_IDX],
                           &SbkPyFalkonTypeStructs[SBK_WebView_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEnginePage_IDX],
                           &SbkPyFalkonTypeStructs[SBK_WebPage_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWebEngineWidgetsTypeStructs[SBK_QWebEngineView_IDX],
                           &SbkPyFalkonTypeStructs[SBK_WebInspector_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkPyFalkonTypeStructs[SBK_UrlInterceptor_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QToolButton_IDX],
                           &SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]);
    bm.addClassInheritance(&SbkPyFalkonTypeStructs[SBK_WebView_IDX],
                           &SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QAbstractProxyModel_IDX],
                           &SbkPyFalkonTypeStructs[SBK_TabTreeModel_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);
    bm.addClassInheritance(&SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX],
                           &SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QAbstractProxyModel_IDX],
                           &SbkPyFalkonTypeStructs[SBK_TabMruModel_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QAbstractListModel_IDX],
                           &SbkPyFalkonTypeStructs[SBK_TabModel_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkPyFalkonTypeStructs[SBK_TabIcon_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX],
                           &SbkPyFalkonTypeStructs[SBK_TabContextMenu_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QStatusBar_IDX],
                           &SbkPyFalkonTypeStructs[SBK_StatusBar_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QLabel_IDX],
                           &SbkPyFalkonTypeStructs[SBK_SqueezeLabelV2_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QLabel_IDX],
                           &SbkPyFalkonTypeStructs[SBK_SqueezeLabelV1_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkPyFalkonTypeStructs[SBK_SqlQueryJob_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkPyFalkonTypeStructs[SBK_SqlDatabase_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkPyFalkonTypeStructs[SBK_SideWidget_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkPyFalkonTypeStructs[SBK_SideBarManager_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkPyFalkonTypeStructs[SBK_SideBarInterface_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkPyFalkonTypeStructs[SBK_SearchToolBar_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX],
                           &SbkPyFalkonTypeStructs[SBK_SearchEnginesDialog_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QApplication_IDX],
                           &SbkPyFalkonTypeStructs[SBK_QtSingleApplication_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkPyFalkonTypeStructs[SBK_Plugins_IDX]);
    bm.addClassInheritance(&SbkPyFalkonTypeStructs[SBK_Plugins_IDX],
                           &SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtNetworkTypeStructs[SBK_QNetworkAccessManager_IDX],
                           &SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX],
                           &SbkPyFalkonTypeStructs[SBK_Menu_IDX]);
    bm.addClassInheritance(&SbkPyFalkonTypeStructs[SBK_QtSingleApplication_IDX],
                           &SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QLineEdit_IDX],
                           &SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]);
    bm.addClassInheritance(&SbkPyFalkonTypeStructs[SBK_LineEdit_IDX],
                           &SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkPyFalkonTypeStructs[SBK_IconProvider_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QAbstractItemModel_IDX],
                           &SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkPyFalkonTypeStructs[SBK_History_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkPyFalkonTypeStructs[SBK_ExternalJsObject_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkPyFalkonTypeStructs[SBK_ExtensionSchemeHandler_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkPyFalkonTypeStructs[SBK_DownloadItem_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkPyFalkonTypeStructs[SBK_DesktopNotificationsFactory_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QFileSystemWatcher_IDX],
                           &SbkPyFalkonTypeStructs[SBK_DelayedFileWatcher_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX],
                           &SbkPyFalkonTypeStructs[SBK_CookieManager_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkPyFalkonTypeStructs[SBK_CookieJar_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);
    bm.addClassInheritance(&SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX],
                           &SbkPyFalkonTypeStructs[SBK_TabBar_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QLabel_IDX],
                           &SbkPyFalkonTypeStructs[SBK_ClickableLabel_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QMessageBox_IDX],
                           &SbkPyFalkonTypeStructs[SBK_CheckBoxDialog_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QMainWindow_IDX],
                           &SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QAbstractItemModel_IDX],
                           &SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX],
                           &SbkPyFalkonTypeStructs[SBK_BookmarksFoldersMenu_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QPushButton_IDX],
                           &SbkPyFalkonTypeStructs[SBK_BookmarksFoldersButton_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkPyFalkonTypeStructs[SBK_AutoSaver_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX],
                           &SbkPyFalkonTypeStructs[SBK_Action_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]);
}

static void initConverters_PyFalkon()
{
    // Register primitive types converters.
    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "QRgb");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__blkcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__blkcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__blksize_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "__caddr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__clock_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__clockid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__compar_d_fn_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__compar_fn_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__daddr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__dev_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__fsblkcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__fsblkcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__fsfilcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__fsfilcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__fsword_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__gid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__id_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__ino64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__ino_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<short>(), "__int16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__int32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__int64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), "__int8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<short>(), "__int_least16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__int_least32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__int_least64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), "__int_least8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__intmax_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__intptr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__key_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__loff_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__mode_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__nlink_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__off64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__off_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__pid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__poll_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__quad_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__rlim64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__rlim_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__sig_atomic_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__socklen_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__ssize_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__suseconds64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__suseconds_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__syscall_slong_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__syscall_ulong_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__time_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "__u_char");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__u_int");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__u_long");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__u_quad_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "__u_short");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__uid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "__uint16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__uint32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__uint64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "__uint8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "__uint_least16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__uint_least32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__uint_least64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "__uint_least8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__uintmax_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__useconds_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "blkcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "blkcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "blksize_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "caddr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "comparison_fn_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "daddr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "dev_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "fsblkcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "fsblkcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "fsfilcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "fsfilcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "gid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "id_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "ino64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "ino_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "int_fast16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "int_fast32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "int_fast64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), "int_fast8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "intmax_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "key_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "loff_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "mode_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "nlink_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "off64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "off_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "pid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "qInternalCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "quad_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "register_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "ssize_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "suseconds_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "u_char");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "u_int");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "u_int16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "u_int32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "u_int64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "u_int8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "u_long");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "u_quad_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "u_short");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "uid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "uint_fast16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "uint_fast32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "uint_fast64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "uint_fast8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "uintmax_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "useconds_t");

}

static void initContainerConverters_PyFalkon()
{
    // Register converter for type 'QList<int>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_int_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_int__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_int_IDX], "QList<int>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_int_IDX],
        PySequence_PythonToCpp__QList_int_,
        is_PySequence_PythonToCpp__QList_int__Convertible);
    Shiboken::Conversions::setPythonToCppPointerFunctions(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_int_IDX],
        PythonToCppQIntList,
        isQIntListPythonToCppConvertible);

    // Register converter for type 'QList<WebTab*>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_WebTabPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_WebTabPTR__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_WebTabPTR_IDX], "QList<WebTab*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_WebTabPTR_IDX],
        PySequence_PythonToCpp__QList_WebTabPTR_,
        is_PySequence_PythonToCpp__QList_WebTabPTR__Convertible);

    // Register converter for type 'QHash<QString,QVariant>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QHash_QString_QVariant_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QHash_QString_QVariant__CppToPython_PyDict);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QHash_QString_QVariant_IDX], "QHash<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QHash_QString_QVariant_IDX],
        PyDict_PythonToCpp__QHash_QString_QVariant_,
        is_PyDict_PythonToCpp__QHash_QString_QVariant__Convertible);
    // Register converters for type aliases of QHash<QString,QVariant>'.
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QHash_QString_QVariant_IDX], "QVariantHash");

    // Register converter for type 'std::pair<bool,QString>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_std_pair_bool_QString_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, std_pair_bool_QString__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_std_pair_bool_QString_IDX], "std::pair<bool,QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_std_pair_bool_QString_IDX],
        PySequence_PythonToCpp_std_pair_bool_QString_,
        is_PySequence_PythonToCpp_std_pair_bool_QString__Convertible);

    // Register converter for type 'QMap<QString,QVariant>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QMap_QString_QVariant_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_QString_QVariant__CppToPython_PyDict);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QMap_QString_QVariant_IDX], "QMap<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QMap_QString_QVariant_IDX],
        PyDict_PythonToCpp__QMap_QString_QVariant_,
        is_PyDict_PythonToCpp__QMap_QString_QVariant__Convertible);
    // Register converters for type aliases of QMap<QString,QVariant>'.
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QMap_QString_QVariant_IDX], "QVariantMap");

    // Register converter for type 'QMap<int,QVariant>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QMap_int_QVariant_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_int_QVariant__CppToPython_PyDict);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QMap_int_QVariant_IDX], "QMap<int,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QMap_int_QVariant_IDX],
        PyDict_PythonToCpp__QMap_int_QVariant_,
        is_PyDict_PythonToCpp__QMap_int_QVariant__Convertible);

    // Register converter for type 'QList<QModelIndex>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QModelIndex_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QModelIndex__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QModelIndex_IDX], "QList<QModelIndex>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QModelIndex_IDX],
        PySequence_PythonToCpp__QList_QModelIndex_,
        is_PySequence_PythonToCpp__QList_QModelIndex__Convertible);
    // Register converters for type aliases of QList<QModelIndex>'.
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QModelIndex_IDX], "QModelIndexList");

    // Register converter for type 'QHash<int,QByteArray>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QHash_int_QByteArray_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QHash_int_QByteArray__CppToPython_PyDict);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QHash_int_QByteArray_IDX], "QHash<int,QByteArray>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QHash_int_QByteArray_IDX],
        PyDict_PythonToCpp__QHash_int_QByteArray_,
        is_PyDict_PythonToCpp__QHash_int_QByteArray__Convertible);

    // Register converter for type 'QList<QSqlRecord>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QSqlRecord_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QSqlRecord__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QSqlRecord_IDX], "QList<QSqlRecord>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QSqlRecord_IDX],
        PySequence_PythonToCpp__QList_QSqlRecord_,
        is_PySequence_PythonToCpp__QList_QSqlRecord__Convertible);

    // Register converter for type 'QMap<QString,SiteSettingsManager::Permission>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QMap_QString_SiteSettingsManager_Permission_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_QString_SiteSettingsManager_Permission__CppToPython_PyDict);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QMap_QString_SiteSettingsManager_Permission_IDX], "QMap<QString,SiteSettingsManager::Permission>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QMap_QString_SiteSettingsManager_Permission_IDX],
        PyDict_PythonToCpp__QMap_QString_SiteSettingsManager_Permission_,
        is_PyDict_PythonToCpp__QMap_QString_SiteSettingsManager_Permission__Convertible);

    // Register converter for type 'QList<QWebEngineSettings::WebAttribute>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QWebEngineSettings_WebAttribute_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QWebEngineSettings_WebAttribute__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QWebEngineSettings_WebAttribute_IDX], "QList<QWebEngineSettings::WebAttribute>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QWebEngineSettings_WebAttribute_IDX],
        PySequence_PythonToCpp__QList_QWebEngineSettings_WebAttribute_,
        is_PySequence_PythonToCpp__QList_QWebEngineSettings_WebAttribute__Convertible);

    // Register converter for type 'QList<QWebEnginePage::Feature>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QWebEnginePage_Feature_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QWebEnginePage_Feature__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QWebEnginePage_Feature_IDX], "QList<QWebEnginePage::Feature>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QWebEnginePage_Feature_IDX],
        PySequence_PythonToCpp__QList_QWebEnginePage_Feature_,
        is_PySequence_PythonToCpp__QList_QWebEnginePage_Feature__Convertible);

    // Register converter for type 'QHash<QWebEngineSettings::WebAttribute,bool>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QHash_QWebEngineSettings_WebAttribute_bool_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QHash_QWebEngineSettings_WebAttribute_bool__CppToPython_PyDict);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QHash_QWebEngineSettings_WebAttribute_bool_IDX], "QHash<QWebEngineSettings::WebAttribute,bool>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QHash_QWebEngineSettings_WebAttribute_bool_IDX],
        PyDict_PythonToCpp__QHash_QWebEngineSettings_WebAttribute_bool_,
        is_PyDict_PythonToCpp__QHash_QWebEngineSettings_WebAttribute_bool__Convertible);

    // Register converter for type 'QMap<QWebEngineSettings::WebAttribute,SiteSettingsManager::Permission>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QMap_QWebEngineSettings_WebAttribute_SiteSettingsManager_Permission_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_QWebEngineSettings_WebAttribute_SiteSettingsManager_Permission__CppToPython_PyDict);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QMap_QWebEngineSettings_WebAttribute_SiteSettingsManager_Permission_IDX], "QMap<QWebEngineSettings::WebAttribute,SiteSettingsManager::Permission>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QMap_QWebEngineSettings_WebAttribute_SiteSettingsManager_Permission_IDX],
        PyDict_PythonToCpp__QMap_QWebEngineSettings_WebAttribute_SiteSettingsManager_Permission_,
        is_PyDict_PythonToCpp__QMap_QWebEngineSettings_WebAttribute_SiteSettingsManager_Permission__Convertible);

    // Register converter for type 'QMap<QWebEnginePage::Feature,SiteSettingsManager::Permission>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QMap_QWebEnginePage_Feature_SiteSettingsManager_Permission_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_QWebEnginePage_Feature_SiteSettingsManager_Permission__CppToPython_PyDict);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QMap_QWebEnginePage_Feature_SiteSettingsManager_Permission_IDX], "QMap<QWebEnginePage::Feature,SiteSettingsManager::Permission>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QMap_QWebEnginePage_Feature_SiteSettingsManager_Permission_IDX],
        PyDict_PythonToCpp__QMap_QWebEnginePage_Feature_SiteSettingsManager_Permission_,
        is_PyDict_PythonToCpp__QMap_QWebEnginePage_Feature_SiteSettingsManager_Permission__Convertible);

    // Register converter for type 'QList<SearchEnginesManager::Engine>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_SearchEnginesManager_Engine_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_SearchEnginesManager_Engine__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_SearchEnginesManager_Engine_IDX], "QList<SearchEnginesManager::Engine>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_SearchEnginesManager_Engine_IDX],
        PySequence_PythonToCpp__QList_SearchEnginesManager_Engine_,
        is_PySequence_PythonToCpp__QList_SearchEnginesManager_Engine__Convertible);

    // Register converter for type 'QList<Plugins::Plugin>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_Plugins_Plugin_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_Plugins_Plugin__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_Plugins_Plugin_IDX], "QList<Plugins::Plugin>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_Plugins_Plugin_IDX],
        PySequence_PythonToCpp__QList_Plugins_Plugin_,
        is_PySequence_PythonToCpp__QList_Plugins_Plugin__Convertible);

    // Register converter for type 'QList<PluginInterface*>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_PluginInterfacePTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_PluginInterfacePTR__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_PluginInterfacePTR_IDX], "QList<PluginInterface*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_PluginInterfacePTR_IDX],
        PySequence_PythonToCpp__QList_PluginInterfacePTR_,
        is_PySequence_PythonToCpp__QList_PluginInterfacePTR__Convertible);

    // Register converter for type 'QHash<QString,PasswordBackend*>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QHash_QString_PasswordBackendPTR_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QHash_QString_PasswordBackendPTR__CppToPython_PyDict);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QHash_QString_PasswordBackendPTR_IDX], "QHash<QString,PasswordBackend*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QHash_QString_PasswordBackendPTR_IDX],
        PyDict_PythonToCpp__QHash_QString_PasswordBackendPTR_,
        is_PyDict_PythonToCpp__QHash_QString_PasswordBackendPTR__Convertible);

    // Register converter for type 'QList<PasswordEntry>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_PasswordEntry_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_PasswordEntry__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_PasswordEntry_IDX], "QList<PasswordEntry>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_PasswordEntry_IDX],
        PySequence_PythonToCpp__QList_PasswordEntry_,
        is_PySequence_PythonToCpp__QList_PasswordEntry__Convertible);

    // Register converter for type 'QHash<QString,QWebEngineCertificateError::Type>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QHash_QString_QWebEngineCertificateError_Type_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QHash_QString_QWebEngineCertificateError_Type__CppToPython_PyDict);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QHash_QString_QWebEngineCertificateError_Type_IDX], "QHash<QString,QWebEngineCertificateError::Type>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QHash_QString_QWebEngineCertificateError_Type_IDX],
        PyDict_PythonToCpp__QHash_QString_QWebEngineCertificateError_Type_,
        is_PyDict_PythonToCpp__QHash_QString_QWebEngineCertificateError_Type__Convertible);

    // Register converter for type 'QList<QUrl>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QUrl_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QUrl__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QUrl_IDX], "QList<QUrl>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QUrl_IDX],
        PySequence_PythonToCpp__QList_QUrl_,
        is_PySequence_PythonToCpp__QList_QUrl__Convertible);

    // Register converter for type 'QList<BrowserWindow*>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_BrowserWindowPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_BrowserWindowPTR__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_BrowserWindowPTR_IDX], "QList<BrowserWindow*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_BrowserWindowPTR_IDX],
        PySequence_PythonToCpp__QList_BrowserWindowPTR_,
        is_PySequence_PythonToCpp__QList_BrowserWindowPTR__Convertible);

    // Register converter for type 'QList<QTextLayout::FormatRange>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QTextLayout_FormatRange_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QTextLayout_FormatRange__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QTextLayout_FormatRange_IDX], "QList<QTextLayout::FormatRange>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QTextLayout_FormatRange_IDX],
        PySequence_PythonToCpp__QList_QTextLayout_FormatRange_,
        is_PySequence_PythonToCpp__QList_QTextLayout_FormatRange__Convertible);
    // Register converters for type aliases of QList<QTextLayout::FormatRange>'.
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QTextLayout_FormatRange_IDX], "LineEdit::TextFormat");

    // Register converter for type 'QList<QPersistentModelIndex>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QPersistentModelIndex_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QPersistentModelIndex__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QPersistentModelIndex_IDX], "QList<QPersistentModelIndex>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QPersistentModelIndex_IDX],
        PySequence_PythonToCpp__QList_QPersistentModelIndex_,
        is_PySequence_PythonToCpp__QList_QPersistentModelIndex__Convertible);

    // Register converter for type 'QList<History::HistoryEntry>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_History_HistoryEntry_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_History_HistoryEntry__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_History_HistoryEntry_IDX], "QList<History::HistoryEntry>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_History_HistoryEntry_IDX],
        PySequence_PythonToCpp__QList_History_HistoryEntry_,
        is_PySequence_PythonToCpp__QList_History_HistoryEntry__Convertible);

    // Register converter for type 'QList<QNetworkCookie>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QNetworkCookie_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QNetworkCookie__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QNetworkCookie_IDX], "QList<QNetworkCookie>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QNetworkCookie_IDX],
        PySequence_PythonToCpp__QList_QNetworkCookie_,
        is_PySequence_PythonToCpp__QList_QNetworkCookie__Convertible);

    // Register converter for type 'QList<QAction*>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QActionPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QActionPTR__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QActionPTR_IDX], "QList<QAction*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QActionPTR_IDX],
        PySequence_PythonToCpp__QList_QActionPTR_,
        is_PySequence_PythonToCpp__QList_QActionPTR__Convertible);

    // Register converter for type 'QList<QVariant>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QVariant_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QVariant__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QVariant_IDX], "QList<QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QVariant_IDX],
        PySequence_PythonToCpp__QList_QVariant_,
        is_PySequence_PythonToCpp__QList_QVariant__Convertible);
    // Register converters for type aliases of QList<QVariant>'.
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QVariant_IDX], "QVariantList");

    // Register converter for type 'QList<BookmarkItem*>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_BookmarkItemPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_BookmarkItemPTR__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_BookmarkItemPTR_IDX], "QList<BookmarkItem*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_BookmarkItemPTR_IDX],
        PySequence_PythonToCpp__QList_BookmarkItemPTR_,
        is_PySequence_PythonToCpp__QList_BookmarkItemPTR__Convertible);

    // Register converter for type 'QList<QString>'.
    SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QString_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QString__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QString_IDX], "QList<QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QString_IDX],
        PySequence_PythonToCpp__QList_QString_,
        is_PySequence_PythonToCpp__QList_QString__Convertible);
    // Register converters for type aliases of QList<QString>'.

}

static void registerOpaqueContainers_PyFalkon(PyObject *module)
{
    PyTypeObject *pyType{};
    auto *qVariantConverter = Shiboken::Conversions::getConverter("QVariant");
    Q_ASSERT(qVariantConverter != nullptr);
    pyType = QIntList_TypeF();
    Py_XINCREF(reinterpret_cast<PyObject *>(pyType));
    PepModule_AddType(module, pyType);
    if constexpr (QMetaTypeId2<int>::Defined) {
        Shiboken::Conversions::prependPythonToCppValueConversion(qVariantConverter,
            PythonToQVariantQIntList, isQIntListPythonToQVariantConvertible);
    }
}

extern "C" {
static int exec_PyFalkon(PyObject *module)
{
    Shiboken::Module::exec(module);

    // Initialize classes in the type system
    Shiboken::Module::AddTypeCreationFunction(module, "WheelHelper", init_WheelHelper);
    Shiboken::Module::AddTypeCreationFunction(module, "WebView", init_WebView);
    Shiboken::Module::AddTypeCreationFunction(module, "WebTab", init_WebTab);
    Shiboken::Module::AddTypeCreationFunction(module, "WebPage", init_WebPage);
    Shiboken::Module::AddTypeCreationFunction(module, "WebInspector", init_WebInspector);
    Shiboken::Module::AddTypeCreationFunction(module, "WebHitTestResult", init_WebHitTestResult);
    Shiboken::Module::AddTypeCreationFunction(module, "UrlInterceptor", init_UrlInterceptor);
    Shiboken::Module::AddTypeCreationFunction(module, "ToolButton", init_ToolButton);
    Shiboken::Module::AddTypeCreationFunction(module, "TabbedWebView", init_TabbedWebView);
    Shiboken::Module::AddTypeCreationFunction(module, "TabTreeModel", init_TabTreeModel);
    Shiboken::Module::AddTypeCreationFunction(module, "TabStackedWidget", init_TabStackedWidget);
    Shiboken::Module::AddTypeCreationFunction(module, "TabWidget", init_TabWidget);
    Shiboken::Module::AddTypeCreationFunction(module, "TabMruModel", init_TabMruModel);
    Shiboken::Module::AddTypeCreationFunction(module, "TabModel", init_TabModel);
    Shiboken::Module::AddTypeCreationFunction(module, "TabIcon", init_TabIcon);
    Shiboken::Module::AddTypeCreationFunction(module, "TabIcon", init_TabIcon_Data, "TabIcon.Data");
    Shiboken::Module::AddTypeCreationFunction(module, "TabContextMenu", init_TabContextMenu);
    Shiboken::Module::AddTypeCreationFunction(module, "StatusBar", init_StatusBar);
    Shiboken::Module::AddTypeCreationFunction(module, "SqueezeLabelV2", init_SqueezeLabelV2);
    Shiboken::Module::AddTypeCreationFunction(module, "SqueezeLabelV1", init_SqueezeLabelV1);
    Shiboken::Module::AddTypeCreationFunction(module, "SqlQueryJob", init_SqlQueryJob);
    Shiboken::Module::AddTypeCreationFunction(module, "SqlDatabase", init_SqlDatabase);
    Shiboken::Module::AddTypeCreationFunction(module, "SiteSettingsManager", init_SiteSettingsManager);
    Shiboken::Module::AddTypeCreationFunction(module, "SiteSettingsManager", init_SiteSettingsManager_SiteSettings, "SiteSettingsManager.SiteSettings");
    Shiboken::Module::AddTypeCreationFunction(module, "SideWidget", init_SideWidget);
    Shiboken::Module::AddTypeCreationFunction(module, "SideBarManager", init_SideBarManager);
    Shiboken::Module::AddTypeCreationFunction(module, "SideBarInterface", init_SideBarInterface);
    Shiboken::Module::AddTypeCreationFunction(module, "Settings", init_Settings);
    Shiboken::Module::AddTypeCreationFunction(module, "SearchToolBar", init_SearchToolBar);
    Shiboken::Module::AddTypeCreationFunction(module, "SearchEnginesManager", init_SearchEnginesManager);
    Shiboken::Module::AddTypeCreationFunction(module, "SearchEnginesManager", init_SearchEnginesManager_Engine, "SearchEnginesManager.Engine");
    Shiboken::Module::AddTypeCreationFunction(module, "SearchEnginesDialog", init_SearchEnginesDialog);
    Shiboken::Module::AddTypeCreationFunction(module, "QzTools", init_QzTools);
    Shiboken::Module::AddTypeCreationFunction(module, "QzSettings", init_QzSettings);
    Shiboken::Module::AddTypeCreationFunction(module, "Qz", init_PyFalkonQz);
    Shiboken::Module::AddTypeCreationFunction(module, "QtSingleApplication", init_QtSingleApplication);
    Shiboken::Module::AddTypeCreationFunction(module, "Plugins", init_Plugins);
    Shiboken::Module::AddTypeCreationFunction(module, "PluginSpec", init_PluginSpec);
    Shiboken::Module::AddTypeCreationFunction(module, "PluginProxy", init_PluginProxy);
    Shiboken::Module::AddTypeCreationFunction(module, "PluginInterface", init_PluginInterface);
    Shiboken::Module::AddTypeCreationFunction(module, "Plugins", init_Plugins_Plugin, "Plugins.Plugin");
    Shiboken::Module::AddTypeCreationFunction(module, "PasswordManager", init_PasswordManager);
    Shiboken::Module::AddTypeCreationFunction(module, "PasswordEntry", init_PasswordEntry);
    Shiboken::Module::AddTypeCreationFunction(module, "PasswordBackend", init_PasswordBackend);
    Shiboken::Module::AddTypeCreationFunction(module, "PageFormData", init_PageFormData);
    Shiboken::Module::AddTypeCreationFunction(module, "NetworkManager", init_NetworkManager);
    Shiboken::Module::AddTypeCreationFunction(module, "NavigationBar", init_NavigationBar);
    Shiboken::Module::AddTypeCreationFunction(module, "Menu", init_Menu);
    Shiboken::Module::AddTypeCreationFunction(module, "MainApplication", init_MainApplication);
    Shiboken::Module::AddTypeCreationFunction(module, "LoadRequest", init_LoadRequest);
    Shiboken::Module::AddTypeCreationFunction(module, "LineEdit", init_LineEdit);
    Shiboken::Module::AddTypeCreationFunction(module, "LocationBar", init_LocationBar);
    Shiboken::Module::AddTypeCreationFunction(module, "IconProvider", init_IconProvider);
    Shiboken::Module::AddTypeCreationFunction(module, "HistoryModel", init_HistoryModel);
    Shiboken::Module::AddTypeCreationFunction(module, "History", init_History);
    Shiboken::Module::AddTypeCreationFunction(module, "History", init_History_HistoryEntry, "History.HistoryEntry");
    Shiboken::Module::AddTypeCreationFunction(module, "HistoryItem", init_HistoryItem);
    Shiboken::Module::AddTypeCreationFunction(module, "ExternalJsObject", init_ExternalJsObject);
    Shiboken::Module::AddTypeCreationFunction(module, "ExtensionSchemeHandler", init_ExtensionSchemeHandler);
    Shiboken::Module::AddTypeCreationFunction(module, "DownloadManager", init_DownloadManager);
    Shiboken::Module::AddTypeCreationFunction(module, "DownloadManager", init_DownloadManager_DownloadInfo, "DownloadManager.DownloadInfo");
    Shiboken::Module::AddTypeCreationFunction(module, "DownloadItem", init_DownloadItem);
    Shiboken::Module::AddTypeCreationFunction(module, "DesktopNotificationsFactory", init_DesktopNotificationsFactory);
    Shiboken::Module::AddTypeCreationFunction(module, "DesktopFile", init_DesktopFile);
    Shiboken::Module::AddTypeCreationFunction(module, "DelayedFileWatcher", init_DelayedFileWatcher);
    Shiboken::Module::AddTypeCreationFunction(module, "DataPaths", init_DataPaths);
    Shiboken::Module::AddTypeCreationFunction(module, "CookieManager", init_CookieManager);
    Shiboken::Module::AddTypeCreationFunction(module, "CookieJar", init_CookieJar);
    Shiboken::Module::AddTypeCreationFunction(module, "ComboTabBar", init_ComboTabBar);
    Shiboken::Module::AddTypeCreationFunction(module, "TabBar", init_TabBar);
    Shiboken::Module::AddTypeCreationFunction(module, "ClickableLabel", init_ClickableLabel);
    Shiboken::Module::AddTypeCreationFunction(module, "CheckBoxDialog", init_CheckBoxDialog);
    Shiboken::Module::AddTypeCreationFunction(module, "BrowserWindow", init_BrowserWindow);
    Shiboken::Module::AddTypeCreationFunction(module, "BookmarksTools", init_BookmarksTools);
    Shiboken::Module::AddTypeCreationFunction(module, "BookmarksModel", init_BookmarksModel);
    Shiboken::Module::AddTypeCreationFunction(module, "BookmarksFoldersMenu", init_BookmarksFoldersMenu);
    Shiboken::Module::AddTypeCreationFunction(module, "BookmarksFoldersButton", init_BookmarksFoldersButton);
    Shiboken::Module::AddTypeCreationFunction(module, "Bookmarks", init_Bookmarks);
    Shiboken::Module::AddTypeCreationFunction(module, "BookmarkItem", init_BookmarkItem);
    Shiboken::Module::AddTypeCreationFunction(module, "LocationBar", init_LocationBar_LoadAction, "LocationBar.LoadAction");
    Shiboken::Module::AddTypeCreationFunction(module, "AutoSaver", init_AutoSaver);
    Shiboken::Module::AddTypeCreationFunction(module, "AutoFill", init_AutoFill);
    Shiboken::Module::AddTypeCreationFunction(module, "Action", init_Action);
    Shiboken::Module::AddTypeCreationFunction(module, "AbstractButtonInterface", init_AbstractButtonInterface);
    Shiboken::Module::AddTypeCreationFunction(module, "AbstractButtonInterface", init_AbstractButtonInterface_ClickController, "AbstractButtonInterface.ClickController");

    registerOpaqueContainers_PyFalkon(module);

    Shiboken::Module::registerTypes(module, SbkPyFalkonTypeStructs);
    Shiboken::Module::registerTypeConverters(module, SbkPyFalkonTypeConverters);

    // Static field initialization
    init_PyFalkonQzStaticFields(module);

    initInheritance();

    if (Shiboken::Errors::occurred() != nullptr) {
        PyErr_Print();
        Py_FatalError("shiboken: can't initialize module PyFalkon");
    }
    // Begin code injection
    QList<QByteArray> version = QByteArray(Qz::VERSION).split('.');
    PyObject *pyFalkonVersion = PyTuple_New(3);
    for (int i = 0; i < 3; ++i)
        PyTuple_SetItem(pyFalkonVersion, i, PyLong_FromLong(version[i].toInt()));
    PyModule_AddObject(module, "__version_info__", pyFalkonVersion);
    PyModule_AddStringConstant(module, "__version__", Qz::VERSION);
    // End of code injection

    PySide::registerCleanupFunction(cleanTypesAttributes);

#if PYSIDE6_COMOPT_COMPRESS == 0
    FinishSignatureInitialization(module, PyFalkon_SignatureStrings);
#else
    if (FinishSignatureInitBytes(module, PyFalkon_SignatureBytes, PyFalkon_SignatureByteSize) < 0)
        return -1;
#endif

    return 0;
}
} // extern "C"

static PyModuleDef_Slot PyFalkonModuleSlots[] = {
    {Py_mod_exec, reinterpret_cast<void *>(exec_PyFalkon)},
#if !defined(PYPY_VERSION) && ((!defined(Py_LIMITED_API) && PY_VERSION_HEX >= 0x030C0000) || (defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030C0000))
    {Py_mod_multiple_interpreters, Py_MOD_MULTIPLE_INTERPRETERS_NOT_SUPPORTED},
#endif
#ifdef Py_GIL_DISABLED
    {Py_mod_gil, Py_MOD_GIL_USED},
#endif
    {0, nullptr}
};

static struct PyModuleDef PyFalkonModuleDef = {
    /* m_base     */ PyModuleDef_HEAD_INIT,
    /* m_name     */ "PyFalkon",
    /* m_doc      */ nullptr,
    /* m_size     */ 0,
    /* m_methods  */ PyFalkonMethods,
    /* m_slots    */ PyFalkonModuleSlots,
    /* m_traverse */ nullptr,
    /* m_clear    */ nullptr,
    /* m_free     */ nullptr
};

extern "C" LIBSHIBOKEN_EXPORT PyObject *PyInit_PyFalkon()
{
    Shiboken::init();

    // Create an array of wrapper types/names for the current module.
    static Shiboken::Module::TypeInitStruct cppApi[] = {
        {nullptr, "PyFalkon.AbstractButtonInterface"},
        {nullptr, "PyFalkon.AbstractButtonInterface.ClickController"},
        {nullptr, "PyFalkon.Action"},
        {nullptr, "PyFalkon.AutoFill"},
        {nullptr, "PyFalkon.AutoSaver"},
        {nullptr, "PyFalkon.BookmarkItem"},
        {nullptr, "PyFalkon.BookmarkItem.Type"},
        {nullptr, "PyFalkon.Bookmarks"},
        {nullptr, "PyFalkon.BookmarksFoldersButton"},
        {nullptr, "PyFalkon.BookmarksFoldersMenu"},
        {nullptr, "PyFalkon.BookmarksModel"},
        {nullptr, "PyFalkon.BookmarksModel.Roles"},
        {nullptr, "PyFalkon.BookmarksTools"},
        {nullptr, "PyFalkon.BrowserWindow"},
        {nullptr, "PyFalkon.CheckBoxDialog"},
        {nullptr, "PyFalkon.ClickableLabel"},
        {nullptr, "PyFalkon.ComboTabBar"},
        {nullptr, "PyFalkon.ComboTabBar.DropIndicatorPosition"},
        {nullptr, "PyFalkon.ComboTabBar.SizeType"},
        {nullptr, "PyFalkon.CookieJar"},
        {nullptr, "PyFalkon.CookieManager"},
        {nullptr, "PyFalkon.DataPaths"},
        {nullptr, "PyFalkon.DataPaths.Path"},
        {nullptr, "PyFalkon.DelayedFileWatcher"},
        {nullptr, "PyFalkon.DesktopFile"},
        {nullptr, "PyFalkon.DesktopNotificationsFactory"},
        {nullptr, "PyFalkon.DesktopNotificationsFactory.Type"},
        {nullptr, "PyFalkon.DownloadItem"},
        {nullptr, "PyFalkon.DownloadManager"},
        {nullptr, "PyFalkon.DownloadManager.DownloadInfo"},
        {nullptr, "PyFalkon.DownloadManager.DownloadOption"},
        {nullptr, "PyFalkon.ExtensionSchemeHandler"},
        {nullptr, "PyFalkon.ExternalJsObject"},
        {nullptr, "PyFalkon.History"},
        {nullptr, "PyFalkon.History.HistoryEntry"},
        {nullptr, "PyFalkon.HistoryItem"},
        {nullptr, "PyFalkon.HistoryModel"},
        {nullptr, "PyFalkon.HistoryModel.Roles"},
        {nullptr, "PyFalkon.IconProvider"},
        {nullptr, "PyFalkon.LineEdit"},
        {nullptr, "PyFalkon.LineEdit.EditAction"},
        {nullptr, "PyFalkon.LineEdit.WidgetPosition"},
        {nullptr, "PyFalkon.LoadRequest"},
        {nullptr, "PyFalkon.LoadRequest.Operation"},
        {nullptr, "PyFalkon.LocationBar"},
        {nullptr, "PyFalkon.LocationBar.LoadAction"},
        {nullptr, "PyFalkon.LocationBar.LoadAction.Type"},
        {nullptr, "PyFalkon.MainApplication"},
        {nullptr, "PyFalkon.MainApplication.AfterLaunch"},
        {nullptr, "PyFalkon.Menu"},
        {nullptr, "PyFalkon.NavigationBar"},
        {nullptr, "PyFalkon.NetworkManager"},
        {nullptr, "PyFalkon.PageFormData"},
        {nullptr, "PyFalkon.PasswordBackend"},
        {nullptr, "PyFalkon.PasswordEntry"},
        {nullptr, "PyFalkon.PasswordManager"},
        {nullptr, "PyFalkon.PluginInterface"},
        {nullptr, "PyFalkon.PluginInterface.InitState"},
        {nullptr, "PyFalkon.PluginProxy"},
        {nullptr, "PyFalkon.PluginProxy.EventHandlerType"},
        {nullptr, "PyFalkon.PluginSpec"},
        {nullptr, "PyFalkon.Plugins"},
        {nullptr, "PyFalkon.Plugins.Plugin"},
        {nullptr, "PyFalkon.Plugins.Plugin.Type"},
        {nullptr, "PyFalkon.Qz.NewTabPositionFlags"},
        {nullptr, "PyFalkon.TabContextMenu.Options"},
        {nullptr, "PyFalkon.QtSingleApplication"},
        {nullptr, "PyFalkon.Qz"},
        {nullptr, "PyFalkon.Qz.BrowserWindowType"},
        {nullptr, "PyFalkon.Qz.ColorScheme"},
        {nullptr, "PyFalkon.Qz.CommandLineAction"},
        {nullptr, "PyFalkon.Qz.NewTabPositionFlag"},
        {nullptr, "PyFalkon.Qz.ObjectName"},
        {nullptr, "PyFalkon.QzSettings"},
        {nullptr, "PyFalkon.QzTools"},
        {nullptr, "PyFalkon.SearchEnginesDialog"},
        {nullptr, "PyFalkon.SearchEnginesManager"},
        {nullptr, "PyFalkon.SearchEnginesManager.Engine"},
        {nullptr, "PyFalkon.SearchToolBar"},
        {nullptr, "PyFalkon.Settings"},
        {nullptr, "PyFalkon.SideBarInterface"},
        {nullptr, "PyFalkon.SideBarManager"},
        {nullptr, "PyFalkon.SideWidget"},
        {nullptr, "PyFalkon.SiteSettingsManager"},
        {nullptr, "PyFalkon.SiteSettingsManager.PageOptions"},
        {nullptr, "PyFalkon.SiteSettingsManager.Permission"},
        {nullptr, "PyFalkon.SiteSettingsManager.SiteSettings"},
        {nullptr, "PyFalkon.SqlDatabase"},
        {nullptr, "PyFalkon.SqlQueryJob"},
        {nullptr, "PyFalkon.SqueezeLabelV1"},
        {nullptr, "PyFalkon.SqueezeLabelV2"},
        {nullptr, "PyFalkon.StatusBar"},
        {nullptr, "PyFalkon.TabBar"},
        {nullptr, "PyFalkon.TabContextMenu"},
        {nullptr, "PyFalkon.TabContextMenu.Option"},
        {nullptr, "PyFalkon.TabIcon"},
        {nullptr, "PyFalkon.TabIcon.Data"},
        {nullptr, "PyFalkon.TabModel"},
        {nullptr, "PyFalkon.TabModel.Roles"},
        {nullptr, "PyFalkon.TabMruModel"},
        {nullptr, "PyFalkon.TabStackedWidget"},
        {nullptr, "PyFalkon.TabTreeModel"},
        {nullptr, "PyFalkon.TabWidget"},
        {nullptr, "PyFalkon.TabbedWebView"},
        {nullptr, "PyFalkon.ToolButton"},
        {nullptr, "PyFalkon.UrlInterceptor"},
        {nullptr, "PyFalkon.WebHitTestResult"},
        {nullptr, "PyFalkon.WebInspector"},
        {nullptr, "PyFalkon.WebPage"},
        {nullptr, "PyFalkon.WebPage.JsWorld"},
        {nullptr, "PyFalkon.WebTab"},
        {nullptr, "PyFalkon.WebTab.AddChildBehavior"},
        {nullptr, "PyFalkon.WebView"},
        {nullptr, "PyFalkon.WheelHelper"},
        {nullptr, "PyFalkon.WheelHelper.Direction"},
        {nullptr, nullptr}
    };
    // The new global structure consisting of (type, name) pairs.
    SbkPyFalkonTypeStructs = cppApi;
    QT_WARNING_PUSH
    QT_WARNING_DISABLE_DEPRECATED
    // The backward compatible alias with upper case indexes.
    SbkPyFalkonTypes = reinterpret_cast<PyTypeObject **>(cppApi);
    QT_WARNING_POP

    // Create an array of primitive type converters for the current module.
    static SbkConverter *sbkConverters[SBK_PyFalkon_CONVERTERS_IDX_COUNT];
    SbkPyFalkonTypeConverters = sbkConverters;

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide6.QtWebEngineCore"));
        if (requiredModule.isNull())
            return nullptr;
        SbkPySide6_QtWebEngineCoreTypeStructs = Shiboken::Module::getTypes(requiredModule);
        SbkPySide6_QtWebEngineCoreTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide6.QtCore"));
        if (requiredModule.isNull())
            return nullptr;
        SbkPySide6_QtCoreTypeStructs = Shiboken::Module::getTypes(requiredModule);
        SbkPySide6_QtCoreTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide6.QtGui"));
        if (requiredModule.isNull())
            return nullptr;
        SbkPySide6_QtGuiTypeStructs = Shiboken::Module::getTypes(requiredModule);
        SbkPySide6_QtGuiTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide6.QtNetwork"));
        if (requiredModule.isNull())
            return nullptr;
        SbkPySide6_QtNetworkTypeStructs = Shiboken::Module::getTypes(requiredModule);
        SbkPySide6_QtNetworkTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide6.QtPrintSupport"));
        if (requiredModule.isNull())
            return nullptr;
        SbkPySide6_QtPrintSupportTypeStructs = Shiboken::Module::getTypes(requiredModule);
        SbkPySide6_QtPrintSupportTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide6.QtWidgets"));
        if (requiredModule.isNull())
            return nullptr;
        SbkPySide6_QtWidgetsTypeStructs = Shiboken::Module::getTypes(requiredModule);
        SbkPySide6_QtWidgetsTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide6.QtWebChannel"));
        if (requiredModule.isNull())
            return nullptr;
        SbkPySide6_QtWebChannelTypeStructs = Shiboken::Module::getTypes(requiredModule);
        SbkPySide6_QtWebChannelTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide6.QtWebEngineWidgets"));
        if (requiredModule.isNull())
            return nullptr;
        SbkPySide6_QtWebEngineWidgetsTypeStructs = Shiboken::Module::getTypes(requiredModule);
        SbkPySide6_QtWebEngineWidgetsTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide6.QtSql"));
        if (requiredModule.isNull())
            return nullptr;
        SbkPySide6_QtSqlTypeStructs = Shiboken::Module::getTypes(requiredModule);
        SbkPySide6_QtSqlTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    initConverters_PyFalkon();
    initContainerConverters_PyFalkon();

    PyObject *module = nullptr;
    if (Shiboken::isCompiled()) {
        PyFalkonModuleDef.m_size = -1;
        PyFalkonModuleDef.m_slots = nullptr;
        module = Shiboken::Module::createOnly("PyFalkon", &PyFalkonModuleDef);
        if (module == nullptr)
            return nullptr;
#ifdef Py_GIL_DISABLED
        PyUnstable_Module_SetGIL(module, Py_MOD_GIL_NOT_USED);
#endif
        if (exec_PyFalkon(module) != 0)
            return nullptr;
    } else {
        module = PyModuleDef_Init(&PyFalkonModuleDef);
    }
    return module;
}

