/* Copyright 2024 Maxim Iorsh <iorsh@users.sourceforge.net>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#pragma once

#include <memory>

#include "i_shaper.hpp"
#include "shaper_shim.hpp"

namespace ff::shapers {

class BuiltInShaper : public IShaper {
 public:
    BuiltInShaper(std::shared_ptr<ShaperContext> context) : context_(context) {}

    const char* name() const override { return "builtin"; }

    ShaperOutput apply_features(SplineChar** glyphs,
                                const std::map<Tag, bool>& feature_map,
                                Tag script, Tag lang, int pixelsize,
                                bool vertical) override;

    void scale_metrics(MetricsView* mv, double iscale, double scale,
                       bool vertical) override;

    std::set<Tag> default_features(Tag script, Tag lang,
                                   bool vertical) const override;

 private:
    std::shared_ptr<ShaperContext> context_;

    // MetricsView::glyphs buffer, kept for convenience
    struct opentype_str* ots_arr_ = NULL;
};

}  // namespace ff::shapers
