/* util-migrate.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from util-migrate.vala, do not modify */

/*
 * Copyright © 2016 Software Freedom Conservancy Inc.
 * Copyright © 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
n */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "geary-client-46.0.h"
#include <gio/gio.h>
#include "geary-engine.h"

#define UTIL_MIGRATE_GROUP "AccountInformation"
#define UTIL_MIGRATE_PRIMARY_EMAIL_KEY "primary_email"
#define UTIL_MIGRATE_SETTINGS_FILENAME ACCOUNTS_MANAGER_SETTINGS_FILENAME
#define UTIL_MIGRATE_MIGRATED_FILENAME ".config_migrated"
#define UTIL_MIGRATE_MIGRATED_CONFIG_KEY "migrated-config"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_settings_schema_source_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_source_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

VALA_EXTERN gboolean util_migrate_is_directory_empty (GFile* dir);
VALA_EXTERN void util_migrate_recursive_copy (GFile* src,
                                  GFile* dest,
                                  GCancellable* cancellable,
                                  GError** error);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

/**
     * Migrates geary.ini to the XDG configuration directory with the account's email address
     *
     * This function iterates through all the account directories in $XDG_DATA_DIR and copies over
     * geary.ini to ~/.config/geary/<account>/geary.ini. Note that it leaves the
     * original file untouched.
     * It also appends a "primary_email" key to the new configuration file to reliaby keep
     * track of the user's email address.
     */
static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

void
util_migrate_xdg_config_dir (GFile* user_config_dir,
                             GFile* user_data_dir,
                             GError** error)
{
	GFile* new_config_dir = NULL;
	GFile* old_data_dir = NULL;
	GFile* new_config_file = NULL;
	GFile* old_config_file = NULL;
	GFileEnumerator* enumerator = NULL;
	GFileEnumerator* _tmp0_ = NULL;
	GFileEnumerator* _tmp1_;
	GFileEnumerator* _tmp2_;
	GFileInfo* info = NULL;
	gchar* email = NULL;
	GFile* is_migrated = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (user_config_dir, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (user_data_dir, g_file_get_type ()));
	if (!g_file_query_exists (user_data_dir, NULL)) {
		_g_object_unref0 (old_config_file);
		_g_object_unref0 (new_config_file);
		_g_object_unref0 (old_data_dir);
		_g_object_unref0 (new_config_dir);
		return;
	}
	_tmp1_ = g_file_enumerate_children (user_data_dir, "standard::*", G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (enumerator);
		_g_object_unref0 (old_config_file);
		_g_object_unref0 (new_config_file);
		_g_object_unref0 (old_data_dir);
		_g_object_unref0 (new_config_dir);
		return;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (enumerator);
	enumerator = _tmp2_;
	while (TRUE) {
		GFileInfo* _tmp3_ = NULL;
		GFileEnumerator* _tmp4_;
		GFileInfo* _tmp5_;
		GFileInfo* _tmp6_;
		GFileInfo* _tmp7_;
		GFileInfo* _tmp8_;
		GFileInfo* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		GFile* _tmp14_;
		const gchar* _tmp15_;
		GFile* _tmp16_;
		GFile* _tmp17_;
		GFile* _tmp18_;
		GFile* _tmp19_;
		GFile* _tmp20_;
		GFile* _tmp21_;
		GFile* _tmp22_;
		GFile* _tmp23_;
		GFile* _tmp27_;
		GFile* _tmp28_;
		GFile* _tmp29_;
		GKeyFile* key_file = NULL;
		GKeyFile* _tmp35_;
		GKeyFile* _tmp43_;
		const gchar* _tmp44_;
		gchar* data = NULL;
		GKeyFile* _tmp45_;
		gchar* _tmp46_;
		GFile* _tmp53_;
		GFileOutputStream* _tmp54_;
		GFileOutputStream* _tmp55_;
		_tmp4_ = enumerator;
		_tmp5_ = g_file_enumerator_next_file (_tmp4_, NULL, &_inner_error0_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (is_migrated);
			_g_free0 (email);
			_g_object_unref0 (info);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (enumerator);
			_g_object_unref0 (old_config_file);
			_g_object_unref0 (new_config_file);
			_g_object_unref0 (old_data_dir);
			_g_object_unref0 (new_config_dir);
			return;
		}
		_tmp6_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (info);
		info = _tmp6_;
		_tmp7_ = info;
		if (!(_tmp7_ != NULL)) {
			_g_object_unref0 (_tmp3_);
			break;
		}
		_tmp8_ = info;
		if (g_file_info_get_file_type (_tmp8_) != G_FILE_TYPE_DIRECTORY) {
			_g_object_unref0 (_tmp3_);
			continue;
		}
		_tmp9_ = info;
		_tmp10_ = g_file_info_get_name (_tmp9_);
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (email);
		email = _tmp11_;
		_tmp12_ = email;
		if (!geary_rf_c822_mailbox_address_is_valid_address (_tmp12_)) {
			_g_object_unref0 (_tmp3_);
			continue;
		}
		_tmp13_ = email;
		_tmp14_ = g_file_get_child (user_data_dir, _tmp13_);
		_g_object_unref0 (old_data_dir);
		old_data_dir = _tmp14_;
		_tmp15_ = email;
		_tmp16_ = g_file_get_child (user_config_dir, _tmp15_);
		_g_object_unref0 (new_config_dir);
		new_config_dir = _tmp16_;
		_tmp17_ = old_data_dir;
		_tmp18_ = g_file_get_child (_tmp17_, UTIL_MIGRATE_SETTINGS_FILENAME);
		_g_object_unref0 (old_config_file);
		old_config_file = _tmp18_;
		_tmp19_ = old_config_file;
		if (!g_file_query_exists (_tmp19_, NULL)) {
			_g_object_unref0 (_tmp3_);
			continue;
		}
		_tmp20_ = old_data_dir;
		_tmp21_ = g_file_get_child (_tmp20_, UTIL_MIGRATE_MIGRATED_FILENAME);
		_g_object_unref0 (is_migrated);
		is_migrated = _tmp21_;
		_tmp22_ = is_migrated;
		if (g_file_query_exists (_tmp22_, NULL)) {
			_g_object_unref0 (_tmp3_);
			continue;
		}
		_tmp23_ = new_config_dir;
		if (!g_file_query_exists (_tmp23_, NULL)) {
			{
				GFile* _tmp24_;
				_tmp24_ = new_config_dir;
				g_file_make_directory_with_parents (_tmp24_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp25_;
				const gchar* _tmp26_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp25_ = e;
				_tmp26_ = _tmp25_->message;
				g_debug ("util-migrate.vala:70: Cannot make directory, %s", _tmp26_);
				_g_error_free0 (e);
				_g_object_unref0 (_tmp3_);
				continue;
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_tmp3_);
				_g_object_unref0 (is_migrated);
				_g_free0 (email);
				_g_object_unref0 (info);
				_g_object_unref0 (_tmp0_);
				_g_object_unref0 (enumerator);
				_g_object_unref0 (old_config_file);
				_g_object_unref0 (new_config_file);
				_g_object_unref0 (old_data_dir);
				_g_object_unref0 (new_config_dir);
				return;
			}
		}
		_tmp27_ = new_config_dir;
		_tmp28_ = g_file_get_child (_tmp27_, UTIL_MIGRATE_SETTINGS_FILENAME);
		_g_object_unref0 (new_config_file);
		new_config_file = _tmp28_;
		_tmp29_ = new_config_file;
		if (g_file_query_exists (_tmp29_, NULL)) {
			_g_object_unref0 (_tmp3_);
			continue;
		}
		{
			GFile* _tmp30_;
			GFile* _tmp31_;
			_tmp30_ = old_config_file;
			_tmp31_ = new_config_file;
			g_file_copy (_tmp30_, _tmp31_, G_FILE_COPY_NONE, NULL, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GFile* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			g_clear_error (&_inner_error0_);
			_tmp32_ = new_config_dir;
			_tmp33_ = g_file_get_path (_tmp32_);
			_tmp34_ = _tmp33_;
			g_debug ("util-migrate.vala:82: Error copying over to %s", _tmp34_);
			_g_free0 (_tmp34_);
			_g_object_unref0 (_tmp3_);
			continue;
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp3_);
			_g_object_unref0 (is_migrated);
			_g_free0 (email);
			_g_object_unref0 (info);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (enumerator);
			_g_object_unref0 (old_config_file);
			_g_object_unref0 (new_config_file);
			_g_object_unref0 (old_data_dir);
			_g_object_unref0 (new_config_dir);
			return;
		}
		_tmp35_ = g_key_file_new ();
		key_file = _tmp35_;
		{
			GKeyFile* _tmp36_;
			GFile* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			_tmp36_ = key_file;
			_tmp37_ = new_config_file;
			_tmp38_ = g_file_get_path (_tmp37_);
			_tmp39_ = _tmp38_;
			g_key_file_load_from_file (_tmp36_, _tmp39_, G_KEY_FILE_NONE, &_inner_error0_);
			_g_free0 (_tmp39_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GFile* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			g_clear_error (&_inner_error0_);
			_tmp40_ = new_config_file;
			_tmp41_ = g_file_get_path (_tmp40_);
			_tmp42_ = _tmp41_;
			g_debug ("util-migrate.vala:89: Error opening %s", _tmp42_);
			_g_free0 (_tmp42_);
			_g_key_file_unref0 (key_file);
			_g_object_unref0 (_tmp3_);
			continue;
		}
		__finally2:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_key_file_unref0 (key_file);
			_g_object_unref0 (_tmp3_);
			_g_object_unref0 (is_migrated);
			_g_free0 (email);
			_g_object_unref0 (info);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (enumerator);
			_g_object_unref0 (old_config_file);
			_g_object_unref0 (new_config_file);
			_g_object_unref0 (old_data_dir);
			_g_object_unref0 (new_config_dir);
			return;
		}
		_tmp43_ = key_file;
		_tmp44_ = email;
		g_key_file_set_value (_tmp43_, UTIL_MIGRATE_GROUP, UTIL_MIGRATE_PRIMARY_EMAIL_KEY, _tmp44_);
		_tmp45_ = key_file;
		_tmp46_ = g_key_file_to_data (_tmp45_, NULL, NULL);
		data = _tmp46_;
		{
			GFile* _tmp47_;
			const gchar* _tmp48_;
			guint8* _tmp49_;
			gint _tmp49__length1;
			gint _tmp50_ = 0;
			guint8* _tmp51_;
			gint _tmp51__length1;
			_tmp47_ = new_config_file;
			_tmp48_ = data;
			_tmp49_ = string_get_data (_tmp48_, &_tmp50_);
			_tmp49__length1 = _tmp50_;
			_tmp51_ = _tmp49_;
			_tmp51__length1 = _tmp49__length1;
			g_file_replace_contents (_tmp47_, (const char*) _tmp51_, (gsize) _tmp51__length1, NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch3_g_error;
			}
		}
		goto __finally3;
		__catch3_g_error:
		{
			const gchar* _tmp52_;
			g_clear_error (&_inner_error0_);
			_tmp52_ = email;
			g_debug ("util-migrate.vala:100: Error writing email %s to config file", _tmp52_);
			_g_free0 (data);
			_g_key_file_unref0 (key_file);
			_g_object_unref0 (_tmp3_);
			continue;
		}
		__finally3:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (data);
			_g_key_file_unref0 (key_file);
			_g_object_unref0 (_tmp3_);
			_g_object_unref0 (is_migrated);
			_g_free0 (email);
			_g_object_unref0 (info);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (enumerator);
			_g_object_unref0 (old_config_file);
			_g_object_unref0 (new_config_file);
			_g_object_unref0 (old_data_dir);
			_g_object_unref0 (new_config_dir);
			return;
		}
		_tmp53_ = is_migrated;
		_tmp54_ = g_file_create (_tmp53_, G_FILE_CREATE_PRIVATE, NULL, &_inner_error0_);
		_tmp55_ = _tmp54_;
		_g_object_unref0 (_tmp55_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (data);
			_g_key_file_unref0 (key_file);
			_g_object_unref0 (_tmp3_);
			_g_object_unref0 (is_migrated);
			_g_free0 (email);
			_g_object_unref0 (info);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (enumerator);
			_g_object_unref0 (old_config_file);
			_g_object_unref0 (new_config_file);
			_g_object_unref0 (old_data_dir);
			_g_object_unref0 (new_config_dir);
			return;
		}
		_g_free0 (data);
		_g_key_file_unref0 (key_file);
		_g_object_unref0 (_tmp3_);
	}
	_g_object_unref0 (is_migrated);
	_g_free0 (email);
	_g_object_unref0 (info);
	_g_object_unref0 (_tmp0_);
	_g_object_unref0 (enumerator);
	_g_object_unref0 (old_config_file);
	_g_object_unref0 (new_config_file);
	_g_object_unref0 (old_data_dir);
	_g_object_unref0 (new_config_dir);
}

/**
     * Migrates configuration from release build locations.
     *
     * This will migrate configuration from release build locations to
     * the current config directory, if and only if the current config
     * directory is empty. For example, from the standard
     * distro-package config location to the current Flatpak location,
     * or from either to a development config location.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

void
util_migrate_release_config (GFile** search_path,
                             gint search_path_length1,
                             GFile* config_dir,
                             GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (config_dir, g_file_get_type ()));
	if (util_migrate_is_directory_empty (config_dir)) {
		GFile* most_recent = NULL;
		GDateTime* most_recent_modified = NULL;
		GFile* _tmp22_;
		most_recent = NULL;
		most_recent_modified = NULL;
		{
			GFile** source_collection = NULL;
			gint source_collection_length1 = 0;
			gint _source_collection_size_ = 0;
			gint source_it = 0;
			source_collection = search_path;
			source_collection_length1 = search_path_length1;
			for (source_it = 0; source_it < source_collection_length1; source_it = source_it + 1) {
				GFile* _tmp0_;
				GFile* source = NULL;
				_tmp0_ = _g_object_ref0 (source_collection[source_it]);
				source = _tmp0_;
				{
					GFile* _tmp1_;
					_tmp1_ = source;
					if (!g_file_equal (_tmp1_, config_dir)) {
						GDateTime* src_modified = NULL;
						gboolean _tmp12_ = FALSE;
						GDateTime* _tmp13_;
						src_modified = NULL;
						{
							GFileInfo* src_info = NULL;
							GFile* _tmp2_;
							GFileInfo* _tmp3_;
							GFileInfo* _tmp4_;
							_tmp2_ = source;
							_tmp3_ = g_file_query_info (_tmp2_, G_FILE_ATTRIBUTE_TIME_MODIFIED, 0, NULL, &_inner_error0_);
							src_info = _tmp3_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
									goto __catch0_g_io_error_not_found;
								}
								goto __catch0_g_error;
							}
							_tmp4_ = src_info;
							if (_tmp4_ != NULL) {
								GFileInfo* _tmp5_;
								GDateTime* _tmp6_;
								_tmp5_ = src_info;
								_tmp6_ = g_file_info_get_modification_date_time (_tmp5_);
								_g_date_time_unref0 (src_modified);
								src_modified = _tmp6_;
							}
							_g_object_unref0 (src_info);
						}
						goto __finally0;
						__catch0_g_io_error_not_found:
						{
							g_clear_error (&_inner_error0_);
						}
						goto __finally0;
						__catch0_g_error:
						{
							GError* err = NULL;
							GFile* _tmp7_;
							gchar* _tmp8_;
							gchar* _tmp9_;
							GError* _tmp10_;
							const gchar* _tmp11_;
							err = _inner_error0_;
							_inner_error0_ = NULL;
							_tmp7_ = source;
							_tmp8_ = g_file_get_path (_tmp7_);
							_tmp9_ = _tmp8_;
							_tmp10_ = err;
							_tmp11_ = _tmp10_->message;
							g_debug ("util-migrate.vala:136: Error querying release config dir %s: %s", _tmp9_, _tmp11_);
							_g_free0 (_tmp9_);
							_g_error_free0 (err);
						}
						__finally0:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							g_propagate_error (error, _inner_error0_);
							_g_date_time_unref0 (src_modified);
							_g_object_unref0 (source);
							_g_date_time_unref0 (most_recent_modified);
							_g_object_unref0 (most_recent);
							return;
						}
						_tmp13_ = most_recent_modified;
						if (_tmp13_ == NULL) {
							_tmp12_ = TRUE;
						} else {
							gboolean _tmp14_ = FALSE;
							GDateTime* _tmp15_;
							_tmp15_ = src_modified;
							if (_tmp15_ != NULL) {
								GDateTime* _tmp16_;
								GDateTime* _tmp17_;
								_tmp16_ = most_recent_modified;
								_tmp17_ = src_modified;
								_tmp14_ = g_date_time_compare (_tmp16_, _tmp17_) < 0;
							} else {
								_tmp14_ = FALSE;
							}
							_tmp12_ = _tmp14_;
						}
						if (_tmp12_) {
							GFile* _tmp18_;
							GFile* _tmp19_;
							GDateTime* _tmp20_;
							GDateTime* _tmp21_;
							_tmp18_ = source;
							_tmp19_ = _g_object_ref0 (_tmp18_);
							_g_object_unref0 (most_recent);
							most_recent = _tmp19_;
							_tmp20_ = src_modified;
							_tmp21_ = _g_date_time_ref0 (_tmp20_);
							_g_date_time_unref0 (most_recent_modified);
							most_recent_modified = _tmp21_;
						}
						_g_date_time_unref0 (src_modified);
					}
					_g_object_unref0 (source);
				}
			}
		}
		_tmp22_ = most_recent;
		if (_tmp22_ != NULL) {
			{
				GFile* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				GFile* _tmp28_;
				_tmp23_ = most_recent;
				_tmp24_ = g_file_get_path (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = g_file_get_path (config_dir);
				_tmp27_ = _tmp26_;
				g_debug ("util-migrate.vala:153: Migrating release config from %s to %s", _tmp25_, _tmp27_);
				_g_free0 (_tmp27_);
				_g_free0 (_tmp25_);
				_tmp28_ = most_recent;
				util_migrate_recursive_copy (_tmp28_, config_dir, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* err = NULL;
				GError* _tmp29_;
				const gchar* _tmp30_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp29_ = err;
				_tmp30_ = _tmp29_->message;
				g_debug ("util-migrate.vala:160: Error migrating release config: %s", _tmp30_);
				_g_error_free0 (err);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_date_time_unref0 (most_recent_modified);
				_g_object_unref0 (most_recent);
				return;
			}
		}
		_g_date_time_unref0 (most_recent_modified);
		_g_object_unref0 (most_recent);
	}
}

gboolean
util_migrate_is_directory_empty (GFile* dir)
{
	gboolean is_empty = FALSE;
	GFileEnumerator* existing = NULL;
	GFileEnumerator* _tmp8_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()), FALSE);
	is_empty = TRUE;
	existing = NULL;
	{
		GFileEnumerator* _tmp0_ = NULL;
		GFileEnumerator* _tmp1_;
		GFileEnumerator* _tmp2_;
		_tmp1_ = g_file_enumerate_children (dir, G_FILE_ATTRIBUTE_STANDARD_TYPE, 0, NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				goto __catch0_g_io_error_not_found;
			}
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (existing);
		existing = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error_not_found:
	{
		g_clear_error (&_inner_error0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = g_file_get_path (dir);
		_tmp4_ = _tmp3_;
		_tmp5_ = err;
		_tmp6_ = _tmp5_->message;
		g_debug ("util-migrate.vala:176: Error enumerating directory %s: %s", _tmp4_, _tmp6_);
		_g_free0 (_tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		_g_object_unref0 (existing);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	_tmp8_ = existing;
	if (_tmp8_ != NULL) {
		{
			GFileInfo* _tmp9_ = NULL;
			GFileEnumerator* _tmp10_;
			GFileInfo* _tmp11_;
			_tmp10_ = existing;
			_tmp11_ = g_file_enumerator_next_file (_tmp10_, NULL, &_inner_error0_);
			_tmp9_ = _tmp11_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			is_empty = _tmp9_ == NULL;
			_g_object_unref0 (_tmp9_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* err = NULL;
			gchar* _tmp12_;
			gchar* _tmp13_;
			GError* _tmp14_;
			const gchar* _tmp15_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp12_ = g_file_get_path (dir);
			_tmp13_ = _tmp12_;
			_tmp14_ = err;
			_tmp15_ = _tmp14_->message;
			g_debug ("util-migrate.vala:187: Error getting next child in directory %s: %s", _tmp13_, _tmp15_);
			_g_free0 (_tmp13_);
			_g_error_free0 (err);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp16_ = FALSE;
			_g_object_unref0 (existing);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp16_;
		}
		{
			GFileEnumerator* _tmp17_;
			_tmp17_ = existing;
			g_file_enumerator_close (_tmp17_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* err = NULL;
			gchar* _tmp18_;
			gchar* _tmp19_;
			GError* _tmp20_;
			const gchar* _tmp21_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp18_ = g_file_get_path (dir);
			_tmp19_ = _tmp18_;
			_tmp20_ = err;
			_tmp21_ = _tmp20_->message;
			g_debug ("util-migrate.vala:197: Error closing directory enumeration %s: %s", _tmp19_, _tmp21_);
			_g_free0 (_tmp19_);
			_g_error_free0 (err);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp22_ = FALSE;
			_g_object_unref0 (existing);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp22_;
		}
	}
	result = is_empty;
	_g_object_unref0 (existing);
	return result;
}

void
util_migrate_recursive_copy (GFile* src,
                             GFile* dest,
                             GCancellable* cancellable,
                             GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (src, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dest, g_file_get_type ()));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	switch (g_file_query_file_type (src, G_FILE_QUERY_INFO_NONE, cancellable)) {
		case G_FILE_TYPE_DIRECTORY:
		{
			GFileEnumerator* children = NULL;
			GFileEnumerator* _tmp0_;
			GFileInfo* child = NULL;
			GFileEnumerator* _tmp1_;
			GFileInfo* _tmp2_;
			{
				g_file_make_directory (dest, cancellable, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
						goto __catch0_g_io_error_exists;
					}
					goto __finally0;
				}
			}
			goto __finally0;
			__catch0_g_io_error_exists:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				return;
			}
			g_file_copy_attributes (src, dest, G_FILE_COPY_NONE, cancellable, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				return;
			}
			_tmp0_ = g_file_enumerate_children (src, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NONE, cancellable, &_inner_error0_);
			children = _tmp0_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				return;
			}
			_tmp1_ = children;
			_tmp2_ = g_file_enumerator_next_file (_tmp1_, cancellable, &_inner_error0_);
			child = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (children);
				return;
			}
			while (TRUE) {
				GFileInfo* _tmp3_;
				GFileInfo* _tmp4_;
				const gchar* _tmp5_;
				GFile* _tmp6_;
				GFile* _tmp7_;
				GFileInfo* _tmp8_;
				const gchar* _tmp9_;
				GFile* _tmp10_;
				GFile* _tmp11_;
				GFileInfo* _tmp12_ = NULL;
				GFileEnumerator* _tmp13_;
				GFileInfo* _tmp14_;
				GFileInfo* _tmp15_;
				_tmp3_ = child;
				if (!(_tmp3_ != NULL)) {
					break;
				}
				_tmp4_ = child;
				_tmp5_ = g_file_info_get_name (_tmp4_);
				_tmp6_ = g_file_get_child (src, _tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = child;
				_tmp9_ = g_file_info_get_name (_tmp8_);
				_tmp10_ = g_file_get_child (dest, _tmp9_);
				_tmp11_ = _tmp10_;
				util_migrate_recursive_copy (_tmp7_, _tmp11_, NULL, &_inner_error0_);
				_g_object_unref0 (_tmp11_);
				_g_object_unref0 (_tmp7_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (child);
					_g_object_unref0 (children);
					return;
				}
				_tmp13_ = children;
				_tmp14_ = g_file_enumerator_next_file (_tmp13_, cancellable, &_inner_error0_);
				_tmp12_ = _tmp14_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (child);
					_g_object_unref0 (children);
					return;
				}
				_tmp15_ = _tmp12_;
				_tmp12_ = NULL;
				_g_object_unref0 (child);
				child = _tmp15_;
				_g_object_unref0 (_tmp12_);
			}
			_g_object_unref0 (child);
			_g_object_unref0 (children);
			break;
		}
		case G_FILE_TYPE_REGULAR:
		{
			g_file_copy (src, dest, G_FILE_COPY_NONE, cancellable, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				return;
			}
			break;
		}
		default:
		{
			break;
		}
	}
}

static gpointer
_g_settings_schema_source_ref0 (gpointer self)
{
	return self ? g_settings_schema_source_ref (self) : NULL;
}

void
util_migrate_old_app_config (GSettings* newSettings,
                             const gchar* old_app_id)
{
	GSettingsSchemaSource* schemaSource = NULL;
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchemaSource* _tmp1_;
	GSettingsSchema* oldSettingsSchema = NULL;
	GSettingsSchemaSource* _tmp5_;
	GSettingsSchema* _tmp6_;
	GSettingsSchema* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (newSettings, g_settings_get_type ()));
	g_return_if_fail (old_app_id != NULL);
	_tmp0_ = g_settings_schema_source_get_default ();
	_tmp1_ = _g_settings_schema_source_ref0 (_tmp0_);
	schemaSource = _tmp1_;
	if (APPLICATION_CLIENT_GSETTINGS_DIR != NULL) {
		{
			GSettingsSchemaSource* _tmp2_ = NULL;
			GSettingsSchemaSource* _tmp3_;
			GSettingsSchemaSource* _tmp4_;
			_tmp3_ = g_settings_schema_source_new_from_directory (APPLICATION_CLIENT_GSETTINGS_DIR, NULL, FALSE, &_inner_error0_);
			_tmp2_ = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp4_ = _tmp2_;
			_tmp2_ = NULL;
			_g_settings_schema_source_unref0 (schemaSource);
			schemaSource = _tmp4_;
			_g_settings_schema_source_unref0 (_tmp2_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_settings_schema_source_unref0 (schemaSource);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp5_ = schemaSource;
	_tmp6_ = g_settings_schema_source_lookup (_tmp5_, old_app_id, FALSE);
	oldSettingsSchema = _tmp6_;
	if (g_settings_get_boolean (newSettings, UTIL_MIGRATE_MIGRATED_CONFIG_KEY)) {
		_g_settings_schema_unref0 (oldSettingsSchema);
		_g_settings_schema_source_unref0 (schemaSource);
		return;
	}
	_tmp7_ = oldSettingsSchema;
	if (_tmp7_ != NULL) {
		GSettings* oldSettings = NULL;
		GSettingsSchema* _tmp8_;
		GSettings* _tmp9_;
		GSettingsSchema* _tmp10_;
		GSettingsSchema* _tmp11_;
		GSettingsSchema* _tmp12_;
		gchar** _tmp13_;
		gchar** _tmp14_;
		gchar** _tmp15_;
		gint _tmp15__length1;
		_tmp8_ = oldSettingsSchema;
		_tmp9_ = g_settings_new_full (_tmp8_, NULL, NULL);
		oldSettings = _tmp9_;
		g_object_get (newSettings, "settings-schema", &_tmp10_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		_tmp14_ = _tmp13_ = g_settings_schema_list_keys (_tmp12_);
		_tmp15_ = _tmp14_;
		_tmp15__length1 = _vala_array_length (_tmp13_);
		_g_settings_schema_unref0 (_tmp12_);
		{
			gchar** key_collection = NULL;
			gint key_collection_length1 = 0;
			gint _key_collection_size_ = 0;
			gint key_it = 0;
			key_collection = _tmp15_;
			key_collection_length1 = _tmp15__length1;
			for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
				gchar* _tmp16_;
				gchar* key = NULL;
				_tmp16_ = g_strdup (key_collection[key_it]);
				key = _tmp16_;
				{
					GSettingsSchema* _tmp17_;
					const gchar* _tmp18_;
					_tmp17_ = oldSettingsSchema;
					_tmp18_ = key;
					if (g_settings_schema_has_key (_tmp17_, _tmp18_)) {
						const gchar* _tmp19_;
						GSettings* _tmp20_;
						const gchar* _tmp21_;
						GVariant* _tmp22_;
						GVariant* _tmp23_;
						_tmp19_ = key;
						_tmp20_ = oldSettings;
						_tmp21_ = key;
						_tmp22_ = g_settings_get_value (_tmp20_, _tmp21_);
						_tmp23_ = _tmp22_;
						g_settings_set_value (newSettings, _tmp19_, _tmp23_);
						_g_variant_unref0 (_tmp23_);
					}
					_g_free0 (key);
				}
			}
			key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_object_unref0 (oldSettings);
	}
	g_settings_set_boolean (newSettings, UTIL_MIGRATE_MIGRATED_CONFIG_KEY, TRUE);
	_g_settings_schema_unref0 (oldSettingsSchema);
	_g_settings_schema_source_unref0 (schemaSource);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

