{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A list model that presents the selection from a @GtkSelectionModel@.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.SelectionFilterModel
    ( 

-- * Exported types
    SelectionFilterModel(..)                ,
    IsSelectionFilterModel                  ,
    toSelectionFilterModel                  ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [itemsChanged]("GI.Gio.Interfaces.ListModel#g:method:itemsChanged"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getItem]("GI.Gio.Interfaces.ListModel#g:method:getItem"), [getItemType]("GI.Gio.Interfaces.ListModel#g:method:getItemType"), [getModel]("GI.Gtk.Objects.SelectionFilterModel#g:method:getModel"), [getNItems]("GI.Gio.Interfaces.ListModel#g:method:getNItems"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setModel]("GI.Gtk.Objects.SelectionFilterModel#g:method:setModel"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveSelectionFilterModelMethod       ,
#endif

-- ** getModel #method:getModel#

#if defined(ENABLE_OVERLOADING)
    SelectionFilterModelGetModelMethodInfo  ,
#endif
    selectionFilterModelGetModel            ,


-- ** new #method:new#

    selectionFilterModelNew                 ,


-- ** setModel #method:setModel#

#if defined(ENABLE_OVERLOADING)
    SelectionFilterModelSetModelMethodInfo  ,
#endif
    selectionFilterModelSetModel            ,




 -- * Properties


-- ** itemType #attr:itemType#
-- | The type of items. See 'GI.Gio.Interfaces.ListModel.listModelGetItemType'.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    SelectionFilterModelItemTypePropertyInfo,
#endif
    getSelectionFilterModelItemType         ,
#if defined(ENABLE_OVERLOADING)
    selectionFilterModelItemType            ,
#endif


-- ** model #attr:model#
-- | The model being filtered.

#if defined(ENABLE_OVERLOADING)
    SelectionFilterModelModelPropertyInfo   ,
#endif
    clearSelectionFilterModelModel          ,
    constructSelectionFilterModelModel      ,
    getSelectionFilterModelModel            ,
#if defined(ENABLE_OVERLOADING)
    selectionFilterModelModel               ,
#endif
    setSelectionFilterModelModel            ,


-- ** nItems #attr:nItems#
-- | The number of items. See 'GI.Gio.Interfaces.ListModel.listModelGetNItems'.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    SelectionFilterModelNItemsPropertyInfo  ,
#endif
    getSelectionFilterModelNItems           ,
#if defined(ENABLE_OVERLOADING)
    selectionFilterModelNItems              ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.SelectionModel as Gtk.SelectionModel
import {-# SOURCE #-} qualified GI.Gtk.Structs.Bitset as Gtk.Bitset

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.SelectionModel as Gtk.SelectionModel

#endif

-- | Memory-managed wrapper type.
newtype SelectionFilterModel = SelectionFilterModel (SP.ManagedPtr SelectionFilterModel)
    deriving (Eq)

instance SP.ManagedPtrNewtype SelectionFilterModel where
    toManagedPtr (SelectionFilterModel p) = p

foreign import ccall "gtk_selection_filter_model_get_type"
    c_gtk_selection_filter_model_get_type :: IO B.Types.GType

instance B.Types.TypedObject SelectionFilterModel where
    glibType = c_gtk_selection_filter_model_get_type

instance B.Types.GObject SelectionFilterModel

-- | Type class for types which can be safely cast to t'SelectionFilterModel', for instance with `toSelectionFilterModel`.
class (SP.GObject o, O.IsDescendantOf SelectionFilterModel o) => IsSelectionFilterModel o
instance (SP.GObject o, O.IsDescendantOf SelectionFilterModel o) => IsSelectionFilterModel o

instance O.HasParentTypes SelectionFilterModel
type instance O.ParentTypes SelectionFilterModel = '[GObject.Object.Object, Gio.ListModel.ListModel]

-- | Cast to t'SelectionFilterModel', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toSelectionFilterModel :: (MIO.MonadIO m, IsSelectionFilterModel o) => o -> m SelectionFilterModel
toSelectionFilterModel = MIO.liftIO . B.ManagedPtr.unsafeCastTo SelectionFilterModel

-- | Convert t'SelectionFilterModel' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe SelectionFilterModel) where
    gvalueGType_ = c_gtk_selection_filter_model_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr SelectionFilterModel)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr SelectionFilterModel)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject SelectionFilterModel ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveSelectionFilterModelMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSelectionFilterModelMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSelectionFilterModelMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSelectionFilterModelMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSelectionFilterModelMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSelectionFilterModelMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSelectionFilterModelMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSelectionFilterModelMethod "itemsChanged" o = Gio.ListModel.ListModelItemsChangedMethodInfo
    ResolveSelectionFilterModelMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSelectionFilterModelMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSelectionFilterModelMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSelectionFilterModelMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSelectionFilterModelMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSelectionFilterModelMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSelectionFilterModelMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSelectionFilterModelMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSelectionFilterModelMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSelectionFilterModelMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSelectionFilterModelMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSelectionFilterModelMethod "getItem" o = Gio.ListModel.ListModelGetItemMethodInfo
    ResolveSelectionFilterModelMethod "getItemType" o = Gio.ListModel.ListModelGetItemTypeMethodInfo
    ResolveSelectionFilterModelMethod "getModel" o = SelectionFilterModelGetModelMethodInfo
    ResolveSelectionFilterModelMethod "getNItems" o = Gio.ListModel.ListModelGetNItemsMethodInfo
    ResolveSelectionFilterModelMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSelectionFilterModelMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSelectionFilterModelMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSelectionFilterModelMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSelectionFilterModelMethod "setModel" o = SelectionFilterModelSetModelMethodInfo
    ResolveSelectionFilterModelMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSelectionFilterModelMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSelectionFilterModelMethod t SelectionFilterModel, O.OverloadedMethod info SelectionFilterModel p) => OL.IsLabel t (SelectionFilterModel -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSelectionFilterModelMethod t SelectionFilterModel, O.OverloadedMethod info SelectionFilterModel p, R.HasField t SelectionFilterModel p) => R.HasField t SelectionFilterModel p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSelectionFilterModelMethod t SelectionFilterModel, O.OverloadedMethodInfo info SelectionFilterModel) => OL.IsLabel t (O.MethodProxy info SelectionFilterModel) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "item-type"
   -- Type: TBasicType TGType
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@item-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' selectionFilterModel #itemType
-- @
getSelectionFilterModelItemType :: (MonadIO m, IsSelectionFilterModel o) => o -> m GType
getSelectionFilterModelItemType obj = MIO.liftIO $ B.Properties.getObjectPropertyGType obj "item-type"

#if defined(ENABLE_OVERLOADING)
data SelectionFilterModelItemTypePropertyInfo
instance AttrInfo SelectionFilterModelItemTypePropertyInfo where
    type AttrAllowedOps SelectionFilterModelItemTypePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint SelectionFilterModelItemTypePropertyInfo = IsSelectionFilterModel
    type AttrSetTypeConstraint SelectionFilterModelItemTypePropertyInfo = (~) ()
    type AttrTransferTypeConstraint SelectionFilterModelItemTypePropertyInfo = (~) ()
    type AttrTransferType SelectionFilterModelItemTypePropertyInfo = ()
    type AttrGetType SelectionFilterModelItemTypePropertyInfo = GType
    type AttrLabel SelectionFilterModelItemTypePropertyInfo = "item-type"
    type AttrOrigin SelectionFilterModelItemTypePropertyInfo = SelectionFilterModel
    attrGet = getSelectionFilterModelItemType
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SelectionFilterModel.itemType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SelectionFilterModel.html#g:attr:itemType"
        })
#endif

-- VVV Prop "model"
   -- Type: TInterface (Name {namespace = "Gtk", name = "SelectionModel"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' selectionFilterModel #model
-- @
getSelectionFilterModelModel :: (MonadIO m, IsSelectionFilterModel o) => o -> m (Maybe Gtk.SelectionModel.SelectionModel)
getSelectionFilterModelModel obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "model" Gtk.SelectionModel.SelectionModel

-- | Set the value of the “@model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' selectionFilterModel [ #model 'Data.GI.Base.Attributes.:=' value ]
-- @
setSelectionFilterModelModel :: (MonadIO m, IsSelectionFilterModel o, Gtk.SelectionModel.IsSelectionModel a) => o -> a -> m ()
setSelectionFilterModelModel obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "model" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@model@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSelectionFilterModelModel :: (IsSelectionFilterModel o, MIO.MonadIO m, Gtk.SelectionModel.IsSelectionModel a) => a -> m (GValueConstruct o)
constructSelectionFilterModelModel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "model" (P.Just val)

-- | Set the value of the “@model@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #model
-- @
clearSelectionFilterModelModel :: (MonadIO m, IsSelectionFilterModel o) => o -> m ()
clearSelectionFilterModelModel obj = liftIO $ B.Properties.setObjectPropertyObject obj "model" (Nothing :: Maybe Gtk.SelectionModel.SelectionModel)

#if defined(ENABLE_OVERLOADING)
data SelectionFilterModelModelPropertyInfo
instance AttrInfo SelectionFilterModelModelPropertyInfo where
    type AttrAllowedOps SelectionFilterModelModelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint SelectionFilterModelModelPropertyInfo = IsSelectionFilterModel
    type AttrSetTypeConstraint SelectionFilterModelModelPropertyInfo = Gtk.SelectionModel.IsSelectionModel
    type AttrTransferTypeConstraint SelectionFilterModelModelPropertyInfo = Gtk.SelectionModel.IsSelectionModel
    type AttrTransferType SelectionFilterModelModelPropertyInfo = Gtk.SelectionModel.SelectionModel
    type AttrGetType SelectionFilterModelModelPropertyInfo = (Maybe Gtk.SelectionModel.SelectionModel)
    type AttrLabel SelectionFilterModelModelPropertyInfo = "model"
    type AttrOrigin SelectionFilterModelModelPropertyInfo = SelectionFilterModel
    attrGet = getSelectionFilterModelModel
    attrSet = setSelectionFilterModelModel
    attrTransfer _ v = do
        unsafeCastTo Gtk.SelectionModel.SelectionModel v
    attrConstruct = constructSelectionFilterModelModel
    attrClear = clearSelectionFilterModelModel
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SelectionFilterModel.model"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SelectionFilterModel.html#g:attr:model"
        })
#endif

-- VVV Prop "n-items"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@n-items@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' selectionFilterModel #nItems
-- @
getSelectionFilterModelNItems :: (MonadIO m, IsSelectionFilterModel o) => o -> m Word32
getSelectionFilterModelNItems obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "n-items"

#if defined(ENABLE_OVERLOADING)
data SelectionFilterModelNItemsPropertyInfo
instance AttrInfo SelectionFilterModelNItemsPropertyInfo where
    type AttrAllowedOps SelectionFilterModelNItemsPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint SelectionFilterModelNItemsPropertyInfo = IsSelectionFilterModel
    type AttrSetTypeConstraint SelectionFilterModelNItemsPropertyInfo = (~) ()
    type AttrTransferTypeConstraint SelectionFilterModelNItemsPropertyInfo = (~) ()
    type AttrTransferType SelectionFilterModelNItemsPropertyInfo = ()
    type AttrGetType SelectionFilterModelNItemsPropertyInfo = Word32
    type AttrLabel SelectionFilterModelNItemsPropertyInfo = "n-items"
    type AttrOrigin SelectionFilterModelNItemsPropertyInfo = SelectionFilterModel
    attrGet = getSelectionFilterModelNItems
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SelectionFilterModel.nItems"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SelectionFilterModel.html#g:attr:nItems"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SelectionFilterModel
type instance O.AttributeList SelectionFilterModel = SelectionFilterModelAttributeList
type SelectionFilterModelAttributeList = ('[ '("itemType", SelectionFilterModelItemTypePropertyInfo), '("model", SelectionFilterModelModelPropertyInfo), '("nItems", SelectionFilterModelNItemsPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
selectionFilterModelItemType :: AttrLabelProxy "itemType"
selectionFilterModelItemType = AttrLabelProxy

selectionFilterModelModel :: AttrLabelProxy "model"
selectionFilterModelModel = AttrLabelProxy

selectionFilterModelNItems :: AttrLabelProxy "nItems"
selectionFilterModelNItems = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList SelectionFilterModel = SelectionFilterModelSignalList
type SelectionFilterModelSignalList = ('[ '("itemsChanged", Gio.ListModel.ListModelItemsChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method SelectionFilterModel::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SelectionModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the selection model to filter"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "SelectionFilterModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_selection_filter_model_new" gtk_selection_filter_model_new :: 
    Ptr Gtk.SelectionModel.SelectionModel -> -- model : TInterface (Name {namespace = "Gtk", name = "SelectionModel"})
    IO (Ptr SelectionFilterModel)

-- | Creates a new @GtkSelectionFilterModel@ that will include the
-- selected items from the underlying selection model.
selectionFilterModelNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.SelectionModel.IsSelectionModel a) =>
    Maybe (a)
    -- ^ /@model@/: the selection model to filter
    -> m SelectionFilterModel
    -- ^ __Returns:__ a new @GtkSelectionFilterModel@
selectionFilterModelNew model = liftIO $ do
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- unsafeManagedPtrCastPtr jModel
            return jModel'
    result <- gtk_selection_filter_model_new maybeModel
    checkUnexpectedReturnNULL "selectionFilterModelNew" result
    result' <- (wrapObject SelectionFilterModel) result
    whenJust model touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method SelectionFilterModel::get_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "SelectionFilterModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSelectionFilterModel`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "SelectionModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_selection_filter_model_get_model" gtk_selection_filter_model_get_model :: 
    Ptr SelectionFilterModel ->             -- self : TInterface (Name {namespace = "Gtk", name = "SelectionFilterModel"})
    IO (Ptr Gtk.SelectionModel.SelectionModel)

-- | Gets the model currently filtered or 'P.Nothing' if none.
selectionFilterModelGetModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsSelectionFilterModel a) =>
    a
    -- ^ /@self@/: a @GtkSelectionFilterModel@
    -> m (Maybe Gtk.SelectionModel.SelectionModel)
    -- ^ __Returns:__ The model that gets filtered
selectionFilterModelGetModel self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_selection_filter_model_get_model self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.SelectionModel.SelectionModel) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data SelectionFilterModelGetModelMethodInfo
instance (signature ~ (m (Maybe Gtk.SelectionModel.SelectionModel)), MonadIO m, IsSelectionFilterModel a) => O.OverloadedMethod SelectionFilterModelGetModelMethodInfo a signature where
    overloadedMethod = selectionFilterModelGetModel

instance O.OverloadedMethodInfo SelectionFilterModelGetModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SelectionFilterModel.selectionFilterModelGetModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SelectionFilterModel.html#v:selectionFilterModelGetModel"
        })


#endif

-- method SelectionFilterModel::set_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "SelectionFilterModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSelectionFilterModel`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SelectionModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The model to be filtered"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_selection_filter_model_set_model" gtk_selection_filter_model_set_model :: 
    Ptr SelectionFilterModel ->             -- self : TInterface (Name {namespace = "Gtk", name = "SelectionFilterModel"})
    Ptr Gtk.SelectionModel.SelectionModel -> -- model : TInterface (Name {namespace = "Gtk", name = "SelectionModel"})
    IO ()

-- | Sets the model to be filtered.
-- 
-- Note that GTK makes no effort to ensure that /@model@/ conforms to
-- the item type of /@self@/. It assumes that the caller knows what they
-- are doing and have set up an appropriate filter to ensure that item
-- types match.
selectionFilterModelSetModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsSelectionFilterModel a, Gtk.SelectionModel.IsSelectionModel b) =>
    a
    -- ^ /@self@/: a @GtkSelectionFilterModel@
    -> Maybe (b)
    -- ^ /@model@/: The model to be filtered
    -> m ()
selectionFilterModelSetModel self model = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- unsafeManagedPtrCastPtr jModel
            return jModel'
    gtk_selection_filter_model_set_model self' maybeModel
    touchManagedPtr self
    whenJust model touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data SelectionFilterModelSetModelMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsSelectionFilterModel a, Gtk.SelectionModel.IsSelectionModel b) => O.OverloadedMethod SelectionFilterModelSetModelMethodInfo a signature where
    overloadedMethod = selectionFilterModelSetModel

instance O.OverloadedMethodInfo SelectionFilterModelSetModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SelectionFilterModel.selectionFilterModelSetModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SelectionFilterModel.html#v:selectionFilterModelSetModel"
        })


#endif


