/* Autogenerated file, DO NOT EDIT manually! generated by perf-metricset-codegen.py
 *
 * Copyright (c) 2018 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include <stddef.h>
#include <stdint.h>
#include <stdlib.h>
#include <stdbool.h>
#include <assert.h>

#include "i915_drm.h"

#include "i915_perf_metrics_mtlgt2.h"
#include "i915_perf_equations.h"
#include "i915_perf_registers_mtlgt2.h"

static bool mtlgt2_render_basic_SamplerBottleneck_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}
static bool mtlgt2_render_basic_SamplersBusy_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_render_basic_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics Basic";
    metric_set->symbol_name = "RenderBasic";
    metric_set->hw_config_guid = "232e858b-7116-44e8-a4be-856c59026650";
    metric_set->counters = calloc(38, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_render_basic_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__render_basic__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__render_basic__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__render_basic__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__render_basic__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = mtlgt2__render_basic__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_basic__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__render_basic__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__render_basic__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__render_basic__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GTI Read Throughput",
                .symbol_name = "GtiReadThroughput",
                .desc = "The total number of GPU memory bytes read from GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = mtlgt2__render_basic__gti_read_throughput__read,
                .max_uint64 = mtlgt2__render_basic__gti_read_throughput__max,
                .group = "GTI",
            },

            {
                .name = "GTI Write Throughput",
                .symbol_name = "GtiWriteThroughput",
                .desc = "The total number of GPU memory bytes written to GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = mtlgt2__render_basic__gti_write_throughput__read,
                .max_uint64 = mtlgt2__render_basic__gti_write_throughput__max,
                .group = "GTI",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = mtlgt2__render_basic__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__render_basic__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = mtlgt2__render_basic__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS EM Pipe Active",
                .symbol_name = "PsEmActive",
                .desc = "The percentage of time in which XVE EM INT pipeline was actively processing a fragment shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_basic__ps_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS FPU Pipe Active",
                .symbol_name = "PsFpuActive",
                .desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a fragment shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_basic__ps_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS Send Pipe Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which XVE send pipeline was actively processing a fragment shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_basic__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__render_basic__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = mtlgt2__render_basic__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Samplers Bottleneck",
                .symbol_name = "SamplerBottleneck",
                .desc = "The percentage of time in which samplers have been slowing down the pipe when processing XVE requests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_basic__sampler_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = mtlgt2_render_basic_SamplerBottleneck_availability,
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = mtlgt2__render_basic__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = mtlgt2__render_basic__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samplers Busy",
                .symbol_name = "SamplersBusy",
                .desc = "The percentage of time in which samplers or L1 cache are not idle.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_basic__samplers_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = mtlgt2_render_basic_SamplersBusy_availability,
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = mtlgt2__render_basic__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = mtlgt2__render_basic__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = mtlgt2__render_basic__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = mtlgt2__render_basic__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = mtlgt2__render_basic__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = mtlgt2__render_basic__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmReads",
                .desc = "The total number of reads from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = mtlgt2__render_basic__slm_reads__read,
                .max_uint64 = mtlgt2__render_basic__slm_reads__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Writes",
                .symbol_name = "SlmWrites",
                .desc = "The total number of writes into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = mtlgt2__render_basic__slm_writes__read,
                .max_uint64 = mtlgt2__render_basic__slm_writes__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS EM Pipe Active",
                .symbol_name = "VsEmActive",
                .desc = "The percentage of time in which XVE EM INT pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_basic__vs_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU Pipe Active",
                .symbol_name = "VsFpuActive",
                .desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_basic__vs_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which XVE send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_basic__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__render_basic__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "XVE Active",
                .symbol_name = "XveActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_basic__xve_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EM And FPU Pipes Active",
                .symbol_name = "XveFpuEmActive",
                .desc = "The percentage of time in which XVE EM INT and FPU INT64 pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_basic__xve_fpu_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "XVE Stall",
                .symbol_name = "XveStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_basic__xve_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "XVE Thread Occupancy",
                .symbol_name = "XveThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied XVEs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_basic__xve_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 38);
}


static void
mtlgt2_add_compute_basic_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Compute Metrics Basic";
    metric_set->symbol_name = "ComputeBasic";
    metric_set->hw_config_guid = "fea2b2b7-a072-41c5-9092-2d7c48bb56c6";
    metric_set->counters = calloc(39, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_compute_basic_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__compute_basic__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__compute_basic__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__compute_basic__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__compute_basic__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = mtlgt2__compute_basic__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EM Pipe Active",
                .symbol_name = "EmActive",
                .desc = "The percentage of time in which XVE EM INT pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__compute_basic__em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "XVE FPU Pipe Active",
                .symbol_name = "FpuActive",
                .desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__compute_basic__fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__compute_basic__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__compute_basic__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__compute_basic__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__compute_basic__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GTI Read Throughput",
                .symbol_name = "GtiReadThroughput",
                .desc = "The total number of GPU memory bytes read from GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = mtlgt2__compute_basic__gti_read_throughput__read,
                .max_uint64 = mtlgt2__compute_basic__gti_read_throughput__max,
                .group = "GTI",
            },

            {
                .name = "GTI Write Throughput",
                .symbol_name = "GtiWriteThroughput",
                .desc = "The total number of GPU memory bytes written to GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = mtlgt2__compute_basic__gti_write_throughput__read,
                .max_uint64 = mtlgt2__compute_basic__gti_write_throughput__max,
                .group = "GTI",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = mtlgt2__compute_basic__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__compute_basic__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = mtlgt2__compute_basic__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__compute_basic__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = mtlgt2__compute_basic__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = mtlgt2__compute_basic__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = mtlgt2__compute_basic__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = mtlgt2__compute_basic__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = mtlgt2__compute_basic__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = mtlgt2__compute_basic__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Send Pipe Active",
                .symbol_name = "SendActive",
                .desc = "The percentage of time in which XVE send pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__compute_basic__send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = mtlgt2__compute_basic__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = mtlgt2__compute_basic__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = mtlgt2__compute_basic__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmReads",
                .desc = "The total number of reads from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = mtlgt2__compute_basic__slm_reads__read,
                .max_uint64 = mtlgt2__compute_basic__slm_reads__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Writes",
                .symbol_name = "SlmWrites",
                .desc = "The total number of writes into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = mtlgt2__compute_basic__slm_writes__read,
                .max_uint64 = mtlgt2__compute_basic__slm_writes__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__compute_basic__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "XMX Pipe Active",
                .symbol_name = "XmxActive",
                .desc = "The percentage of time in which XVE XMX pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__compute_basic__xmx_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "XVE Active",
                .symbol_name = "XveActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__compute_basic__xve_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "XVE AVG IPC Rate",
                .symbol_name = "XveAvgIpcRate",
                .desc = "The average rate of IPC calculated for 2 FPU pipelines.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NUMBER,
                .read_float = mtlgt2__compute_basic__xve_avg_ipc_rate__read,
                .max_float = mtlgt2__compute_basic__xve_avg_ipc_rate__max,
                .group = "EU Array",
            },

            {
                .name = "EM And FPU Pipes Active",
                .symbol_name = "XveFpuEmActive",
                .desc = "The percentage of time in which XVE EM INT and FPU INT64 pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__compute_basic__xve_fpu_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "FPU FLT16 Instruction",
                .symbol_name = "XveFpuFlt16",
                .desc = "The percentage of time in which FLT16 instruction were processed actively on FPU INT64 pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__compute_basic__xve_fpu_flt16__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "FPU FLT32 Instruction",
                .symbol_name = "XveFpuFlt32",
                .desc = "The percentage of time in which FLT32 instruction were processed actively on FPU INT64 pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__compute_basic__xve_fpu_flt32__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "FPU FLT64 Instruction",
                .symbol_name = "XveFpuFlt64",
                .desc = "The percentage of time in which FLT64 instruction were processed actively on FPU INT64 pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__compute_basic__xve_fpu_flt64__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "XMX And FPU Pipes Active",
                .symbol_name = "XveFpuXmxActive",
                .desc = "The percentage of time in which XVE XMX and FPU INT64 pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__compute_basic__xve_fpu_xmx_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "XVE Stall",
                .symbol_name = "XveStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__compute_basic__xve_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "XVE Thread Occupancy",
                .symbol_name = "XveThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied XVEs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__compute_basic__xve_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 39);
}


static void
mtlgt2_add_async_compute_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "AsyncCompute";
    metric_set->symbol_name = "AsyncCompute";
    metric_set->hw_config_guid = "011e5c80-c877-46fd-90ff-fd0bb29cb5ec";
    metric_set->counters = calloc(23, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_async_compute_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "ASYNC CS EM Pipe Active",
                .symbol_name = "AsyncCsEmActive",
                .desc = "The percentage of time in which XVE EM INT pipeline was actively processing a compute shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__async_compute__async_cs_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "ASYNC CS FPU Pipe Active",
                .symbol_name = "AsyncCsFpuActive",
                .desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a compute shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__async_compute__async_cs_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__async_compute__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__async_compute__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS EM Pipe Active",
                .symbol_name = "CsEmActive",
                .desc = "The percentage of time in which XVE EM INT pipeline was actively processing a compute shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__async_compute__cs_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "CS FPU Pipe Active",
                .symbol_name = "CsFpuActive",
                .desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a compute shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__async_compute__cs_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__async_compute__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__async_compute__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "EM Pipe Active",
                .symbol_name = "EmActive",
                .desc = "The percentage of time in which XVE EM INT pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__async_compute__em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "XVE FPU Pipe Active",
                .symbol_name = "FpuActive",
                .desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__async_compute__fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__async_compute__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__async_compute__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__async_compute__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__async_compute__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__async_compute__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "FS EM Pipe Active",
                .symbol_name = "PsEmActive",
                .desc = "The percentage of time in which XVE EM INT pipeline was actively processing a fragment shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__async_compute__ps_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS FPU Pipe Active",
                .symbol_name = "PsFpuActive",
                .desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a fragment shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__async_compute__ps_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__async_compute__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "VS EM Pipe Active",
                .symbol_name = "VsEmActive",
                .desc = "The percentage of time in which XVE EM INT pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__async_compute__vs_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU Pipe Active",
                .symbol_name = "VsFpuActive",
                .desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__async_compute__vs_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__async_compute__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "XVE Active",
                .symbol_name = "XveActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__async_compute__xve_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "XVE Stall",
                .symbol_name = "XveStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__async_compute__xve_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "XVE Thread Occupancy",
                .symbol_name = "XveThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied XVEs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__async_compute__xve_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 23);
}


static void
mtlgt2_add_xve_activity_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "XveActivity";
    metric_set->symbol_name = "XveActivity";
    metric_set->hw_config_guid = "5f430543-ba1e-487c-b217-90570cfb85f9";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_xve_activity_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__xve_activity__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__xve_activity__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Send Pipe Active",
                .symbol_name = "CsSendActive",
                .desc = "The percentage of time in which XVE send pipeline was actively processing a compute shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__xve_activity__cs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__xve_activity__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS EM Pipe Active",
                .symbol_name = "DsEmActive",
                .desc = "The percentage of time in which XVE EM INT pipeline was actively processing a domain shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__xve_activity__ds_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "DS FPU Pipe Active",
                .symbol_name = "DsFpuActive",
                .desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a domain shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__xve_activity__ds_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "DS Send Pipe Active",
                .symbol_name = "DsSendActive",
                .desc = "The percentage of time in which XVE send pipeline was actively processing a domain shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__xve_activity__ds_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__xve_activity__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__xve_activity__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__xve_activity__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__xve_activity__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS EM Pipe Active",
                .symbol_name = "GsEmActive",
                .desc = "The percentage of time in which XVE EM INT pipeline was actively processing a geometry shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__xve_activity__gs_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS FPU Pipe Active",
                .symbol_name = "GsFpuActive",
                .desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a geometry shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__xve_activity__gs_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS Send Pipe Active",
                .symbol_name = "GsSendActive",
                .desc = "The percentage of time in which XVE send pipeline was actively processing a geometry shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__xve_activity__gs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__xve_activity__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "HS EM Pipe Active",
                .symbol_name = "HsEmActive",
                .desc = "The percentage of time in which XVE EM INT pipeline was actively processing a hull shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__xve_activity__hs_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "HS FPU Pipe Active",
                .symbol_name = "HsFpuActive",
                .desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a hull shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__xve_activity__hs_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "HS Send Pipe Active",
                .symbol_name = "HsSendActive",
                .desc = "The percentage of time in which XVE send pipeline was actively processing a hull shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__xve_activity__hs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__xve_activity__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__xve_activity__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__xve_activity__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 20);
}


static void
mtlgt2_add_gpu_busyness_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "GpuBusyness";
    metric_set->symbol_name = "GpuBusyness";
    metric_set->hw_config_guid = "3cb64fed-0f61-4e41-a754-b9c5b4892f77";
    metric_set->counters = calloc(16, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_gpu_busyness_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__gpu_busyness__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__gpu_busyness__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "Blitter Ring Busy",
                .symbol_name = "BlitterBusy",
                .desc = "The percentage of time when blitter command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__gpu_busyness__blitter_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "ComputeEngine0 Ring Busy",
                .symbol_name = "ComputeEngine0Busy",
                .desc = "The percentage of time when compute command streamer 0 was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__gpu_busyness__compute_engine0_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__gpu_busyness__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__gpu_busyness__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__gpu_busyness__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__gpu_busyness__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__gpu_busyness__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__gpu_busyness__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__gpu_busyness__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__gpu_busyness__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Render Ring Busy",
                .symbol_name = "RenderBusy",
                .desc = "The percentage of time when render command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__gpu_busyness__render_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = mtlgt2__gpu_busyness__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "XVE Active",
                .symbol_name = "XveActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__gpu_busyness__xve_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "XVE Stall",
                .symbol_name = "XveStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__gpu_busyness__xve_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "XVE Thread Occupancy",
                .symbol_name = "XveThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied XVEs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__gpu_busyness__xve_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 16);
}

static bool mtlgt2_hdc_and_sf_NonSamplerShader00AccessStalledOnL3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_hdc_and_sf_NonSamplerShader01AccessStalledOnL3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_hdc_and_sf_NonSamplerShader02AccessStalledOnL3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_hdc_and_sf_NonSamplerShader03AccessStalledOnL3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_hdc_and_sf_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set HDCAndSF";
    metric_set->symbol_name = "HDCAndSF";
    metric_set->hw_config_guid = "27d6eda4-aabc-4203-8848-aef69658ae74";
    metric_set->counters = calloc(13, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_hdc_and_sf_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__hdc_and_sf__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__hdc_and_sf__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "SQ00 is full",
                .symbol_name = "GTRequestQueue00Full",
                .desc = "The percentage of time when IDI0 SQ00 is filled above a threshold (usually 48 entries)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__hdc_and_sf__gt_request_queue00_full__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI",
            },

            {
                .name = "SQ01 is full",
                .symbol_name = "GTRequestQueue01Full",
                .desc = "The percentage of time when IDI0 SQ01 is filled above a threshold (usually 48 entries)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__hdc_and_sf__gt_request_queue01_full__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI",
            },

            {
                .name = "SQ10 is full",
                .symbol_name = "GTRequestQueue10Full",
                .desc = "The percentage of time when IDI0 SQ10 is filled above a threshold (usually 48 entries)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__hdc_and_sf__gt_request_queue10_full__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI",
            },

            {
                .name = "SQ11 is full",
                .symbol_name = "GTRequestQueue11Full",
                .desc = "The percentage of time when IDI0 SQ11 is filled above a threshold (usually 48 entries)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__hdc_and_sf__gt_request_queue11_full__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__hdc_and_sf__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__hdc_and_sf__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__hdc_and_sf__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "Slice0 Xe Core0 Non-sampler Shader Access Stalled On L3",
                .symbol_name = "NonSamplerShader00AccessStalledOnL3",
                .desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Xe Core0)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__hdc_and_sf__non_sampler_shader00_access_stalled_on_l3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Data Port",
                .availability = mtlgt2_hdc_and_sf_NonSamplerShader00AccessStalledOnL3_availability,
            },

            {
                .name = "Slice0 Xe Core1 Non-sampler Shader Access Stalled On L3",
                .symbol_name = "NonSamplerShader01AccessStalledOnL3",
                .desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Xe Core1)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__hdc_and_sf__non_sampler_shader01_access_stalled_on_l3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Data Port",
                .availability = mtlgt2_hdc_and_sf_NonSamplerShader01AccessStalledOnL3_availability,
            },

            {
                .name = "Slice0 Xe Core2 Non-sampler Shader Access Stalled On L3",
                .symbol_name = "NonSamplerShader02AccessStalledOnL3",
                .desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Xe Core2)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__hdc_and_sf__non_sampler_shader02_access_stalled_on_l3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Data Port",
                .availability = mtlgt2_hdc_and_sf_NonSamplerShader02AccessStalledOnL3_availability,
            },

            {
                .name = "Slice0 Xe Core3 Non-sampler Shader Access Stalled On L3",
                .symbol_name = "NonSamplerShader03AccessStalledOnL3",
                .desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Xe Core3)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__hdc_and_sf__non_sampler_shader03_access_stalled_on_l3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Data Port",
                .availability = mtlgt2_hdc_and_sf_NonSamplerShader03AccessStalledOnL3_availability,
            },

            {
                .name = "Polygon (Slice0) Data Ready",
                .symbol_name = "Poly0DataReady",
                .desc = "The percentage of time in which geometry pipeline output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__hdc_and_sf__poly0_data_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/3D Pipe/Strip-Fans",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 13);
}

static bool mtlgt2_l3_L3_INPUT_AVAILABLE_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_l3_L3_INPUT_AVAILABLE_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_l3_L3_INPUT_AVAILABLE_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_l3_L3_INPUT_AVAILABLE_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_l3_L3_OUTPUT_READY_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_l3_L3_OUTPUT_READY_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_l3_L3_OUTPUT_READY_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_l3_L3_OUTPUT_READY_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_l3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L3";
    metric_set->symbol_name = "L3";
    metric_set->hw_config_guid = "50b898ad-44ae-4d02-ba5b-a7d2a024a480";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_l3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__l3__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__l3__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__l3__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__l3__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__l3__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "L3 INPUT AVAILABLE L3BANK0",
                .symbol_name = "L3_INPUT_AVAILABLE_L3BANK0",
                .desc = "Percentage of time in which L3 Bank has input requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__l3__l3_input_available_l3_bank0__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_l3_L3_INPUT_AVAILABLE_L3BANK0_availability,
            },

            {
                .name = "L3 INPUT AVAILABLE L3BANK1",
                .symbol_name = "L3_INPUT_AVAILABLE_L3BANK1",
                .desc = "Percentage of time in which L3 Bank has input requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__l3__l3_input_available_l3_bank1__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_l3_L3_INPUT_AVAILABLE_L3BANK1_availability,
            },

            {
                .name = "L3 INPUT AVAILABLE L3BANK2",
                .symbol_name = "L3_INPUT_AVAILABLE_L3BANK2",
                .desc = "Percentage of time in which L3 Bank has input requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__l3__l3_input_available_l3_bank2__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_l3_L3_INPUT_AVAILABLE_L3BANK2_availability,
            },

            {
                .name = "L3 INPUT AVAILABLE L3BANK3",
                .symbol_name = "L3_INPUT_AVAILABLE_L3BANK3",
                .desc = "Percentage of time in which L3 Bank has input requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__l3__l3_input_available_l3_bank3__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_l3_L3_INPUT_AVAILABLE_L3BANK3_availability,
            },

            {
                .name = "L3 OUTPUT READY L3BANK0",
                .symbol_name = "L3_OUTPUT_READY_L3BANK0",
                .desc = "Percentage of time in which L3 Bank has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__l3__l3_output_ready_l3_bank0__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_l3_L3_OUTPUT_READY_L3BANK0_availability,
            },

            {
                .name = "L3 OUTPUT READY L3BANK1",
                .symbol_name = "L3_OUTPUT_READY_L3BANK1",
                .desc = "Percentage of time in which L3 Bank has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__l3__l3_output_ready_l3_bank1__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_l3_L3_OUTPUT_READY_L3BANK1_availability,
            },

            {
                .name = "L3 OUTPUT READY L3BANK2",
                .symbol_name = "L3_OUTPUT_READY_L3BANK2",
                .desc = "Percentage of time in which L3 Bank has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__l3__l3_output_ready_l3_bank2__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_l3_L3_OUTPUT_READY_L3BANK2_availability,
            },

            {
                .name = "L3 OUTPUT READY L3BANK3",
                .symbol_name = "L3_OUTPUT_READY_L3BANK3",
                .desc = "Percentage of time in which L3 Bank has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__l3__l3_output_ready_l3_bank3__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_l3_L3_OUTPUT_READY_L3BANK3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 12);
}

static bool mtlgt2_rasterizer_and_pixel_backend1_Rasterizer0OutputReady_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_rasterizer_and_pixel_backend1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set RasterizerAndPixelBackend1";
    metric_set->symbol_name = "RasterizerAndPixelBackend1";
    metric_set->hw_config_guid = "29adb364-f161-40cb-929d-c14036447c4f";
    metric_set->counters = calloc(9, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_rasterizer_and_pixel_backend1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__rasterizer_and_pixel_backend1__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__rasterizer_and_pixel_backend1__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__rasterizer_and_pixel_backend1__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__rasterizer_and_pixel_backend1__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__rasterizer_and_pixel_backend1__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "PS00 Output Available",
                .symbol_name = "PSOutput00Available",
                .desc = "The percentage of time in which PS00 output is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__rasterizer_and_pixel_backend1__ps_output00_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/3D Pipe",
            },

            {
                .name = "Slice0 Pipe0 Post-EarlyZ Pixel Data Ready",
                .symbol_name = "PixelData00Ready",
                .desc = "The percentage of time in which slice0  pipe0 post-EarlyZ pixel data is ready (after early Z tests have been applied)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__rasterizer_and_pixel_backend1__pixel_data00_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Rasterizer/Early Depth Test",
            },

            {
                .name = "Slice0 Pipe1 Post-EarlyZ Pixel Data Ready",
                .symbol_name = "PixelData01Ready",
                .desc = "The percentage of time in which slice0  pipe1 post-EarlyZ pixel data is ready (after early Z tests have been applied)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__rasterizer_and_pixel_backend1__pixel_data01_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Rasterizer/Early Depth Test",
            },

            {
                .name = "Pixel Values 00 Ready",
                .symbol_name = "PixelValues00Ready",
                .desc = "The percentage of time in which pixel values 00 are ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__rasterizer_and_pixel_backend1__pixel_values00_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/3D Pipe",
            },

            {
                .name = "Slice0 Rasterizer Output Ready",
                .symbol_name = "Rasterizer0OutputReady",
                .desc = "The percentage of time in which slice0 rasterizer output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__rasterizer_and_pixel_backend1__rasterizer0_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Rasterizer",
                .availability = mtlgt2_rasterizer_and_pixel_backend1_Rasterizer0OutputReady_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 9);
}

static bool mtlgt2_rasterizer_and_pixel_backend2_Rasterizer0InputAvailable_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_rasterizer_and_pixel_backend2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set RasterizerAndPixelBackend2";
    metric_set->symbol_name = "RasterizerAndPixelBackend2";
    metric_set->hw_config_guid = "787c682f-68be-4a64-b998-77d8a30b4ea6";
    metric_set->counters = calloc(9, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_rasterizer_and_pixel_backend2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__rasterizer_and_pixel_backend2__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__rasterizer_and_pixel_backend2__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__rasterizer_and_pixel_backend2__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__rasterizer_and_pixel_backend2__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__rasterizer_and_pixel_backend2__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "PS00 Output Available",
                .symbol_name = "PSOutput00Available",
                .desc = "The percentage of time in which PS00 output is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__rasterizer_and_pixel_backend2__ps_output00_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/3D Pipe",
            },

            {
                .name = "Slice0 Pipe0 Post-EarlyZ Pixel Data Ready",
                .symbol_name = "PixelData00Ready",
                .desc = "The percentage of time in which slice0  pipe0 post-EarlyZ pixel data is ready (after early Z tests have been applied)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__rasterizer_and_pixel_backend2__pixel_data00_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Rasterizer/Early Depth Test",
            },

            {
                .name = "Slice0 Pipe1 Post-EarlyZ Pixel Data Ready",
                .symbol_name = "PixelData01Ready",
                .desc = "The percentage of time in which slice0  pipe1 post-EarlyZ pixel data is ready (after early Z tests have been applied)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__rasterizer_and_pixel_backend2__pixel_data01_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Rasterizer/Early Depth Test",
            },

            {
                .name = "Pixel Values 00 Ready",
                .symbol_name = "PixelValues00Ready",
                .desc = "The percentage of time in which pixel values 00 are ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__rasterizer_and_pixel_backend2__pixel_values00_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/3D Pipe",
            },

            {
                .name = "Slice0 Rasterizer Input Available",
                .symbol_name = "Rasterizer0InputAvailable",
                .desc = "The percentage of time in which slice0 rasterizer input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__rasterizer_and_pixel_backend2__rasterizer0_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Rasterizer",
                .availability = mtlgt2_rasterizer_and_pixel_backend2_Rasterizer0InputAvailable_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 9);
}


static void
mtlgt2_add_render_pipe_profile_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics for 3D Pipeline Profile";
    metric_set->symbol_name = "RenderPipeProfile";
    metric_set->hw_config_guid = "1269ddfd-22a6-47ca-9a1a-dc37b8c38490";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_render_pipe_profile_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__render_pipe_profile__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__render_pipe_profile__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "BC00 Bottleneck",
                .symbol_name = "Bc00Bottleneck",
                .desc = "The percentage of time in which barycentric coordinates calculation pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_pipe_profile__bc00_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Rasterizer/Barycentric Calc",
            },

            {
                .name = "Clipper0 Bottleneck",
                .symbol_name = "Cl0Bottleneck",
                .desc = "The percentage of time in which clipper pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_pipe_profile__cl0_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Clipper",
            },

            {
                .name = "CL0 Stall",
                .symbol_name = "Cl0Stall",
                .desc = "The percentage of time in which clipper pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_pipe_profile__cl0_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Clipper",
            },

            {
                .name = "DS0 Bottleneck",
                .symbol_name = "Ds0Bottleneck",
                .desc = "The percentage of time in which domain shader pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_pipe_profile__ds0_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Domain Shader",
            },

            {
                .name = "DS0 Stall",
                .symbol_name = "Ds0Stall",
                .desc = "The percentage of time in which domain shader pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_pipe_profile__ds0_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Domain Shader",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_pipe_profile__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__render_pipe_profile__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__render_pipe_profile__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS0 Bottleneck",
                .symbol_name = "Gs0Bottleneck",
                .desc = "The percentage of time in which geometry shader pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_pipe_profile__gs0_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Geometry Shader",
            },

            {
                .name = "Hi-Depth00 Bottleneck",
                .symbol_name = "HiDepth00Bottleneck",
                .desc = "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_pipe_profile__hi_depth00_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "Hi-Depth01 Bottleneck",
                .symbol_name = "HiDepth01Bottleneck",
                .desc = "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_pipe_profile__hi_depth01_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS0 Bottleneck",
                .symbol_name = "Hs0Bottleneck",
                .desc = "The percentage of time in which hull shader pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_pipe_profile__hs0_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Hull Shader",
            },

            {
                .name = "HS0 Stall",
                .symbol_name = "Hs0Stall",
                .desc = "The percentage of time in which hull stall pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_pipe_profile__hs0_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Hull Shader",
            },

            {
                .name = "SF0 Bottleneck",
                .symbol_name = "Sf0Bottleneck",
                .desc = "The percentage of time in which strip-fans pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_pipe_profile__sf0_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Rasterizer/Strip-Fans",
            },

            {
                .name = "SF0 Stall",
                .symbol_name = "Sf0Stall",
                .desc = "The percentage of time in which strip-fans pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_pipe_profile__sf0_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Rasterizer/Strip-Fans",
            },

            {
                .name = "SO0 Bottleneck",
                .symbol_name = "So0Bottleneck",
                .desc = "The percentage of time in which stream output pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_pipe_profile__so0_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Stream Output",
            },

            {
                .name = "SO0 Stall",
                .symbol_name = "So0Stall",
                .desc = "The percentage of time in which stream-output pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_pipe_profile__so0_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Stream Output",
            },

            {
                .name = "VF0 Bottleneck",
                .symbol_name = "Vf0Bottleneck",
                .desc = "The percentage of time in which vertex fetch pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_pipe_profile__vf0_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Input Assembler",
            },

            {
                .name = "VS0 Bottleneck",
                .symbol_name = "Vs0Bottleneck",
                .desc = "The percentage of time in which VS0 pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__render_pipe_profile__vs0_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 20);
}

static bool mtlgt2_sampler_Sampler00InputAvailable_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_sampler_Sampler00OutputReady_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_sampler_Sampler01InputAvailable_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_sampler_Sampler01OutputReady_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_sampler_Sampler02InputAvailable_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_sampler_Sampler02OutputReady_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_sampler_Sampler03InputAvailable_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_sampler_Sampler03OutputReady_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_sampler_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Sampler_Slice0";
    metric_set->symbol_name = "Sampler";
    metric_set->hw_config_guid = "3c304c3b-9ada-4d92-9b54-34ec4e70aea6";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_sampler_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__sampler__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__sampler__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__sampler__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__sampler__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__sampler__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "Slice0 Xe Core0 Input Available",
                .symbol_name = "Sampler00InputAvailable",
                .desc = "The percentage of time in which slice0 Xe core0 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__sampler__sampler00_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = mtlgt2_sampler_Sampler00InputAvailable_availability,
            },

            {
                .name = "Slice0 Xe Core0 Sampler Output Ready",
                .symbol_name = "Sampler00OutputReady",
                .desc = "The percentage of time in which slice0 Xe core0 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__sampler__sampler00_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = mtlgt2_sampler_Sampler00OutputReady_availability,
            },

            {
                .name = "Slice0 Xe Core1 Input Available",
                .symbol_name = "Sampler01InputAvailable",
                .desc = "The percentage of time in which slice0 Xe core1 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__sampler__sampler01_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = mtlgt2_sampler_Sampler01InputAvailable_availability,
            },

            {
                .name = "Slice0 Xe Core1 Sampler Output Ready",
                .symbol_name = "Sampler01OutputReady",
                .desc = "The percentage of time in which slice0 Xe core1 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__sampler__sampler01_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = mtlgt2_sampler_Sampler01OutputReady_availability,
            },

            {
                .name = "Slice0 Xe Core2 Input Available",
                .symbol_name = "Sampler02InputAvailable",
                .desc = "The percentage of time in which slice0 Xe core2 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__sampler__sampler02_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = mtlgt2_sampler_Sampler02InputAvailable_availability,
            },

            {
                .name = "Slice0 Xe Core2 Sampler Output Ready",
                .symbol_name = "Sampler02OutputReady",
                .desc = "The percentage of time in which slice0 Xe core2 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__sampler__sampler02_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = mtlgt2_sampler_Sampler02OutputReady_availability,
            },

            {
                .name = "Slice0 Xe Core3 Input Available",
                .symbol_name = "Sampler03InputAvailable",
                .desc = "The percentage of time in which slice0 Xe core3 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__sampler__sampler03_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = mtlgt2_sampler_Sampler03InputAvailable_availability,
            },

            {
                .name = "Slice0 Xe Core3 Sampler Output Ready",
                .symbol_name = "Sampler03OutputReady",
                .desc = "The percentage of time in which slice0 Xe core3 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__sampler__sampler03_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = mtlgt2_sampler_Sampler03OutputReady_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 12);
}

static bool mtlgt2_tdl1_NonPSThread00ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_tdl1_NonPSThread01ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_tdl1_PSThread00ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_tdl1_PSThread01ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_tdl1_ThreadHeader00Ready_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_tdl1_ThreadHeader00ReadyPort0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_tdl1_ThreadHeader00ReadyPort1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_tdl1_ThreadHeader00ReadyPort2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_tdl1_ThreadHeader00ReadyPort3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_tdl1_ThreadHeader01Ready_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_tdl1_ThreadHeader01ReadyPort0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_tdl1_ThreadHeader01ReadyPort1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_tdl1_ThreadHeader01ReadyPort2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_tdl1_ThreadHeader01ReadyPort3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_tdl1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL1";
    metric_set->symbol_name = "TDL1";
    metric_set->hw_config_guid = "616fc1b0-53bb-4411-93b0-b34ab2b0bfb8";
    metric_set->counters = calloc(18, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_tdl1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__tdl1__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__tdl1__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl1__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__tdl1__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__tdl1__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "Non-PS Thread Ready For Dispatch on Slice0 Xe Core0 Thread Dispatcher",
                .symbol_name = "NonPSThread00ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 Xe core0 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl1__non_ps_thread00_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl1_NonPSThread00ReadyForDispatch_availability,
            },

            {
                .name = "Non-PS Thread Ready For Dispatch on Slice0 Xe Core1 Thread Dispatcher",
                .symbol_name = "NonPSThread01ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 Xe core1 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl1__non_ps_thread01_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl1_NonPSThread01ReadyForDispatch_availability,
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice0 Xe Core0 Thread Dispatcher",
                .symbol_name = "PSThread00ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice0 Xe core0 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl1__ps_thread00_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl1_PSThread00ReadyForDispatch_availability,
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice0 Xe Core1 Thread Dispatcher",
                .symbol_name = "PSThread01ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice0 Xe core1 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl1__ps_thread01_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl1_PSThread01ReadyForDispatch_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Xe Core0 Thread Dispatcher",
                .symbol_name = "ThreadHeader00Ready",
                .desc = "The percentage of time in which thread header is ready on slice0 Xe core0 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl1__thread_header00_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl1_ThreadHeader00Ready_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Xe Core0 Thread Dispatcher Port 0",
                .symbol_name = "ThreadHeader00ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice0 Xe core0 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl1__thread_header00_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl1_ThreadHeader00ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Xe Core0 Thread Dispatcher Port 1",
                .symbol_name = "ThreadHeader00ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice0 Xe core0 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl1__thread_header00_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl1_ThreadHeader00ReadyPort1_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Xe Core0 Thread Dispatcher Port 2",
                .symbol_name = "ThreadHeader00ReadyPort2",
                .desc = "The percentage of time in which thread header is ready on slice0 Xe core0 thread dispatcher port 2",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl1__thread_header00_ready_port2__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl1_ThreadHeader00ReadyPort2_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Xe Core0 Thread Dispatcher Port 3",
                .symbol_name = "ThreadHeader00ReadyPort3",
                .desc = "The percentage of time in which thread header is ready on slice0 Xe core0 thread dispatcher port 3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl1__thread_header00_ready_port3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl1_ThreadHeader00ReadyPort3_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Xe Core1 Thread Dispatcher",
                .symbol_name = "ThreadHeader01Ready",
                .desc = "The percentage of time in which thread header is ready on slice0 Xe core1 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl1__thread_header01_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl1_ThreadHeader01Ready_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Xe Core1 Thread Dispatcher Port 0",
                .symbol_name = "ThreadHeader01ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice0 Xe core1 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl1__thread_header01_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl1_ThreadHeader01ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Xe Core1 Thread Dispatcher Port 1",
                .symbol_name = "ThreadHeader01ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice0 Xe core1 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl1__thread_header01_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl1_ThreadHeader01ReadyPort1_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Xe Core1 Thread Dispatcher Port 2",
                .symbol_name = "ThreadHeader01ReadyPort2",
                .desc = "The percentage of time in which thread header is ready on slice0 Xe core1 thread dispatcher port 2",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl1__thread_header01_ready_port2__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl1_ThreadHeader01ReadyPort2_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Xe Core1 Thread Dispatcher Port 3",
                .symbol_name = "ThreadHeader01ReadyPort3",
                .desc = "The percentage of time in which thread header is ready on slice0 Xe core1 thread dispatcher port 3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl1__thread_header01_ready_port3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl1_ThreadHeader01ReadyPort3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 18);
}

static bool mtlgt2_tdl2_NonPSThread02ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_tdl2_NonPSThread03ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_tdl2_PSThread02ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_tdl2_PSThread03ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_tdl2_ThreadHeader02Ready_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_tdl2_ThreadHeader02ReadyPort0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_tdl2_ThreadHeader02ReadyPort1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_tdl2_ThreadHeader02ReadyPort2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_tdl2_ThreadHeader02ReadyPort3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_tdl2_ThreadHeader03Ready_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_tdl2_ThreadHeader03ReadyPort0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_tdl2_ThreadHeader03ReadyPort1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_tdl2_ThreadHeader03ReadyPort2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_tdl2_ThreadHeader03ReadyPort3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_tdl2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL2";
    metric_set->symbol_name = "TDL2";
    metric_set->hw_config_guid = "952fa513-550e-49bc-a355-22fadbea5455";
    metric_set->counters = calloc(18, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_tdl2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__tdl2__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__tdl2__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl2__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__tdl2__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__tdl2__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "Non-PS Thread Ready For Dispatch on Slice0 Xe Core2 Thread Dispatcher",
                .symbol_name = "NonPSThread02ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 Xe core2 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl2__non_ps_thread02_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl2_NonPSThread02ReadyForDispatch_availability,
            },

            {
                .name = "Non-PS Thread Ready For Dispatch on Slice0 Xe Core3 Thread Dispatcher",
                .symbol_name = "NonPSThread03ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 Xe core3 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl2__non_ps_thread03_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl2_NonPSThread03ReadyForDispatch_availability,
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice0 Xe Core2 Thread Dispatcher",
                .symbol_name = "PSThread02ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice0 Xe core2 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl2__ps_thread02_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl2_PSThread02ReadyForDispatch_availability,
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice0 Xe Core3 Thread Dispatcher",
                .symbol_name = "PSThread03ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice0 Xe core3 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl2__ps_thread03_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl2_PSThread03ReadyForDispatch_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Xe Core2 Thread Dispatcher",
                .symbol_name = "ThreadHeader02Ready",
                .desc = "The percentage of time in which thread header is ready on slice0 Xe core2 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl2__thread_header02_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl2_ThreadHeader02Ready_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Xe Core2 Thread Dispatcher Port 0",
                .symbol_name = "ThreadHeader02ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice0 Xe core2 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl2__thread_header02_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl2_ThreadHeader02ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Xe Core2 Thread Dispatcher Port 1",
                .symbol_name = "ThreadHeader02ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice0 Xe core2 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl2__thread_header02_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl2_ThreadHeader02ReadyPort1_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Xe Core2 Thread Dispatcher Port 2",
                .symbol_name = "ThreadHeader02ReadyPort2",
                .desc = "The percentage of time in which thread header is ready on slice0 Xe core2 thread dispatcher port 2",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl2__thread_header02_ready_port2__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl2_ThreadHeader02ReadyPort2_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Xe Core2 Thread Dispatcher Port 3",
                .symbol_name = "ThreadHeader02ReadyPort3",
                .desc = "The percentage of time in which thread header is ready on slice0 Xe core2 thread dispatcher port 3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl2__thread_header02_ready_port3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl2_ThreadHeader02ReadyPort3_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Xe Core3 Thread Dispatcher",
                .symbol_name = "ThreadHeader03Ready",
                .desc = "The percentage of time in which thread header is ready on slice0 Xe core3 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl2__thread_header03_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl2_ThreadHeader03Ready_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Xe Core3 Thread Dispatcher Port 0",
                .symbol_name = "ThreadHeader03ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice0 Xe core3 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl2__thread_header03_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl2_ThreadHeader03ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Xe Core3 Thread Dispatcher Port 1",
                .symbol_name = "ThreadHeader03ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice0 Xe core3 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl2__thread_header03_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl2_ThreadHeader03ReadyPort1_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Xe Core3 Thread Dispatcher Port 2",
                .symbol_name = "ThreadHeader03ReadyPort2",
                .desc = "The percentage of time in which thread header is ready on slice0 Xe core3 thread dispatcher port 2",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl2__thread_header03_ready_port2__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl2_ThreadHeader03ReadyPort2_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Xe Core3 Thread Dispatcher Port 3",
                .symbol_name = "ThreadHeader03ReadyPort3",
                .desc = "The percentage of time in which thread header is ready on slice0 Xe core3 thread dispatcher port 3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__tdl2__thread_header03_ready_port3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = mtlgt2_tdl2_ThreadHeader03ReadyPort3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 18);
}


static void
mtlgt2_add_test_oa_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set TestOa";
    metric_set->symbol_name = "TestOa";
    metric_set->hw_config_guid = "d0ed8afd-ad64-4774-8788-1a15f4ab7829";
    metric_set->counters = calloc(13, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_test_oa_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__test_oa__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__test_oa__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "TestCounter0",
                .symbol_name = "Counter0",
                .desc = "HW test counter 0. Factor: 0.0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__test_oa__counter0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter1",
                .symbol_name = "Counter1",
                .desc = "HW test counter 1. Factor: 1.0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__test_oa__counter1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter2",
                .symbol_name = "Counter2",
                .desc = "HW test counter 2. Factor: 1.0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__test_oa__counter2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter3",
                .symbol_name = "Counter3",
                .desc = "HW test counter 3. Factor: 0.5",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__test_oa__counter3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter4",
                .symbol_name = "Counter4",
                .desc = "HW test counter 4. Factor: 0.3333",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__test_oa__counter4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter5",
                .symbol_name = "Counter5",
                .desc = "HW test counter 5. Factor: 0.3333",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__test_oa__counter5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter6",
                .symbol_name = "Counter6",
                .desc = "HW test counter 6. Factor: 0.16666",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__test_oa__counter6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter7",
                .symbol_name = "Counter7",
                .desc = "HW test counter 7. Factor: 0.6666",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__test_oa__counter7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter8",
                .symbol_name = "Counter8",
                .desc = "HW test counter 8. Should be equal to 1 in IOStream or in OAG query mode",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__test_oa__counter8__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter9 - OAR enable",
                .symbol_name = "Counter9",
                .desc = "HW test counter 9. Should be equal to 1 in query.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__test_oa__counter9__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__test_oa__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__test_oa__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 13);
}


static void
mtlgt2_add_ext1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext1";
    metric_set->symbol_name = "Ext1";
    metric_set->hw_config_guid = "fc82db3d-d6a7-413a-8349-b31f02251d2f";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext1__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext1__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY ACTIVE SQIDI0",
                .symbol_name = "GPU_MEMORY_ACTIVE_SQIDI0",
                .desc = "Percentage of time in which device local memory (HBM, GDDR, LPDDR, etc.) is active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext1__gpu_memory_active_sqidi0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY ACTIVE SQIDI1",
                .symbol_name = "GPU_MEMORY_ACTIVE_SQIDI1",
                .desc = "Percentage of time in which device local memory (HBM, GDDR, LPDDR, etc.) is active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext1__gpu_memory_active_sqidi1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY BYTE READ BW SQIDI0",
                .symbol_name = "GPU_MEMORY_BYTE_READ_BW_SQIDI0",
                .desc = "Device local memory (HBM, GDDR, LPDDR, etc.) read bandwidth",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS,
                .read_float = mtlgt2__ext1__gpu_memory_byte_read_bw_sqidi0__read,
                .max_float = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY BYTE READ BW SQIDI1",
                .symbol_name = "GPU_MEMORY_BYTE_READ_BW_SQIDI1",
                .desc = "Device local memory (HBM, GDDR, LPDDR, etc.) read bandwidth",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS,
                .read_float = mtlgt2__ext1__gpu_memory_byte_read_bw_sqidi1__read,
                .max_float = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY BYTE READ SQIDI0",
                .symbol_name = "GPU_MEMORY_BYTE_READ_SQIDI0",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext1__gpu_memory_byte_read_sqidi0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY BYTE READ SQIDI1",
                .symbol_name = "GPU_MEMORY_BYTE_READ_SQIDI1",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext1__gpu_memory_byte_read_sqidi1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY BYTE WRITE BW SQIDI0",
                .symbol_name = "GPU_MEMORY_BYTE_WRITE_BW_SQIDI0",
                .desc = "Device local memory (HBM, GDDR, LPDDR, etc.) write bandwidth",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS,
                .read_float = mtlgt2__ext1__gpu_memory_byte_write_bw_sqidi0__read,
                .max_float = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY BYTE WRITE BW SQIDI1",
                .symbol_name = "GPU_MEMORY_BYTE_WRITE_BW_SQIDI1",
                .desc = "Device local memory (HBM, GDDR, LPDDR, etc.) write bandwidth",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS,
                .read_float = mtlgt2__ext1__gpu_memory_byte_write_bw_sqidi1__read,
                .max_float = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY BYTE WRITE SQIDI0",
                .symbol_name = "GPU_MEMORY_BYTE_WRITE_SQIDI0",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext1__gpu_memory_byte_write_sqidi0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY BYTE WRITE SQIDI1",
                .symbol_name = "GPU_MEMORY_BYTE_WRITE_SQIDI1",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext1__gpu_memory_byte_write_sqidi1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY READ",
                .symbol_name = "GPU_MEMORY_READ",
                .desc = "Number of GTI memory reads",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext1__gpu_memory_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY READ SQIDI0",
                .symbol_name = "GPU_MEMORY_READ_SQIDI0",
                .desc = "Number of GTI memory reads",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext1__gpu_memory_read_sqidi0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY READ SQIDI1",
                .symbol_name = "GPU_MEMORY_READ_SQIDI1",
                .desc = "Number of GTI memory reads",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext1__gpu_memory_read_sqidi1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY WRITE",
                .symbol_name = "GPU_MEMORY_WRITE",
                .desc = "Number of GTI memory writes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext1__gpu_memory_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY WRITE SQIDI0",
                .symbol_name = "GPU_MEMORY_WRITE_SQIDI0",
                .desc = "Number of GTI memory writes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext1__gpu_memory_write_sqidi0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY WRITE SQIDI1",
                .symbol_name = "GPU_MEMORY_WRITE_SQIDI1",
                .desc = "Number of GTI memory writes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext1__gpu_memory_write_sqidi1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext1__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext1__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 19);
}

static bool mtlgt2_ext4_L3_READ_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext4_L3_READ_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext4_L3_READ_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext4_L3_READ_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext4_L3_WRITE_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext4_L3_WRITE_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext4_L3_WRITE_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext4_L3_WRITE_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext4_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext4";
    metric_set->symbol_name = "Ext4";
    metric_set->hw_config_guid = "3479a81d-9017-4930-af0c-14f7fabadb38";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext4_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext4__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext4__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext4__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext4__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "L3 READ L3BANK0",
                .symbol_name = "L3_READ_L3BANK0",
                .desc = "Number of L3 read requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext4__l3_read_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext4_L3_READ_L3BANK0_availability,
            },

            {
                .name = "L3 READ L3BANK1",
                .symbol_name = "L3_READ_L3BANK1",
                .desc = "Number of L3 read requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext4__l3_read_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext4_L3_READ_L3BANK1_availability,
            },

            {
                .name = "L3 READ L3BANK2",
                .symbol_name = "L3_READ_L3BANK2",
                .desc = "Number of L3 read requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext4__l3_read_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext4_L3_READ_L3BANK2_availability,
            },

            {
                .name = "L3 READ L3BANK3",
                .symbol_name = "L3_READ_L3BANK3",
                .desc = "Number of L3 read requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext4__l3_read_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext4_L3_READ_L3BANK3_availability,
            },

            {
                .name = "L3 WRITE L3BANK0",
                .symbol_name = "L3_WRITE_L3BANK0",
                .desc = "Number of L3 write requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext4__l3_write_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext4_L3_WRITE_L3BANK0_availability,
            },

            {
                .name = "L3 WRITE L3BANK1",
                .symbol_name = "L3_WRITE_L3BANK1",
                .desc = "Number of L3 write requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext4__l3_write_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext4_L3_WRITE_L3BANK1_availability,
            },

            {
                .name = "L3 WRITE L3BANK2",
                .symbol_name = "L3_WRITE_L3BANK2",
                .desc = "Number of L3 write requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext4__l3_write_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext4_L3_WRITE_L3BANK2_availability,
            },

            {
                .name = "L3 WRITE L3BANK3",
                .symbol_name = "L3_WRITE_L3BANK3",
                .desc = "Number of L3 write requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext4__l3_write_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext4_L3_WRITE_L3BANK3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}

static bool mtlgt2_ext5_DATAPORT_L3_READ_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext5_DATAPORT_L3_READ_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext5_DATAPORT_L3_READ_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext5_DATAPORT_L3_READ_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext5_DATAPORT_L3_WRITE_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext5_DATAPORT_L3_WRITE_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext5_DATAPORT_L3_WRITE_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext5_DATAPORT_L3_WRITE_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext5_L3_HIT_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext5_L3_HIT_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext5_L3_HIT_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext5_L3_HIT_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext5_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext5";
    metric_set->symbol_name = "Ext5";
    metric_set->hw_config_guid = "e4701256-cd06-48f7-a005-d4d1f9e895c1";
    metric_set->counters = calloc(15, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext5_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext5__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext5__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "DATAPORT L3 READ L3BANK0",
                .symbol_name = "DATAPORT_L3_READ_L3BANK0",
                .desc = "Number of L3 read requests coming from XVE via Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext5__dataport_l3_read_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext5_DATAPORT_L3_READ_L3BANK0_availability,
            },

            {
                .name = "DATAPORT L3 READ L3BANK1",
                .symbol_name = "DATAPORT_L3_READ_L3BANK1",
                .desc = "Number of L3 read requests coming from XVE via Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext5__dataport_l3_read_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext5_DATAPORT_L3_READ_L3BANK1_availability,
            },

            {
                .name = "DATAPORT L3 READ L3BANK2",
                .symbol_name = "DATAPORT_L3_READ_L3BANK2",
                .desc = "Number of L3 read requests coming from XVE via Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext5__dataport_l3_read_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext5_DATAPORT_L3_READ_L3BANK2_availability,
            },

            {
                .name = "DATAPORT L3 READ L3BANK3",
                .symbol_name = "DATAPORT_L3_READ_L3BANK3",
                .desc = "Number of L3 read requests coming from XVE via Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext5__dataport_l3_read_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext5_DATAPORT_L3_READ_L3BANK3_availability,
            },

            {
                .name = "DATAPORT L3 WRITE L3BANK0",
                .symbol_name = "DATAPORT_L3_WRITE_L3BANK0",
                .desc = "Number of L3 write requests coming from XVE via Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext5__dataport_l3_write_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext5_DATAPORT_L3_WRITE_L3BANK0_availability,
            },

            {
                .name = "DATAPORT L3 WRITE L3BANK1",
                .symbol_name = "DATAPORT_L3_WRITE_L3BANK1",
                .desc = "Number of L3 write requests coming from XVE via Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext5__dataport_l3_write_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext5_DATAPORT_L3_WRITE_L3BANK1_availability,
            },

            {
                .name = "DATAPORT L3 WRITE L3BANK2",
                .symbol_name = "DATAPORT_L3_WRITE_L3BANK2",
                .desc = "Number of L3 write requests coming from XVE via Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext5__dataport_l3_write_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext5_DATAPORT_L3_WRITE_L3BANK2_availability,
            },

            {
                .name = "DATAPORT L3 WRITE L3BANK3",
                .symbol_name = "DATAPORT_L3_WRITE_L3BANK3",
                .desc = "Number of L3 write requests coming from XVE via Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext5__dataport_l3_write_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext5_DATAPORT_L3_WRITE_L3BANK3_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext5__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext5__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "L3 HIT L3BANK0",
                .symbol_name = "L3_HIT_L3BANK0",
                .desc = "Number of L3 accesses which hits in the L3 cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext5__l3_hit_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext5_L3_HIT_L3BANK0_availability,
            },

            {
                .name = "L3 HIT L3BANK1",
                .symbol_name = "L3_HIT_L3BANK1",
                .desc = "Number of L3 accesses which hits in the L3 cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext5__l3_hit_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext5_L3_HIT_L3BANK1_availability,
            },

            {
                .name = "L3 HIT L3BANK2",
                .symbol_name = "L3_HIT_L3BANK2",
                .desc = "Number of L3 accesses which hits in the L3 cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext5__l3_hit_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext5_L3_HIT_L3BANK2_availability,
            },

            {
                .name = "L3 HIT L3BANK3",
                .symbol_name = "L3_HIT_L3BANK3",
                .desc = "Number of L3 accesses which hits in the L3 cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext5__l3_hit_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext5_L3_HIT_L3BANK3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 15);
}

static bool mtlgt2_ext7_SAMPLER_BUSY_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext7_SAMPLER_BUSY_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext7_SAMPLER_BUSY_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext7_SAMPLER_BUSY_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext7_SAMPLER_L3_HIT_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext7_SAMPLER_L3_HIT_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext7_SAMPLER_L3_HIT_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext7_SAMPLER_L3_HIT_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext7_SAMPLER_L3_READ_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext7_SAMPLER_L3_READ_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext7_SAMPLER_L3_READ_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext7_SAMPLER_L3_READ_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext7_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext7";
    metric_set->symbol_name = "Ext7";
    metric_set->hw_config_guid = "3e47d0e8-5414-4496-8746-37e36fefc777";
    metric_set->counters = calloc(15, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext7_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext7__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext7__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext7__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext7__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "SAMPLER BUSY XECORE0",
                .symbol_name = "SAMPLER_BUSY_XECORE0",
                .desc = "Percentage of time in which Sampler pipeline active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext7__sampler_busy_xecore0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext7_SAMPLER_BUSY_XECORE0_availability,
            },

            {
                .name = "SAMPLER BUSY XECORE1",
                .symbol_name = "SAMPLER_BUSY_XECORE1",
                .desc = "Percentage of time in which Sampler pipeline active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext7__sampler_busy_xecore1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext7_SAMPLER_BUSY_XECORE1_availability,
            },

            {
                .name = "SAMPLER BUSY XECORE2",
                .symbol_name = "SAMPLER_BUSY_XECORE2",
                .desc = "Percentage of time in which Sampler pipeline active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext7__sampler_busy_xecore2__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext7_SAMPLER_BUSY_XECORE2_availability,
            },

            {
                .name = "SAMPLER BUSY XECORE3",
                .symbol_name = "SAMPLER_BUSY_XECORE3",
                .desc = "Percentage of time in which Sampler pipeline active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext7__sampler_busy_xecore3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext7_SAMPLER_BUSY_XECORE3_availability,
            },

            {
                .name = "SAMPLER L3 HIT L3BANK0",
                .symbol_name = "SAMPLER_L3_HIT_L3BANK0",
                .desc = "Number of L3 hit requests resulting from Sampler local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext7__sampler_l3_hit_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext7_SAMPLER_L3_HIT_L3BANK0_availability,
            },

            {
                .name = "SAMPLER L3 HIT L3BANK1",
                .symbol_name = "SAMPLER_L3_HIT_L3BANK1",
                .desc = "Number of L3 hit requests resulting from Sampler local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext7__sampler_l3_hit_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext7_SAMPLER_L3_HIT_L3BANK1_availability,
            },

            {
                .name = "SAMPLER L3 HIT L3BANK2",
                .symbol_name = "SAMPLER_L3_HIT_L3BANK2",
                .desc = "Number of L3 hit requests resulting from Sampler local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext7__sampler_l3_hit_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext7_SAMPLER_L3_HIT_L3BANK2_availability,
            },

            {
                .name = "SAMPLER L3 HIT L3BANK3",
                .symbol_name = "SAMPLER_L3_HIT_L3BANK3",
                .desc = "Number of L3 hit requests resulting from Sampler local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext7__sampler_l3_hit_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext7_SAMPLER_L3_HIT_L3BANK3_availability,
            },

            {
                .name = "SAMPLER L3 READ L3BANK0",
                .symbol_name = "SAMPLER_L3_READ_L3BANK0",
                .desc = "Number of L3 read requests resulting from Sampler local cache miss",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext7__sampler_l3_read_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext7_SAMPLER_L3_READ_L3BANK0_availability,
            },

            {
                .name = "SAMPLER L3 READ L3BANK1",
                .symbol_name = "SAMPLER_L3_READ_L3BANK1",
                .desc = "Number of L3 read requests resulting from Sampler local cache miss",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext7__sampler_l3_read_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext7_SAMPLER_L3_READ_L3BANK1_availability,
            },

            {
                .name = "SAMPLER L3 READ L3BANK2",
                .symbol_name = "SAMPLER_L3_READ_L3BANK2",
                .desc = "Number of L3 read requests resulting from Sampler local cache miss",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext7__sampler_l3_read_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext7_SAMPLER_L3_READ_L3BANK2_availability,
            },

            {
                .name = "SAMPLER L3 READ L3BANK3",
                .symbol_name = "SAMPLER_L3_READ_L3BANK3",
                .desc = "Number of L3 read requests resulting from Sampler local cache miss",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext7__sampler_l3_read_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext7_SAMPLER_L3_READ_L3BANK3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 15);
}

static bool mtlgt2_ext8_ICACHE_L3_HIT_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext8_ICACHE_L3_HIT_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext8_ICACHE_L3_HIT_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext8_ICACHE_L3_HIT_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext8_ICACHE_L3_READ_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext8_ICACHE_L3_READ_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext8_ICACHE_L3_READ_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext8_ICACHE_L3_READ_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext8_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext8";
    metric_set->symbol_name = "Ext8";
    metric_set->hw_config_guid = "5aa36c1f-c6da-45ab-ab21-397d9a4b6a06";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext8_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext8__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext8__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext8__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext8__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "ICACHE L3 HIT L3BANK0",
                .symbol_name = "ICACHE_L3_HIT_L3BANK0",
                .desc = "Number of XVE instruction cache requests that hit the L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext8__icache_l3_hit_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext8_ICACHE_L3_HIT_L3BANK0_availability,
            },

            {
                .name = "ICACHE L3 HIT L3BANK1",
                .symbol_name = "ICACHE_L3_HIT_L3BANK1",
                .desc = "Number of XVE instruction cache requests that hit the L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext8__icache_l3_hit_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext8_ICACHE_L3_HIT_L3BANK1_availability,
            },

            {
                .name = "ICACHE L3 HIT L3BANK2",
                .symbol_name = "ICACHE_L3_HIT_L3BANK2",
                .desc = "Number of XVE instruction cache requests that hit the L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext8__icache_l3_hit_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext8_ICACHE_L3_HIT_L3BANK2_availability,
            },

            {
                .name = "ICACHE L3 HIT L3BANK3",
                .symbol_name = "ICACHE_L3_HIT_L3BANK3",
                .desc = "Number of XVE instruction cache requests that hit the L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext8__icache_l3_hit_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext8_ICACHE_L3_HIT_L3BANK3_availability,
            },

            {
                .name = "ICACHE L3 READ L3BANK0",
                .symbol_name = "ICACHE_L3_READ_L3BANK0",
                .desc = "Number of L3 read requests coming from XVE Instruction Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext8__icache_l3_read_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext8_ICACHE_L3_READ_L3BANK0_availability,
            },

            {
                .name = "ICACHE L3 READ L3BANK1",
                .symbol_name = "ICACHE_L3_READ_L3BANK1",
                .desc = "Number of L3 read requests coming from XVE Instruction Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext8__icache_l3_read_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext8_ICACHE_L3_READ_L3BANK1_availability,
            },

            {
                .name = "ICACHE L3 READ L3BANK2",
                .symbol_name = "ICACHE_L3_READ_L3BANK2",
                .desc = "Number of L3 read requests coming from XVE Instruction Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext8__icache_l3_read_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext8_ICACHE_L3_READ_L3BANK2_availability,
            },

            {
                .name = "ICACHE L3 READ L3BANK3",
                .symbol_name = "ICACHE_L3_READ_L3BANK3",
                .desc = "Number of L3 read requests coming from XVE Instruction Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext8__icache_l3_read_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext8_ICACHE_L3_READ_L3BANK3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}

static bool mtlgt2_ext10_COLOR_L3_HIT_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext10_COLOR_L3_HIT_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext10_COLOR_L3_HIT_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext10_COLOR_L3_HIT_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext10_DATAPORT_L3_HIT_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext10_DATAPORT_L3_HIT_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext10_DATAPORT_L3_HIT_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext10_DATAPORT_L3_HIT_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext10_Z_L3_ACCESS_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext10_Z_L3_ACCESS_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext10_Z_L3_ACCESS_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext10_Z_L3_ACCESS_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext10_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext10";
    metric_set->symbol_name = "Ext10";
    metric_set->hw_config_guid = "1df59d79-16d8-471c-b3da-f0f62862f89e";
    metric_set->counters = calloc(15, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext10_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext10__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext10__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "COLOR L3 HIT L3BANK0",
                .symbol_name = "COLOR_L3_HIT_L3BANK0",
                .desc = "Number of L3 read requests resulting from color local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext10__color_l3_hit_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext10_COLOR_L3_HIT_L3BANK0_availability,
            },

            {
                .name = "COLOR L3 HIT L3BANK1",
                .symbol_name = "COLOR_L3_HIT_L3BANK1",
                .desc = "Number of L3 read requests resulting from color local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext10__color_l3_hit_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext10_COLOR_L3_HIT_L3BANK1_availability,
            },

            {
                .name = "COLOR L3 HIT L3BANK2",
                .symbol_name = "COLOR_L3_HIT_L3BANK2",
                .desc = "Number of L3 read requests resulting from color local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext10__color_l3_hit_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext10_COLOR_L3_HIT_L3BANK2_availability,
            },

            {
                .name = "COLOR L3 HIT L3BANK3",
                .symbol_name = "COLOR_L3_HIT_L3BANK3",
                .desc = "Number of L3 read requests resulting from color local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext10__color_l3_hit_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext10_COLOR_L3_HIT_L3BANK3_availability,
            },

            {
                .name = "DATAPORT L3 HIT L3BANK0",
                .symbol_name = "DATAPORT_L3_HIT_L3BANK0",
                .desc = "Number of L3 hits for requests coming from the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext10__dataport_l3_hit_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext10_DATAPORT_L3_HIT_L3BANK0_availability,
            },

            {
                .name = "DATAPORT L3 HIT L3BANK1",
                .symbol_name = "DATAPORT_L3_HIT_L3BANK1",
                .desc = "Number of L3 hits for requests coming from the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext10__dataport_l3_hit_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext10_DATAPORT_L3_HIT_L3BANK1_availability,
            },

            {
                .name = "DATAPORT L3 HIT L3BANK2",
                .symbol_name = "DATAPORT_L3_HIT_L3BANK2",
                .desc = "Number of L3 hits for requests coming from the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext10__dataport_l3_hit_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext10_DATAPORT_L3_HIT_L3BANK2_availability,
            },

            {
                .name = "DATAPORT L3 HIT L3BANK3",
                .symbol_name = "DATAPORT_L3_HIT_L3BANK3",
                .desc = "Number of L3 hits for requests coming from the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext10__dataport_l3_hit_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext10_DATAPORT_L3_HIT_L3BANK3_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext10__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext10__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "Z L3 ACCESS L3BANK0",
                .symbol_name = "Z_L3_ACCESS_L3BANK0",
                .desc = "Number of L3 read requests resulting from Z local cache miss",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext10__z_l3_access_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext10_Z_L3_ACCESS_L3BANK0_availability,
            },

            {
                .name = "Z L3 ACCESS L3BANK1",
                .symbol_name = "Z_L3_ACCESS_L3BANK1",
                .desc = "Number of L3 read requests resulting from Z local cache miss",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext10__z_l3_access_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext10_Z_L3_ACCESS_L3BANK1_availability,
            },

            {
                .name = "Z L3 ACCESS L3BANK2",
                .symbol_name = "Z_L3_ACCESS_L3BANK2",
                .desc = "Number of L3 read requests resulting from Z local cache miss",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext10__z_l3_access_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext10_Z_L3_ACCESS_L3BANK2_availability,
            },

            {
                .name = "Z L3 ACCESS L3BANK3",
                .symbol_name = "Z_L3_ACCESS_L3BANK3",
                .desc = "Number of L3 read requests resulting from Z local cache miss",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext10__z_l3_access_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext10_Z_L3_ACCESS_L3BANK3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 15);
}

static bool mtlgt2_ext11_L3_ATOMIC_ACCESS_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext11_L3_ATOMIC_ACCESS_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext11_L3_ATOMIC_ACCESS_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext11_L3_ATOMIC_ACCESS_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext11_Z_L3_HIT_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext11_Z_L3_HIT_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext11_Z_L3_HIT_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext11_Z_L3_HIT_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext11_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext11";
    metric_set->symbol_name = "Ext11";
    metric_set->hw_config_guid = "d05d3d84-ba16-41b5-b825-5a3d2aaabbfc";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext11_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext11__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext11__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext11__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext11__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "L3 ATOMIC ACCESS L3BANK0",
                .symbol_name = "L3_ATOMIC_ACCESS_L3BANK0",
                .desc = "Number of atomic accesses to L3 Bank",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext11__l3_atomic_access_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext11_L3_ATOMIC_ACCESS_L3BANK0_availability,
            },

            {
                .name = "L3 ATOMIC ACCESS L3BANK1",
                .symbol_name = "L3_ATOMIC_ACCESS_L3BANK1",
                .desc = "Number of atomic accesses to L3 Bank",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext11__l3_atomic_access_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext11_L3_ATOMIC_ACCESS_L3BANK1_availability,
            },

            {
                .name = "L3 ATOMIC ACCESS L3BANK2",
                .symbol_name = "L3_ATOMIC_ACCESS_L3BANK2",
                .desc = "Number of atomic accesses to L3 Bank",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext11__l3_atomic_access_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext11_L3_ATOMIC_ACCESS_L3BANK2_availability,
            },

            {
                .name = "L3 ATOMIC ACCESS L3BANK3",
                .symbol_name = "L3_ATOMIC_ACCESS_L3BANK3",
                .desc = "Number of atomic accesses to L3 Bank",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext11__l3_atomic_access_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext11_L3_ATOMIC_ACCESS_L3BANK3_availability,
            },

            {
                .name = "Z L3 HIT L3BANK0",
                .symbol_name = "Z_L3_HIT_L3BANK0",
                .desc = "Number of L3 read requests resulting from Z local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext11__z_l3_hit_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext11_Z_L3_HIT_L3BANK0_availability,
            },

            {
                .name = "Z L3 HIT L3BANK1",
                .symbol_name = "Z_L3_HIT_L3BANK1",
                .desc = "Number of L3 read requests resulting from Z local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext11__z_l3_hit_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext11_Z_L3_HIT_L3BANK1_availability,
            },

            {
                .name = "Z L3 HIT L3BANK2",
                .symbol_name = "Z_L3_HIT_L3BANK2",
                .desc = "Number of L3 read requests resulting from Z local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext11__z_l3_hit_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext11_Z_L3_HIT_L3BANK2_availability,
            },

            {
                .name = "Z L3 HIT L3BANK3",
                .symbol_name = "Z_L3_HIT_L3BANK3",
                .desc = "Number of L3 read requests resulting from Z local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext11__z_l3_hit_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext11_Z_L3_HIT_L3BANK3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}

static bool mtlgt2_ext12_L3_INPUT_AVAILABLE_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext12_L3_INPUT_AVAILABLE_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext12_L3_INPUT_AVAILABLE_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext12_L3_INPUT_AVAILABLE_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext12_L3_OUTPUT_READY_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext12_L3_OUTPUT_READY_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext12_L3_OUTPUT_READY_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext12_L3_OUTPUT_READY_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext12_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext12";
    metric_set->symbol_name = "Ext12";
    metric_set->hw_config_guid = "a49e7038-1e78-4b49-bc55-e7e7d04e4074";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext12_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext12__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext12__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext12__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext12__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "L3 INPUT AVAILABLE L3BANK0",
                .symbol_name = "L3_INPUT_AVAILABLE_L3BANK0",
                .desc = "Percentage of time in which L3 Bank has input requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext12__l3_input_available_l3_bank0__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_ext12_L3_INPUT_AVAILABLE_L3BANK0_availability,
            },

            {
                .name = "L3 INPUT AVAILABLE L3BANK1",
                .symbol_name = "L3_INPUT_AVAILABLE_L3BANK1",
                .desc = "Percentage of time in which L3 Bank has input requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext12__l3_input_available_l3_bank1__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_ext12_L3_INPUT_AVAILABLE_L3BANK1_availability,
            },

            {
                .name = "L3 INPUT AVAILABLE L3BANK2",
                .symbol_name = "L3_INPUT_AVAILABLE_L3BANK2",
                .desc = "Percentage of time in which L3 Bank has input requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext12__l3_input_available_l3_bank2__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_ext12_L3_INPUT_AVAILABLE_L3BANK2_availability,
            },

            {
                .name = "L3 INPUT AVAILABLE L3BANK3",
                .symbol_name = "L3_INPUT_AVAILABLE_L3BANK3",
                .desc = "Percentage of time in which L3 Bank has input requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext12__l3_input_available_l3_bank3__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_ext12_L3_INPUT_AVAILABLE_L3BANK3_availability,
            },

            {
                .name = "L3 OUTPUT READY L3BANK0",
                .symbol_name = "L3_OUTPUT_READY_L3BANK0",
                .desc = "Percentage of time in which L3 Bank has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext12__l3_output_ready_l3_bank0__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_ext12_L3_OUTPUT_READY_L3BANK0_availability,
            },

            {
                .name = "L3 OUTPUT READY L3BANK1",
                .symbol_name = "L3_OUTPUT_READY_L3BANK1",
                .desc = "Percentage of time in which L3 Bank has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext12__l3_output_ready_l3_bank1__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_ext12_L3_OUTPUT_READY_L3BANK1_availability,
            },

            {
                .name = "L3 OUTPUT READY L3BANK2",
                .symbol_name = "L3_OUTPUT_READY_L3BANK2",
                .desc = "Percentage of time in which L3 Bank has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext12__l3_output_ready_l3_bank2__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_ext12_L3_OUTPUT_READY_L3BANK2_availability,
            },

            {
                .name = "L3 OUTPUT READY L3BANK3",
                .symbol_name = "L3_OUTPUT_READY_L3BANK3",
                .desc = "Percentage of time in which L3 Bank has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext12__l3_output_ready_l3_bank3__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_ext12_L3_OUTPUT_READY_L3BANK3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}

static bool mtlgt2_ext13_COLOR_L3_ACCESS_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext13_COLOR_L3_ACCESS_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext13_COLOR_L3_ACCESS_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext13_COLOR_L3_ACCESS_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext13_L3_SUPERQ_FULL_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext13_L3_SUPERQ_FULL_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext13_L3_SUPERQ_FULL_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext13_L3_SUPERQ_FULL_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext13_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext13";
    metric_set->symbol_name = "Ext13";
    metric_set->hw_config_guid = "10f4cba5-2db8-46a9-a211-391dca810ea0";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext13_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext13__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext13__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "COLOR L3 ACCESS L3BANK0",
                .symbol_name = "COLOR_L3_ACCESS_L3BANK0",
                .desc = "Number of L3 request resulting from color local cache miss",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext13__color_l3_access_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext13_COLOR_L3_ACCESS_L3BANK0_availability,
            },

            {
                .name = "COLOR L3 ACCESS L3BANK1",
                .symbol_name = "COLOR_L3_ACCESS_L3BANK1",
                .desc = "Number of L3 request resulting from color local cache miss",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext13__color_l3_access_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext13_COLOR_L3_ACCESS_L3BANK1_availability,
            },

            {
                .name = "COLOR L3 ACCESS L3BANK2",
                .symbol_name = "COLOR_L3_ACCESS_L3BANK2",
                .desc = "Number of L3 request resulting from color local cache miss",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext13__color_l3_access_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext13_COLOR_L3_ACCESS_L3BANK2_availability,
            },

            {
                .name = "COLOR L3 ACCESS L3BANK3",
                .symbol_name = "COLOR_L3_ACCESS_L3BANK3",
                .desc = "Number of L3 request resulting from color local cache miss",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext13__color_l3_access_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext13_COLOR_L3_ACCESS_L3BANK3_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext13__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext13__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "L3 SUPERQ FULL L3BANK0",
                .symbol_name = "L3_SUPERQ_FULL_L3BANK0",
                .desc = "Percentage of time in which all slots in L3 request queue are waiting for data return / response",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext13__l3_superq_full_l3_bank0__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_ext13_L3_SUPERQ_FULL_L3BANK0_availability,
            },

            {
                .name = "L3 SUPERQ FULL L3BANK1",
                .symbol_name = "L3_SUPERQ_FULL_L3BANK1",
                .desc = "Percentage of time in which all slots in L3 request queue are waiting for data return / response",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext13__l3_superq_full_l3_bank1__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_ext13_L3_SUPERQ_FULL_L3BANK1_availability,
            },

            {
                .name = "L3 SUPERQ FULL L3BANK2",
                .symbol_name = "L3_SUPERQ_FULL_L3BANK2",
                .desc = "Percentage of time in which all slots in L3 request queue are waiting for data return / response",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext13__l3_superq_full_l3_bank2__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_ext13_L3_SUPERQ_FULL_L3BANK2_availability,
            },

            {
                .name = "L3 SUPERQ FULL L3BANK3",
                .symbol_name = "L3_SUPERQ_FULL_L3BANK3",
                .desc = "Percentage of time in which all slots in L3 request queue are waiting for data return / response",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext13__l3_superq_full_l3_bank3__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_ext13_L3_SUPERQ_FULL_L3BANK3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}

static bool mtlgt2_ext14_L3_BUSY_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext14_L3_BUSY_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext14_L3_BUSY_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext14_L3_BUSY_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext14_L3_STALL_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext14_L3_STALL_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext14_L3_STALL_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext14_L3_STALL_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext14_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext14";
    metric_set->symbol_name = "Ext14";
    metric_set->hw_config_guid = "36c1995a-e670-4c2a-ab94-74b9e7360fb2";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext14_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext14__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext14__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext14__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext14__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "L3 BUSY L3BANK0",
                .symbol_name = "L3_BUSY_L3BANK0",
                .desc = "Percentage of time in which L3 request queue has one or more requests pending",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext14__l3_busy_l3_bank0__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_ext14_L3_BUSY_L3BANK0_availability,
            },

            {
                .name = "L3 BUSY L3BANK1",
                .symbol_name = "L3_BUSY_L3BANK1",
                .desc = "Percentage of time in which L3 request queue has one or more requests pending",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext14__l3_busy_l3_bank1__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_ext14_L3_BUSY_L3BANK1_availability,
            },

            {
                .name = "L3 BUSY L3BANK2",
                .symbol_name = "L3_BUSY_L3BANK2",
                .desc = "Percentage of time in which L3 request queue has one or more requests pending",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext14__l3_busy_l3_bank2__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_ext14_L3_BUSY_L3BANK2_availability,
            },

            {
                .name = "L3 BUSY L3BANK3",
                .symbol_name = "L3_BUSY_L3BANK3",
                .desc = "Percentage of time in which L3 request queue has one or more requests pending",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext14__l3_busy_l3_bank3__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_ext14_L3_BUSY_L3BANK3_availability,
            },

            {
                .name = "L3 STALL L3BANK0",
                .symbol_name = "L3_STALL_L3BANK0",
                .desc = "Percentage of time in which L3 Bank Stalled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext14__l3_stall_l3_bank0__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_ext14_L3_STALL_L3BANK0_availability,
            },

            {
                .name = "L3 STALL L3BANK1",
                .symbol_name = "L3_STALL_L3BANK1",
                .desc = "Percentage of time in which L3 Bank Stalled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext14__l3_stall_l3_bank1__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_ext14_L3_STALL_L3BANK1_availability,
            },

            {
                .name = "L3 STALL L3BANK2",
                .symbol_name = "L3_STALL_L3BANK2",
                .desc = "Percentage of time in which L3 Bank Stalled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext14__l3_stall_l3_bank2__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_ext14_L3_STALL_L3BANK2_availability,
            },

            {
                .name = "L3 STALL L3BANK3",
                .symbol_name = "L3_STALL_L3BANK3",
                .desc = "Percentage of time in which L3 Bank Stalled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext14__l3_stall_l3_bank3__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = mtlgt2_ext14_L3_STALL_L3BANK3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}

static bool mtlgt2_ext17_LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext17_LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext17_LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext17_LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext17_LOAD_STORE_CACHE_OUTPUT_READY_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext17_LOAD_STORE_CACHE_OUTPUT_READY_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext17_LOAD_STORE_CACHE_OUTPUT_READY_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext17_LOAD_STORE_CACHE_OUTPUT_READY_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext17_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext17";
    metric_set->symbol_name = "Ext17";
    metric_set->hw_config_guid = "a04168f6-637e-44af-a1b6-e5f005708df4";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext17_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext17__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext17__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext17__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext17__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "LOAD STORE CACHE INPUT AVAILABLE XECORE0",
                .symbol_name = "LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE0",
                .desc = "Percentage of time in which the Load Store Cache has input available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext17__load_store_cache_input_available_xecore0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext17_LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE0_availability,
            },

            {
                .name = "LOAD STORE CACHE INPUT AVAILABLE XECORE1",
                .symbol_name = "LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE1",
                .desc = "Percentage of time in which the Load Store Cache has input available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext17__load_store_cache_input_available_xecore1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext17_LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE1_availability,
            },

            {
                .name = "LOAD STORE CACHE INPUT AVAILABLE XECORE2",
                .symbol_name = "LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE2",
                .desc = "Percentage of time in which the Load Store Cache has input available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext17__load_store_cache_input_available_xecore2__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext17_LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE2_availability,
            },

            {
                .name = "LOAD STORE CACHE INPUT AVAILABLE XECORE3",
                .symbol_name = "LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE3",
                .desc = "Percentage of time in which the Load Store Cache has input available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext17__load_store_cache_input_available_xecore3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext17_LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE3_availability,
            },

            {
                .name = "LOAD STORE CACHE OUTPUT READY XECORE0",
                .symbol_name = "LOAD_STORE_CACHE_OUTPUT_READY_XECORE0",
                .desc = "Percentage of time in which the Load Store Cache has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext17__load_store_cache_output_ready_xecore0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext17_LOAD_STORE_CACHE_OUTPUT_READY_XECORE0_availability,
            },

            {
                .name = "LOAD STORE CACHE OUTPUT READY XECORE1",
                .symbol_name = "LOAD_STORE_CACHE_OUTPUT_READY_XECORE1",
                .desc = "Percentage of time in which the Load Store Cache has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext17__load_store_cache_output_ready_xecore1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext17_LOAD_STORE_CACHE_OUTPUT_READY_XECORE1_availability,
            },

            {
                .name = "LOAD STORE CACHE OUTPUT READY XECORE2",
                .symbol_name = "LOAD_STORE_CACHE_OUTPUT_READY_XECORE2",
                .desc = "Percentage of time in which the Load Store Cache has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext17__load_store_cache_output_ready_xecore2__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext17_LOAD_STORE_CACHE_OUTPUT_READY_XECORE2_availability,
            },

            {
                .name = "LOAD STORE CACHE OUTPUT READY XECORE3",
                .symbol_name = "LOAD_STORE_CACHE_OUTPUT_READY_XECORE3",
                .desc = "Percentage of time in which the Load Store Cache has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext17__load_store_cache_output_ready_xecore3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext17_LOAD_STORE_CACHE_OUTPUT_READY_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}

static bool mtlgt2_ext21_LOAD_STORE_CACHE_ACCESS_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext21_LOAD_STORE_CACHE_ACCESS_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext21_LOAD_STORE_CACHE_ACCESS_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext21_LOAD_STORE_CACHE_ACCESS_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext21_LOAD_STORE_CACHE_L3_READ_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext21_LOAD_STORE_CACHE_L3_READ_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext21_LOAD_STORE_CACHE_L3_READ_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext21_LOAD_STORE_CACHE_L3_READ_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext21_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext21";
    metric_set->symbol_name = "Ext21";
    metric_set->hw_config_guid = "0486a0e0-3522-4689-bdf9-623603f8e3c6";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext21_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext21__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext21__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext21__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext21__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "LOAD STORE CACHE ACCESS XECORE0",
                .symbol_name = "LOAD_STORE_CACHE_ACCESS_XECORE0",
                .desc = "Number of Load Store Cache accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext21__load_store_cache_access_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext21_LOAD_STORE_CACHE_ACCESS_XECORE0_availability,
            },

            {
                .name = "LOAD STORE CACHE ACCESS XECORE1",
                .symbol_name = "LOAD_STORE_CACHE_ACCESS_XECORE1",
                .desc = "Number of Load Store Cache accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext21__load_store_cache_access_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext21_LOAD_STORE_CACHE_ACCESS_XECORE1_availability,
            },

            {
                .name = "LOAD STORE CACHE ACCESS XECORE2",
                .symbol_name = "LOAD_STORE_CACHE_ACCESS_XECORE2",
                .desc = "Number of Load Store Cache accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext21__load_store_cache_access_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext21_LOAD_STORE_CACHE_ACCESS_XECORE2_availability,
            },

            {
                .name = "LOAD STORE CACHE ACCESS XECORE3",
                .symbol_name = "LOAD_STORE_CACHE_ACCESS_XECORE3",
                .desc = "Number of Load Store Cache accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext21__load_store_cache_access_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext21_LOAD_STORE_CACHE_ACCESS_XECORE3_availability,
            },

            {
                .name = "LOAD STORE CACHE L3 READ XECORE0",
                .symbol_name = "LOAD_STORE_CACHE_L3_READ_XECORE0",
                .desc = "Number of cacheline read requests from the Load Store Cache to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext21__load_store_cache_l3_read_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext21_LOAD_STORE_CACHE_L3_READ_XECORE0_availability,
            },

            {
                .name = "LOAD STORE CACHE L3 READ XECORE1",
                .symbol_name = "LOAD_STORE_CACHE_L3_READ_XECORE1",
                .desc = "Number of cacheline read requests from the Load Store Cache to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext21__load_store_cache_l3_read_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext21_LOAD_STORE_CACHE_L3_READ_XECORE1_availability,
            },

            {
                .name = "LOAD STORE CACHE L3 READ XECORE2",
                .symbol_name = "LOAD_STORE_CACHE_L3_READ_XECORE2",
                .desc = "Number of cacheline read requests from the Load Store Cache to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext21__load_store_cache_l3_read_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext21_LOAD_STORE_CACHE_L3_READ_XECORE2_availability,
            },

            {
                .name = "LOAD STORE CACHE L3 READ XECORE3",
                .symbol_name = "LOAD_STORE_CACHE_L3_READ_XECORE3",
                .desc = "Number of cacheline read requests from the Load Store Cache to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext21__load_store_cache_l3_read_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext21_LOAD_STORE_CACHE_L3_READ_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}

static bool mtlgt2_ext23_LOAD_STORE_CACHE_HIT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext23_LOAD_STORE_CACHE_HIT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext23_LOAD_STORE_CACHE_HIT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext23_LOAD_STORE_CACHE_HIT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext23_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext23";
    metric_set->symbol_name = "Ext23";
    metric_set->hw_config_guid = "b30ba7fb-fe8f-4e81-b271-3d6f52edc257";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext23_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext23__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext23__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext23__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext23__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "LOAD STORE CACHE HIT XECORE0",
                .symbol_name = "LOAD_STORE_CACHE_HIT_XECORE0",
                .desc = "Number of Load Store Cache hits",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext23__load_store_cache_hit_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext23_LOAD_STORE_CACHE_HIT_XECORE0_availability,
            },

            {
                .name = "LOAD STORE CACHE HIT XECORE1",
                .symbol_name = "LOAD_STORE_CACHE_HIT_XECORE1",
                .desc = "Number of Load Store Cache hits",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext23__load_store_cache_hit_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext23_LOAD_STORE_CACHE_HIT_XECORE1_availability,
            },

            {
                .name = "LOAD STORE CACHE HIT XECORE2",
                .symbol_name = "LOAD_STORE_CACHE_HIT_XECORE2",
                .desc = "Number of Load Store Cache hits",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext23__load_store_cache_hit_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext23_LOAD_STORE_CACHE_HIT_XECORE2_availability,
            },

            {
                .name = "LOAD STORE CACHE HIT XECORE3",
                .symbol_name = "LOAD_STORE_CACHE_HIT_XECORE3",
                .desc = "Number of Load Store Cache hits",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext23__load_store_cache_hit_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext23_LOAD_STORE_CACHE_HIT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext28_LOAD_STORE_CACHE_L3_WRITE_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext28_LOAD_STORE_CACHE_L3_WRITE_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext28_LOAD_STORE_CACHE_L3_WRITE_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext28_LOAD_STORE_CACHE_L3_WRITE_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext28_LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext28_LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext28_LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext28_LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext28_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext28";
    metric_set->symbol_name = "Ext28";
    metric_set->hw_config_guid = "053ca218-0961-4bb2-b689-9fe2cb090fdc";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext28_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext28__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext28__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext28__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext28__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "LOAD STORE CACHE L3 WRITE XECORE0",
                .symbol_name = "LOAD_STORE_CACHE_L3_WRITE_XECORE0",
                .desc = "Number of cacheline write requests from the Load Store Cache to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext28__load_store_cache_l3_write_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext28_LOAD_STORE_CACHE_L3_WRITE_XECORE0_availability,
            },

            {
                .name = "LOAD STORE CACHE L3 WRITE XECORE1",
                .symbol_name = "LOAD_STORE_CACHE_L3_WRITE_XECORE1",
                .desc = "Number of cacheline write requests from the Load Store Cache to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext28__load_store_cache_l3_write_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext28_LOAD_STORE_CACHE_L3_WRITE_XECORE1_availability,
            },

            {
                .name = "LOAD STORE CACHE L3 WRITE XECORE2",
                .symbol_name = "LOAD_STORE_CACHE_L3_WRITE_XECORE2",
                .desc = "Number of cacheline write requests from the Load Store Cache to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext28__load_store_cache_l3_write_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext28_LOAD_STORE_CACHE_L3_WRITE_XECORE2_availability,
            },

            {
                .name = "LOAD STORE CACHE L3 WRITE XECORE3",
                .symbol_name = "LOAD_STORE_CACHE_L3_WRITE_XECORE3",
                .desc = "Number of cacheline write requests from the Load Store Cache to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext28__load_store_cache_l3_write_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext28_LOAD_STORE_CACHE_L3_WRITE_XECORE3_availability,
            },

            {
                .name = "LOAD STORE CACHE PARTIAL WRITE COUNT XECORE0",
                .symbol_name = "LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE0",
                .desc = "Number of writes to the Load Store Cache that don't fill a subsector",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext28__load_store_cache_partial_write_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext28_LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE0_availability,
            },

            {
                .name = "LOAD STORE CACHE PARTIAL WRITE COUNT XECORE1",
                .symbol_name = "LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE1",
                .desc = "Number of writes to the Load Store Cache that don't fill a subsector",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext28__load_store_cache_partial_write_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext28_LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE1_availability,
            },

            {
                .name = "LOAD STORE CACHE PARTIAL WRITE COUNT XECORE2",
                .symbol_name = "LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE2",
                .desc = "Number of writes to the Load Store Cache that don't fill a subsector",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext28__load_store_cache_partial_write_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext28_LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE2_availability,
            },

            {
                .name = "LOAD STORE CACHE PARTIAL WRITE COUNT XECORE3",
                .symbol_name = "LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE3",
                .desc = "Number of writes to the Load Store Cache that don't fill a subsector",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext28__load_store_cache_partial_write_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext28_LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}

static bool mtlgt2_ext31_XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext31_XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext31_XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext31_XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext31_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext31";
    metric_set->symbol_name = "Ext31";
    metric_set->hw_config_guid = "7a4a45f1-e844-460b-8800-91b62eb47124";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext31_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext31__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext31__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext31__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext31__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE READ MESSAGE COUNT XECORE0",
                .symbol_name = "XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE0",
                .desc = "Number of read messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext31__xve_load_store_cache_read_message_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext31_XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE READ MESSAGE COUNT XECORE1",
                .symbol_name = "XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE1",
                .desc = "Number of read messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext31__xve_load_store_cache_read_message_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext31_XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE1_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE READ MESSAGE COUNT XECORE2",
                .symbol_name = "XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE2",
                .desc = "Number of read messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext31__xve_load_store_cache_read_message_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext31_XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE2_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE READ MESSAGE COUNT XECORE3",
                .symbol_name = "XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE3",
                .desc = "Number of read messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext31__xve_load_store_cache_read_message_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext31_XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext35_XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext35_XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext35_XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext35_XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext35_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext35";
    metric_set->symbol_name = "Ext35";
    metric_set->hw_config_guid = "fd99f6f4-d418-4d86-800b-52998df4eb00";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext35_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext35__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext35__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext35__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext35__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE WRITE MESSAGE COUNT XECORE0",
                .symbol_name = "XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE0",
                .desc = "Number of write messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext35__xve_load_store_cache_write_message_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext35_XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE WRITE MESSAGE COUNT XECORE1",
                .symbol_name = "XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE1",
                .desc = "Number of write messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext35__xve_load_store_cache_write_message_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext35_XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE1_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE WRITE MESSAGE COUNT XECORE2",
                .symbol_name = "XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE2",
                .desc = "Number of write messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext35__xve_load_store_cache_write_message_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext35_XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE2_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE WRITE MESSAGE COUNT XECORE3",
                .symbol_name = "XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE3",
                .desc = "Number of write messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext35__xve_load_store_cache_write_message_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext35_XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext39_XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext39_XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext39_XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext39_XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext39_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext39";
    metric_set->symbol_name = "Ext39";
    metric_set->hw_config_guid = "10f4436b-83c7-4e38-867d-82144311e412";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext39_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext39__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext39__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext39__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext39__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE FENCE MESSAGE COUNT XECORE0",
                .symbol_name = "XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE0",
                .desc = "Number of fence messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext39__xve_load_store_cache_fence_message_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext39_XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE FENCE MESSAGE COUNT XECORE1",
                .symbol_name = "XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE1",
                .desc = "Number of fence messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext39__xve_load_store_cache_fence_message_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext39_XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE1_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE FENCE MESSAGE COUNT XECORE2",
                .symbol_name = "XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE2",
                .desc = "Number of fence messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext39__xve_load_store_cache_fence_message_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext39_XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE2_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE FENCE MESSAGE COUNT XECORE3",
                .symbol_name = "XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE3",
                .desc = "Number of fence messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext39__xve_load_store_cache_fence_message_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext39_XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext43_XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext43_XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext43_XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext43_XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext43_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext43";
    metric_set->symbol_name = "Ext43";
    metric_set->hw_config_guid = "ab8c937a-a24c-4b7b-94d2-7cdf4cf3829f";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext43_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext43__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext43__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext43__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext43__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE ATOMIC MESSAGE COUNT XECORE0",
                .symbol_name = "XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE0",
                .desc = "Number of atomic operations sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext43__xve_load_store_cache_atomic_message_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext43_XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE ATOMIC MESSAGE COUNT XECORE1",
                .symbol_name = "XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE1",
                .desc = "Number of atomic operations sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext43__xve_load_store_cache_atomic_message_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext43_XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE1_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE REGISTER REQUEST COUNT XECORE0",
                .symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE0",
                .desc = "Number of message payload transactions sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext43__xve_load_store_cache_register_request_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext43_XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE REGISTER REQUEST COUNT XECORE1",
                .symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE1",
                .desc = "Number of message payload transactions sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext43__xve_load_store_cache_register_request_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext43_XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE1_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext45_XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext45_XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext45_XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext45_XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext45_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext45";
    metric_set->symbol_name = "Ext45";
    metric_set->hw_config_guid = "aa3ac820-b824-4681-94ff-3425eee63648";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext45_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext45__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext45__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext45__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext45__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE ATOMIC MESSAGE COUNT XECORE2",
                .symbol_name = "XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE2",
                .desc = "Number of atomic operations sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext45__xve_load_store_cache_atomic_message_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext45_XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE2_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE ATOMIC MESSAGE COUNT XECORE3",
                .symbol_name = "XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE3",
                .desc = "Number of atomic operations sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext45__xve_load_store_cache_atomic_message_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext45_XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE3_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE REGISTER REQUEST COUNT XECORE2",
                .symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE2",
                .desc = "Number of message payload transactions sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext45__xve_load_store_cache_register_request_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext45_XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE2_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE REGISTER REQUEST COUNT XECORE3",
                .symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE3",
                .desc = "Number of message payload transactions sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext45__xve_load_store_cache_register_request_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext45_XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext51_XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext51_XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext51_XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext51_XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext51_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext51";
    metric_set->symbol_name = "Ext51";
    metric_set->hw_config_guid = "3a093546-2929-4b79-87f4-97df02c1fe8e";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext51_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext51__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext51__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext51__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext51__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE REGISTER RESPONSE COUNT XECORE0",
                .symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE0",
                .desc = "Number of message payload transactions sent from the Load Store Cache back to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext51__xve_load_store_cache_register_response_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext51_XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE REGISTER RESPONSE COUNT XECORE1",
                .symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE1",
                .desc = "Number of message payload transactions sent from the Load Store Cache back to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext51__xve_load_store_cache_register_response_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext51_XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE1_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE REGISTER RESPONSE COUNT XECORE2",
                .symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE2",
                .desc = "Number of message payload transactions sent from the Load Store Cache back to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext51__xve_load_store_cache_register_response_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext51_XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE2_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE REGISTER RESPONSE COUNT XECORE3",
                .symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE3",
                .desc = "Number of message payload transactions sent from the Load Store Cache back to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext51__xve_load_store_cache_register_response_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext51_XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext53_XVE_SLM_READ_MESSAGE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext53_XVE_SLM_READ_MESSAGE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext53_XVE_SLM_READ_MESSAGE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext53_XVE_SLM_READ_MESSAGE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext53_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext53";
    metric_set->symbol_name = "Ext53";
    metric_set->hw_config_guid = "2ccdac56-9683-4eb5-89fd-7d42e77c117f";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext53_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext53__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext53__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext53__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext53__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SLM READ MESSAGE COUNT XECORE0",
                .symbol_name = "XVE_SLM_READ_MESSAGE_COUNT_XECORE0",
                .desc = "Number of SLM read messages sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext53__xve_slm_read_message_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext53_XVE_SLM_READ_MESSAGE_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE SLM READ MESSAGE COUNT XECORE1",
                .symbol_name = "XVE_SLM_READ_MESSAGE_COUNT_XECORE1",
                .desc = "Number of SLM read messages sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext53__xve_slm_read_message_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext53_XVE_SLM_READ_MESSAGE_COUNT_XECORE1_availability,
            },

            {
                .name = "XVE SLM READ MESSAGE COUNT XECORE2",
                .symbol_name = "XVE_SLM_READ_MESSAGE_COUNT_XECORE2",
                .desc = "Number of SLM read messages sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext53__xve_slm_read_message_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext53_XVE_SLM_READ_MESSAGE_COUNT_XECORE2_availability,
            },

            {
                .name = "XVE SLM READ MESSAGE COUNT XECORE3",
                .symbol_name = "XVE_SLM_READ_MESSAGE_COUNT_XECORE3",
                .desc = "Number of SLM read messages sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext53__xve_slm_read_message_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext53_XVE_SLM_READ_MESSAGE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext57_XVE_SLM_WRITE_MESSAGE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext57_XVE_SLM_WRITE_MESSAGE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext57_XVE_SLM_WRITE_MESSAGE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext57_XVE_SLM_WRITE_MESSAGE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext57_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext57";
    metric_set->symbol_name = "Ext57";
    metric_set->hw_config_guid = "d297b1e3-fc04-45a7-a5c5-f92ab4357eb2";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext57_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext57__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext57__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext57__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext57__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SLM WRITE MESSAGE COUNT XECORE0",
                .symbol_name = "XVE_SLM_WRITE_MESSAGE_COUNT_XECORE0",
                .desc = "Number of SLM write messages sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext57__xve_slm_write_message_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext57_XVE_SLM_WRITE_MESSAGE_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE SLM WRITE MESSAGE COUNT XECORE1",
                .symbol_name = "XVE_SLM_WRITE_MESSAGE_COUNT_XECORE1",
                .desc = "Number of SLM write messages sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext57__xve_slm_write_message_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext57_XVE_SLM_WRITE_MESSAGE_COUNT_XECORE1_availability,
            },

            {
                .name = "XVE SLM WRITE MESSAGE COUNT XECORE2",
                .symbol_name = "XVE_SLM_WRITE_MESSAGE_COUNT_XECORE2",
                .desc = "Number of SLM write messages sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext57__xve_slm_write_message_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext57_XVE_SLM_WRITE_MESSAGE_COUNT_XECORE2_availability,
            },

            {
                .name = "XVE SLM WRITE MESSAGE COUNT XECORE3",
                .symbol_name = "XVE_SLM_WRITE_MESSAGE_COUNT_XECORE3",
                .desc = "Number of SLM write messages sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext57__xve_slm_write_message_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext57_XVE_SLM_WRITE_MESSAGE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext61_XVE_SLM_FENCE_MESSAGE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext61_XVE_SLM_FENCE_MESSAGE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext61_XVE_SLM_FENCE_MESSAGE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext61_XVE_SLM_FENCE_MESSAGE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext61_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext61";
    metric_set->symbol_name = "Ext61";
    metric_set->hw_config_guid = "bc372334-fe31-452e-843a-515328c75fd2";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext61_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext61__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext61__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext61__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext61__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SLM FENCE MESSAGE COUNT XECORE0",
                .symbol_name = "XVE_SLM_FENCE_MESSAGE_COUNT_XECORE0",
                .desc = "Number of SLM fence operations sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext61__xve_slm_fence_message_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext61_XVE_SLM_FENCE_MESSAGE_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE SLM FENCE MESSAGE COUNT XECORE1",
                .symbol_name = "XVE_SLM_FENCE_MESSAGE_COUNT_XECORE1",
                .desc = "Number of SLM fence operations sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext61__xve_slm_fence_message_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext61_XVE_SLM_FENCE_MESSAGE_COUNT_XECORE1_availability,
            },

            {
                .name = "XVE SLM FENCE MESSAGE COUNT XECORE2",
                .symbol_name = "XVE_SLM_FENCE_MESSAGE_COUNT_XECORE2",
                .desc = "Number of SLM fence operations sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext61__xve_slm_fence_message_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext61_XVE_SLM_FENCE_MESSAGE_COUNT_XECORE2_availability,
            },

            {
                .name = "XVE SLM FENCE MESSAGE COUNT XECORE3",
                .symbol_name = "XVE_SLM_FENCE_MESSAGE_COUNT_XECORE3",
                .desc = "Number of SLM fence operations sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext61__xve_slm_fence_message_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext61_XVE_SLM_FENCE_MESSAGE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext65_XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext65_XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext65_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext65";
    metric_set->symbol_name = "Ext65";
    metric_set->hw_config_guid = "8a5ca732-17d3-4336-a33c-292a7f625237";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext65_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext65__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext65__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext65__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext65__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SLM ATOMIC MESSAGE COUNT XECORE0",
                .symbol_name = "XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE0",
                .desc = "Number of SLM atomic operations sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext65__xve_slm_atomic_message_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext65_XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE SLM ATOMIC MESSAGE COUNT XECORE1",
                .symbol_name = "XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE1",
                .desc = "Number of SLM atomic operations sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext65__xve_slm_atomic_message_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext65_XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE1_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool mtlgt2_ext66_XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext66_XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext66_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext66";
    metric_set->symbol_name = "Ext66";
    metric_set->hw_config_guid = "2e72f570-378b-4672-a615-374c1a3d524c";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext66_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext66__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext66__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext66__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext66__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SLM ATOMIC MESSAGE COUNT XECORE2",
                .symbol_name = "XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE2",
                .desc = "Number of SLM atomic operations sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext66__xve_slm_atomic_message_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext66_XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE2_availability,
            },

            {
                .name = "XVE SLM ATOMIC MESSAGE COUNT XECORE3",
                .symbol_name = "XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE3",
                .desc = "Number of SLM atomic operations sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext66__xve_slm_atomic_message_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext66_XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool mtlgt2_ext73_DATAPORT_INPUT_AVAILABLE_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext73_DATAPORT_INPUT_AVAILABLE_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext73_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext73";
    metric_set->symbol_name = "Ext73";
    metric_set->hw_config_guid = "8f63bf05-fccb-45c2-89c1-cf1226c4fb80";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext73_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext73__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext73__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "DATAPORT INPUT AVAILABLE XECORE0",
                .symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE0",
                .desc = "Percentage of time in which XVEs have requests to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext73__dataport_input_available_xecore0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext73_DATAPORT_INPUT_AVAILABLE_XECORE0_availability,
            },

            {
                .name = "DATAPORT INPUT AVAILABLE XECORE1",
                .symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE1",
                .desc = "Percentage of time in which XVEs have requests to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext73__dataport_input_available_xecore1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext73_DATAPORT_INPUT_AVAILABLE_XECORE1_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext73__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext73__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool mtlgt2_ext74_DATAPORT_INPUT_AVAILABLE_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext74_DATAPORT_INPUT_AVAILABLE_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext74_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext74";
    metric_set->symbol_name = "Ext74";
    metric_set->hw_config_guid = "2e5b5a64-580f-4cfc-ac3b-e6ccc55a1260";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext74_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext74__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext74__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "DATAPORT INPUT AVAILABLE XECORE2",
                .symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE2",
                .desc = "Percentage of time in which XVEs have requests to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext74__dataport_input_available_xecore2__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext74_DATAPORT_INPUT_AVAILABLE_XECORE2_availability,
            },

            {
                .name = "DATAPORT INPUT AVAILABLE XECORE3",
                .symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE3",
                .desc = "Percentage of time in which XVEs have requests to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext74__dataport_input_available_xecore3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext74_DATAPORT_INPUT_AVAILABLE_XECORE3_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext74__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext74__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool mtlgt2_ext77_DATAPORT_OUTPUT_READY_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext77_DATAPORT_OUTPUT_READY_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext77_DATAPORT_OUTPUT_READY_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext77_DATAPORT_OUTPUT_READY_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext77_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext77";
    metric_set->symbol_name = "Ext77";
    metric_set->hw_config_guid = "1e7215b8-72b7-460b-99d1-9be3984e9f6c";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext77_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext77__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext77__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "DATAPORT OUTPUT READY XECORE0",
                .symbol_name = "DATAPORT_OUTPUT_READY_XECORE0",
                .desc = "Percentage of time in which the Dataport has data to return to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext77__dataport_output_ready_xecore0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext77_DATAPORT_OUTPUT_READY_XECORE0_availability,
            },

            {
                .name = "DATAPORT OUTPUT READY XECORE1",
                .symbol_name = "DATAPORT_OUTPUT_READY_XECORE1",
                .desc = "Percentage of time in which the Dataport has data to return to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext77__dataport_output_ready_xecore1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext77_DATAPORT_OUTPUT_READY_XECORE1_availability,
            },

            {
                .name = "DATAPORT OUTPUT READY XECORE2",
                .symbol_name = "DATAPORT_OUTPUT_READY_XECORE2",
                .desc = "Percentage of time in which the Dataport has data to return to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext77__dataport_output_ready_xecore2__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext77_DATAPORT_OUTPUT_READY_XECORE2_availability,
            },

            {
                .name = "DATAPORT OUTPUT READY XECORE3",
                .symbol_name = "DATAPORT_OUTPUT_READY_XECORE3",
                .desc = "Percentage of time in which the Dataport has data to return to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext77__dataport_output_ready_xecore3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext77_DATAPORT_OUTPUT_READY_XECORE3_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext77__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext77__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext79_DATAPORT_BYTE_READ_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext79_DATAPORT_BYTE_READ_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext79_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext79";
    metric_set->symbol_name = "Ext79";
    metric_set->hw_config_guid = "a1a1cc95-7466-461d-a3a4-a04818bb5d74";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext79_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext79__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext79__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "DATAPORT BYTE READ XECORE0",
                .symbol_name = "DATAPORT_BYTE_READ_XECORE0",
                .desc = "Number of bytes read through the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext79__dataport_byte_read_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext79_DATAPORT_BYTE_READ_XECORE0_availability,
            },

            {
                .name = "DATAPORT BYTE READ XECORE1",
                .symbol_name = "DATAPORT_BYTE_READ_XECORE1",
                .desc = "Number of bytes read through the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext79__dataport_byte_read_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext79_DATAPORT_BYTE_READ_XECORE1_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext79__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext79__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool mtlgt2_ext80_DATAPORT_BYTE_READ_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext80_DATAPORT_BYTE_READ_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext80_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext80";
    metric_set->symbol_name = "Ext80";
    metric_set->hw_config_guid = "06d62e44-cf58-4e35-a8cf-c76ee2b4fd7f";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext80_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext80__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext80__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "DATAPORT BYTE READ XECORE2",
                .symbol_name = "DATAPORT_BYTE_READ_XECORE2",
                .desc = "Number of bytes read through the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext80__dataport_byte_read_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext80_DATAPORT_BYTE_READ_XECORE2_availability,
            },

            {
                .name = "DATAPORT BYTE READ XECORE3",
                .symbol_name = "DATAPORT_BYTE_READ_XECORE3",
                .desc = "Number of bytes read through the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext80__dataport_byte_read_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext80_DATAPORT_BYTE_READ_XECORE3_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext80__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext80__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool mtlgt2_ext83_DATAPORT_BYTE_WRITE_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext83_DATAPORT_BYTE_WRITE_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext83_DATAPORT_BYTE_WRITE_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext83_DATAPORT_BYTE_WRITE_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext83_DATAPORT_TEXTURE_CACHE_ACCESS_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext83_DATAPORT_TEXTURE_CACHE_ACCESS_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext83_DATAPORT_TEXTURE_CACHE_ACCESS_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext83_DATAPORT_TEXTURE_CACHE_ACCESS_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext83_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext83";
    metric_set->symbol_name = "Ext83";
    metric_set->hw_config_guid = "428a93d8-3475-4efc-960e-3402b062d8f0";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext83_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext83__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext83__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "DATAPORT BYTE WRITE XECORE0",
                .symbol_name = "DATAPORT_BYTE_WRITE_XECORE0",
                .desc = "Number of bytes written through the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = mtlgt2__ext83__dataport_byte_write_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext83_DATAPORT_BYTE_WRITE_XECORE0_availability,
            },

            {
                .name = "DATAPORT BYTE WRITE XECORE1",
                .symbol_name = "DATAPORT_BYTE_WRITE_XECORE1",
                .desc = "Number of bytes written through the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = mtlgt2__ext83__dataport_byte_write_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext83_DATAPORT_BYTE_WRITE_XECORE1_availability,
            },

            {
                .name = "DATAPORT BYTE WRITE XECORE2",
                .symbol_name = "DATAPORT_BYTE_WRITE_XECORE2",
                .desc = "Number of bytes written through the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = mtlgt2__ext83__dataport_byte_write_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext83_DATAPORT_BYTE_WRITE_XECORE2_availability,
            },

            {
                .name = "DATAPORT BYTE WRITE XECORE3",
                .symbol_name = "DATAPORT_BYTE_WRITE_XECORE3",
                .desc = "Number of bytes written through the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = mtlgt2__ext83__dataport_byte_write_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext83_DATAPORT_BYTE_WRITE_XECORE3_availability,
            },

            {
                .name = "DATAPORT TEXTURE CACHE ACCESS XECORE0",
                .symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE0",
                .desc = "Number of cacheline requests from the Dataport to the Render Cache not including uncached accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext83__dataport_texture_cache_access_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext83_DATAPORT_TEXTURE_CACHE_ACCESS_XECORE0_availability,
            },

            {
                .name = "DATAPORT TEXTURE CACHE ACCESS XECORE1",
                .symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE1",
                .desc = "Number of cacheline requests from the Dataport to the Render Cache not including uncached accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext83__dataport_texture_cache_access_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext83_DATAPORT_TEXTURE_CACHE_ACCESS_XECORE1_availability,
            },

            {
                .name = "DATAPORT TEXTURE CACHE ACCESS XECORE2",
                .symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE2",
                .desc = "Number of cacheline requests from the Dataport to the Render Cache not including uncached accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext83__dataport_texture_cache_access_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext83_DATAPORT_TEXTURE_CACHE_ACCESS_XECORE2_availability,
            },

            {
                .name = "DATAPORT TEXTURE CACHE ACCESS XECORE3",
                .symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE3",
                .desc = "Number of cacheline requests from the Dataport to the Render Cache not including uncached accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext83__dataport_texture_cache_access_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext83_DATAPORT_TEXTURE_CACHE_ACCESS_XECORE3_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext83__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext83__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}

static bool mtlgt2_ext85_DATAPORT_TEXTURE_CACHE_HIT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext85_DATAPORT_TEXTURE_CACHE_HIT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext85_DATAPORT_TEXTURE_CACHE_HIT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext85_DATAPORT_TEXTURE_CACHE_HIT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext85_XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext85_XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext85_XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext85_XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext85_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext85";
    metric_set->symbol_name = "Ext85";
    metric_set->hw_config_guid = "e6db7a16-f214-4cd0-91e9-94d8036c20ee";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext85_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext85__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext85__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "DATAPORT TEXTURE CACHE HIT XECORE0",
                .symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE0",
                .desc = "Number of cache requests from the Dataport to the Render Cache that resulted in a cache hit",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext85__dataport_texture_cache_hit_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext85_DATAPORT_TEXTURE_CACHE_HIT_XECORE0_availability,
            },

            {
                .name = "DATAPORT TEXTURE CACHE HIT XECORE1",
                .symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE1",
                .desc = "Number of cache requests from the Dataport to the Render Cache that resulted in a cache hit",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext85__dataport_texture_cache_hit_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext85_DATAPORT_TEXTURE_CACHE_HIT_XECORE1_availability,
            },

            {
                .name = "DATAPORT TEXTURE CACHE HIT XECORE2",
                .symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE2",
                .desc = "Number of cache requests from the Dataport to the Render Cache that resulted in a cache hit",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext85__dataport_texture_cache_hit_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext85_DATAPORT_TEXTURE_CACHE_HIT_XECORE2_availability,
            },

            {
                .name = "DATAPORT TEXTURE CACHE HIT XECORE3",
                .symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE3",
                .desc = "Number of cache requests from the Dataport to the Render Cache that resulted in a cache hit",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext85__dataport_texture_cache_hit_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext85_DATAPORT_TEXTURE_CACHE_HIT_XECORE3_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext85__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext85__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE DATAPORT READ MESSAGE COUNT XECORE0",
                .symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE0",
                .desc = "Number of read messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext85__xve_dataport_read_message_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext85_XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE DATAPORT READ MESSAGE COUNT XECORE1",
                .symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE1",
                .desc = "Number of read messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext85__xve_dataport_read_message_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext85_XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE1_availability,
            },

            {
                .name = "XVE DATAPORT READ MESSAGE COUNT XECORE2",
                .symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE2",
                .desc = "Number of read messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext85__xve_dataport_read_message_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext85_XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE2_availability,
            },

            {
                .name = "XVE DATAPORT READ MESSAGE COUNT XECORE3",
                .symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE3",
                .desc = "Number of read messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext85__xve_dataport_read_message_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext85_XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}

static bool mtlgt2_ext87_XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext87_XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext87_XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext87_XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext87_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext87";
    metric_set->symbol_name = "Ext87";
    metric_set->hw_config_guid = "b96d78d7-c0c8-4941-9f28-e746f36627e4";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext87_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext87__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext87__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext87__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext87__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE0",
                .symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE0",
                .desc = "Number of write messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext87__xve_dataport_write_message_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext87_XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE1",
                .symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE1",
                .desc = "Number of write messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext87__xve_dataport_write_message_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext87_XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE1_availability,
            },

            {
                .name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE2",
                .symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE2",
                .desc = "Number of write messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext87__xve_dataport_write_message_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext87_XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE2_availability,
            },

            {
                .name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE3",
                .symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE3",
                .desc = "Number of write messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext87__xve_dataport_write_message_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext87_XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext91_XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext91_XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext91_XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext91_XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext91_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext91";
    metric_set->symbol_name = "Ext91";
    metric_set->hw_config_guid = "55e5926a-364e-45f0-bbcd-69375ac61391";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext91_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext91__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext91__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext91__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext91__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE0",
                .symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE0",
                .desc = "Number of atomic messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext91__xve_dataport_atomic_message_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext91_XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE1",
                .symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE1",
                .desc = "Number of atomic messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext91__xve_dataport_atomic_message_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext91_XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE1_availability,
            },

            {
                .name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE2",
                .symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE2",
                .desc = "Number of atomic messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext91__xve_dataport_atomic_message_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext91_XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE2_availability,
            },

            {
                .name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE3",
                .symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE3",
                .desc = "Number of atomic messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext91__xve_dataport_atomic_message_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext91_XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext93_XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext93_XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext93_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext93";
    metric_set->symbol_name = "Ext93";
    metric_set->hw_config_guid = "a06cf71c-ad14-49b8-8a22-b367118514bb";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext93_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext93__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext93__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext93__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext93__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE0",
                .symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE0",
                .desc = "Number of return message payload transactions sent from the Dataport to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext93__xve_dataport_register_response_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext93_XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE1",
                .symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE1",
                .desc = "Number of return message payload transactions sent from the Dataport to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_float = mtlgt2__ext93__xve_dataport_register_response_count_xecore1__read,
                .max_float = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext93_XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE1_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool mtlgt2_ext94_XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext94_XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext94_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext94";
    metric_set->symbol_name = "Ext94";
    metric_set->hw_config_guid = "a05152f2-80f2-47cc-add7-70f4664b58e8";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext94_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext94__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext94__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext94__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext94__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE2",
                .symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE2",
                .desc = "Number of return message payload transactions sent from the Dataport to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_float = mtlgt2__ext94__xve_dataport_register_response_count_xecore2__read,
                .max_float = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext94_XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE2_availability,
            },

            {
                .name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE3",
                .symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE3",
                .desc = "Number of return message payload transactions sent from the Dataport to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_float = mtlgt2__ext94__xve_dataport_register_response_count_xecore3__read,
                .max_float = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext94_XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool mtlgt2_ext97_XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext97_XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext97_XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext97_XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext97_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext97";
    metric_set->symbol_name = "Ext97";
    metric_set->hw_config_guid = "39f8d4d2-b28d-40a3-b545-a57865d7714e";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext97_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext97__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext97__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext97__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext97__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE0",
                .symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE0",
                .desc = "Number of message payload transactions sent from XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext97__xve_dataport_register_request_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext97_XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE1",
                .symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE1",
                .desc = "Number of message payload transactions sent from XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext97__xve_dataport_register_request_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext97_XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE1_availability,
            },

            {
                .name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE2",
                .symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE2",
                .desc = "Number of message payload transactions sent from XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext97__xve_dataport_register_request_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext97_XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE2_availability,
            },

            {
                .name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE3",
                .symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE3",
                .desc = "Number of message payload transactions sent from XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext97__xve_dataport_register_request_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext97_XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext98_SAMPLER_OUTPUT_READY_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext98_SAMPLER_OUTPUT_READY_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext98_SAMPLER_OUTPUT_READY_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext98_SAMPLER_OUTPUT_READY_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext98_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext98";
    metric_set->symbol_name = "Ext98";
    metric_set->hw_config_guid = "ee9377fe-2623-4588-8ffc-517e34c2eb75";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext98_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext98__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext98__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext98__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext98__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "SAMPLER OUTPUT READY XECORE0",
                .symbol_name = "SAMPLER_OUTPUT_READY_XECORE0",
                .desc = "Percentage of time in which Sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext98__sampler_output_ready_xecore0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext98_SAMPLER_OUTPUT_READY_XECORE0_availability,
            },

            {
                .name = "SAMPLER OUTPUT READY XECORE1",
                .symbol_name = "SAMPLER_OUTPUT_READY_XECORE1",
                .desc = "Percentage of time in which Sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext98__sampler_output_ready_xecore1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext98_SAMPLER_OUTPUT_READY_XECORE1_availability,
            },

            {
                .name = "SAMPLER OUTPUT READY XECORE2",
                .symbol_name = "SAMPLER_OUTPUT_READY_XECORE2",
                .desc = "Percentage of time in which Sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext98__sampler_output_ready_xecore2__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext98_SAMPLER_OUTPUT_READY_XECORE2_availability,
            },

            {
                .name = "SAMPLER OUTPUT READY XECORE3",
                .symbol_name = "SAMPLER_OUTPUT_READY_XECORE3",
                .desc = "Percentage of time in which Sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext98__sampler_output_ready_xecore3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext98_SAMPLER_OUTPUT_READY_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext100_SAMPLER_INPUT_AVAILABLE_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext100_SAMPLER_INPUT_AVAILABLE_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext100_SAMPLER_INPUT_AVAILABLE_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext100_SAMPLER_INPUT_AVAILABLE_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext100_SAMPLER_MEMORY_LATENCY_STALL_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext100_SAMPLER_MEMORY_LATENCY_STALL_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext100_SAMPLER_MEMORY_LATENCY_STALL_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext100_SAMPLER_MEMORY_LATENCY_STALL_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext100_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext100";
    metric_set->symbol_name = "Ext100";
    metric_set->hw_config_guid = "b5533650-f6f1-4f66-ad40-6b4aba600102";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext100_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext100__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext100__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext100__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext100__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "SAMPLER INPUT AVAILABLE XECORE0",
                .symbol_name = "SAMPLER_INPUT_AVAILABLE_XECORE0",
                .desc = "Percentage of time in which Sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext100__sampler_input_available_xecore0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext100_SAMPLER_INPUT_AVAILABLE_XECORE0_availability,
            },

            {
                .name = "SAMPLER INPUT AVAILABLE XECORE1",
                .symbol_name = "SAMPLER_INPUT_AVAILABLE_XECORE1",
                .desc = "Percentage of time in which Sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext100__sampler_input_available_xecore1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext100_SAMPLER_INPUT_AVAILABLE_XECORE1_availability,
            },

            {
                .name = "SAMPLER INPUT AVAILABLE XECORE2",
                .symbol_name = "SAMPLER_INPUT_AVAILABLE_XECORE2",
                .desc = "Percentage of time in which Sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext100__sampler_input_available_xecore2__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext100_SAMPLER_INPUT_AVAILABLE_XECORE2_availability,
            },

            {
                .name = "SAMPLER INPUT AVAILABLE XECORE3",
                .symbol_name = "SAMPLER_INPUT_AVAILABLE_XECORE3",
                .desc = "Percentage of time in which Sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext100__sampler_input_available_xecore3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext100_SAMPLER_INPUT_AVAILABLE_XECORE3_availability,
            },

            {
                .name = "SAMPLER MEMORY LATENCY STALL XECORE0",
                .symbol_name = "SAMPLER_MEMORY_LATENCY_STALL_XECORE0",
                .desc = "Percentage of time in which Sampler stalled due to latency hiding structure full",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext100__sampler_memory_latency_stall_xecore0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext100_SAMPLER_MEMORY_LATENCY_STALL_XECORE0_availability,
            },

            {
                .name = "SAMPLER MEMORY LATENCY STALL XECORE1",
                .symbol_name = "SAMPLER_MEMORY_LATENCY_STALL_XECORE1",
                .desc = "Percentage of time in which Sampler stalled due to latency hiding structure full",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext100__sampler_memory_latency_stall_xecore1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext100_SAMPLER_MEMORY_LATENCY_STALL_XECORE1_availability,
            },

            {
                .name = "SAMPLER MEMORY LATENCY STALL XECORE2",
                .symbol_name = "SAMPLER_MEMORY_LATENCY_STALL_XECORE2",
                .desc = "Percentage of time in which Sampler stalled due to latency hiding structure full",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext100__sampler_memory_latency_stall_xecore2__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext100_SAMPLER_MEMORY_LATENCY_STALL_XECORE2_availability,
            },

            {
                .name = "SAMPLER MEMORY LATENCY STALL XECORE3",
                .symbol_name = "SAMPLER_MEMORY_LATENCY_STALL_XECORE3",
                .desc = "Percentage of time in which Sampler stalled due to latency hiding structure full",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext100__sampler_memory_latency_stall_xecore3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext100_SAMPLER_MEMORY_LATENCY_STALL_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}

static bool mtlgt2_ext101_THREAD_DISPATCH_INPUT_AVAILABLE_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext101_THREAD_DISPATCH_INPUT_AVAILABLE_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext101_THREAD_DISPATCH_INPUT_AVAILABLE_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext101_THREAD_DISPATCH_INPUT_AVAILABLE_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext101_THREAD_DISPATCH_STALL_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext101_THREAD_DISPATCH_STALL_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext101_THREAD_DISPATCH_STALL_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext101_THREAD_DISPATCH_STALL_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext101_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext101";
    metric_set->symbol_name = "Ext101";
    metric_set->hw_config_guid = "136839ab-66a3-42ac-bca4-1cfca1d3088e";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext101_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext101__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext101__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext101__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext101__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "THREAD DISPATCH INPUT AVAILABLE XECORE0",
                .symbol_name = "THREAD_DISPATCH_INPUT_AVAILABLE_XECORE0",
                .desc = "Percentage of time in which Thread Dispatch input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext101__thread_dispatch_input_available_xecore0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext101_THREAD_DISPATCH_INPUT_AVAILABLE_XECORE0_availability,
            },

            {
                .name = "THREAD DISPATCH INPUT AVAILABLE XECORE1",
                .symbol_name = "THREAD_DISPATCH_INPUT_AVAILABLE_XECORE1",
                .desc = "Percentage of time in which Thread Dispatch input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext101__thread_dispatch_input_available_xecore1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext101_THREAD_DISPATCH_INPUT_AVAILABLE_XECORE1_availability,
            },

            {
                .name = "THREAD DISPATCH INPUT AVAILABLE XECORE2",
                .symbol_name = "THREAD_DISPATCH_INPUT_AVAILABLE_XECORE2",
                .desc = "Percentage of time in which Thread Dispatch input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext101__thread_dispatch_input_available_xecore2__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext101_THREAD_DISPATCH_INPUT_AVAILABLE_XECORE2_availability,
            },

            {
                .name = "THREAD DISPATCH INPUT AVAILABLE XECORE3",
                .symbol_name = "THREAD_DISPATCH_INPUT_AVAILABLE_XECORE3",
                .desc = "Percentage of time in which Thread Dispatch input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext101__thread_dispatch_input_available_xecore3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext101_THREAD_DISPATCH_INPUT_AVAILABLE_XECORE3_availability,
            },

            {
                .name = "THREAD DISPATCH STALL XECORE0",
                .symbol_name = "THREAD_DISPATCH_STALL_XECORE0",
                .desc = "Percentage of time in which Thread Dispatch is stalled waiting for threads to be available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext101__thread_dispatch_stall_xecore0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext101_THREAD_DISPATCH_STALL_XECORE0_availability,
            },

            {
                .name = "THREAD DISPATCH STALL XECORE1",
                .symbol_name = "THREAD_DISPATCH_STALL_XECORE1",
                .desc = "Percentage of time in which Thread Dispatch is stalled waiting for threads to be available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext101__thread_dispatch_stall_xecore1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext101_THREAD_DISPATCH_STALL_XECORE1_availability,
            },

            {
                .name = "THREAD DISPATCH STALL XECORE2",
                .symbol_name = "THREAD_DISPATCH_STALL_XECORE2",
                .desc = "Percentage of time in which Thread Dispatch is stalled waiting for threads to be available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext101__thread_dispatch_stall_xecore2__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext101_THREAD_DISPATCH_STALL_XECORE2_availability,
            },

            {
                .name = "THREAD DISPATCH STALL XECORE3",
                .symbol_name = "THREAD_DISPATCH_STALL_XECORE3",
                .desc = "Percentage of time in which Thread Dispatch is stalled waiting for threads to be available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext101__thread_dispatch_stall_xecore3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext101_THREAD_DISPATCH_STALL_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}

static bool mtlgt2_ext102_SAMPLER_TEXTURE_CACHE_ACCESS_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext102_SAMPLER_TEXTURE_CACHE_ACCESS_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext102_SAMPLER_TEXTURE_CACHE_ACCESS_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext102_SAMPLER_TEXTURE_CACHE_ACCESS_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext102_SAMPLER_TEXTURE_CACHE_MISS_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext102_SAMPLER_TEXTURE_CACHE_MISS_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext102_SAMPLER_TEXTURE_CACHE_MISS_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext102_SAMPLER_TEXTURE_CACHE_MISS_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext102_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext102";
    metric_set->symbol_name = "Ext102";
    metric_set->hw_config_guid = "bd8e9b37-35b3-4a94-8ff7-bbad7d67642c";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext102_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext102__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext102__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext102__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext102__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "SAMPLER TEXTURE CACHE ACCESS XECORE0",
                .symbol_name = "SAMPLER_TEXTURE_CACHE_ACCESS_XECORE0",
                .desc = "Number of Sampler L1 requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext102__sampler_texture_cache_access_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext102_SAMPLER_TEXTURE_CACHE_ACCESS_XECORE0_availability,
            },

            {
                .name = "SAMPLER TEXTURE CACHE ACCESS XECORE1",
                .symbol_name = "SAMPLER_TEXTURE_CACHE_ACCESS_XECORE1",
                .desc = "Number of Sampler L1 requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext102__sampler_texture_cache_access_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext102_SAMPLER_TEXTURE_CACHE_ACCESS_XECORE1_availability,
            },

            {
                .name = "SAMPLER TEXTURE CACHE ACCESS XECORE2",
                .symbol_name = "SAMPLER_TEXTURE_CACHE_ACCESS_XECORE2",
                .desc = "Number of Sampler L1 requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext102__sampler_texture_cache_access_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext102_SAMPLER_TEXTURE_CACHE_ACCESS_XECORE2_availability,
            },

            {
                .name = "SAMPLER TEXTURE CACHE ACCESS XECORE3",
                .symbol_name = "SAMPLER_TEXTURE_CACHE_ACCESS_XECORE3",
                .desc = "Number of Sampler L1 requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext102__sampler_texture_cache_access_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext102_SAMPLER_TEXTURE_CACHE_ACCESS_XECORE3_availability,
            },

            {
                .name = "SAMPLER TEXTURE CACHE MISS XECORE0",
                .symbol_name = "SAMPLER_TEXTURE_CACHE_MISS_XECORE0",
                .desc = "Number of Sampler L1 misses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext102__sampler_texture_cache_miss_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext102_SAMPLER_TEXTURE_CACHE_MISS_XECORE0_availability,
            },

            {
                .name = "SAMPLER TEXTURE CACHE MISS XECORE1",
                .symbol_name = "SAMPLER_TEXTURE_CACHE_MISS_XECORE1",
                .desc = "Number of Sampler L1 misses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext102__sampler_texture_cache_miss_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext102_SAMPLER_TEXTURE_CACHE_MISS_XECORE1_availability,
            },

            {
                .name = "SAMPLER TEXTURE CACHE MISS XECORE2",
                .symbol_name = "SAMPLER_TEXTURE_CACHE_MISS_XECORE2",
                .desc = "Number of Sampler L1 misses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext102__sampler_texture_cache_miss_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext102_SAMPLER_TEXTURE_CACHE_MISS_XECORE2_availability,
            },

            {
                .name = "SAMPLER TEXTURE CACHE MISS XECORE3",
                .symbol_name = "SAMPLER_TEXTURE_CACHE_MISS_XECORE3",
                .desc = "Number of Sampler L1 misses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext102__sampler_texture_cache_miss_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext102_SAMPLER_TEXTURE_CACHE_MISS_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}

static bool mtlgt2_ext104_ASYNC_GPGPU_THREAD_EXIT_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext104_GPGPU_THREADGROUP_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext104_TASK_THREADGROUP_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext104_TASK_THREAD_EXIT_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext104_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext104";
    metric_set->symbol_name = "Ext104";
    metric_set->hw_config_guid = "576a210f-b921-46dc-9af7-7f34eb1d368e";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext104_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "ASYNC GPGPU THREAD EXIT COUNT XECORE0",
                .symbol_name = "ASYNC_GPGPU_THREAD_EXIT_COUNT_XECORE0",
                .desc = "Number of Async GPGPU EOT messages received",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext104__async_gpgpu_thread_exit_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext104_ASYNC_GPGPU_THREAD_EXIT_COUNT_XECORE0_availability,
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext104__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext104__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPGPU THREADGROUP COUNT XECORE2",
                .symbol_name = "GPGPU_THREADGROUP_COUNT_XECORE2",
                .desc = "Number of GPGPU threadgroups dispatched",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext104__gpgpu_threadgroup_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext104_GPGPU_THREADGROUP_COUNT_XECORE2_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext104__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext104__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TASK THREADGROUP COUNT XECORE2",
                .symbol_name = "TASK_THREADGROUP_COUNT_XECORE2",
                .desc = "Number of Task Shader threadgroups dispatched",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext104__task_threadgroup_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext104_TASK_THREADGROUP_COUNT_XECORE2_availability,
            },

            {
                .name = "TASK THREAD EXIT COUNT XECORE0",
                .symbol_name = "TASK_THREAD_EXIT_COUNT_XECORE0",
                .desc = "Number of Task Shader EOT messages received",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext104__task_thread_exit_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext104_TASK_THREAD_EXIT_COUNT_XECORE0_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext105_ASYNC_GPGPU_THREAD_EXIT_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext105_GPGPU_THREADGROUP_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext105_TASK_THREADGROUP_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext105_TASK_THREAD_EXIT_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext105_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext105";
    metric_set->symbol_name = "Ext105";
    metric_set->hw_config_guid = "96b32930-859d-4fa8-8d81-4d26a160f0e8";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext105_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "ASYNC GPGPU THREAD EXIT COUNT XECORE1",
                .symbol_name = "ASYNC_GPGPU_THREAD_EXIT_COUNT_XECORE1",
                .desc = "Number of Async GPGPU EOT messages received",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext105__async_gpgpu_thread_exit_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext105_ASYNC_GPGPU_THREAD_EXIT_COUNT_XECORE1_availability,
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext105__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext105__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPGPU THREADGROUP COUNT XECORE3",
                .symbol_name = "GPGPU_THREADGROUP_COUNT_XECORE3",
                .desc = "Number of GPGPU threadgroups dispatched",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext105__gpgpu_threadgroup_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext105_GPGPU_THREADGROUP_COUNT_XECORE3_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext105__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext105__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TASK THREADGROUP COUNT XECORE3",
                .symbol_name = "TASK_THREADGROUP_COUNT_XECORE3",
                .desc = "Number of Task Shader threadgroups dispatched",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext105__task_threadgroup_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext105_TASK_THREADGROUP_COUNT_XECORE3_availability,
            },

            {
                .name = "TASK THREAD EXIT COUNT XECORE1",
                .symbol_name = "TASK_THREAD_EXIT_COUNT_XECORE1",
                .desc = "Number of Task Shader EOT messages received",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext105__task_thread_exit_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext105_TASK_THREAD_EXIT_COUNT_XECORE1_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext106_ASYNC_GPGPU_THREAD_EXIT_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext106_GPGPU_THREADGROUP_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext106_TASK_THREADGROUP_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext106_TASK_THREAD_EXIT_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext106_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext106";
    metric_set->symbol_name = "Ext106";
    metric_set->hw_config_guid = "bbe4bf0d-03a3-482a-869c-1c6e71d52dac";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext106_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "ASYNC GPGPU THREAD EXIT COUNT XECORE2",
                .symbol_name = "ASYNC_GPGPU_THREAD_EXIT_COUNT_XECORE2",
                .desc = "Number of Async GPGPU EOT messages received",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext106__async_gpgpu_thread_exit_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext106_ASYNC_GPGPU_THREAD_EXIT_COUNT_XECORE2_availability,
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext106__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext106__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPGPU THREADGROUP COUNT XECORE0",
                .symbol_name = "GPGPU_THREADGROUP_COUNT_XECORE0",
                .desc = "Number of GPGPU threadgroups dispatched",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext106__gpgpu_threadgroup_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext106_GPGPU_THREADGROUP_COUNT_XECORE0_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext106__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext106__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TASK THREADGROUP COUNT XECORE0",
                .symbol_name = "TASK_THREADGROUP_COUNT_XECORE0",
                .desc = "Number of Task Shader threadgroups dispatched",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext106__task_threadgroup_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext106_TASK_THREADGROUP_COUNT_XECORE0_availability,
            },

            {
                .name = "TASK THREAD EXIT COUNT XECORE2",
                .symbol_name = "TASK_THREAD_EXIT_COUNT_XECORE2",
                .desc = "Number of Task Shader EOT messages received",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext106__task_thread_exit_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext106_TASK_THREAD_EXIT_COUNT_XECORE2_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext107_ASYNC_GPGPU_THREAD_EXIT_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext107_GPGPU_THREADGROUP_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext107_TASK_THREADGROUP_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext107_TASK_THREAD_EXIT_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext107_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext107";
    metric_set->symbol_name = "Ext107";
    metric_set->hw_config_guid = "02eafe17-886d-4559-b18d-c661fd6914c0";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext107_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "ASYNC GPGPU THREAD EXIT COUNT XECORE3",
                .symbol_name = "ASYNC_GPGPU_THREAD_EXIT_COUNT_XECORE3",
                .desc = "Number of Async GPGPU EOT messages received",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext107__async_gpgpu_thread_exit_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext107_ASYNC_GPGPU_THREAD_EXIT_COUNT_XECORE3_availability,
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext107__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext107__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPGPU THREADGROUP COUNT XECORE1",
                .symbol_name = "GPGPU_THREADGROUP_COUNT_XECORE1",
                .desc = "Number of GPGPU threadgroups dispatched",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext107__gpgpu_threadgroup_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext107_GPGPU_THREADGROUP_COUNT_XECORE1_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext107__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext107__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TASK THREADGROUP COUNT XECORE1",
                .symbol_name = "TASK_THREADGROUP_COUNT_XECORE1",
                .desc = "Number of Task Shader threadgroups dispatched",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext107__task_threadgroup_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext107_TASK_THREADGROUP_COUNT_XECORE1_availability,
            },

            {
                .name = "TASK THREAD EXIT COUNT XECORE3",
                .symbol_name = "TASK_THREAD_EXIT_COUNT_XECORE3",
                .desc = "Number of Task Shader EOT messages received",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext107__task_thread_exit_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext107_TASK_THREAD_EXIT_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext113_THREAD_DISPATCH_PS_ACTIVE_CYCLES_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext113_THREAD_DISPATCH_PS_ACTIVE_CYCLES_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext113_THREAD_DISPATCH_PS_ACTIVE_CYCLES_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext113_THREAD_DISPATCH_PS_ACTIVE_CYCLES_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext113_THREAD_DISPATCH_QUEUE0_ACTIVE_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext113_THREAD_DISPATCH_QUEUE0_ACTIVE_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext113_THREAD_DISPATCH_QUEUE0_ACTIVE_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext113_THREAD_DISPATCH_QUEUE0_ACTIVE_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext113_THREAD_DISPATCH_QUEUE1_ACTIVE_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext113_THREAD_DISPATCH_QUEUE1_ACTIVE_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext113_THREAD_DISPATCH_QUEUE1_ACTIVE_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext113_THREAD_DISPATCH_QUEUE1_ACTIVE_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext113_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext113";
    metric_set->symbol_name = "Ext113";
    metric_set->hw_config_guid = "8cb51ae4-6d00-44d5-9d24-29521022f02b";
    metric_set->counters = calloc(15, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext113_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext113__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext113__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext113__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext113__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "THREAD DISPATCH PS ACTIVE CYCLES XECORE0",
                .symbol_name = "THREAD_DISPATCH_PS_ACTIVE_CYCLES_XECORE0",
                .desc = "Percentage of time in which Pixel Shader threads are ready for dispatch in a particular Xe core",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext113__thread_dispatch_ps_active_cycles_xecore0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext113_THREAD_DISPATCH_PS_ACTIVE_CYCLES_XECORE0_availability,
            },

            {
                .name = "THREAD DISPATCH PS ACTIVE CYCLES XECORE1",
                .symbol_name = "THREAD_DISPATCH_PS_ACTIVE_CYCLES_XECORE1",
                .desc = "Percentage of time in which Pixel Shader threads are ready for dispatch in a particular Xe core",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext113__thread_dispatch_ps_active_cycles_xecore1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext113_THREAD_DISPATCH_PS_ACTIVE_CYCLES_XECORE1_availability,
            },

            {
                .name = "THREAD DISPATCH PS ACTIVE CYCLES XECORE2",
                .symbol_name = "THREAD_DISPATCH_PS_ACTIVE_CYCLES_XECORE2",
                .desc = "Percentage of time in which Pixel Shader threads are ready for dispatch in a particular Xe core",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext113__thread_dispatch_ps_active_cycles_xecore2__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext113_THREAD_DISPATCH_PS_ACTIVE_CYCLES_XECORE2_availability,
            },

            {
                .name = "THREAD DISPATCH PS ACTIVE CYCLES XECORE3",
                .symbol_name = "THREAD_DISPATCH_PS_ACTIVE_CYCLES_XECORE3",
                .desc = "Percentage of time in which Pixel Shader threads are ready for dispatch in a particular Xe core",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext113__thread_dispatch_ps_active_cycles_xecore3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext113_THREAD_DISPATCH_PS_ACTIVE_CYCLES_XECORE3_availability,
            },

            {
                .name = "THREAD DISPATCH QUEUE0 ACTIVE XECORE0",
                .symbol_name = "THREAD_DISPATCH_QUEUE0_ACTIVE_XECORE0",
                .desc = "Percentage of time in which non-Pixel Shader threads are ready for dispatch in a particular Xe core",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext113__thread_dispatch_queue0_active_xecore0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext113_THREAD_DISPATCH_QUEUE0_ACTIVE_XECORE0_availability,
            },

            {
                .name = "THREAD DISPATCH QUEUE0 ACTIVE XECORE1",
                .symbol_name = "THREAD_DISPATCH_QUEUE0_ACTIVE_XECORE1",
                .desc = "Percentage of time in which non-Pixel Shader threads are ready for dispatch in a particular Xe core",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext113__thread_dispatch_queue0_active_xecore1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext113_THREAD_DISPATCH_QUEUE0_ACTIVE_XECORE1_availability,
            },

            {
                .name = "THREAD DISPATCH QUEUE0 ACTIVE XECORE2",
                .symbol_name = "THREAD_DISPATCH_QUEUE0_ACTIVE_XECORE2",
                .desc = "Percentage of time in which non-Pixel Shader threads are ready for dispatch in a particular Xe core",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext113__thread_dispatch_queue0_active_xecore2__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext113_THREAD_DISPATCH_QUEUE0_ACTIVE_XECORE2_availability,
            },

            {
                .name = "THREAD DISPATCH QUEUE0 ACTIVE XECORE3",
                .symbol_name = "THREAD_DISPATCH_QUEUE0_ACTIVE_XECORE3",
                .desc = "Percentage of time in which non-Pixel Shader threads are ready for dispatch in a particular Xe core",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext113__thread_dispatch_queue0_active_xecore3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext113_THREAD_DISPATCH_QUEUE0_ACTIVE_XECORE3_availability,
            },

            {
                .name = "THREAD DISPATCH QUEUE1 ACTIVE XECORE0",
                .symbol_name = "THREAD_DISPATCH_QUEUE1_ACTIVE_XECORE0",
                .desc = "Percentage of time in which Async GPGPU threads are ready for dispatch in a particular Xe core",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext113__thread_dispatch_queue1_active_xecore0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext113_THREAD_DISPATCH_QUEUE1_ACTIVE_XECORE0_availability,
            },

            {
                .name = "THREAD DISPATCH QUEUE1 ACTIVE XECORE1",
                .symbol_name = "THREAD_DISPATCH_QUEUE1_ACTIVE_XECORE1",
                .desc = "Percentage of time in which Async GPGPU threads are ready for dispatch in a particular Xe core",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext113__thread_dispatch_queue1_active_xecore1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext113_THREAD_DISPATCH_QUEUE1_ACTIVE_XECORE1_availability,
            },

            {
                .name = "THREAD DISPATCH QUEUE1 ACTIVE XECORE2",
                .symbol_name = "THREAD_DISPATCH_QUEUE1_ACTIVE_XECORE2",
                .desc = "Percentage of time in which Async GPGPU threads are ready for dispatch in a particular Xe core",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext113__thread_dispatch_queue1_active_xecore2__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext113_THREAD_DISPATCH_QUEUE1_ACTIVE_XECORE2_availability,
            },

            {
                .name = "THREAD DISPATCH QUEUE1 ACTIVE XECORE3",
                .symbol_name = "THREAD_DISPATCH_QUEUE1_ACTIVE_XECORE3",
                .desc = "Percentage of time in which Async GPGPU threads are ready for dispatch in a particular Xe core",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext113__thread_dispatch_queue1_active_xecore3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext113_THREAD_DISPATCH_QUEUE1_ACTIVE_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 15);
}

static bool mtlgt2_ext116_THREADGROUP_DISPATCH_RESOURCE_STALL_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext116_THREADGROUP_DISPATCH_RESOURCE_STALL_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext116_THREADGROUP_DISPATCH_RESOURCE_STALL_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext116_THREADGROUP_DISPATCH_RESOURCE_STALL_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext116_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext116";
    metric_set->symbol_name = "Ext116";
    metric_set->hw_config_guid = "c50c1328-01a4-44a4-bc10-cea109a86100";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext116_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext116__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext116__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext116__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext116__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "THREADGROUP DISPATCH RESOURCE STALL XECORE0",
                .symbol_name = "THREADGROUP_DISPATCH_RESOURCE_STALL_XECORE0",
                .desc = "Percentage of time in which Thread Spawner is stalled waiting for resources to be available (SLM, Barrier, BTD stack)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext116__threadgroup_dispatch_resource_stall_xecore0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext116_THREADGROUP_DISPATCH_RESOURCE_STALL_XECORE0_availability,
            },

            {
                .name = "THREADGROUP DISPATCH RESOURCE STALL XECORE1",
                .symbol_name = "THREADGROUP_DISPATCH_RESOURCE_STALL_XECORE1",
                .desc = "Percentage of time in which Thread Spawner is stalled waiting for resources to be available (SLM, Barrier, BTD stack)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext116__threadgroup_dispatch_resource_stall_xecore1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext116_THREADGROUP_DISPATCH_RESOURCE_STALL_XECORE1_availability,
            },

            {
                .name = "THREADGROUP DISPATCH RESOURCE STALL XECORE2",
                .symbol_name = "THREADGROUP_DISPATCH_RESOURCE_STALL_XECORE2",
                .desc = "Percentage of time in which Thread Spawner is stalled waiting for resources to be available (SLM, Barrier, BTD stack)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext116__threadgroup_dispatch_resource_stall_xecore2__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext116_THREADGROUP_DISPATCH_RESOURCE_STALL_XECORE2_availability,
            },

            {
                .name = "THREADGROUP DISPATCH RESOURCE STALL XECORE3",
                .symbol_name = "THREADGROUP_DISPATCH_RESOURCE_STALL_XECORE3",
                .desc = "Percentage of time in which Thread Spawner is stalled waiting for resources to be available (SLM, Barrier, BTD stack)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext116__threadgroup_dispatch_resource_stall_xecore3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext116_THREADGROUP_DISPATCH_RESOURCE_STALL_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext118_AMFS_CACHE_HIT_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext118_AMFS_CACHE_MISS_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext118_AMFS_STALL_ALL_INPUT_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext118_AMFS_STALL_ANY_INPUT_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext118_RENDER_CACHE_HIT_L3NODE0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext118_RENDER_CACHE_INPUT_AVAILABLE_L3NODE0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext118_RENDER_CACHE_OUTPUT_READY_L3NODE0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext118_RENDER_CACHE_READ_L3NODE0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext118_RENDER_CACHE_WRITE_L3NODE0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext118_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext118";
    metric_set->symbol_name = "Ext118";
    metric_set->hw_config_guid = "3ac7b553-9dd8-4588-be88-8a50d4aa8497";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext118_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AMFS CACHE HIT SLICE0",
                .symbol_name = "AMFS_CACHE_HIT_SLICE0",
                .desc = "Number of hits in the AMFS cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext118__amfs_cache_hit_slice0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext118_AMFS_CACHE_HIT_SLICE0_availability,
            },

            {
                .name = "AMFS CACHE MISS SLICE0",
                .symbol_name = "AMFS_CACHE_MISS_SLICE0",
                .desc = "Number of cache misses in AMFS",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext118__amfs_cache_miss_slice0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext118_AMFS_CACHE_MISS_SLICE0_availability,
            },

            {
                .name = "AMFS STALL ALL INPUT SLICE0",
                .symbol_name = "AMFS_STALL_ALL_INPUT_SLICE0",
                .desc = "Percentage of time in which AMFS stalls at both of the color pipe inputs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext118__amfs_stall_all_input_slice0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext118_AMFS_STALL_ALL_INPUT_SLICE0_availability,
            },

            {
                .name = "AMFS STALL ANY INPUT SLICE0",
                .symbol_name = "AMFS_STALL_ANY_INPUT_SLICE0",
                .desc = "Percentage of time in which AMFS stalls at any of the color pipe inputs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext118__amfs_stall_any_input_slice0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext118_AMFS_STALL_ANY_INPUT_SLICE0_availability,
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext118__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext118__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext118__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext118__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "RENDER CACHE HIT L3NODE0",
                .symbol_name = "RENDER_CACHE_HIT_L3NODE0",
                .desc = "Number of Render Cache hits",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext118__render_cache_hit_l3_node0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext118_RENDER_CACHE_HIT_L3NODE0_availability,
            },

            {
                .name = "RENDER CACHE INPUT AVAILABLE _L3NODE0",
                .symbol_name = "RENDER_CACHE_INPUT_AVAILABLE_L3NODE0",
                .desc = "Percentage of time when Render Cache input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext118__render_cache_input_available_l3_node0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext118_RENDER_CACHE_INPUT_AVAILABLE_L3NODE0_availability,
            },

            {
                .name = "RENDER CACHE OUTPUT READY _L3NODE0",
                .symbol_name = "RENDER_CACHE_OUTPUT_READY_L3NODE0",
                .desc = "Percentage of time when Render Cache output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext118__render_cache_output_ready_l3_node0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext118_RENDER_CACHE_OUTPUT_READY_L3NODE0_availability,
            },

            {
                .name = "RENDER CACHE READ L3NODE0",
                .symbol_name = "RENDER_CACHE_READ_L3NODE0",
                .desc = "Number of Render Cache reads",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext118__render_cache_read_l3_node0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext118_RENDER_CACHE_READ_L3NODE0_availability,
            },

            {
                .name = "RENDER CACHE WRITE L3NODE0",
                .symbol_name = "RENDER_CACHE_WRITE_L3NODE0",
                .desc = "Number of Render Cache writes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext118__render_cache_write_l3_node0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext118_RENDER_CACHE_WRITE_L3NODE0_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 12);
}

static bool mtlgt2_ext120_PIXEL_POST_PROCESS_INPUT_AVAILABLE_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext120_PIXEL_POST_PROCESS_INPUT_AVAILABLE_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext120_PIXEL_POST_PROCESS_INPUT_AVAILABLE_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext120_PIXEL_POST_PROCESS_INPUT_AVAILABLE_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext120_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext120";
    metric_set->symbol_name = "Ext120";
    metric_set->hw_config_guid = "39bbba4c-b77d-424a-9156-ede3d325df25";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext120_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext120__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext120__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext120__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext120__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "PIXEL POST PROCESS INPUT AVAILABLE XECORE0",
                .symbol_name = "PIXEL_POST_PROCESS_INPUT_AVAILABLE_XECORE0",
                .desc = "Percentage of time in which Color Pipeline input ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext120__pixel_post_process_input_available_xecore0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext120_PIXEL_POST_PROCESS_INPUT_AVAILABLE_XECORE0_availability,
            },

            {
                .name = "PIXEL POST PROCESS INPUT AVAILABLE XECORE1",
                .symbol_name = "PIXEL_POST_PROCESS_INPUT_AVAILABLE_XECORE1",
                .desc = "Percentage of time in which Color Pipeline input ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext120__pixel_post_process_input_available_xecore1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext120_PIXEL_POST_PROCESS_INPUT_AVAILABLE_XECORE1_availability,
            },

            {
                .name = "PIXEL POST PROCESS INPUT AVAILABLE XECORE2",
                .symbol_name = "PIXEL_POST_PROCESS_INPUT_AVAILABLE_XECORE2",
                .desc = "Percentage of time in which Color Pipeline input ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext120__pixel_post_process_input_available_xecore2__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext120_PIXEL_POST_PROCESS_INPUT_AVAILABLE_XECORE2_availability,
            },

            {
                .name = "PIXEL POST PROCESS INPUT AVAILABLE XECORE3",
                .symbol_name = "PIXEL_POST_PROCESS_INPUT_AVAILABLE_XECORE3",
                .desc = "Percentage of time in which Color Pipeline input ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext120__pixel_post_process_input_available_xecore3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext120_PIXEL_POST_PROCESS_INPUT_AVAILABLE_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext122_AMFS_4X4_SHADING_REQUEST_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext122_COLOR_PIPE_CACHE_LATENCY1_STALL_CPIPE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext122_COLOR_PIPE_CACHE_LATENCY1_STALL_CPIPE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext122_COLOR_PIPE_CACHE_LATENCY2_STALL_L3NODE0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext122_PIXEL_BACKEND_INPUT_AVAILABLE_L3NODE0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext122_PIXEL_BACKEND_OUTPUT_READY_L3NODE0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext122_PIXEL_POST_PROCESS_OUTPUT_READY_CPIPE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext122_PIXEL_POST_PROCESS_OUTPUT_READY_CPIPE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext122_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext122";
    metric_set->symbol_name = "Ext122";
    metric_set->hw_config_guid = "1c2b42f8-2763-4c20-85d9-5a5bd7381eb8";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext122_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AMFS 4X4 SHADING REQUEST SLICE0",
                .symbol_name = "AMFS_4X4_SHADING_REQUEST_SLICE0",
                .desc = "Number of Shading Request (evaluate) messages processed by AMFS",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext122__amfs_4_x4_shading_request_slice0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext122_AMFS_4X4_SHADING_REQUEST_SLICE0_availability,
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext122__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext122__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "COLOR PIPE CACHE LATENCY1 STALL CPIPE0",
                .symbol_name = "COLOR_PIPE_CACHE_LATENCY1_STALL_CPIPE0",
                .desc = "Percentage of time in which Color Pipeline stalled due to MultiSampling Cache latency hiding structure full",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext122__color_pipe_cache_latency1_stall_cpipe0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext122_COLOR_PIPE_CACHE_LATENCY1_STALL_CPIPE0_availability,
            },

            {
                .name = "COLOR PIPE CACHE LATENCY1 STALL CPIPE1",
                .symbol_name = "COLOR_PIPE_CACHE_LATENCY1_STALL_CPIPE1",
                .desc = "Percentage of time in which Color Pipeline stalled due to MultiSampling Cache latency hiding structure full",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext122__color_pipe_cache_latency1_stall_cpipe1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext122_COLOR_PIPE_CACHE_LATENCY1_STALL_CPIPE1_availability,
            },

            {
                .name = "COLOR PIPE CACHE LATENCY2 STALL L3NODE0",
                .symbol_name = "COLOR_PIPE_CACHE_LATENCY2_STALL_L3NODE0",
                .desc = "Percentage of time in which Color Pipeline stalled due to Render Cache latency hiding structure full",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext122__color_pipe_cache_latency2_stall_l3_node0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext122_COLOR_PIPE_CACHE_LATENCY2_STALL_L3NODE0_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext122__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext122__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "PIXEL BACKEND INPUT AVAILABLE _L3NODE0",
                .symbol_name = "PIXEL_BACKEND_INPUT_AVAILABLE_L3NODE0",
                .desc = "Percentage of time when  the data is available at input of Pixel Backend",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext122__pixel_backend_input_available_l3_node0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext122_PIXEL_BACKEND_INPUT_AVAILABLE_L3NODE0_availability,
            },

            {
                .name = "PIXEL BACKEND OUTPUT READY _L3NODE0",
                .symbol_name = "PIXEL_BACKEND_OUTPUT_READY_L3NODE0",
                .desc = "Percentage of time when  the data at Pixel Backend output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext122__pixel_backend_output_ready_l3_node0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext122_PIXEL_BACKEND_OUTPUT_READY_L3NODE0_availability,
            },

            {
                .name = "PIXEL POST PROCESS OUTPUT READY CPIPE0",
                .symbol_name = "PIXEL_POST_PROCESS_OUTPUT_READY_CPIPE0",
                .desc = "Percentage of time in which Color Pipeline pixel output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext122__pixel_post_process_output_ready_cpipe0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext122_PIXEL_POST_PROCESS_OUTPUT_READY_CPIPE0_availability,
            },

            {
                .name = "PIXEL POST PROCESS OUTPUT READY CPIPE1",
                .symbol_name = "PIXEL_POST_PROCESS_OUTPUT_READY_CPIPE1",
                .desc = "Percentage of time in which Color Pipeline pixel output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext122__pixel_post_process_output_ready_cpipe1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext122_PIXEL_POST_PROCESS_OUTPUT_READY_CPIPE1_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}

static bool mtlgt2_ext123_AMFS_L3_ACCESS_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext123_AMFS_L3_ATOMIC_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext123_CLIPPER_PRIMITIVE_FAR_NEAR_CLIP_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext123_PS_OUTPUT_AVAILABLE_CPIPE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext123_PS_OUTPUT_AVAILABLE_CPIPE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext123_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext123";
    metric_set->symbol_name = "Ext123";
    metric_set->hw_config_guid = "80240cbe-83d5-44dd-a03a-c498a6928be5";
    metric_set->counters = calloc(8, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext123_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AMFS L3 ACCESS SLICE0",
                .symbol_name = "AMFS_L3_ACCESS_SLICE0",
                .desc = "Number of AMFS accesses to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext123__amfs_l3_access_slice0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext123_AMFS_L3_ACCESS_SLICE0_availability,
            },

            {
                .name = "AMFS L3 ATOMIC SLICE0",
                .symbol_name = "AMFS_L3_ATOMIC_SLICE0",
                .desc = "Number of AMFS atomics to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext123__amfs_l3_atomic_slice0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext123_AMFS_L3_ATOMIC_SLICE0_availability,
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext123__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext123__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CLIPPER PRIMITIVE FAR NEAR CLIP SLICE0",
                .symbol_name = "CLIPPER_PRIMITIVE_FAR_NEAR_CLIP_SLICE0",
                .desc = "Number of primitives clipped by Clipper due to near/far planes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext123__clipper_primitive_far_near_clip_slice0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext123_CLIPPER_PRIMITIVE_FAR_NEAR_CLIP_SLICE0_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext123__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext123__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "PS OUTPUT AVAILABLE CPIPE0",
                .symbol_name = "PS_OUTPUT_AVAILABLE_CPIPE0",
                .desc = "Percentage of time in which Pixel Shader data is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext123__ps_output_available_cpipe0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext123_PS_OUTPUT_AVAILABLE_CPIPE0_availability,
            },

            {
                .name = "PS OUTPUT AVAILABLE CPIPE1",
                .symbol_name = "PS_OUTPUT_AVAILABLE_CPIPE1",
                .desc = "Percentage of time in which Pixel Shader data is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext123__ps_output_available_cpipe1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext123_PS_OUTPUT_AVAILABLE_CPIPE1_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 8);
}

static bool mtlgt2_ext124_CLIPPER_INPUT_AVAILABLE_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext124_CLIPPER_INPUT_VERTEX_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext124_CLIPPER_OUTPUT_READY_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext124_CLIPPER_PRIMITIVE_OUTPUT_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext124_STREAMOUT_OUTPUT_VERTEX_COUNT_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext124_STRIPSFAN_OUTPUT_READY_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext124_VERTEX_FETCH_INPUT_AVAILABLE_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext124_VERTEX_FETCH_OUTPUT_READY_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext124_VS_OUTPUT_READY_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext124_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext124";
    metric_set->symbol_name = "Ext124";
    metric_set->hw_config_guid = "f8d36c8e-4129-4962-afce-7917f98e9b2d";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext124_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext124__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext124__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CLIPPER INPUT AVAILABLE SLICE0",
                .symbol_name = "CLIPPER_INPUT_AVAILABLE_SLICE0",
                .desc = "Percentage of time in which Clipper has input available (from Vertex Shader or SOL)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext124__clipper_input_available_slice0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext124_CLIPPER_INPUT_AVAILABLE_SLICE0_availability,
            },

            {
                .name = "CLIPPER INPUT VERTEX SLICE0",
                .symbol_name = "CLIPPER_INPUT_VERTEX_SLICE0",
                .desc = "Number of Clipper input vertices",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext124__clipper_input_vertex_slice0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext124_CLIPPER_INPUT_VERTEX_SLICE0_availability,
            },

            {
                .name = "CLIPPER OUTPUT READY SLICE0",
                .symbol_name = "CLIPPER_OUTPUT_READY_SLICE0",
                .desc = "Percentage of time in which Clipper output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext124__clipper_output_ready_slice0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext124_CLIPPER_OUTPUT_READY_SLICE0_availability,
            },

            {
                .name = "CLIPPER PRIMITIVE OUTPUT SLICE0",
                .symbol_name = "CLIPPER_PRIMITIVE_OUTPUT_SLICE0",
                .desc = "Number of primitives going out of Clipper, must clip plus the trivial accept",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext124__clipper_primitive_output_slice0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext124_CLIPPER_PRIMITIVE_OUTPUT_SLICE0_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext124__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext124__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "STREAMOUT OUTPUT VERTEX COUNT SLICE0",
                .symbol_name = "STREAMOUT_OUTPUT_VERTEX_COUNT_SLICE0",
                .desc = "Number of vertices written by SOL",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext124__streamout_output_vertex_count_slice0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext124_STREAMOUT_OUTPUT_VERTEX_COUNT_SLICE0_availability,
            },

            {
                .name = "STRIPSFAN OUTPUT READY SLICE0",
                .symbol_name = "STRIPSFAN_OUTPUT_READY_SLICE0",
                .desc = "Percentage of time in which in which geometry pipeline output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext124__stripsfan_output_ready_slice0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext124_STRIPSFAN_OUTPUT_READY_SLICE0_availability,
            },

            {
                .name = "VERTEX FETCH INPUT AVAILABLE SLICE0",
                .symbol_name = "VERTEX_FETCH_INPUT_AVAILABLE_SLICE0",
                .desc = "Percentage of time in which Vertex Fetch input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext124__vertex_fetch_input_available_slice0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext124_VERTEX_FETCH_INPUT_AVAILABLE_SLICE0_availability,
            },

            {
                .name = "VERTEX FETCH OUTPUT READY SLICE0",
                .symbol_name = "VERTEX_FETCH_OUTPUT_READY_SLICE0",
                .desc = "Percentage of time in which Vertex Fetch output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext124__vertex_fetch_output_ready_slice0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext124_VERTEX_FETCH_OUTPUT_READY_SLICE0_availability,
            },

            {
                .name = "VS OUTPUT READY SLICE0",
                .symbol_name = "VS_OUTPUT_READY_SLICE0",
                .desc = "Percentage of time in which Vertex Shader output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext124__vs_output_ready_slice0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext124_VS_OUTPUT_READY_SLICE0_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 12);
}

static bool mtlgt2_ext126_CLIPPER_PRIMITIVE_CULL_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext126_CLIPPER_TRANSACTION_OUTPUT_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext126_RASTERIZER_INPUT_AVAILABLE_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext126_RASTERIZER_OUTPUT_READY_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext126_RASTERIZER_TRANSACTION_OUTPUT_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext126_STRIPSFAN_OBJECTS_CULL_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext126_STRIPSFAN_OBJECT_COUNT_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext126_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext126";
    metric_set->symbol_name = "Ext126";
    metric_set->hw_config_guid = "08670eec-8015-4c40-b900-d47b9824ec83";
    metric_set->counters = calloc(10, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext126_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext126__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext126__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CLIPPER PRIMITIVE CULL SLICE0",
                .symbol_name = "CLIPPER_PRIMITIVE_CULL_SLICE0",
                .desc = "Number of Clipper early cull primitives",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext126__clipper_primitive_cull_slice0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext126_CLIPPER_PRIMITIVE_CULL_SLICE0_availability,
            },

            {
                .name = "CLIPPER TRANSACTION OUTPUT SLICE0",
                .symbol_name = "CLIPPER_TRANSACTION_OUTPUT_SLICE0",
                .desc = "Number of elements pushed by Clipper into Stripsfan stage",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext126__clipper_transaction_output_slice0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext126_CLIPPER_TRANSACTION_OUTPUT_SLICE0_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext126__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext126__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "RASTERIZER INPUT AVAILABLE SLICE0",
                .symbol_name = "RASTERIZER_INPUT_AVAILABLE_SLICE0",
                .desc = "Percentage of time in which Rasterizer input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext126__rasterizer_input_available_slice0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext126_RASTERIZER_INPUT_AVAILABLE_SLICE0_availability,
            },

            {
                .name = "RASTERIZER OUTPUT READY SLICE0",
                .symbol_name = "RASTERIZER_OUTPUT_READY_SLICE0",
                .desc = "Percentage of time in which Rasterizer output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext126__rasterizer_output_ready_slice0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext126_RASTERIZER_OUTPUT_READY_SLICE0_availability,
            },

            {
                .name = "RASTERIZER TRANSACTION OUTPUT SLICE0",
                .symbol_name = "RASTERIZER_TRANSACTION_OUTPUT_SLICE0",
                .desc = "Number of transactions pushed from Rasterizer to the Z pipe",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext126__rasterizer_transaction_output_slice0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext126_RASTERIZER_TRANSACTION_OUTPUT_SLICE0_availability,
            },

            {
                .name = "STRIPSFAN OBJECTS CULL SLICE0",
                .symbol_name = "STRIPSFAN_OBJECTS_CULL_SLICE0",
                .desc = "Number of simple culled objects in Stripsfan stage",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext126__stripsfan_objects_cull_slice0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext126_STRIPSFAN_OBJECTS_CULL_SLICE0_availability,
            },

            {
                .name = "STRIPSFAN OBJECT COUNT SLICE0",
                .symbol_name = "STRIPSFAN_OBJECT_COUNT_SLICE0",
                .desc = "Number of objects exiting Stripsfan stage",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext126__stripsfan_object_count_slice0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext126_STRIPSFAN_OBJECT_COUNT_SLICE0_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 10);
}

static bool mtlgt2_ext128_URB_CROSS_SLICE_READ_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext128_URB_READ_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext128_URB_WRITE_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext128_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext128";
    metric_set->symbol_name = "Ext128";
    metric_set->hw_config_guid = "7d149ad7-90bd-4201-8791-2e8c1c4359e8";
    metric_set->counters = calloc(6, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext128_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext128__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext128__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext128__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext128__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "URB CROSS SLICE READ SLICE0",
                .symbol_name = "URB_CROSS_SLICE_READ_SLICE0",
                .desc = "Number of URB reads occurred from cross slices",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext128__urb_cross_slice_read_slice0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext128_URB_CROSS_SLICE_READ_SLICE0_availability,
            },

            {
                .name = "URB READ SLICE0",
                .symbol_name = "URB_READ_SLICE0",
                .desc = "Number of URB reads",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext128__urb_read_slice0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext128_URB_READ_SLICE0_availability,
            },

            {
                .name = "URB WRITE SLICE0",
                .symbol_name = "URB_WRITE_SLICE0",
                .desc = "Number of URB writes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext128__urb_write_slice0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext128_URB_WRITE_SLICE0_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 6);
}

static bool mtlgt2_ext130_EARLY_DEPTH_STENCIL_TEST_FAIL_NP_ZPIPE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext130_EARLY_DEPTH_STENCIL_TEST_FAIL_P_ZPIPE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext130_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext130";
    metric_set->symbol_name = "Ext130";
    metric_set->hw_config_guid = "52597b67-dea9-411c-845e-c7f7befa744e";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext130_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext130__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext130__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "EARLY DEPTH STENCIL TEST FAIL NP ZPIPE0",
                .symbol_name = "EARLY_DEPTH_STENCIL_TEST_FAIL_NP_ZPIPE0",
                .desc = "Number of non-promoted 2x2 that failed Depth / Stencil before the Pixel Shader that were previously ambiguous at HiZ",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext130__early_depth_stencil_test_fail_np_zpipe0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext130_EARLY_DEPTH_STENCIL_TEST_FAIL_NP_ZPIPE0_availability,
            },

            {
                .name = "EARLY DEPTH STENCIL TEST FAIL P ZPIPE0",
                .symbol_name = "EARLY_DEPTH_STENCIL_TEST_FAIL_P_ZPIPE0",
                .desc = "Number of promoted 2x2 that failed Depth / Stencil that were previously ambiguous at HiZ",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext130__early_depth_stencil_test_fail_p_zpipe0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext130_EARLY_DEPTH_STENCIL_TEST_FAIL_P_ZPIPE0_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext130__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext130__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool mtlgt2_ext131_EARLY_DEPTH_STENCIL_TEST_FAIL_NP_ZPIPE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext131_EARLY_DEPTH_STENCIL_TEST_FAIL_P_ZPIPE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext131_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext131";
    metric_set->symbol_name = "Ext131";
    metric_set->hw_config_guid = "56b5eb77-117c-4392-a4ed-6a809598c28f";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext131_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext131__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext131__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "EARLY DEPTH STENCIL TEST FAIL NP ZPIPE1",
                .symbol_name = "EARLY_DEPTH_STENCIL_TEST_FAIL_NP_ZPIPE1",
                .desc = "Number of non-promoted 2x2 that failed Depth / Stencil before the Pixel Shader that were previously ambiguous at HiZ",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext131__early_depth_stencil_test_fail_np_zpipe1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext131_EARLY_DEPTH_STENCIL_TEST_FAIL_NP_ZPIPE1_availability,
            },

            {
                .name = "EARLY DEPTH STENCIL TEST FAIL P ZPIPE1",
                .symbol_name = "EARLY_DEPTH_STENCIL_TEST_FAIL_P_ZPIPE1",
                .desc = "Number of promoted 2x2 that failed Depth / Stencil that were previously ambiguous at HiZ",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext131__early_depth_stencil_test_fail_p_zpipe1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext131_EARLY_DEPTH_STENCIL_TEST_FAIL_P_ZPIPE1_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext131__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext131__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool mtlgt2_ext134_HIZ_DEPTH_TEST_AMBIG_NP_ZPIPE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext134_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext134";
    metric_set->symbol_name = "Ext134";
    metric_set->hw_config_guid = "d4f5b1c3-553d-46f6-abb8-8535ee5e4c90";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext134_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext134__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext134__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext134__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext134__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "HIZ DEPTH TEST AMBIG NP ZPIPE0",
                .symbol_name = "HIZ_DEPTH_TEST_AMBIG_NP_ZPIPE0",
                .desc = "Number of non-promoted 2x2 that are ambiguous by hierarchical depth test",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = mtlgt2__ext134__hiz_depth_test_ambig_np_zpipe0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext134_HIZ_DEPTH_TEST_AMBIG_NP_ZPIPE0_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 4);
}

static bool mtlgt2_ext135_HIZ_DEPTH_TEST_AMBIG_NP_ZPIPE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext135_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext135";
    metric_set->symbol_name = "Ext135";
    metric_set->hw_config_guid = "2aa7d46b-8b53-4693-9e5b-1245dc85cb90";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext135_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext135__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext135__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext135__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext135__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "HIZ DEPTH TEST AMBIG NP ZPIPE1",
                .symbol_name = "HIZ_DEPTH_TEST_AMBIG_NP_ZPIPE1",
                .desc = "Number of non-promoted 2x2 that are ambiguous by hierarchical depth test",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = mtlgt2__ext135__hiz_depth_test_ambig_np_zpipe1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext135_HIZ_DEPTH_TEST_AMBIG_NP_ZPIPE1_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 4);
}

static bool mtlgt2_ext138_HIZ_DEPTH_TEST_AMBIG_P_ZPIPE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext138_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext138";
    metric_set->symbol_name = "Ext138";
    metric_set->hw_config_guid = "18d95a38-b79c-42ac-a1c1-f6f3ef5ee213";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext138_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext138__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext138__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext138__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext138__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "HIZ DEPTH TEST AMBIG P ZPIPE0",
                .symbol_name = "HIZ_DEPTH_TEST_AMBIG_P_ZPIPE0",
                .desc = "Number of promoted 2x2 that are ambiguous by hierarchical depth test",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = mtlgt2__ext138__hiz_depth_test_ambig_p_zpipe0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext138_HIZ_DEPTH_TEST_AMBIG_P_ZPIPE0_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 4);
}

static bool mtlgt2_ext139_HIZ_DEPTH_TEST_AMBIG_P_ZPIPE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext139_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext139";
    metric_set->symbol_name = "Ext139";
    metric_set->hw_config_guid = "7869d90b-8a61-40c5-b705-91ce55b64cd8";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext139_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext139__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext139__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext139__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext139__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "HIZ DEPTH TEST AMBIG P ZPIPE1",
                .symbol_name = "HIZ_DEPTH_TEST_AMBIG_P_ZPIPE1",
                .desc = "Number of promoted 2x2 that are ambiguous by hierarchical depth test",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = mtlgt2__ext139__hiz_depth_test_ambig_p_zpipe1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext139_HIZ_DEPTH_TEST_AMBIG_P_ZPIPE1_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 4);
}

static bool mtlgt2_ext142_HIZ_DEPTH_TEST_FAIL_NP_ZPIPE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext142_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext142";
    metric_set->symbol_name = "Ext142";
    metric_set->hw_config_guid = "c9f005ff-957d-471f-b6d3-98ebfd423f88";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext142_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext142__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext142__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext142__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext142__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "HIZ DEPTH TEST FAIL NP ZPIPE0",
                .symbol_name = "HIZ_DEPTH_TEST_FAIL_NP_ZPIPE0",
                .desc = "Number of non-promoted 2x2 that failed the hierarchical depth test",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = mtlgt2__ext142__hiz_depth_test_fail_np_zpipe0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext142_HIZ_DEPTH_TEST_FAIL_NP_ZPIPE0_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 4);
}

static bool mtlgt2_ext143_HIZ_DEPTH_TEST_FAIL_NP_ZPIPE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext143_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext143";
    metric_set->symbol_name = "Ext143";
    metric_set->hw_config_guid = "bf8f687e-d93f-439a-904e-14758015b273";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext143_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext143__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext143__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext143__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext143__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "HIZ DEPTH TEST FAIL NP ZPIPE1",
                .symbol_name = "HIZ_DEPTH_TEST_FAIL_NP_ZPIPE1",
                .desc = "Number of non-promoted 2x2 that failed the hierarchical depth test",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = mtlgt2__ext143__hiz_depth_test_fail_np_zpipe1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext143_HIZ_DEPTH_TEST_FAIL_NP_ZPIPE1_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 4);
}

static bool mtlgt2_ext146_HIZ_DEPTH_TEST_FAIL_P_ZPIPE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext146_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext146";
    metric_set->symbol_name = "Ext146";
    metric_set->hw_config_guid = "38cb3c8a-b6b1-46e9-b18e-331afd4faad6";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext146_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext146__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext146__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext146__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext146__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "HIZ DEPTH TEST FAIL P ZPIPE0",
                .symbol_name = "HIZ_DEPTH_TEST_FAIL_P_ZPIPE0",
                .desc = "Number of promoted 2x2 that failed the hierarchical depth test",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = mtlgt2__ext146__hiz_depth_test_fail_p_zpipe0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext146_HIZ_DEPTH_TEST_FAIL_P_ZPIPE0_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 4);
}

static bool mtlgt2_ext147_HIZ_DEPTH_TEST_FAIL_P_ZPIPE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext147_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext147";
    metric_set->symbol_name = "Ext147";
    metric_set->hw_config_guid = "f0624b43-b429-4be9-9cef-1a9c966b9bf5";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext147_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext147__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext147__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext147__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext147__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "HIZ DEPTH TEST FAIL P ZPIPE1",
                .symbol_name = "HIZ_DEPTH_TEST_FAIL_P_ZPIPE1",
                .desc = "Number of promoted 2x2 that failed the hierarchical depth test",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = mtlgt2__ext147__hiz_depth_test_fail_p_zpipe1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext147_HIZ_DEPTH_TEST_FAIL_P_ZPIPE1_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 4);
}

static bool mtlgt2_ext150_HIZ_DEPTH_TEST_PASS_P_ZPIPE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext150_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext150";
    metric_set->symbol_name = "Ext150";
    metric_set->hw_config_guid = "9be51bc5-540f-4a51-80b9-a6e8f849107c";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext150_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext150__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext150__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext150__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext150__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "HIZ DEPTH TEST PASS P ZPIPE0",
                .symbol_name = "HIZ_DEPTH_TEST_PASS_P_ZPIPE0",
                .desc = "Number of promoted 2x2 passed by hierarchical depth test",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = mtlgt2__ext150__hiz_depth_test_pass_p_zpipe0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext150_HIZ_DEPTH_TEST_PASS_P_ZPIPE0_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 4);
}

static bool mtlgt2_ext151_HIZ_DEPTH_TEST_PASS_P_ZPIPE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext151_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext151";
    metric_set->symbol_name = "Ext151";
    metric_set->hw_config_guid = "5303f1e7-b41b-4f48-a638-02293743f84d";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext151_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext151__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext151__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext151__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext151__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "HIZ DEPTH TEST PASS P ZPIPE1",
                .symbol_name = "HIZ_DEPTH_TEST_PASS_P_ZPIPE1",
                .desc = "Number of promoted 2x2 passed by hierarchical depth test",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = mtlgt2__ext151__hiz_depth_test_pass_p_zpipe1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext151_HIZ_DEPTH_TEST_PASS_P_ZPIPE1_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 4);
}

static bool mtlgt2_ext154_HIZ_SUBSPAN_LATENCY_FIFOFULL_ZPIPE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext154_HIZ_SUBSPAN_LATENCY_FIFOFULL_ZPIPE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext154_IZ_OUTPUT_READY_ZPIPE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext154_IZ_OUTPUT_READY_ZPIPE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext154_IZ_SUBSPAN_LATENCY_FIFOFULL_ZPIPE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext154_IZ_SUBSPAN_LATENCY_FIFOFULL_ZPIPE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext154_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext154";
    metric_set->symbol_name = "Ext154";
    metric_set->hw_config_guid = "269bfd75-1e50-4717-959c-f72de6c5e37e";
    metric_set->counters = calloc(9, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext154_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext154__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext154__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext154__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext154__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "HIZ SUBSPAN LATENCY FIFOFULL ZPIPE0",
                .symbol_name = "HIZ_SUBSPAN_LATENCY_FIFOFULL_ZPIPE0",
                .desc = "Percentage of time in which HiZ latency hiding structure full",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext154__hiz_subspan_latency_fifofull_zpipe0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext154_HIZ_SUBSPAN_LATENCY_FIFOFULL_ZPIPE0_availability,
            },

            {
                .name = "HIZ SUBSPAN LATENCY FIFOFULL ZPIPE1",
                .symbol_name = "HIZ_SUBSPAN_LATENCY_FIFOFULL_ZPIPE1",
                .desc = "Percentage of time in which HiZ latency hiding structure full",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext154__hiz_subspan_latency_fifofull_zpipe1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext154_HIZ_SUBSPAN_LATENCY_FIFOFULL_ZPIPE1_availability,
            },

            {
                .name = "IZ OUTPUT READY ZPIPE0",
                .symbol_name = "IZ_OUTPUT_READY_ZPIPE0",
                .desc = "Percentage of time in which IZ has requests to different clients",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext154__iz_output_ready_zpipe0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext154_IZ_OUTPUT_READY_ZPIPE0_availability,
            },

            {
                .name = "IZ OUTPUT READY ZPIPE1",
                .symbol_name = "IZ_OUTPUT_READY_ZPIPE1",
                .desc = "Percentage of time in which IZ has requests to different clients",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext154__iz_output_ready_zpipe1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext154_IZ_OUTPUT_READY_ZPIPE1_availability,
            },

            {
                .name = "IZ SUBSPAN LATENCY FIFOFULL ZPIPE0",
                .symbol_name = "IZ_SUBSPAN_LATENCY_FIFOFULL_ZPIPE0",
                .desc = "Percentage of time in which IZ latency hiding structure full",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext154__iz_subspan_latency_fifofull_zpipe0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext154_IZ_SUBSPAN_LATENCY_FIFOFULL_ZPIPE0_availability,
            },

            {
                .name = "IZ SUBSPAN LATENCY FIFOFULL ZPIPE1",
                .symbol_name = "IZ_SUBSPAN_LATENCY_FIFOFULL_ZPIPE1",
                .desc = "Percentage of time in which IZ latency hiding structure full",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext154__iz_subspan_latency_fifofull_zpipe1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext154_IZ_SUBSPAN_LATENCY_FIFOFULL_ZPIPE1_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 9);
}


static void
mtlgt2_add_ext155_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext155";
    metric_set->symbol_name = "Ext155";
    metric_set->hw_config_guid = "77c2e8f4-297f-46ed-95a9-370e21e131c6";
    metric_set->counters = calloc(6, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext155_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext155__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext155__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "COMMAND PARSER COMPUTE ENGINE BUSY CCS0",
                .symbol_name = "COMMAND_PARSER_COMPUTE_ENGINE_BUSY_CCS0",
                .desc = "Percentage of time in which there is a context loaded and active on the compute queue",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext155__command_parser_compute_engine_busy_ccs0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "COMMAND PARSER COPY ENGINE BUSY",
                .symbol_name = "COMMAND_PARSER_COPY_ENGINE_BUSY",
                .desc = "Percentage of time in which there is a context loaded and active on the copy queue",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext155__command_parser_copy_engine_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "COMMAND PARSER RENDER ENGINE BUSY",
                .symbol_name = "COMMAND_PARSER_RENDER_ENGINE_BUSY",
                .desc = "Percentage of time in which there is a context loaded and active on the 3D queue",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext155__command_parser_render_engine_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext155__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext155__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 6);
}


static void
mtlgt2_add_ext156_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext156";
    metric_set->symbol_name = "Ext156";
    metric_set->hw_config_guid = "dea81dd8-3792-4245-9ce3-4591a6ff2d31";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext156_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext156__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext156__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "COMMAND PARSER COMPUTE ENGINE DISPATCH KERNEL COUNT CCS0",
                .symbol_name = "COMMAND_PARSER_COMPUTE_ENGINE_DISPATCH_KERNEL_COUNT_CCS0",
                .desc = "Number of compute walker commands parsed on the compute engine",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext156__command_parser_compute_engine_dispatch_kernel_count_ccs0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "COMMAND PARSER FLUSH COUNT",
                .symbol_name = "COMMAND_PARSER_FLUSH_COUNT",
                .desc = "Number of Stalling flushes at the top of the pipe",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext156__command_parser_flush_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "COMMAND PARSER RENDER ENGINE DISPATCH KERNEL COUNT",
                .symbol_name = "COMMAND_PARSER_RENDER_ENGINE_DISPATCH_KERNEL_COUNT",
                .desc = "Number of compute walker commands parsed on the 3D engine",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext156__command_parser_render_engine_dispatch_kernel_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "COMMAND PARSER RENDER ENGINE DRAW COUNT",
                .symbol_name = "COMMAND_PARSER_RENDER_ENGINE_DRAW_COUNT",
                .desc = "Number of DRAW and MESH commands parsed on the 3D engine",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext156__command_parser_render_engine_draw_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext156__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext156__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext158_RT_INPUT_MESSAGE_RAY_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext158_RT_INPUT_MESSAGE_RAY_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext158_RT_INPUT_MESSAGE_RAY_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext158_RT_INPUT_MESSAGE_RAY_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext158_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext158";
    metric_set->symbol_name = "Ext158";
    metric_set->hw_config_guid = "0f6dfbfe-33f8-4910-996a-8b639c57066f";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext158_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext158__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext158__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext158__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext158__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "RT INPUT MESSAGE RAY COUNT XECORE0",
                .symbol_name = "RT_INPUT_MESSAGE_RAY_COUNT_XECORE0",
                .desc = "Number of valid SIMD lanes in the TraceRay message",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext158__rt_input_message_ray_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext158_RT_INPUT_MESSAGE_RAY_COUNT_XECORE0_availability,
            },

            {
                .name = "RT INPUT MESSAGE RAY COUNT XECORE1",
                .symbol_name = "RT_INPUT_MESSAGE_RAY_COUNT_XECORE1",
                .desc = "Number of valid SIMD lanes in the TraceRay message",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext158__rt_input_message_ray_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext158_RT_INPUT_MESSAGE_RAY_COUNT_XECORE1_availability,
            },

            {
                .name = "RT INPUT MESSAGE RAY COUNT XECORE2",
                .symbol_name = "RT_INPUT_MESSAGE_RAY_COUNT_XECORE2",
                .desc = "Number of valid SIMD lanes in the TraceRay message",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext158__rt_input_message_ray_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext158_RT_INPUT_MESSAGE_RAY_COUNT_XECORE2_availability,
            },

            {
                .name = "RT INPUT MESSAGE RAY COUNT XECORE3",
                .symbol_name = "RT_INPUT_MESSAGE_RAY_COUNT_XECORE3",
                .desc = "Number of valid SIMD lanes in the TraceRay message",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext158__rt_input_message_ray_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext158_RT_INPUT_MESSAGE_RAY_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext159_RT_CLOSEST_HIT_THREAD_RAY_DISPATCH_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext159_RT_CLOSEST_HIT_THREAD_RAY_DISPATCH_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext159_RT_CLOSEST_HIT_THREAD_RAY_DISPATCH_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext159_RT_CLOSEST_HIT_THREAD_RAY_DISPATCH_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext159_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext159";
    metric_set->symbol_name = "Ext159";
    metric_set->hw_config_guid = "7b4a0c8f-f35d-49e2-b1a7-243740c4d888";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext159_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext159__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext159__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext159__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext159__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "RT CLOSEST HIT THREAD RAY DISPATCH XECORE0",
                .symbol_name = "RT_CLOSEST_HIT_THREAD_RAY_DISPATCH_XECORE0",
                .desc = "Number of closest hit threads dispatched for RayQuery only",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext159__rt_closest_hit_thread_ray_dispatch_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext159_RT_CLOSEST_HIT_THREAD_RAY_DISPATCH_XECORE0_availability,
            },

            {
                .name = "RT CLOSEST HIT THREAD RAY DISPATCH XECORE1",
                .symbol_name = "RT_CLOSEST_HIT_THREAD_RAY_DISPATCH_XECORE1",
                .desc = "Number of closest hit threads dispatched for RayQuery only",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext159__rt_closest_hit_thread_ray_dispatch_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext159_RT_CLOSEST_HIT_THREAD_RAY_DISPATCH_XECORE1_availability,
            },

            {
                .name = "RT CLOSEST HIT THREAD RAY DISPATCH XECORE2",
                .symbol_name = "RT_CLOSEST_HIT_THREAD_RAY_DISPATCH_XECORE2",
                .desc = "Number of closest hit threads dispatched for RayQuery only",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext159__rt_closest_hit_thread_ray_dispatch_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext159_RT_CLOSEST_HIT_THREAD_RAY_DISPATCH_XECORE2_availability,
            },

            {
                .name = "RT CLOSEST HIT THREAD RAY DISPATCH XECORE3",
                .symbol_name = "RT_CLOSEST_HIT_THREAD_RAY_DISPATCH_XECORE3",
                .desc = "Number of closest hit threads dispatched for RayQuery only",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext159__rt_closest_hit_thread_ray_dispatch_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext159_RT_CLOSEST_HIT_THREAD_RAY_DISPATCH_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext161_RT_MISS_THREAD_RAY_DISPATCH_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext161_RT_MISS_THREAD_RAY_DISPATCH_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext161_RT_MISS_THREAD_RAY_DISPATCH_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext161_RT_MISS_THREAD_RAY_DISPATCH_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext161_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext161";
    metric_set->symbol_name = "Ext161";
    metric_set->hw_config_guid = "bf4c98bf-1930-408b-87ad-2674e6e617c0";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext161_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext161__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext161__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext161__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext161__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "RT MISS THREAD RAY DISPATCH XECORE0",
                .symbol_name = "RT_MISS_THREAD_RAY_DISPATCH_XECORE0",
                .desc = "Number of miss threads dispatched for RayQuery only",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext161__rt_miss_thread_ray_dispatch_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext161_RT_MISS_THREAD_RAY_DISPATCH_XECORE0_availability,
            },

            {
                .name = "RT MISS THREAD RAY DISPATCH XECORE1",
                .symbol_name = "RT_MISS_THREAD_RAY_DISPATCH_XECORE1",
                .desc = "Number of miss threads dispatched for RayQuery only",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext161__rt_miss_thread_ray_dispatch_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext161_RT_MISS_THREAD_RAY_DISPATCH_XECORE1_availability,
            },

            {
                .name = "RT MISS THREAD RAY DISPATCH XECORE2",
                .symbol_name = "RT_MISS_THREAD_RAY_DISPATCH_XECORE2",
                .desc = "Number of miss threads dispatched for RayQuery only",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext161__rt_miss_thread_ray_dispatch_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext161_RT_MISS_THREAD_RAY_DISPATCH_XECORE2_availability,
            },

            {
                .name = "RT MISS THREAD RAY DISPATCH XECORE3",
                .symbol_name = "RT_MISS_THREAD_RAY_DISPATCH_XECORE3",
                .desc = "Number of miss threads dispatched for RayQuery only",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext161__rt_miss_thread_ray_dispatch_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext161_RT_MISS_THREAD_RAY_DISPATCH_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext163_RT_ANY_HIT_THREAD_RAY_DISPATCH_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext163_RT_ANY_HIT_THREAD_RAY_DISPATCH_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext163_RT_ANY_HIT_THREAD_RAY_DISPATCH_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext163_RT_ANY_HIT_THREAD_RAY_DISPATCH_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext163_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext163";
    metric_set->symbol_name = "Ext163";
    metric_set->hw_config_guid = "2826204b-5835-4b64-840f-133d1ca5b03a";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext163_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext163__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext163__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext163__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext163__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "RT ANY HIT THREAD RAY DISPATCH XECORE0",
                .symbol_name = "RT_ANY_HIT_THREAD_RAY_DISPATCH_XECORE0",
                .desc = "Number of any hit threads dispatched for RayQuery only",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext163__rt_any_hit_thread_ray_dispatch_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext163_RT_ANY_HIT_THREAD_RAY_DISPATCH_XECORE0_availability,
            },

            {
                .name = "RT ANY HIT THREAD RAY DISPATCH XECORE1",
                .symbol_name = "RT_ANY_HIT_THREAD_RAY_DISPATCH_XECORE1",
                .desc = "Number of any hit threads dispatched for RayQuery only",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext163__rt_any_hit_thread_ray_dispatch_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext163_RT_ANY_HIT_THREAD_RAY_DISPATCH_XECORE1_availability,
            },

            {
                .name = "RT ANY HIT THREAD RAY DISPATCH XECORE2",
                .symbol_name = "RT_ANY_HIT_THREAD_RAY_DISPATCH_XECORE2",
                .desc = "Number of any hit threads dispatched for RayQuery only",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext163__rt_any_hit_thread_ray_dispatch_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext163_RT_ANY_HIT_THREAD_RAY_DISPATCH_XECORE2_availability,
            },

            {
                .name = "RT ANY HIT THREAD RAY DISPATCH XECORE3",
                .symbol_name = "RT_ANY_HIT_THREAD_RAY_DISPATCH_XECORE3",
                .desc = "Number of any hit threads dispatched for RayQuery only",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext163__rt_any_hit_thread_ray_dispatch_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext163_RT_ANY_HIT_THREAD_RAY_DISPATCH_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext165_RT_INTERSECTION_THREAD_RAY_DISPATCH_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext165_RT_INTERSECTION_THREAD_RAY_DISPATCH_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext165_RT_INTERSECTION_THREAD_RAY_DISPATCH_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext165_RT_INTERSECTION_THREAD_RAY_DISPATCH_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext165_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext165";
    metric_set->symbol_name = "Ext165";
    metric_set->hw_config_guid = "b9e7193e-99b9-4e9f-9738-de7144ea3b39";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext165_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext165__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext165__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext165__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext165__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "RT INTERSECTION THREAD RAY DISPATCH XECORE0",
                .symbol_name = "RT_INTERSECTION_THREAD_RAY_DISPATCH_XECORE0",
                .desc = "Number of intersection threads dispatched for RayQuery only",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext165__rt_intersection_thread_ray_dispatch_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext165_RT_INTERSECTION_THREAD_RAY_DISPATCH_XECORE0_availability,
            },

            {
                .name = "RT INTERSECTION THREAD RAY DISPATCH XECORE1",
                .symbol_name = "RT_INTERSECTION_THREAD_RAY_DISPATCH_XECORE1",
                .desc = "Number of intersection threads dispatched for RayQuery only",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext165__rt_intersection_thread_ray_dispatch_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext165_RT_INTERSECTION_THREAD_RAY_DISPATCH_XECORE1_availability,
            },

            {
                .name = "RT INTERSECTION THREAD RAY DISPATCH XECORE2",
                .symbol_name = "RT_INTERSECTION_THREAD_RAY_DISPATCH_XECORE2",
                .desc = "Number of intersection threads dispatched for RayQuery only",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext165__rt_intersection_thread_ray_dispatch_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext165_RT_INTERSECTION_THREAD_RAY_DISPATCH_XECORE2_availability,
            },

            {
                .name = "RT INTERSECTION THREAD RAY DISPATCH XECORE3",
                .symbol_name = "RT_INTERSECTION_THREAD_RAY_DISPATCH_XECORE3",
                .desc = "Number of intersection threads dispatched for RayQuery only",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext165__rt_intersection_thread_ray_dispatch_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext165_RT_INTERSECTION_THREAD_RAY_DISPATCH_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext167_RT_CALLABLE_THREAD_RAY_DISPATCH_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext167_RT_CALLABLE_THREAD_RAY_DISPATCH_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext167_RT_CALLABLE_THREAD_RAY_DISPATCH_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext167_RT_CALLABLE_THREAD_RAY_DISPATCH_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext167_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext167";
    metric_set->symbol_name = "Ext167";
    metric_set->hw_config_guid = "4797cea4-4618-42c1-aa36-0f8210b42a47";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext167_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext167__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext167__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext167__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext167__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "RT CALLABLE THREAD RAY DISPATCH XECORE0",
                .symbol_name = "RT_CALLABLE_THREAD_RAY_DISPATCH_XECORE0",
                .desc = "Number of callable threads dispatched for RayQuery only",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext167__rt_callable_thread_ray_dispatch_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext167_RT_CALLABLE_THREAD_RAY_DISPATCH_XECORE0_availability,
            },

            {
                .name = "RT CALLABLE THREAD RAY DISPATCH XECORE1",
                .symbol_name = "RT_CALLABLE_THREAD_RAY_DISPATCH_XECORE1",
                .desc = "Number of callable threads dispatched for RayQuery only",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext167__rt_callable_thread_ray_dispatch_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext167_RT_CALLABLE_THREAD_RAY_DISPATCH_XECORE1_availability,
            },

            {
                .name = "RT CALLABLE THREAD RAY DISPATCH XECORE2",
                .symbol_name = "RT_CALLABLE_THREAD_RAY_DISPATCH_XECORE2",
                .desc = "Number of callable threads dispatched for RayQuery only",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext167__rt_callable_thread_ray_dispatch_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext167_RT_CALLABLE_THREAD_RAY_DISPATCH_XECORE2_availability,
            },

            {
                .name = "RT CALLABLE THREAD RAY DISPATCH XECORE3",
                .symbol_name = "RT_CALLABLE_THREAD_RAY_DISPATCH_XECORE3",
                .desc = "Number of callable threads dispatched for RayQuery only",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext167__rt_callable_thread_ray_dispatch_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext167_RT_CALLABLE_THREAD_RAY_DISPATCH_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext169_RT_TRAVERSAL_OUTPUT_RAY_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext169_RT_TRAVERSAL_OUTPUT_RAY_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext169_RT_TRAVERSAL_OUTPUT_RAY_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext169_RT_TRAVERSAL_OUTPUT_RAY_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext169_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext169";
    metric_set->symbol_name = "Ext169";
    metric_set->hw_config_guid = "daeb4a53-f0ba-4bec-9462-8025cc17ca8b";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext169_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext169__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext169__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext169__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext169__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "RT TRAVERSAL OUTPUT RAY COUNT XECORE0",
                .symbol_name = "RT_TRAVERSAL_OUTPUT_RAY_COUNT_XECORE0",
                .desc = "Number of Ray Tracing Traversal output rays",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext169__rt_traversal_output_ray_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext169_RT_TRAVERSAL_OUTPUT_RAY_COUNT_XECORE0_availability,
            },

            {
                .name = "RT TRAVERSAL OUTPUT RAY COUNT XECORE1",
                .symbol_name = "RT_TRAVERSAL_OUTPUT_RAY_COUNT_XECORE1",
                .desc = "Number of Ray Tracing Traversal output rays",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext169__rt_traversal_output_ray_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext169_RT_TRAVERSAL_OUTPUT_RAY_COUNT_XECORE1_availability,
            },

            {
                .name = "RT TRAVERSAL OUTPUT RAY COUNT XECORE2",
                .symbol_name = "RT_TRAVERSAL_OUTPUT_RAY_COUNT_XECORE2",
                .desc = "Number of Ray Tracing Traversal output rays",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext169__rt_traversal_output_ray_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext169_RT_TRAVERSAL_OUTPUT_RAY_COUNT_XECORE2_availability,
            },

            {
                .name = "RT TRAVERSAL OUTPUT RAY COUNT XECORE3",
                .symbol_name = "RT_TRAVERSAL_OUTPUT_RAY_COUNT_XECORE3",
                .desc = "Number of Ray Tracing Traversal output rays",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext169__rt_traversal_output_ray_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext169_RT_TRAVERSAL_OUTPUT_RAY_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext171_RT_MESSAGE_STALL_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext171_RT_MESSAGE_STALL_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext171_RT_MESSAGE_STALL_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext171_RT_MESSAGE_STALL_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext171_RT_QUAD_TEST_RAY_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext171_RT_QUAD_TEST_RAY_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext171_RT_QUAD_TEST_RAY_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext171_RT_QUAD_TEST_RAY_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext171_RT_REQUEST_COLLISION_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext171_RT_REQUEST_COLLISION_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext171_RT_REQUEST_COLLISION_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext171_RT_REQUEST_COLLISION_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext171_RT_TRANSFORM_RAY_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext171_RT_TRANSFORM_RAY_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext171_RT_TRANSFORM_RAY_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext171_RT_TRANSFORM_RAY_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext171_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext171";
    metric_set->symbol_name = "Ext171";
    metric_set->hw_config_guid = "2aeaff8e-ce08-49f1-aacf-c9631dc3c756";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext171_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext171__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext171__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext171__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext171__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "RT MESSAGE STALL COUNT XECORE0",
                .symbol_name = "RT_MESSAGE_STALL_COUNT_XECORE0",
                .desc = "Percentage of time in which Ray Tracing message input is stalled while accepting input",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext171__rt_message_stall_count_xecore0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext171_RT_MESSAGE_STALL_COUNT_XECORE0_availability,
            },

            {
                .name = "RT MESSAGE STALL COUNT XECORE1",
                .symbol_name = "RT_MESSAGE_STALL_COUNT_XECORE1",
                .desc = "Percentage of time in which Ray Tracing message input is stalled while accepting input",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext171__rt_message_stall_count_xecore1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext171_RT_MESSAGE_STALL_COUNT_XECORE1_availability,
            },

            {
                .name = "RT MESSAGE STALL COUNT XECORE2",
                .symbol_name = "RT_MESSAGE_STALL_COUNT_XECORE2",
                .desc = "Percentage of time in which Ray Tracing message input is stalled while accepting input",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext171__rt_message_stall_count_xecore2__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext171_RT_MESSAGE_STALL_COUNT_XECORE2_availability,
            },

            {
                .name = "RT MESSAGE STALL COUNT XECORE3",
                .symbol_name = "RT_MESSAGE_STALL_COUNT_XECORE3",
                .desc = "Percentage of time in which Ray Tracing message input is stalled while accepting input",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext171__rt_message_stall_count_xecore3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext171_RT_MESSAGE_STALL_COUNT_XECORE3_availability,
            },

            {
                .name = "RT QUAD TEST RAY COUNT XECORE0",
                .symbol_name = "RT_QUAD_TEST_RAY_COUNT_XECORE0",
                .desc = "Number of nodes processed that use ray-quad intersection pipeline",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext171__rt_quad_test_ray_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext171_RT_QUAD_TEST_RAY_COUNT_XECORE0_availability,
            },

            {
                .name = "RT QUAD TEST RAY COUNT XECORE1",
                .symbol_name = "RT_QUAD_TEST_RAY_COUNT_XECORE1",
                .desc = "Number of nodes processed that use ray-quad intersection pipeline",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext171__rt_quad_test_ray_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext171_RT_QUAD_TEST_RAY_COUNT_XECORE1_availability,
            },

            {
                .name = "RT QUAD TEST RAY COUNT XECORE2",
                .symbol_name = "RT_QUAD_TEST_RAY_COUNT_XECORE2",
                .desc = "Number of nodes processed that use ray-quad intersection pipeline",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext171__rt_quad_test_ray_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext171_RT_QUAD_TEST_RAY_COUNT_XECORE2_availability,
            },

            {
                .name = "RT QUAD TEST RAY COUNT XECORE3",
                .symbol_name = "RT_QUAD_TEST_RAY_COUNT_XECORE3",
                .desc = "Number of nodes processed that use ray-quad intersection pipeline",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext171__rt_quad_test_ray_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext171_RT_QUAD_TEST_RAY_COUNT_XECORE3_availability,
            },

            {
                .name = "RT REQUEST COLLISION XECORE0",
                .symbol_name = "RT_REQUEST_COLLISION_XECORE0",
                .desc = "Percentage of time in which RayTracing Leaf has two Traversal inputs valid",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext171__rt_request_collision_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext171_RT_REQUEST_COLLISION_XECORE0_availability,
            },

            {
                .name = "RT REQUEST COLLISION XECORE1",
                .symbol_name = "RT_REQUEST_COLLISION_XECORE1",
                .desc = "Percentage of time in which RayTracing Leaf has two Traversal inputs valid",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext171__rt_request_collision_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext171_RT_REQUEST_COLLISION_XECORE1_availability,
            },

            {
                .name = "RT REQUEST COLLISION XECORE2",
                .symbol_name = "RT_REQUEST_COLLISION_XECORE2",
                .desc = "Percentage of time in which RayTracing Leaf has two Traversal inputs valid",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext171__rt_request_collision_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext171_RT_REQUEST_COLLISION_XECORE2_availability,
            },

            {
                .name = "RT REQUEST COLLISION XECORE3",
                .symbol_name = "RT_REQUEST_COLLISION_XECORE3",
                .desc = "Percentage of time in which RayTracing Leaf has two Traversal inputs valid",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext171__rt_request_collision_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext171_RT_REQUEST_COLLISION_XECORE3_availability,
            },

            {
                .name = "RT TRANSFORM RAY COUNT XECORE0",
                .symbol_name = "RT_TRANSFORM_RAY_COUNT_XECORE0",
                .desc = "Number of only HW transform accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext171__rt_transform_ray_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext171_RT_TRANSFORM_RAY_COUNT_XECORE0_availability,
            },

            {
                .name = "RT TRANSFORM RAY COUNT XECORE1",
                .symbol_name = "RT_TRANSFORM_RAY_COUNT_XECORE1",
                .desc = "Number of only HW transform accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext171__rt_transform_ray_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext171_RT_TRANSFORM_RAY_COUNT_XECORE1_availability,
            },

            {
                .name = "RT TRANSFORM RAY COUNT XECORE2",
                .symbol_name = "RT_TRANSFORM_RAY_COUNT_XECORE2",
                .desc = "Number of only HW transform accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext171__rt_transform_ray_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext171_RT_TRANSFORM_RAY_COUNT_XECORE2_availability,
            },

            {
                .name = "RT TRANSFORM RAY COUNT XECORE3",
                .symbol_name = "RT_TRANSFORM_RAY_COUNT_XECORE3",
                .desc = "Number of only HW transform accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext171__rt_transform_ray_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext171_RT_TRANSFORM_RAY_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 19);
}

static bool mtlgt2_ext173_XVE_SHARED_FUNCTION_ACCESS_HOLD_XECORE0_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext173_XVE_STALL_ALUWR_XECORE0_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext173_XVE_STALL_BARRIER_XECORE0_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext173_XVE_STALL_CONTROL_XECORE0_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext173_XVE_STALL_INSTFETCH_XECORE0_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext173_XVE_STALL_OTHER_XECORE0_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext173_XVE_STALL_SBID_XECORE0_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext173_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext173";
    metric_set->symbol_name = "Ext173";
    metric_set->hw_config_guid = "5005db3a-31a9-498c-8153-bf47147473b1";
    metric_set->counters = calloc(10, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext173_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext173__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext173__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext173__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext173__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SHARED FUNCTION ACCESS HOLD XECORE0 XVE0 THREAD0",
                .symbol_name = "XVE_SHARED_FUNCTION_ACCESS_HOLD_XECORE0_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE requests stalled by Shared Function units",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext173__xve_shared_function_access_hold_xecore0_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext173_XVE_SHARED_FUNCTION_ACCESS_HOLD_XECORE0_XVE0_THREAD0_availability,
            },

            {
                .name = "XVE STALL ALUWR XECORE0 XVE0 THREAD0",
                .symbol_name = "XVE_STALL_ALUWR_XECORE0_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting for ALU to write GRF/ACC register",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext173__xve_stall_aluwr_xecore0_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext173_XVE_STALL_ALUWR_XECORE0_XVE0_THREAD0_availability,
            },

            {
                .name = "XVE STALL BARRIER XECORE0 XVE0 THREAD0",
                .symbol_name = "XVE_STALL_BARRIER_XECORE0_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting for Gateway to write Notify register",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext173__xve_stall_barrier_xecore0_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext173_XVE_STALL_BARRIER_XECORE0_XVE0_THREAD0_availability,
            },

            {
                .name = "XVE STALL CONTROL XECORE0 XVE0 THREAD0",
                .symbol_name = "XVE_STALL_CONTROL_XECORE0_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting for JEU to complete branch instruction",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext173__xve_stall_control_xecore0_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext173_XVE_STALL_CONTROL_XECORE0_XVE0_THREAD0_availability,
            },

            {
                .name = "XVE STALL INSTFETCH XECORE0 XVE0 THREAD0",
                .symbol_name = "XVE_STALL_INSTFETCH_XECORE0_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting for Instruction Fetch",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext173__xve_stall_instfetch_xecore0_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext173_XVE_STALL_INSTFETCH_XECORE0_XVE0_THREAD0_availability,
            },

            {
                .name = "XVE STALL OTHER XECORE0 XVE0 THREAD0",
                .symbol_name = "XVE_STALL_OTHER_XECORE0_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting on any other dependency (Flag/EoT etc)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext173__xve_stall_other_xecore0_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext173_XVE_STALL_OTHER_XECORE0_XVE0_THREAD0_availability,
            },

            {
                .name = "XVE STALL SBID XECORE0 XVE0 THREAD0",
                .symbol_name = "XVE_STALL_SBID_XECORE0_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting for Scoreboard token to be available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext173__xve_stall_sbid_xecore0_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext173_XVE_STALL_SBID_XECORE0_XVE0_THREAD0_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 10);
}

static bool mtlgt2_ext174_XVE_SHARED_FUNCTION_ACCESS_HOLD_XECORE1_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext174_XVE_STALL_ALUWR_XECORE1_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext174_XVE_STALL_BARRIER_XECORE1_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext174_XVE_STALL_CONTROL_XECORE1_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext174_XVE_STALL_INSTFETCH_XECORE1_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext174_XVE_STALL_OTHER_XECORE1_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext174_XVE_STALL_SBID_XECORE1_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext174_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext174";
    metric_set->symbol_name = "Ext174";
    metric_set->hw_config_guid = "3e2a351c-3f4f-461a-a6cf-64f099b83fc5";
    metric_set->counters = calloc(10, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext174_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext174__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext174__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext174__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext174__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SHARED FUNCTION ACCESS HOLD XECORE1 XVE0 THREAD0",
                .symbol_name = "XVE_SHARED_FUNCTION_ACCESS_HOLD_XECORE1_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE requests stalled by Shared Function units",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext174__xve_shared_function_access_hold_xecore1_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext174_XVE_SHARED_FUNCTION_ACCESS_HOLD_XECORE1_XVE0_THREAD0_availability,
            },

            {
                .name = "XVE STALL ALUWR XECORE1 XVE0 THREAD0",
                .symbol_name = "XVE_STALL_ALUWR_XECORE1_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting for ALU to write GRF/ACC register",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext174__xve_stall_aluwr_xecore1_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext174_XVE_STALL_ALUWR_XECORE1_XVE0_THREAD0_availability,
            },

            {
                .name = "XVE STALL BARRIER XECORE1 XVE0 THREAD0",
                .symbol_name = "XVE_STALL_BARRIER_XECORE1_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting for Gateway to write Notify register",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext174__xve_stall_barrier_xecore1_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext174_XVE_STALL_BARRIER_XECORE1_XVE0_THREAD0_availability,
            },

            {
                .name = "XVE STALL CONTROL XECORE1 XVE0 THREAD0",
                .symbol_name = "XVE_STALL_CONTROL_XECORE1_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting for JEU to complete branch instruction",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext174__xve_stall_control_xecore1_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext174_XVE_STALL_CONTROL_XECORE1_XVE0_THREAD0_availability,
            },

            {
                .name = "XVE STALL INSTFETCH XECORE1 XVE0 THREAD0",
                .symbol_name = "XVE_STALL_INSTFETCH_XECORE1_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting for Instruction Fetch",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext174__xve_stall_instfetch_xecore1_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext174_XVE_STALL_INSTFETCH_XECORE1_XVE0_THREAD0_availability,
            },

            {
                .name = "XVE STALL OTHER XECORE1 XVE0 THREAD0",
                .symbol_name = "XVE_STALL_OTHER_XECORE1_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting on any other dependency (Flag/EoT etc)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext174__xve_stall_other_xecore1_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext174_XVE_STALL_OTHER_XECORE1_XVE0_THREAD0_availability,
            },

            {
                .name = "XVE STALL SBID XECORE1 XVE0 THREAD0",
                .symbol_name = "XVE_STALL_SBID_XECORE1_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting for Scoreboard token to be available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext174__xve_stall_sbid_xecore1_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext174_XVE_STALL_SBID_XECORE1_XVE0_THREAD0_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 10);
}

static bool mtlgt2_ext175_XVE_SHARED_FUNCTION_ACCESS_HOLD_XECORE2_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext175_XVE_STALL_ALUWR_XECORE2_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext175_XVE_STALL_BARRIER_XECORE2_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext175_XVE_STALL_CONTROL_XECORE2_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext175_XVE_STALL_INSTFETCH_XECORE2_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext175_XVE_STALL_OTHER_XECORE2_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext175_XVE_STALL_SBID_XECORE2_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext175_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext175";
    metric_set->symbol_name = "Ext175";
    metric_set->hw_config_guid = "14c17f9b-021b-41e5-a4f0-ab8daaad56a4";
    metric_set->counters = calloc(10, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext175_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext175__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext175__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext175__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext175__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SHARED FUNCTION ACCESS HOLD XECORE2 XVE0 THREAD0",
                .symbol_name = "XVE_SHARED_FUNCTION_ACCESS_HOLD_XECORE2_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE requests stalled by Shared Function units",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext175__xve_shared_function_access_hold_xecore2_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext175_XVE_SHARED_FUNCTION_ACCESS_HOLD_XECORE2_XVE0_THREAD0_availability,
            },

            {
                .name = "XVE STALL ALUWR XECORE2 XVE0 THREAD0",
                .symbol_name = "XVE_STALL_ALUWR_XECORE2_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting for ALU to write GRF/ACC register",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext175__xve_stall_aluwr_xecore2_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext175_XVE_STALL_ALUWR_XECORE2_XVE0_THREAD0_availability,
            },

            {
                .name = "XVE STALL BARRIER XECORE2 XVE0 THREAD0",
                .symbol_name = "XVE_STALL_BARRIER_XECORE2_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting for Gateway to write Notify register",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext175__xve_stall_barrier_xecore2_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext175_XVE_STALL_BARRIER_XECORE2_XVE0_THREAD0_availability,
            },

            {
                .name = "XVE STALL CONTROL XECORE2 XVE0 THREAD0",
                .symbol_name = "XVE_STALL_CONTROL_XECORE2_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting for JEU to complete branch instruction",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext175__xve_stall_control_xecore2_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext175_XVE_STALL_CONTROL_XECORE2_XVE0_THREAD0_availability,
            },

            {
                .name = "XVE STALL INSTFETCH XECORE2 XVE0 THREAD0",
                .symbol_name = "XVE_STALL_INSTFETCH_XECORE2_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting for Instruction Fetch",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext175__xve_stall_instfetch_xecore2_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext175_XVE_STALL_INSTFETCH_XECORE2_XVE0_THREAD0_availability,
            },

            {
                .name = "XVE STALL OTHER XECORE2 XVE0 THREAD0",
                .symbol_name = "XVE_STALL_OTHER_XECORE2_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting on any other dependency (Flag/EoT etc)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext175__xve_stall_other_xecore2_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext175_XVE_STALL_OTHER_XECORE2_XVE0_THREAD0_availability,
            },

            {
                .name = "XVE STALL SBID XECORE2 XVE0 THREAD0",
                .symbol_name = "XVE_STALL_SBID_XECORE2_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting for Scoreboard token to be available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext175__xve_stall_sbid_xecore2_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext175_XVE_STALL_SBID_XECORE2_XVE0_THREAD0_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 10);
}

static bool mtlgt2_ext176_XVE_SHARED_FUNCTION_ACCESS_HOLD_XECORE3_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext176_XVE_STALL_ALUWR_XECORE3_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext176_XVE_STALL_BARRIER_XECORE3_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext176_XVE_STALL_CONTROL_XECORE3_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext176_XVE_STALL_INSTFETCH_XECORE3_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext176_XVE_STALL_OTHER_XECORE3_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext176_XVE_STALL_SBID_XECORE3_XVE0_THREAD0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext176_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext176";
    metric_set->symbol_name = "Ext176";
    metric_set->hw_config_guid = "a258d429-a165-4fed-bbcb-c743a09dd68f";
    metric_set->counters = calloc(10, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext176_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext176__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext176__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext176__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext176__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SHARED FUNCTION ACCESS HOLD XECORE3 XVE0 THREAD0",
                .symbol_name = "XVE_SHARED_FUNCTION_ACCESS_HOLD_XECORE3_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE requests stalled by Shared Function units",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext176__xve_shared_function_access_hold_xecore3_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext176_XVE_SHARED_FUNCTION_ACCESS_HOLD_XECORE3_XVE0_THREAD0_availability,
            },

            {
                .name = "XVE STALL ALUWR XECORE3 XVE0 THREAD0",
                .symbol_name = "XVE_STALL_ALUWR_XECORE3_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting for ALU to write GRF/ACC register",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext176__xve_stall_aluwr_xecore3_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext176_XVE_STALL_ALUWR_XECORE3_XVE0_THREAD0_availability,
            },

            {
                .name = "XVE STALL BARRIER XECORE3 XVE0 THREAD0",
                .symbol_name = "XVE_STALL_BARRIER_XECORE3_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting for Gateway to write Notify register",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext176__xve_stall_barrier_xecore3_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext176_XVE_STALL_BARRIER_XECORE3_XVE0_THREAD0_availability,
            },

            {
                .name = "XVE STALL CONTROL XECORE3 XVE0 THREAD0",
                .symbol_name = "XVE_STALL_CONTROL_XECORE3_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting for JEU to complete branch instruction",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext176__xve_stall_control_xecore3_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext176_XVE_STALL_CONTROL_XECORE3_XVE0_THREAD0_availability,
            },

            {
                .name = "XVE STALL INSTFETCH XECORE3 XVE0 THREAD0",
                .symbol_name = "XVE_STALL_INSTFETCH_XECORE3_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting for Instruction Fetch",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext176__xve_stall_instfetch_xecore3_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext176_XVE_STALL_INSTFETCH_XECORE3_XVE0_THREAD0_availability,
            },

            {
                .name = "XVE STALL OTHER XECORE3 XVE0 THREAD0",
                .symbol_name = "XVE_STALL_OTHER_XECORE3_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting on any other dependency (Flag/EoT etc)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext176__xve_stall_other_xecore3_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext176_XVE_STALL_OTHER_XECORE3_XVE0_THREAD0_availability,
            },

            {
                .name = "XVE STALL SBID XECORE3 XVE0 THREAD0",
                .symbol_name = "XVE_STALL_SBID_XECORE3_XVE0_THREAD0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting for Scoreboard token to be available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext176__xve_stall_sbid_xecore3_xve0_thread0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext176_XVE_STALL_SBID_XECORE3_XVE0_THREAD0_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 10);
}

static bool mtlgt2_ext177_RENDER_CACHE_ALLOC_L3NODE0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext177_XVE_INST_ISSUED_ALL_XECORE3_XVE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext177_XVE_STALL_PIPESTALL_XECORE0_XVE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext177_XVE_STALL_PIPESTALL_XECORE1_XVE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext177_XVE_STALL_PIPESTALL_XECORE2_XVE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext177_XVE_STALL_PIPESTALL_XECORE3_XVE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext177_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext177";
    metric_set->symbol_name = "Ext177";
    metric_set->hw_config_guid = "986b3512-df42-4300-a3fb-3a0d5835b5dc";
    metric_set->counters = calloc(9, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext177_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext177__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext177__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext177__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext177__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "RENDER CACHE ALLOC L3NODE0",
                .symbol_name = "RENDER_CACHE_ALLOC_L3NODE0",
                .desc = "Number of Render Cache allocations - cache miss signal for new allocation",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext177__render_cache_alloc_l3_node0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext177_RENDER_CACHE_ALLOC_L3NODE0_availability,
            },

            {
                .name = "XVE INST ISSUED ALL XECORE3 XVE0",
                .symbol_name = "XVE_INST_ISSUED_ALL_XECORE3_XVE0",
                .desc = "Number of instructions issued (decoded) to any pipe",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext177__xve_inst_issued_all_xecore3_xve0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext177_XVE_INST_ISSUED_ALL_XECORE3_XVE0_availability,
            },

            {
                .name = "XVE STALL PIPESTALL XECORE0 XVE0",
                .symbol_name = "XVE_STALL_PIPESTALL_XECORE0_XVE0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread is ready to be scheduled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext177__xve_stall_pipestall_xecore0_xve0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext177_XVE_STALL_PIPESTALL_XECORE0_XVE0_availability,
            },

            {
                .name = "XVE STALL PIPESTALL XECORE1 XVE0",
                .symbol_name = "XVE_STALL_PIPESTALL_XECORE1_XVE0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread is ready to be scheduled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext177__xve_stall_pipestall_xecore1_xve0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext177_XVE_STALL_PIPESTALL_XECORE1_XVE0_availability,
            },

            {
                .name = "XVE STALL PIPESTALL XECORE2 XVE0",
                .symbol_name = "XVE_STALL_PIPESTALL_XECORE2_XVE0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread is ready to be scheduled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext177__xve_stall_pipestall_xecore2_xve0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext177_XVE_STALL_PIPESTALL_XECORE2_XVE0_availability,
            },

            {
                .name = "XVE STALL PIPESTALL XECORE3 XVE0",
                .symbol_name = "XVE_STALL_PIPESTALL_XECORE3_XVE0",
                .desc = "Percentage of time in which XVE stalled, with at least one thread is ready to be scheduled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext177__xve_stall_pipestall_xecore3_xve0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext177_XVE_STALL_PIPESTALL_XECORE3_XVE0_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 9);
}

static bool mtlgt2_ext181_XVE_INST_ISSUED_ALL_XECORE0_XVE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext181_XVE_INST_ISSUED_ALL_XECORE1_XVE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext181_XVE_INST_ISSUED_ALL_XECORE2_XVE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext181_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext181";
    metric_set->symbol_name = "Ext181";
    metric_set->hw_config_guid = "29b4890b-203f-44d7-a007-270354d414ed";
    metric_set->counters = calloc(6, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext181_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext181__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext181__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext181__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext181__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE INST ISSUED ALL XECORE0 XVE0",
                .symbol_name = "XVE_INST_ISSUED_ALL_XECORE0_XVE0",
                .desc = "Number of instructions issued (decoded) to any pipe",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext181__xve_inst_issued_all_xecore0_xve0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext181_XVE_INST_ISSUED_ALL_XECORE0_XVE0_availability,
            },

            {
                .name = "XVE INST ISSUED ALL XECORE1 XVE0",
                .symbol_name = "XVE_INST_ISSUED_ALL_XECORE1_XVE0",
                .desc = "Number of instructions issued (decoded) to any pipe",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext181__xve_inst_issued_all_xecore1_xve0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext181_XVE_INST_ISSUED_ALL_XECORE1_XVE0_availability,
            },

            {
                .name = "XVE INST ISSUED ALL XECORE2 XVE0",
                .symbol_name = "XVE_INST_ISSUED_ALL_XECORE2_XVE0",
                .desc = "Number of instructions issued (decoded) to any pipe",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext181__xve_inst_issued_all_xecore2_xve0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext181_XVE_INST_ISSUED_ALL_XECORE2_XVE0_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 6);
}

static bool mtlgt2_ext184_RT_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext184_RT_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext184_RT_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext184_RT_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext184_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext184";
    metric_set->symbol_name = "Ext184";
    metric_set->hw_config_guid = "87ec0ca0-a406-4ddb-9fb9-60beed37e12a";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext184_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext184__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext184__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext184__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext184__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "RT LOAD STORE CACHE READ MESSAGE COUNT XECORE0",
                .symbol_name = "RT_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE0",
                .desc = "Number of read messages sent from Ray Tracing unit to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext184__rt_load_store_cache_read_message_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext184_RT_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE0_availability,
            },

            {
                .name = "RT LOAD STORE CACHE READ MESSAGE COUNT XECORE1",
                .symbol_name = "RT_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE1",
                .desc = "Number of read messages sent from Ray Tracing unit to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext184__rt_load_store_cache_read_message_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext184_RT_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE1_availability,
            },

            {
                .name = "RT LOAD STORE CACHE READ MESSAGE COUNT XECORE2",
                .symbol_name = "RT_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE2",
                .desc = "Number of read messages sent from Ray Tracing unit to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext184__rt_load_store_cache_read_message_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext184_RT_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE2_availability,
            },

            {
                .name = "RT LOAD STORE CACHE READ MESSAGE COUNT XECORE3",
                .symbol_name = "RT_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE3",
                .desc = "Number of read messages sent from Ray Tracing unit to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext184__rt_load_store_cache_read_message_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext184_RT_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext188_RT_LOAD_STORE_CACHE_WRITE_FROM_MESSAGE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext188_RT_LOAD_STORE_CACHE_WRITE_FROM_MESSAGE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext188_RT_LOAD_STORE_CACHE_WRITE_FROM_MESSAGE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext188_RT_LOAD_STORE_CACHE_WRITE_FROM_MESSAGE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext188_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext188";
    metric_set->symbol_name = "Ext188";
    metric_set->hw_config_guid = "11c77c80-498e-4cad-9e2d-565a52fd3578";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext188_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext188__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext188__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext188__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext188__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "RT LOAD STORE CACHE WRITE FROM MESSAGE COUNT XECORE0",
                .symbol_name = "RT_LOAD_STORE_CACHE_WRITE_FROM_MESSAGE_COUNT_XECORE0",
                .desc = "Number of write messages sent from Ray Tracing unit to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext188__rt_load_store_cache_write_from_message_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext188_RT_LOAD_STORE_CACHE_WRITE_FROM_MESSAGE_COUNT_XECORE0_availability,
            },

            {
                .name = "RT LOAD STORE CACHE WRITE FROM MESSAGE COUNT XECORE1",
                .symbol_name = "RT_LOAD_STORE_CACHE_WRITE_FROM_MESSAGE_COUNT_XECORE1",
                .desc = "Number of write messages sent from Ray Tracing unit to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext188__rt_load_store_cache_write_from_message_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext188_RT_LOAD_STORE_CACHE_WRITE_FROM_MESSAGE_COUNT_XECORE1_availability,
            },

            {
                .name = "RT LOAD STORE CACHE WRITE FROM MESSAGE COUNT XECORE2",
                .symbol_name = "RT_LOAD_STORE_CACHE_WRITE_FROM_MESSAGE_COUNT_XECORE2",
                .desc = "Number of write messages sent from Ray Tracing unit to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext188__rt_load_store_cache_write_from_message_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext188_RT_LOAD_STORE_CACHE_WRITE_FROM_MESSAGE_COUNT_XECORE2_availability,
            },

            {
                .name = "RT LOAD STORE CACHE WRITE FROM MESSAGE COUNT XECORE3",
                .symbol_name = "RT_LOAD_STORE_CACHE_WRITE_FROM_MESSAGE_COUNT_XECORE3",
                .desc = "Number of write messages sent from Ray Tracing unit to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext188__rt_load_store_cache_write_from_message_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext188_RT_LOAD_STORE_CACHE_WRITE_FROM_MESSAGE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext190_PIXEL_POST_PROCESS_INPUT_AVAILABLE_CPIPE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext190_PIXEL_POST_PROCESS_INPUT_AVAILABLE_CPIPE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext190_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext190";
    metric_set->symbol_name = "Ext190";
    metric_set->hw_config_guid = "123714d3-5d52-49de-91eb-0c909557d221";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext190_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext190__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext190__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext190__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext190__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "PIXEL POST PROCESS INPUT AVAILABLE CPIPE0",
                .symbol_name = "PIXEL_POST_PROCESS_INPUT_AVAILABLE_CPIPE0",
                .desc = "Percentage of time in which Color Pipeline input ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext190__pixel_post_process_input_available_cpipe0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext190_PIXEL_POST_PROCESS_INPUT_AVAILABLE_CPIPE0_availability,
            },

            {
                .name = "PIXEL POST PROCESS INPUT AVAILABLE CPIPE1",
                .symbol_name = "PIXEL_POST_PROCESS_INPUT_AVAILABLE_CPIPE1",
                .desc = "Percentage of time in which Color Pipeline input ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext190__pixel_post_process_input_available_cpipe1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext190_PIXEL_POST_PROCESS_INPUT_AVAILABLE_CPIPE1_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool mtlgt2_ext192_RT_INPUT_AVAILABLE_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext192_RT_INPUT_AVAILABLE_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext192_RT_INPUT_AVAILABLE_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext192_RT_INPUT_AVAILABLE_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext192_RT_TRAVERSAL_STEP_RAY_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext192_RT_TRAVERSAL_STEP_RAY_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext192_RT_TRAVERSAL_STEP_RAY_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext192_RT_TRAVERSAL_STEP_RAY_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext192_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext192";
    metric_set->symbol_name = "Ext192";
    metric_set->hw_config_guid = "d2741830-1ee3-42ab-b578-2b9c31a69c1c";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext192_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext192__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext192__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext192__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext192__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "RT INPUT AVAILABLE XECORE0",
                .symbol_name = "RT_INPUT_AVAILABLE_XECORE0",
                .desc = "Percentage of time in which new message is accepted by Ray Tracing Frontend",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext192__rt_input_available_xecore0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext192_RT_INPUT_AVAILABLE_XECORE0_availability,
            },

            {
                .name = "RT INPUT AVAILABLE XECORE1",
                .symbol_name = "RT_INPUT_AVAILABLE_XECORE1",
                .desc = "Percentage of time in which new message is accepted by Ray Tracing Frontend",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext192__rt_input_available_xecore1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext192_RT_INPUT_AVAILABLE_XECORE1_availability,
            },

            {
                .name = "RT INPUT AVAILABLE XECORE2",
                .symbol_name = "RT_INPUT_AVAILABLE_XECORE2",
                .desc = "Percentage of time in which new message is accepted by Ray Tracing Frontend",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext192__rt_input_available_xecore2__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext192_RT_INPUT_AVAILABLE_XECORE2_availability,
            },

            {
                .name = "RT INPUT AVAILABLE XECORE3",
                .symbol_name = "RT_INPUT_AVAILABLE_XECORE3",
                .desc = "Percentage of time in which new message is accepted by Ray Tracing Frontend",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext192__rt_input_available_xecore3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext192_RT_INPUT_AVAILABLE_XECORE3_availability,
            },

            {
                .name = "RT TRAVERSAL STEP RAY COUNT XECORE0",
                .symbol_name = "RT_TRAVERSAL_STEP_RAY_COUNT_XECORE0",
                .desc = "Number of BVH nodes processed",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext192__rt_traversal_step_ray_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext192_RT_TRAVERSAL_STEP_RAY_COUNT_XECORE0_availability,
            },

            {
                .name = "RT TRAVERSAL STEP RAY COUNT XECORE1",
                .symbol_name = "RT_TRAVERSAL_STEP_RAY_COUNT_XECORE1",
                .desc = "Number of BVH nodes processed",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext192__rt_traversal_step_ray_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext192_RT_TRAVERSAL_STEP_RAY_COUNT_XECORE1_availability,
            },

            {
                .name = "RT TRAVERSAL STEP RAY COUNT XECORE2",
                .symbol_name = "RT_TRAVERSAL_STEP_RAY_COUNT_XECORE2",
                .desc = "Number of BVH nodes processed",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext192__rt_traversal_step_ray_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext192_RT_TRAVERSAL_STEP_RAY_COUNT_XECORE2_availability,
            },

            {
                .name = "RT TRAVERSAL STEP RAY COUNT XECORE3",
                .symbol_name = "RT_TRAVERSAL_STEP_RAY_COUNT_XECORE3",
                .desc = "Number of BVH nodes processed",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext192__rt_traversal_step_ray_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext192_RT_TRAVERSAL_STEP_RAY_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}

static bool mtlgt2_ext195_GPGPU_DISPATCH_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext195_GPGPU_DISPATCH_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext195_GPGPU_DISPATCH_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext195_GPGPU_DISPATCH_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext195_XVE_MULTIPLE_PIPE_ACTIVE_XECORE0_XVE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext195_XVE_MULTIPLE_PIPE_ACTIVE_XECORE1_XVE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext195_XVE_MULTIPLE_PIPE_ACTIVE_XECORE2_XVE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext195_XVE_MULTIPLE_PIPE_ACTIVE_XECORE3_XVE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext195_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext195";
    metric_set->symbol_name = "Ext195";
    metric_set->hw_config_guid = "d41508b5-921c-4033-a2f0-8a88aad4e718";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext195_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext195__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext195__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPGPU DISPATCH XECORE0",
                .symbol_name = "GPGPU_DISPATCH_XECORE0",
                .desc = "Number of clocks spent dispatching GPGPU threads to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext195__gpgpu_dispatch_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext195_GPGPU_DISPATCH_XECORE0_availability,
            },

            {
                .name = "GPGPU DISPATCH XECORE1",
                .symbol_name = "GPGPU_DISPATCH_XECORE1",
                .desc = "Number of clocks spent dispatching GPGPU threads to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext195__gpgpu_dispatch_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext195_GPGPU_DISPATCH_XECORE1_availability,
            },

            {
                .name = "GPGPU DISPATCH XECORE2",
                .symbol_name = "GPGPU_DISPATCH_XECORE2",
                .desc = "Number of clocks spent dispatching GPGPU threads to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext195__gpgpu_dispatch_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext195_GPGPU_DISPATCH_XECORE2_availability,
            },

            {
                .name = "GPGPU DISPATCH XECORE3",
                .symbol_name = "GPGPU_DISPATCH_XECORE3",
                .desc = "Number of clocks spent dispatching GPGPU threads to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext195__gpgpu_dispatch_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext195_GPGPU_DISPATCH_XECORE3_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext195__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext195__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE MULTIPLE PIPE ACTIVE XECORE0 XVE0",
                .symbol_name = "XVE_MULTIPLE_PIPE_ACTIVE_XECORE0_XVE0",
                .desc = "Percentage of time in which at least two pipes are actively executing a Gen ISA instruction among ALU0, ALU1 and XMX pipes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext195__xve_multiple_pipe_active_xecore0_xve0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext195_XVE_MULTIPLE_PIPE_ACTIVE_XECORE0_XVE0_availability,
            },

            {
                .name = "XVE MULTIPLE PIPE ACTIVE XECORE1 XVE0",
                .symbol_name = "XVE_MULTIPLE_PIPE_ACTIVE_XECORE1_XVE0",
                .desc = "Percentage of time in which at least two pipes are actively executing a Gen ISA instruction among ALU0, ALU1 and XMX pipes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext195__xve_multiple_pipe_active_xecore1_xve0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext195_XVE_MULTIPLE_PIPE_ACTIVE_XECORE1_XVE0_availability,
            },

            {
                .name = "XVE MULTIPLE PIPE ACTIVE XECORE2 XVE0",
                .symbol_name = "XVE_MULTIPLE_PIPE_ACTIVE_XECORE2_XVE0",
                .desc = "Percentage of time in which at least two pipes are actively executing a Gen ISA instruction among ALU0, ALU1 and XMX pipes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext195__xve_multiple_pipe_active_xecore2_xve0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext195_XVE_MULTIPLE_PIPE_ACTIVE_XECORE2_XVE0_availability,
            },

            {
                .name = "XVE MULTIPLE PIPE ACTIVE XECORE3 XVE0",
                .symbol_name = "XVE_MULTIPLE_PIPE_ACTIVE_XECORE3_XVE0",
                .desc = "Percentage of time in which at least two pipes are actively executing a Gen ISA instruction among ALU0, ALU1 and XMX pipes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = mtlgt2__ext195__xve_multiple_pipe_active_xecore3_xve0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = mtlgt2_ext195_XVE_MULTIPLE_PIPE_ACTIVE_XECORE3_XVE0_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}

static bool mtlgt2_ext200_SLM_ACCESS_COUNT_BANK0_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext200_SLM_ACCESS_COUNT_BANK0_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext200_SLM_ACCESS_COUNT_BANK0_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext200_SLM_ACCESS_COUNT_BANK0_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext200_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext200";
    metric_set->symbol_name = "Ext200";
    metric_set->hw_config_guid = "73a53c50-0922-4d77-87d9-13b18d368e4e";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext200_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext200__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext200__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext200__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext200__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "SLM ACCESS COUNT BANK0 XECORE0",
                .symbol_name = "SLM_ACCESS_COUNT_BANK0_XECORE0",
                .desc = "Number of SLM accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext200__slm_access_count_bank0_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext200_SLM_ACCESS_COUNT_BANK0_XECORE0_availability,
            },

            {
                .name = "SLM ACCESS COUNT BANK0 XECORE1",
                .symbol_name = "SLM_ACCESS_COUNT_BANK0_XECORE1",
                .desc = "Number of SLM accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext200__slm_access_count_bank0_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext200_SLM_ACCESS_COUNT_BANK0_XECORE1_availability,
            },

            {
                .name = "SLM ACCESS COUNT BANK0 XECORE2",
                .symbol_name = "SLM_ACCESS_COUNT_BANK0_XECORE2",
                .desc = "Number of SLM accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext200__slm_access_count_bank0_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext200_SLM_ACCESS_COUNT_BANK0_XECORE2_availability,
            },

            {
                .name = "SLM ACCESS COUNT BANK0 XECORE3",
                .symbol_name = "SLM_ACCESS_COUNT_BANK0_XECORE3",
                .desc = "Number of SLM accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext200__slm_access_count_bank0_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext200_SLM_ACCESS_COUNT_BANK0_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext201_SLM_ACCESS_COUNT_BANK1_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext201_SLM_ACCESS_COUNT_BANK1_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext201_SLM_ACCESS_COUNT_BANK1_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext201_SLM_ACCESS_COUNT_BANK1_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext201_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext201";
    metric_set->symbol_name = "Ext201";
    metric_set->hw_config_guid = "32b9a4f4-b1f0-478f-8998-d86e5c5c458f";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext201_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext201__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext201__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext201__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext201__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "SLM ACCESS COUNT BANK1 XECORE0",
                .symbol_name = "SLM_ACCESS_COUNT_BANK1_XECORE0",
                .desc = "Number of SLM accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext201__slm_access_count_bank1_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext201_SLM_ACCESS_COUNT_BANK1_XECORE0_availability,
            },

            {
                .name = "SLM ACCESS COUNT BANK1 XECORE1",
                .symbol_name = "SLM_ACCESS_COUNT_BANK1_XECORE1",
                .desc = "Number of SLM accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext201__slm_access_count_bank1_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext201_SLM_ACCESS_COUNT_BANK1_XECORE1_availability,
            },

            {
                .name = "SLM ACCESS COUNT BANK1 XECORE2",
                .symbol_name = "SLM_ACCESS_COUNT_BANK1_XECORE2",
                .desc = "Number of SLM accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext201__slm_access_count_bank1_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext201_SLM_ACCESS_COUNT_BANK1_XECORE2_availability,
            },

            {
                .name = "SLM ACCESS COUNT BANK1 XECORE3",
                .symbol_name = "SLM_ACCESS_COUNT_BANK1_XECORE3",
                .desc = "Number of SLM accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext201__slm_access_count_bank1_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext201_SLM_ACCESS_COUNT_BANK1_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}


static void
mtlgt2_add_ext202_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext202";
    metric_set->symbol_name = "Ext202";
    metric_set->hw_config_guid = "e1606d82-b67b-4fd8-9b07-a769dd6e6581";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext202_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext202__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext202__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY L3 WRITE SQIDI0",
                .symbol_name = "GPU_MEMORY_L3_WRITE_SQIDI0",
                .desc = "Number of GTI memory writes from L3 caused by L3 invalidations",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext202__gpu_memory_l3_write_sqidi0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext202__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext202__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 4);
}


static void
mtlgt2_add_ext203_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext203";
    metric_set->symbol_name = "Ext203";
    metric_set->hw_config_guid = "16647b5e-c9e4-4201-afc2-cb47a9f3f4d2";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext203_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext203__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext203__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY L3 WRITE SQIDI1",
                .symbol_name = "GPU_MEMORY_L3_WRITE_SQIDI1",
                .desc = "Number of GTI memory writes from L3 caused by L3 invalidations",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext203__gpu_memory_l3_write_sqidi1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext203__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext203__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 4);
}

static bool mtlgt2_ext204_RT_INTERNAL_NODE_RAY_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext204_RT_INTERNAL_NODE_RAY_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext204_RT_INTERNAL_NODE_RAY_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext204_RT_INTERNAL_NODE_RAY_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext204_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext204";
    metric_set->symbol_name = "Ext204";
    metric_set->hw_config_guid = "639a17e1-f339-49ab-9884-6b9a91a5a0c8";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext204_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext204__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext204__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext204__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext204__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "RT INTERNAL NODE RAY COUNT XECORE0",
                .symbol_name = "RT_INTERNAL_NODE_RAY_COUNT_XECORE0",
                .desc = "Number of internal BVH nodes processed by the traversal function",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext204__rt_internal_node_ray_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext204_RT_INTERNAL_NODE_RAY_COUNT_XECORE0_availability,
            },

            {
                .name = "RT INTERNAL NODE RAY COUNT XECORE1",
                .symbol_name = "RT_INTERNAL_NODE_RAY_COUNT_XECORE1",
                .desc = "Number of internal BVH nodes processed by the traversal function",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext204__rt_internal_node_ray_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext204_RT_INTERNAL_NODE_RAY_COUNT_XECORE1_availability,
            },

            {
                .name = "RT INTERNAL NODE RAY COUNT XECORE2",
                .symbol_name = "RT_INTERNAL_NODE_RAY_COUNT_XECORE2",
                .desc = "Number of internal BVH nodes processed by the traversal function",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext204__rt_internal_node_ray_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext204_RT_INTERNAL_NODE_RAY_COUNT_XECORE2_availability,
            },

            {
                .name = "RT INTERNAL NODE RAY COUNT XECORE3",
                .symbol_name = "RT_INTERNAL_NODE_RAY_COUNT_XECORE3",
                .desc = "Number of internal BVH nodes processed by the traversal function",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext204__rt_internal_node_ray_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext204_RT_INTERNAL_NODE_RAY_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext205_RT_INSTANCE_NODE_RAY_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext205_RT_INSTANCE_NODE_RAY_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext205_RT_INSTANCE_NODE_RAY_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext205_RT_INSTANCE_NODE_RAY_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext205_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext205";
    metric_set->symbol_name = "Ext205";
    metric_set->hw_config_guid = "7420acf6-1809-41e3-b5d1-49455c60aa66";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext205_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext205__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext205__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext205__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext205__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "RT INSTANCE NODE RAY COUNT XECORE0",
                .symbol_name = "RT_INSTANCE_NODE_RAY_COUNT_XECORE0",
                .desc = "Number of instance BVH nodes processed by the traversal function",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext205__rt_instance_node_ray_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext205_RT_INSTANCE_NODE_RAY_COUNT_XECORE0_availability,
            },

            {
                .name = "RT INSTANCE NODE RAY COUNT XECORE1",
                .symbol_name = "RT_INSTANCE_NODE_RAY_COUNT_XECORE1",
                .desc = "Number of instance BVH nodes processed by the traversal function",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext205__rt_instance_node_ray_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext205_RT_INSTANCE_NODE_RAY_COUNT_XECORE1_availability,
            },

            {
                .name = "RT INSTANCE NODE RAY COUNT XECORE2",
                .symbol_name = "RT_INSTANCE_NODE_RAY_COUNT_XECORE2",
                .desc = "Number of instance BVH nodes processed by the traversal function",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext205__rt_instance_node_ray_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext205_RT_INSTANCE_NODE_RAY_COUNT_XECORE2_availability,
            },

            {
                .name = "RT INSTANCE NODE RAY COUNT XECORE3",
                .symbol_name = "RT_INSTANCE_NODE_RAY_COUNT_XECORE3",
                .desc = "Number of instance BVH nodes processed by the traversal function",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext205__rt_instance_node_ray_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext205_RT_INSTANCE_NODE_RAY_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext212_RT_PROCEDURAL_NODE_RAY_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext212_RT_PROCEDURAL_NODE_RAY_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext212_RT_QUAD_LEAF_RAY_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext212_RT_QUAD_LEAF_RAY_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext212_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext212";
    metric_set->symbol_name = "Ext212";
    metric_set->hw_config_guid = "015d134a-1b6e-4969-b972-b904c1d0cc85";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext212_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext212__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext212__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext212__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext212__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "RT PROCEDURAL NODE RAY COUNT XECORE0",
                .symbol_name = "RT_PROCEDURAL_NODE_RAY_COUNT_XECORE0",
                .desc = "Number of procedural BVH nodes processed by the traversal function",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext212__rt_procedural_node_ray_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext212_RT_PROCEDURAL_NODE_RAY_COUNT_XECORE0_availability,
            },

            {
                .name = "RT PROCEDURAL NODE RAY COUNT XECORE1",
                .symbol_name = "RT_PROCEDURAL_NODE_RAY_COUNT_XECORE1",
                .desc = "Number of procedural BVH nodes processed by the traversal function",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext212__rt_procedural_node_ray_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext212_RT_PROCEDURAL_NODE_RAY_COUNT_XECORE1_availability,
            },

            {
                .name = "RT QUAD LEAF RAY COUNT XECORE0",
                .symbol_name = "RT_QUAD_LEAF_RAY_COUNT_XECORE0",
                .desc = "Number of triangle BVH nodes processed by the traversal function",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext212__rt_quad_leaf_ray_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext212_RT_QUAD_LEAF_RAY_COUNT_XECORE0_availability,
            },

            {
                .name = "RT QUAD LEAF RAY COUNT XECORE1",
                .symbol_name = "RT_QUAD_LEAF_RAY_COUNT_XECORE1",
                .desc = "Number of triangle BVH nodes processed by the traversal function",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext212__rt_quad_leaf_ray_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext212_RT_QUAD_LEAF_RAY_COUNT_XECORE1_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext214_RT_PROCEDURAL_NODE_RAY_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext214_RT_PROCEDURAL_NODE_RAY_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext214_RT_QUAD_LEAF_RAY_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext214_RT_QUAD_LEAF_RAY_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext214_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext214";
    metric_set->symbol_name = "Ext214";
    metric_set->hw_config_guid = "191eb41b-6180-4cf9-b3fb-048bf4da8b94";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext214_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext214__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext214__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext214__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext214__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "RT PROCEDURAL NODE RAY COUNT XECORE2",
                .symbol_name = "RT_PROCEDURAL_NODE_RAY_COUNT_XECORE2",
                .desc = "Number of procedural BVH nodes processed by the traversal function",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext214__rt_procedural_node_ray_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext214_RT_PROCEDURAL_NODE_RAY_COUNT_XECORE2_availability,
            },

            {
                .name = "RT PROCEDURAL NODE RAY COUNT XECORE3",
                .symbol_name = "RT_PROCEDURAL_NODE_RAY_COUNT_XECORE3",
                .desc = "Number of procedural BVH nodes processed by the traversal function",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext214__rt_procedural_node_ray_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext214_RT_PROCEDURAL_NODE_RAY_COUNT_XECORE3_availability,
            },

            {
                .name = "RT QUAD LEAF RAY COUNT XECORE2",
                .symbol_name = "RT_QUAD_LEAF_RAY_COUNT_XECORE2",
                .desc = "Number of triangle BVH nodes processed by the traversal function",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext214__rt_quad_leaf_ray_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext214_RT_QUAD_LEAF_RAY_COUNT_XECORE2_availability,
            },

            {
                .name = "RT QUAD LEAF RAY COUNT XECORE3",
                .symbol_name = "RT_QUAD_LEAF_RAY_COUNT_XECORE3",
                .desc = "Number of triangle BVH nodes processed by the traversal function",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext214__rt_quad_leaf_ray_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext214_RT_QUAD_LEAF_RAY_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext220_RT_BVH_CACHE_MISS_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext220_RT_BVH_CACHE_MISS_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext220_RT_BVH_CACHE_MISS_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext220_RT_BVH_CACHE_MISS_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext220_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext220";
    metric_set->symbol_name = "Ext220";
    metric_set->hw_config_guid = "840ad20c-c8ba-4dd5-bc42-674987d6ec79";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext220_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext220__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext220__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext220__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext220__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "RT BVH CACHE MISS XECORE0",
                .symbol_name = "RT_BVH_CACHE_MISS_XECORE0",
                .desc = "Number of BVH cache misses for RayQuery only",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext220__rt_bvh_cache_miss_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext220_RT_BVH_CACHE_MISS_XECORE0_availability,
            },

            {
                .name = "RT BVH CACHE MISS XECORE1",
                .symbol_name = "RT_BVH_CACHE_MISS_XECORE1",
                .desc = "Number of BVH cache misses for RayQuery only",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext220__rt_bvh_cache_miss_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext220_RT_BVH_CACHE_MISS_XECORE1_availability,
            },

            {
                .name = "RT BVH CACHE MISS XECORE2",
                .symbol_name = "RT_BVH_CACHE_MISS_XECORE2",
                .desc = "Number of BVH cache misses for RayQuery only",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext220__rt_bvh_cache_miss_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext220_RT_BVH_CACHE_MISS_XECORE2_availability,
            },

            {
                .name = "RT BVH CACHE MISS XECORE3",
                .symbol_name = "RT_BVH_CACHE_MISS_XECORE3",
                .desc = "Number of BVH cache misses for RayQuery only",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext220__rt_bvh_cache_miss_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext220_RT_BVH_CACHE_MISS_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext225_PIXEL_2x2_LIT_POST_RASTERIZER_EARLY_DEPTH_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext225_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext225";
    metric_set->symbol_name = "Ext225";
    metric_set->hw_config_guid = "a8bfddc1-d469-45d6-8790-7d8c649ada41";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext225_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext225__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext225__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext225__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext225__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "PIXEL 2x2 LIT POST RASTERIZER EARLY DEPTH SLICE0",
                .symbol_name = "PIXEL_2x2_LIT_POST_RASTERIZER_EARLY_DEPTH_SLICE0",
                .desc = "Number of promoted 2x2 that are lit from Rasterizer",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext225__pixel_2x2_lit_post_rasterizer_early_depth_slice0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext225_PIXEL_2x2_LIT_POST_RASTERIZER_EARLY_DEPTH_SLICE0_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 4);
}

static bool mtlgt2_ext227_PIXEL_2x2_LIT_POST_RASTERIZER_LATE_DEPTH_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext227_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext227";
    metric_set->symbol_name = "Ext227";
    metric_set->hw_config_guid = "325e5e9b-a055-4c22-8997-98d546a31afe";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext227_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext227__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext227__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext227__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext227__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "PIXEL 2x2 LIT POST RASTERIZER LATE DEPTH SLICE0",
                .symbol_name = "PIXEL_2x2_LIT_POST_RASTERIZER_LATE_DEPTH_SLICE0",
                .desc = "Number of non-promoted 2x2 that are lit from Rasterizer",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext227__pixel_2x2_lit_post_rasterizer_late_depth_slice0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext227_PIXEL_2x2_LIT_POST_RASTERIZER_LATE_DEPTH_SLICE0_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 4);
}

static bool mtlgt2_ext229_SLM_BANK_CONFLICT_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext229_SLM_BANK_CONFLICT_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext229_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext229";
    metric_set->symbol_name = "Ext229";
    metric_set->hw_config_guid = "94537bb4-60fd-45fe-b172-29ed90c9abac";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext229_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext229__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext229__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext229__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext229__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "SLM BANK CONFLICT COUNT XECORE0",
                .symbol_name = "SLM_BANK_CONFLICT_COUNT_XECORE0",
                .desc = "Number of SLM accesses resulting in a bank conflict",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext229__slm_bank_conflict_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext229_SLM_BANK_CONFLICT_COUNT_XECORE0_availability,
            },

            {
                .name = "SLM BANK CONFLICT COUNT XECORE1",
                .symbol_name = "SLM_BANK_CONFLICT_COUNT_XECORE1",
                .desc = "Number of SLM accesses resulting in a bank conflict",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext229__slm_bank_conflict_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext229_SLM_BANK_CONFLICT_COUNT_XECORE1_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool mtlgt2_ext231_SLM_BANK_CONFLICT_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext231_SLM_BANK_CONFLICT_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext231_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext231";
    metric_set->symbol_name = "Ext231";
    metric_set->hw_config_guid = "7fceb68b-57e6-480d-81d1-991d8d6f7c4d";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext231_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext231__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext231__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext231__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext231__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "SLM BANK CONFLICT COUNT XECORE2",
                .symbol_name = "SLM_BANK_CONFLICT_COUNT_XECORE2",
                .desc = "Number of SLM accesses resulting in a bank conflict",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext231__slm_bank_conflict_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext231_SLM_BANK_CONFLICT_COUNT_XECORE2_availability,
            },

            {
                .name = "SLM BANK CONFLICT COUNT XECORE3",
                .symbol_name = "SLM_BANK_CONFLICT_COUNT_XECORE3",
                .desc = "Number of SLM accesses resulting in a bank conflict",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext231__slm_bank_conflict_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext231_SLM_BANK_CONFLICT_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool mtlgt2_ext237_L3_MISS_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext237_L3_MISS_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext237_L3_MISS_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext237_L3_MISS_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext237_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext237";
    metric_set->symbol_name = "Ext237";
    metric_set->hw_config_guid = "ad62dc60-987b-415e-9f7d-6976fbe82dac";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext237_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext237__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext237__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext237__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext237__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "L3 MISS L3BANK0",
                .symbol_name = "L3_MISS_L3BANK0",
                .desc = "Number of L3 accesses which miss in the L3 cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext237__l3_miss_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext237_L3_MISS_L3BANK0_availability,
            },

            {
                .name = "L3 MISS L3BANK1",
                .symbol_name = "L3_MISS_L3BANK1",
                .desc = "Number of L3 accesses which miss in the L3 cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext237__l3_miss_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext237_L3_MISS_L3BANK1_availability,
            },

            {
                .name = "L3 MISS L3BANK2",
                .symbol_name = "L3_MISS_L3BANK2",
                .desc = "Number of L3 accesses which miss in the L3 cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext237__l3_miss_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext237_L3_MISS_L3BANK2_availability,
            },

            {
                .name = "L3 MISS L3BANK3",
                .symbol_name = "L3_MISS_L3BANK3",
                .desc = "Number of L3 accesses which miss in the L3 cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext237__l3_miss_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = mtlgt2_ext237_L3_MISS_L3BANK3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool mtlgt2_ext238_AMFS_L3_WRITE_SLICE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext238_XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext238_XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext238_XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext238_XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext238_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext238";
    metric_set->symbol_name = "Ext238";
    metric_set->hw_config_guid = "e630dd77-cf9e-4deb-8f52-57506b306b63";
    metric_set->counters = calloc(8, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext238_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AMFS L3 WRITE SLICE0",
                .symbol_name = "AMFS_L3_WRITE_SLICE0",
                .desc = "Number of AMFS writes to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext238__amfs_l3_write_slice0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext238_AMFS_L3_WRITE_SLICE0_availability,
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext238__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext238__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext238__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext238__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE DATAPORT FENCE MESSAGE COUNT XECORE0",
                .symbol_name = "XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE0",
                .desc = "Number of fence messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext238__xve_dataport_fence_message_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext238_XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE DATAPORT FENCE MESSAGE COUNT XECORE1",
                .symbol_name = "XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE1",
                .desc = "Number of fence messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext238__xve_dataport_fence_message_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext238_XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE1_availability,
            },

            {
                .name = "XVE DATAPORT FENCE MESSAGE COUNT XECORE2",
                .symbol_name = "XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE2",
                .desc = "Number of fence messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext238__xve_dataport_fence_message_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext238_XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE2_availability,
            },

            {
                .name = "XVE DATAPORT FENCE MESSAGE COUNT XECORE3",
                .symbol_name = "XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE3",
                .desc = "Number of fence messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext238__xve_dataport_fence_message_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext238_XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 8);
}


static void
mtlgt2_add_ext239_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext239";
    metric_set->symbol_name = "Ext239";
    metric_set->hw_config_guid = "6dfee12d-6bfc-434a-8873-bc076a47d80b";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext239_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext239__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext239__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY L3 READ SQIDI0",
                .symbol_name = "GPU_MEMORY_L3_READ_SQIDI0",
                .desc = "Number of GTI memory reads from L3 caused by L3 Cache misses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext239__gpu_memory_l3_read_sqidi0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext239__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext239__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 4);
}


static void
mtlgt2_add_ext240_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext240";
    metric_set->symbol_name = "Ext240";
    metric_set->hw_config_guid = "5edd0480-7a46-49f7-8709-7f737d0cc42a";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext240_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext240__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext240__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY L3 READ SQIDI1",
                .symbol_name = "GPU_MEMORY_L3_READ_SQIDI1",
                .desc = "Number of GTI memory reads from L3 caused by L3 Cache misses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext240__gpu_memory_l3_read_sqidi1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext240__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext240__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 4);
}

static bool mtlgt2_ext500_ICACHE_HIT_BANK0_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext500_ICACHE_HIT_BANK0_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext500_ICACHE_HIT_BANK0_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext500_ICACHE_HIT_BANK0_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext500_ICACHE_MISS_BANK0_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext500_ICACHE_MISS_BANK0_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext500_ICACHE_MISS_BANK0_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        return true;
    }
    return false;
}
static bool mtlgt2_ext500_ICACHE_MISS_BANK0_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        return true;
    }
    return false;
}

static void
mtlgt2_add_ext500_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext500";
    metric_set->symbol_name = "Ext500";
    metric_set->hw_config_guid = "a7cd6b7e-e8ee-4853-b2d3-269bf3ed73c7";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    mtlgt2_ext500_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = mtlgt2__ext500__avg_gpu_core_frequency__read,
                .max_uint64 = mtlgt2__ext500__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = mtlgt2__ext500__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = mtlgt2__ext500__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "ICACHE HIT BANK0 XECORE0",
                .symbol_name = "ICACHE_HIT_BANK0_XECORE0",
                .desc = "Number of Instruction Cache Hits",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = mtlgt2__ext500__icache_hit_bank0_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
                .availability = mtlgt2_ext500_ICACHE_HIT_BANK0_XECORE0_availability,
            },

            {
                .name = "ICACHE HIT BANK0 XECORE1",
                .symbol_name = "ICACHE_HIT_BANK0_XECORE1",
                .desc = "Number of Instru