
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kjobuidelegate_wrapper.h"

// Wrappers providing overrides
#include "ksignalhandler_wrapper.h"

// Argument includes
#include <QString>
#include <kjob.h>
#include <qobject.h>
#include <qobjectdefs.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KJobUiDelegate_Type = nullptr;
static PyTypeObject *Sbk_KJobUiDelegate_TypeF(void)
{
    return _Sbk_KJobUiDelegate_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KJobUiDelegateWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KJobUiDelegateWrapper::KJobUiDelegateWrapper(::QFlags<KJobUiDelegate::Flag> flags) : KJobUiDelegate(flags)
{
}

void KJobUiDelegateWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KSignalHandlerWrapper::sbk_o_childEvent("KJobUiDelegate", funcName, gil, pyOverride, event);
}

void KJobUiDelegateWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KSignalHandlerWrapper::sbk_o_connectNotify("KJobUiDelegate", funcName, gil, pyOverride, signal);
}

void KJobUiDelegateWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KSignalHandlerWrapper::sbk_o_customEvent("KJobUiDelegate", funcName, gil, pyOverride, event);
}

void KJobUiDelegateWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KSignalHandlerWrapper::sbk_o_connectNotify("KJobUiDelegate", funcName, gil, pyOverride, signal);
}

bool KJobUiDelegateWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KSignalHandlerWrapper::sbk_o_event("KJobUiDelegate", funcName, gil, pyOverride, event);
}

bool KJobUiDelegateWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KSignalHandlerWrapper::sbk_o_eventFilter("KJobUiDelegate", funcName, gil, pyOverride, watched, event);
}

bool KJobUiDelegateWrapper::setJob(::KJob * job)
{
    static const char *funcName = "setJob";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobUiDelegate::setJob(job);
    }
    return sbk_o_setJob("KJobUiDelegate", funcName, gil, pyOverride, job);
}

bool KJobUiDelegateWrapper::sbk_o_setJob(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::KJob * job)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), job)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), job)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void KJobUiDelegateWrapper::showErrorMessage()
{
    static const char *funcName = "showErrorMessage";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobUiDelegate::showErrorMessage();
    }
    sbk_o_showErrorMessage("KJobUiDelegate", funcName, gil, pyOverride);
}

void KJobUiDelegateWrapper::sbk_o_showErrorMessage(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KJobUiDelegateWrapper::slotWarning(::KJob * job, const ::QString & message)
{
    static const char *funcName = "slotWarning";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobUiDelegate::slotWarning(job, message);
    }
    sbk_o_slotWarning("KJobUiDelegate", funcName, gil, pyOverride, job, message);
}

void KJobUiDelegateWrapper::sbk_o_slotWarning(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::KJob * job, const ::QString & message)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), job),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &message)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), job),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &message)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KJobUiDelegateWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KSignalHandlerWrapper::sbk_o_timerEvent("KJobUiDelegate", funcName, gil, pyOverride, event);
}

const QMetaObject *KJobUiDelegateWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KJobUiDelegate::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KJobUiDelegateWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KJobUiDelegate::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KJobUiDelegateWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KJobUiDelegateWrapper *>(this));
    }
    return KJobUiDelegate::qt_metacast(_clname);
}

KJobUiDelegateWrapper::~KJobUiDelegateWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KJobUiDelegate_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KJobUiDelegate_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KJobUiDelegate >()))
        return -1;

    KJobUiDelegateWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KJobUiDelegate", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KJobUiDelegate::KJobUiDelegate(QFlags<KJobUiDelegate::Flag>=)
    if (numArgs == 0) {
        overloadId = 0; // KJobUiDelegate(QFlags<KJobUiDelegate::Flag>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_QFlags_KJobUiDelegate_Flag_IDX])))->flagsConverter, (pyArgs[0])))) {
        overloadId = 0; // KJobUiDelegate(QFlags<KJobUiDelegate::Flag>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"flags", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_QFlags_KJobUiDelegate_Flag_IDX])))->flagsConverter, (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX]);
            }
        }
        ::QFlags<KJobUiDelegate::Flag> cppArg0({KJobUiDelegate::AutoHandlingDisabled});
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KJobUiDelegate(QFlags<KJobUiDelegate::Flag>)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KJobUiDelegateWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KJobUiDelegateWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KJobUiDelegate >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KJobUiDelegateFunc_isAutoErrorHandlingEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJobUiDelegate *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isAutoErrorHandlingEnabled()const
        bool cppResult = const_cast<const ::KJobUiDelegate *>(cppSelf)->isAutoErrorHandlingEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KJobUiDelegateFunc_isAutoWarningHandlingEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJobUiDelegate *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isAutoWarningHandlingEnabled()const
        bool cppResult = const_cast<const ::KJobUiDelegate *>(cppSelf)->isAutoWarningHandlingEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KJobUiDelegateFunc_job(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJobUiDelegate *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // job()const
        KJob * cppResult = const_cast<const ::KJobUiDelegate *>(cppSelf)->job();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KJobUiDelegateFunc_setAutoErrorHandlingEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJobUiDelegate *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobUiDelegate::setAutoErrorHandlingEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAutoErrorHandlingEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setAutoErrorHandlingEnabled", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAutoErrorHandlingEnabled(bool)
            cppSelf->setAutoErrorHandlingEnabled(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobUiDelegateFunc_setAutoWarningHandlingEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJobUiDelegate *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobUiDelegate::setAutoWarningHandlingEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAutoWarningHandlingEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setAutoWarningHandlingEnabled", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAutoWarningHandlingEnabled(bool)
            cppSelf->setAutoWarningHandlingEnabled(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobUiDelegateFunc_setJob(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJobUiDelegate *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobUiDelegate::setJob(KJob*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // setJob(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setJob", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setJob(KJob*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KJobUiDelegate::setJob(cppArg0)
                : cppSelf->setJob(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KJobUiDelegateFunc_showErrorMessage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJobUiDelegate *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // showErrorMessage()
        Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KJobUiDelegate::showErrorMessage()
            : cppSelf->showErrorMessage();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobUiDelegateFunc_slotWarning(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJobUiDelegate *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "slotWarning", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobUiDelegate::slotWarning(KJob*,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // slotWarning(KJob*,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "slotWarning", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // slotWarning(KJob*,QString)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KJobUiDelegate::slotWarning(cppArg0, cppArg1)
                : cppSelf->slotWarning(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KJobUiDelegate_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_KJobUiDelegate_EnumFlagInfo[] = {
    "Flag:IntFlag:Flags",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KJobUiDelegate_methods[] = {
    {"isAutoErrorHandlingEnabled", reinterpret_cast<PyCFunction>(Sbk_KJobUiDelegateFunc_isAutoErrorHandlingEnabled), METH_NOARGS, nullptr},
    {"isAutoWarningHandlingEnabled", reinterpret_cast<PyCFunction>(Sbk_KJobUiDelegateFunc_isAutoWarningHandlingEnabled), METH_NOARGS, nullptr},
    {"job", reinterpret_cast<PyCFunction>(Sbk_KJobUiDelegateFunc_job), METH_NOARGS, nullptr},
    {"setAutoErrorHandlingEnabled", reinterpret_cast<PyCFunction>(Sbk_KJobUiDelegateFunc_setAutoErrorHandlingEnabled), METH_O, nullptr},
    {"setAutoWarningHandlingEnabled", reinterpret_cast<PyCFunction>(Sbk_KJobUiDelegateFunc_setAutoWarningHandlingEnabled), METH_O, nullptr},
    {"setJob", reinterpret_cast<PyCFunction>(Sbk_KJobUiDelegateFunc_setJob), METH_O, nullptr},
    {"showErrorMessage", reinterpret_cast<PyCFunction>(Sbk_KJobUiDelegateFunc_showErrorMessage), METH_NOARGS, nullptr},
    {"slotWarning", reinterpret_cast<PyCFunction>(Sbk_KJobUiDelegateFunc_slotWarning), METH_VARARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KJobUiDelegate_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KJobUiDelegate *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KJobUiDelegateWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KJobUiDelegate_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KJobUiDelegate_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KJobUiDelegate_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KJobUiDelegate_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KJobUiDelegate_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KJobUiDelegate_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KJobUiDelegate_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KJobUiDelegate_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KJobUiDelegate_spec = {
    "1:KCoreAddons.KJobUiDelegate",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KJobUiDelegate_slots
};

} //extern "C"

static void *Sbk_KJobUiDelegate_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KJobUiDelegate *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KJobUiDelegate_Flag(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KJobUiDelegate::Flag>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KJobUiDelegate::Flag *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KJobUiDelegate_Flag_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_Flag_IDX])))
        return Enum_PythonToCpp_KJobUiDelegate_Flag;
    return {};
}

static PyObject *KJobUiDelegate_Flag_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KJobUiDelegate::Flag>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KJobUiDelegate::Flag *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Flag_PythonToCpp_KJobUiDelegate_Flag(PyObject *pyIn, void *cppOut)
{
    const auto value = QFlags<::KJobUiDelegate::Flag>::fromInt(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<QFlags<::KJobUiDelegate::Flag> *>(cppOut) = value;

}

static PyObject *KJobUiDelegate_Flag_CppToPython_Flag(const void *cppIn)
{
    const auto flags = *reinterpret_cast<const QFlags<::KJobUiDelegate::Flag> *>(cppIn);
    return Shiboken::Enum::newItem(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_Flag_IDX]), flags.toInt());

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KJobUiDelegate_PythonToCpp_KJobUiDelegate_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KJobUiDelegate_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KJobUiDelegate_PythonToCpp_KJobUiDelegate_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KJobUiDelegate_TypeF()))
        return KJobUiDelegate_PythonToCpp_KJobUiDelegate_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KJobUiDelegate_PTR_CppToPython_KJobUiDelegate(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KJobUiDelegate *>(const_cast<void *>(cppIn)), Sbk_KJobUiDelegate_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KJobUiDelegate_SignatureStrings[] = {
    "KCoreAddons.KJobUiDelegate(self,flags:KCoreAddons.KJobUiDelegate.Flag={KJobUiDelegate.AutoHandlingDisabled})",
    "KCoreAddons.KJobUiDelegate.isAutoErrorHandlingEnabled(self)->bool",
    "KCoreAddons.KJobUiDelegate.isAutoWarningHandlingEnabled(self)->bool",
    "KCoreAddons.KJobUiDelegate.job(self)->KCoreAddons.KJob",
    "KCoreAddons.KJobUiDelegate.setAutoErrorHandlingEnabled(self,enable:bool)",
    "KCoreAddons.KJobUiDelegate.setAutoWarningHandlingEnabled(self,enable:bool)",
    "KCoreAddons.KJobUiDelegate.setJob(self,job:KCoreAddons.KJob)->bool",
    "KCoreAddons.KJobUiDelegate.showErrorMessage(self)",
    "KCoreAddons.KJobUiDelegate.slotWarning(self,job:KCoreAddons.KJob,message:QString)",
    nullptr}; // Sentinel
#else
static constexpr size_t KJobUiDelegate_SignatureByteSize = 193;
static constexpr uint8_t KJobUiDelegate_SignatureBytes[193] = {
    0x78, 0xda, 0x9d, 0x92, 0x51, 0x0b, 0x82, 0x30, 0x14, 0x85, 0xdf, 0xfd, 0x25, 0x09, 0xcb, 0x1f,
    0x20, 0x14, 0x48, 0x1a, 0xa1, 0xf4, 0x10, 0x11, 0x3d, 0x4f, 0xbc, 0x2e, 0x63, 0xed, 0xc2, 0xee,
    0xa2, 0x87, 0xe8, 0xbf, 0x37, 0xa7, 0xbe, 0x18, 0x2e, 0xeb, 0x71, 0xe3, 0x9c, 0xef, 0xdc, 0x73,
    0xb7, 0x62, 0x83, 0x1a, 0x92, 0xaa, 0x42, 0x45, 0x51, 0x91, 0x63, 0x79, 0x6a, 0x52, 0x90, 0x20,
    0xb8, 0x81, 0x05, 0x81, 0xac, 0x59, 0x2d, 0xb9, 0xa0, 0xb8, 0x98, 0x54, 0x45, 0x5b, 0x2b, 0x58,
    0x3d, 0x47, 0x97, 0xc9, 0xdd, 0xe0, 0x8e, 0xab, 0x4a, 0x36, 0x4a, 0xa4, 0x0d, 0xf1, 0x52, 0x42,
    0xf5, 0x0a, 0x03, 0x0f, 0xa6, 0xa1, 0xd6, 0x93, 0x69, 0x8d, 0x7a, 0x30, 0x66, 0xca, 0xf9, 0xdc,
    0x1c, 0xe1, 0x72, 0x5d, 0x22, 0xca, 0xef, 0x84, 0x33, 0xd7, 0xca, 0x7a, 0xff, 0x64, 0x5c, 0xb1,
    0x1c, 0xa4, 0x63, 0x95, 0xcf, 0x46, 0x60, 0xbc, 0xd3, 0x33, 0x70, 0x87, 0xb8, 0x8d, 0x0f, 0x67,
    0x80, 0x3c, 0x25, 0x7e, 0x41, 0xe5, 0x7d, 0x1b, 0x66, 0x6b, 0x7d, 0x3c, 0xe1, 0x8c, 0x6d, 0xd0,
    0x05, 0x1f, 0xae, 0xd3, 0x1e, 0x88, 0xb8, 0xe8, 0x7e, 0x84, 0x3f, 0x54, 0xa2, 0xe9, 0x87, 0x9f,
    0x4e, 0x66, 0xb7, 0x0e, 0x17, 0x1f, 0x8e, 0x46, 0x5b, 0x65, 0x18, 0xbc, 0x01, 0x24, 0xd1, 0xea,
    0xed
};
#endif

PyTypeObject *init_KJobUiDelegate(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX].type;

    Shiboken::AutoDecRef Sbk_KJobUiDelegate_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_KJobUiDelegate_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KJobUiDelegate",
        "KJobUiDelegate*",
        &Sbk_KJobUiDelegate_spec,
        &Shiboken::callCppDestructor< KJobUiDelegate >,
        Sbk_KJobUiDelegate_Type_bases.object(),
        0);
    auto *pyType = Sbk_KJobUiDelegate_TypeF(); // references _Sbk_KJobUiDelegate_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KJobUiDelegate_SignatureStrings);
#else
    InitSignatureBytes(pyType, KJobUiDelegate_SignatureBytes, KJobUiDelegate_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KJobUiDelegate_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KJobUiDelegate_PythonToCpp_KJobUiDelegate_PTR,
        is_KJobUiDelegate_PythonToCpp_KJobUiDelegate_PTR_Convertible,
        KJobUiDelegate_PTR_CppToPython_KJobUiDelegate);

    Shiboken::Conversions::registerConverterName(converter, "KJobUiDelegate");
    Shiboken::Conversions::registerConverterName(converter, "KJobUiDelegate*");
    Shiboken::Conversions::registerConverterName(converter, "KJobUiDelegate&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KJobUiDelegate).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KJobUiDelegateWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KJobUiDelegate_TypeF(), &Sbk_KJobUiDelegate_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KJobUiDelegate_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Flag'.
    const char *Flag_Initializer[] = {
        "AutoHandlingDisabled",
        "AutoErrorHandlingEnabled",
        "AutoWarningHandlingEnabled",
        "AutoHandlingEnabled",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Flag_InitializerValues[] = {
        uint8_t(KJobUiDelegate::Flag::AutoHandlingDisabled),       //  0x00  0
        uint8_t(KJobUiDelegate::Flag::AutoErrorHandlingEnabled),   //  0x01  1
        uint8_t(KJobUiDelegate::Flag::AutoWarningHandlingEnabled), //  0x02  2
        uint8_t(KJobUiDelegate::Flag::AutoHandlingEnabled)         //  0x03  3
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KJobUiDelegate_TypeF(),
        "1:KCoreAddons.KJobUiDelegate.Flag",
        Flag_Initializer, Flag_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_Flag_IDX].type = EType;
    // PYSIDE-1735: Mapping the flags class to the same enum class.
    SbkKCoreAddonsTypeStructs[SBK_QFlags_KJobUiDelegate_Flag_IDX].type =
        EType;
    // Register converter for enum 'KJobUiDelegate::Flag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KJobUiDelegate_Flag_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KJobUiDelegate_Flag,
            is_Enum_PythonToCpp_KJobUiDelegate_Flag_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KJobUiDelegate::Flag");
        Shiboken::Conversions::registerConverterAlias(converter, "Flag");
        SbkConverter *flagsConverter = Shiboken::Conversions::createConverter(EType,
            KJobUiDelegate_Flag_CppToPython_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(flagsConverter,
            Flag_PythonToCpp_KJobUiDelegate_Flag,
            is_Enum_PythonToCpp_KJobUiDelegate_Flag_Convertible);
        // Register converter for flag 'QFlags<KJobUiDelegate::Flag>'.
        Shiboken::Conversions::registerConverterName(flagsConverter, "QFlags<KJobUiDelegate::Flag>");
        Shiboken::Conversions::registerConverterName(flagsConverter, "KJobUiDelegate::Flags");
        Shiboken::Enum::setTypeConverter(EType, converter, flagsConverter);
    }
    // End of 'Flag' enum/flags.

    qRegisterMetaType< ::KJobUiDelegate::Flag >("KJobUiDelegate::Flag");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KJobUiDelegate::staticMetaObject, sizeof(KJobUiDelegateWrapper));

    return pyType;
}
