
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <QtCore/QBuffer>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kpluginmetadata_wrapper.h"

// Argument includes
#include <QList>
#include <QString>
#include <QStringList>
#include <QStringView>
#include <kaboutdata.h>
#include <kpluginmetadata.h>
#include <qjsonobject.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpluginloader.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KPluginMetaData_Type = nullptr;
static PyTypeObject *Sbk_KPluginMetaData_TypeF(void)
{
    return _Sbk_KPluginMetaData_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KPluginMetaData_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KPluginMetaData >()))
        return -1;

    ::KPluginMetaData *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]);

    if (PyArg_ParseTuple(args, "|OO:KPluginMetaData", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KPluginMetaData::KPluginMetaData()
    // 1: KPluginMetaData::KPluginMetaData(KPluginMetaData)
    // 2: KPluginMetaData::KPluginMetaData(QJsonObject,QString)
    // 3: KPluginMetaData::KPluginMetaData(QPluginLoader,QFlags<KPluginMetaData::KPluginMetaDataOption>=)
    // 4: KPluginMetaData::KPluginMetaData(QString,QFlags<KPluginMetaData::KPluginMetaDataOption>=)
    if (numArgs == 0) {
        overloadId = 0; // KPluginMetaData()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 4; // KPluginMetaData(QString,QFlags<KPluginMetaData::KPluginMetaDataOption>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_QFlags_KPluginMetaData_KPluginMetaDataOption_IDX])))->flagsConverter, (pyArgs[1])))) {
            overloadId = 4; // KPluginMetaData(QString,QFlags<KPluginMetaData::KPluginMetaDataOption>)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPluginLoader_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 3; // KPluginMetaData(QPluginLoader,QFlags<KPluginMetaData::KPluginMetaDataOption>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_QFlags_KPluginMetaData_KPluginMetaDataOption_IDX])))->flagsConverter, (pyArgs[1])))) {
            overloadId = 3; // KPluginMetaData(QPluginLoader,QFlags<KPluginMetaData::KPluginMetaDataOption>)
        }
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QJsonObject_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 2; // KPluginMetaData(QJsonObject,QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), (pyArgs[0])))) {
        overloadId = 1; // KPluginMetaData(KPluginMetaData)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KPluginMetaData()
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]);
            }

            // KPluginMetaData()
            cptr = new ::KPluginMetaData();
            break;
        }
        case 1: // KPluginMetaData(const KPluginMetaData &arg__1)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]);
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::KPluginMetaData *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KPluginMetaData(KPluginMetaData)
                cptr = new ::KPluginMetaData(*cppArg0);
            }
            break;
        }
        case 2: // KPluginMetaData(const QJsonObject &metaData, const QString &fileName)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]);
            }
            ::QJsonObject cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KPluginMetaData(QJsonObject,QString)
                cptr = new ::KPluginMetaData(cppArg0, cppArg1);
            }
            break;
        }
        case 3: // KPluginMetaData(const QPluginLoader &loader, QFlags<KPluginMetaData::KPluginMetaDataOption> options)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"options", 1}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_QFlags_KPluginMetaData_KPluginMetaDataOption_IDX])))->flagsConverter, (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPluginLoader *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<KPluginMetaData::KPluginMetaDataOption> cppArg1{};
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KPluginMetaData(QPluginLoader,QFlags<KPluginMetaData::KPluginMetaDataOption>)
                cptr = new ::KPluginMetaData(*cppArg0, cppArg1);
            }
            break;
        }
        case 4: // KPluginMetaData(const QString &pluginFile, QFlags<KPluginMetaData::KPluginMetaDataOption> options)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"options", 1}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_QFlags_KPluginMetaData_KPluginMetaDataOption_IDX])))->flagsConverter, (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<KPluginMetaData::KPluginMetaDataOption> cppArg1{};
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KPluginMetaData(QString,QFlags<KPluginMetaData::KPluginMetaDataOption>)
                cptr = new ::KPluginMetaData(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::KPluginMetaData >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KPluginMetaDataFunc_authors(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginMetaData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // authors()const
        QList<KAboutPerson> cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->authors();
        pyResult = Shiboken::Conversions::copyToPython(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KAboutPerson_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPluginMetaDataFunc_bugReportUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginMetaData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // bugReportUrl()const
        QString cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->bugReportUrl();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPluginMetaDataFunc_category(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginMetaData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // category()const
        QString cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->category();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPluginMetaDataFunc_copyrightText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginMetaData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // copyrightText()const
        QString cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->copyrightText();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPluginMetaDataFunc_description(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginMetaData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // description()const
        QString cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->description();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPluginMetaDataFunc_fileName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginMetaData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // fileName()const
        QString cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->fileName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPluginMetaDataFunc_findPluginById(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "findPluginById", errInfo, SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:findPluginById", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KPluginMetaData::findPluginById(QString,QString,QFlags<KPluginMetaData::KPluginMetaDataOption>=)->KPluginMetaData
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // findPluginById(QString,QString,QFlags<KPluginMetaData::KPluginMetaDataOption>)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_QFlags_KPluginMetaData_KPluginMetaDataOption_IDX])))->flagsConverter, (pyArgs[2])))) {
            overloadId = 0; // findPluginById(QString,QString,QFlags<KPluginMetaData::KPluginMetaDataOption>)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "findPluginById", errInfo, SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"options", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_QFlags_KPluginMetaData_KPluginMetaDataOption_IDX])))->flagsConverter, (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "findPluginById", errInfo, SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QFlags<KPluginMetaData::KPluginMetaDataOption> cppArg2{};
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // findPluginById(QString,QString,QFlags<KPluginMetaData::KPluginMetaDataOption>)
            KPluginMetaData* cppResult = new KPluginMetaData(::KPluginMetaData::findPluginById(cppArg0, cppArg1, cppArg2));
            pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), cppResult, true, true);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPluginMetaDataFunc_findPlugins(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KPluginMetaData::findPlugins(QString)->QList<KPluginMetaData>
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // findPlugins(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "findPlugins", errInfo, SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // findPlugins(QString)
            QList<KPluginMetaData> cppResult = ::KPluginMetaData::findPlugins(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KPluginMetaData_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPluginMetaDataFunc_formFactors(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginMetaData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // formFactors()const
        QStringList cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->formFactors();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPluginMetaDataFunc_fromJsonFile(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KPluginMetaData::fromJsonFile(QString)->KPluginMetaData
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // fromJsonFile(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "fromJsonFile", errInfo, SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // fromJsonFile(QString)
            KPluginMetaData* cppResult = new KPluginMetaData(::KPluginMetaData::fromJsonFile(cppArg0));
            pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), cppResult, true, true);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPluginMetaDataFunc_iconName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginMetaData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // iconName()const
        QString cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->iconName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPluginMetaDataFunc_isEnabledByDefault(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginMetaData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isEnabledByDefault()const
        bool cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->isEnabledByDefault();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPluginMetaDataFunc_isHidden(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginMetaData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isHidden()const
        bool cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->isHidden();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPluginMetaDataFunc_isStaticPlugin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginMetaData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isStaticPlugin()const
        bool cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->isStaticPlugin();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPluginMetaDataFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginMetaData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isValid()const
        bool cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->isValid();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPluginMetaDataFunc_license(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginMetaData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // license()const
        QString cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->license();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPluginMetaDataFunc_licenseText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginMetaData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // licenseText()const
        QString cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->licenseText();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPluginMetaDataFunc_mimeTypes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginMetaData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // mimeTypes()const
        QStringList cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->mimeTypes();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPluginMetaDataFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginMetaData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // name()const
        QString cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->name();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPluginMetaDataFunc_otherContributors(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginMetaData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // otherContributors()const
        QList<KAboutPerson> cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->otherContributors();
        pyResult = Shiboken::Conversions::copyToPython(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KAboutPerson_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPluginMetaDataFunc_pluginId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginMetaData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // pluginId()const
        QString cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->pluginId();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPluginMetaDataFunc_rawData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginMetaData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // rawData()const
        QJsonObject cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->rawData();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QJsonObject_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPluginMetaDataFunc_supportsMimeType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginMetaData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPluginMetaData::supportsMimeType(QString)const->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // supportsMimeType(QString)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "supportsMimeType", errInfo, SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // supportsMimeType(QString)const
            bool cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->supportsMimeType(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPluginMetaDataFunc_translators(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginMetaData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // translators()const
        QList<KAboutPerson> cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->translators();
        pyResult = Shiboken::Conversions::copyToPython(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KAboutPerson_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPluginMetaDataFunc_value(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginMetaData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "value", errInfo, SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]);

    if (PyArg_ParseTuple(args, "|OO:value", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KPluginMetaData::value(QStringView,bool)const->bool
    // 1: KPluginMetaData::value(QStringView,const QString&=)const->QString
    // 2: KPluginMetaData::value(QStringView,QStringList)const->QStringList
    // 3: KPluginMetaData::value(QStringView,int)const->int
    // 4: KPluginMetaData::value(QString,bool)const->bool
    // 5: KPluginMetaData::value(QString,const QString&=)const->QString
    // 6: KPluginMetaData::value(QString,QStringList)const->QStringList
    // 7: KPluginMetaData::value(QString,int)const->int
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 5; // value(QString,QString)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[1])))) {
            overloadId = 6; // value(QString,QStringList)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 5; // value(QString,QString)const
        } else if (numArgs == 2
            && PyBool_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 4; // value(QString,bool)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 7; // value(QString,int)const
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // value(QStringView,QString)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[1])))) {
            overloadId = 2; // value(QStringView,QStringList)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 1; // value(QStringView,QString)const
        } else if (numArgs == 2
            && PyBool_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // value(QStringView,bool)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 3; // value(QStringView,int)const
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "value", errInfo, SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // value(QStringView key, bool defaultValue) const
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "value", errInfo, SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]);
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            bool cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // value(QStringView,bool)const
                bool cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->value(QStringView(cppArg0), cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // value(QStringView key, const QString &defaultValue) const
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"defaultValue", 1}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "value", errInfo, SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // value(QStringView,QString)const
                QString cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->value(QStringView(cppArg0), cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
            }
            break;
        }
        case 2: // value(QStringView key, const QStringList &defaultValue) const
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "value", errInfo, SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]);
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QStringList cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // value(QStringView,QStringList)const
                QStringList cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->value(QStringView(cppArg0), cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
            }
            break;
        }
        case 3: // value(QStringView key, int defaultValue) const
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "value", errInfo, SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]);
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // value(QStringView,int)const
                int cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->value(QStringView(cppArg0), cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 4: // value(const QString &key, bool defaultValue) const
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "value", errInfo, SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]);
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            bool cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // value(QString,bool)const
                bool cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->value(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 5: // value(const QString &key, const QString &defaultValue) const
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"defaultValue", 1}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "value", errInfo, SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // value(QString,QString)const
                QString cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->value(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
            }
            break;
        }
        case 6: // value(const QString &key, const QStringList &defaultValue) const
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "value", errInfo, SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]);
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QStringList cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // value(QString,QStringList)const
                QStringList cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->value(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
            }
            break;
        }
        case 7: // value(const QString &key, int defaultValue) const
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "value", errInfo, SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]);
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // value(QString,int)const
                int cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->value(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPluginMetaDataFunc_version(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginMetaData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // version()const
        QString cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->version();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPluginMetaDataFunc_website(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginMetaData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // website()const
        QString cppResult = const_cast<const ::KPluginMetaData *>(cppSelf)->website();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KPluginMetaData_PropertyStrings[] = {
    "authors:",
    "bugReportUrl:",
    "category:",
    "copyrightText:",
    "description:",
    "fileName:",
    "formFactors:",
    "iconName:",
    "isEnabledByDefault:",
    "isHidden:",
    "isValid:",
    "license:",
    "licenseText:",
    "mimeTypes:",
    "name:",
    "otherContributors:",
    "pluginId:",
    "rawData:",
    "translators:",
    "version:",
    "website:",
    nullptr // Sentinel
};

static const char *Sbk_KPluginMetaData_EnumFlagInfo[] = {
    "KPluginMetaDataOption:IntFlag:KPluginMetaDataOptions",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KPluginMetaData_methods[] = {
    {"authors", reinterpret_cast<PyCFunction>(Sbk_KPluginMetaDataFunc_authors), METH_NOARGS, nullptr},
    {"bugReportUrl", reinterpret_cast<PyCFunction>(Sbk_KPluginMetaDataFunc_bugReportUrl), METH_NOARGS, nullptr},
    {"category", reinterpret_cast<PyCFunction>(Sbk_KPluginMetaDataFunc_category), METH_NOARGS, nullptr},
    {"copyrightText", reinterpret_cast<PyCFunction>(Sbk_KPluginMetaDataFunc_copyrightText), METH_NOARGS, nullptr},
    {"description", reinterpret_cast<PyCFunction>(Sbk_KPluginMetaDataFunc_description), METH_NOARGS, nullptr},
    {"fileName", reinterpret_cast<PyCFunction>(Sbk_KPluginMetaDataFunc_fileName), METH_NOARGS, nullptr},
    {"findPluginById", reinterpret_cast<PyCFunction>(Sbk_KPluginMetaDataFunc_findPluginById), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"findPlugins", reinterpret_cast<PyCFunction>(Sbk_KPluginMetaDataFunc_findPlugins), METH_O|METH_STATIC, nullptr},
    {"formFactors", reinterpret_cast<PyCFunction>(Sbk_KPluginMetaDataFunc_formFactors), METH_NOARGS, nullptr},
    {"fromJsonFile", reinterpret_cast<PyCFunction>(Sbk_KPluginMetaDataFunc_fromJsonFile), METH_O|METH_STATIC, nullptr},
    {"iconName", reinterpret_cast<PyCFunction>(Sbk_KPluginMetaDataFunc_iconName), METH_NOARGS, nullptr},
    {"isEnabledByDefault", reinterpret_cast<PyCFunction>(Sbk_KPluginMetaDataFunc_isEnabledByDefault), METH_NOARGS, nullptr},
    {"isHidden", reinterpret_cast<PyCFunction>(Sbk_KPluginMetaDataFunc_isHidden), METH_NOARGS, nullptr},
    {"isStaticPlugin", reinterpret_cast<PyCFunction>(Sbk_KPluginMetaDataFunc_isStaticPlugin), METH_NOARGS, nullptr},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_KPluginMetaDataFunc_isValid), METH_NOARGS, nullptr},
    {"license", reinterpret_cast<PyCFunction>(Sbk_KPluginMetaDataFunc_license), METH_NOARGS, nullptr},
    {"licenseText", reinterpret_cast<PyCFunction>(Sbk_KPluginMetaDataFunc_licenseText), METH_NOARGS, nullptr},
    {"mimeTypes", reinterpret_cast<PyCFunction>(Sbk_KPluginMetaDataFunc_mimeTypes), METH_NOARGS, nullptr},
    {"name", reinterpret_cast<PyCFunction>(Sbk_KPluginMetaDataFunc_name), METH_NOARGS, nullptr},
    {"otherContributors", reinterpret_cast<PyCFunction>(Sbk_KPluginMetaDataFunc_otherContributors), METH_NOARGS, nullptr},
    {"pluginId", reinterpret_cast<PyCFunction>(Sbk_KPluginMetaDataFunc_pluginId), METH_NOARGS, nullptr},
    {"rawData", reinterpret_cast<PyCFunction>(Sbk_KPluginMetaDataFunc_rawData), METH_NOARGS, nullptr},
    {"supportsMimeType", reinterpret_cast<PyCFunction>(Sbk_KPluginMetaDataFunc_supportsMimeType), METH_O, nullptr},
    {"translators", reinterpret_cast<PyCFunction>(Sbk_KPluginMetaDataFunc_translators), METH_NOARGS, nullptr},
    {"value", reinterpret_cast<PyCFunction>(Sbk_KPluginMetaDataFunc_value), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"version", reinterpret_cast<PyCFunction>(Sbk_KPluginMetaDataFunc_version), METH_NOARGS, nullptr},
    {"website", reinterpret_cast<PyCFunction>(Sbk_KPluginMetaDataFunc_website), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_KPluginMetaData_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::KPluginMetaData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), (pyArg)))) {
                // operator!=(const KPluginMetaData &other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::KPluginMetaData *cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf != (*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), (pyArg)))) {
                // operator==(const KPluginMetaData &other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::KPluginMetaData *cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf == (*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
    }

    return Shiboken::returnFromRichCompare(pyResult);
}

} // extern "C"

static Py_hash_t Sbk_KPluginMetaData_HashFunc(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginMetaData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Py_hash_t(qHash(cppSelf));
}

static int Sbk_KPluginMetaData_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KPluginMetaData_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
extern "C"
{
static PyObject *Sbk_KPluginMetaData__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginMetaData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    const auto idx = str.indexOf('(');
    auto *typeName = Py_TYPE(self)->tp_name;
    if (idx >= 0)
        str.replace(0, idx, typeName);
    str = str.trimmed();
    Shiboken::AutoDecRef tpDict(PepType_GetDict(Py_TYPE(self)));
    PyObject *mod = PyDict_GetItem(tpDict.object(), Shiboken::PyMagicName::module());
    if (mod != nullptr && std::strchr(typeName, '.') == nullptr)
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C


// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KPluginMetaData_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_KPluginMetaData__repr__)},
    {Py_tp_hash,        reinterpret_cast<void *>(&Sbk_KPluginMetaData_HashFunc)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KPluginMetaData_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KPluginMetaData_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_KPluginMetaData_richcompare)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KPluginMetaData_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KPluginMetaData_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KPluginMetaData_spec = {
    "1:KCoreAddons.KPluginMetaData",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KPluginMetaData_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KPluginMetaData_KPluginMetaDataOption(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KPluginMetaData::KPluginMetaDataOption>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KPluginMetaData::KPluginMetaDataOption *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KPluginMetaData_KPluginMetaDataOption_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_KPluginMetaDataOption_IDX])))
        return Enum_PythonToCpp_KPluginMetaData_KPluginMetaDataOption;
    return {};
}

static PyObject *KPluginMetaData_KPluginMetaDataOption_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KPluginMetaData::KPluginMetaDataOption>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KPluginMetaData::KPluginMetaDataOption *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Flag_PythonToCpp_KPluginMetaData_KPluginMetaDataOption(PyObject *pyIn, void *cppOut)
{
    const auto value = QFlags<::KPluginMetaData::KPluginMetaDataOption>::fromInt(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<QFlags<::KPluginMetaData::KPluginMetaDataOption> *>(cppOut) = value;

}

static PyObject *KPluginMetaData_KPluginMetaDataOption_CppToPython_Flag(const void *cppIn)
{
    const auto flags = *reinterpret_cast<const QFlags<::KPluginMetaData::KPluginMetaDataOption> *>(cppIn);
    return Shiboken::Enum::newItem(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_KPluginMetaDataOption_IDX]), flags.toInt());

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KPluginMetaData_PythonToCpp_KPluginMetaData_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KPluginMetaData_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KPluginMetaData_PythonToCpp_KPluginMetaData_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KPluginMetaData_TypeF()))
        return KPluginMetaData_PythonToCpp_KPluginMetaData_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KPluginMetaData_PTR_CppToPython_KPluginMetaData(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KPluginMetaData_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KPluginMetaData_TypeF(), const_cast<void *>(cppIn), false);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KPluginMetaData_SignatureStrings[] = {
    "4:KCoreAddons.KPluginMetaData(self,*:KeywordOnly=None,isValid:bool=None,isHidden:bool=None,fileName:QString=None,rawData:QJsonObject=None,name:QString=None,description:QString=None,authors:QList[KCoreAddons.KAboutPerson]=None,translators:QList[KCoreAddons.KAboutPerson]=None,otherContributors:QList[KCoreAddons.KAboutPerson]=None,category:QString=None,iconName:QString=None,license:QString=None,licenseText:QString=None,copyrightText:QString=None,pluginId:QString=None,version:QString=None,website:QString=None,bugReportUrl:QString=None,mimeTypes:QStringList=None,formFactors:QStringList=None,isEnabledByDefault:bool=None)",
    "3:KCoreAddons.KPluginMetaData(self,arg__1:KCoreAddons.KPluginMetaData,*:KeywordOnly=None,isValid:bool=None,isHidden:bool=None,fileName:QString=None,rawData:QJsonObject=None,name:QString=None,description:QString=None,authors:QList[KCoreAddons.KAboutPerson]=None,translators:QList[KCoreAddons.KAboutPerson]=None,otherContributors:QList[KCoreAddons.KAboutPerson]=None,category:QString=None,iconName:QString=None,license:QString=None,licenseText:QString=None,copyrightText:QString=None,pluginId:QString=None,version:QString=None,website:QString=None,bugReportUrl:QString=None,mimeTypes:QStringList=None,formFactors:QStringList=None,isEnabledByDefault:bool=None)",
    "2:KCoreAddons.KPluginMetaData(self,metaData:QJsonObject,fileName:QString,*:KeywordOnly=None,isValid:bool=None,isHidden:bool=None,fileName:QString=None,rawData:QJsonObject=None,name:QString=None,description:QString=None,authors:QList[KCoreAddons.KAboutPerson]=None,translators:QList[KCoreAddons.KAboutPerson]=None,otherContributors:QList[KCoreAddons.KAboutPerson]=None,category:QString=None,iconName:QString=None,license:QString=None,licenseText:QString=None,copyrightText:QString=None,pluginId:QString=None,version:QString=None,website:QString=None,bugReportUrl:QString=None,mimeTypes:QStringList=None,formFactors:QStringList=None,isEnabledByDefault:bool=None)",
    "1:KCoreAddons.KPluginMetaData(self,loader:PySide6.QtCore.QPluginLoader,options:KCoreAddons.KPluginMetaData.KPluginMetaDataOption={},*:KeywordOnly=None,isValid:bool=None,isHidden:bool=None,fileName:QString=None,rawData:QJsonObject=None,name:QString=None,description:QString=None,authors:QList[KCoreAddons.KAboutPerson]=None,translators:QList[KCoreAddons.KAboutPerson]=None,otherContributors:QList[KCoreAddons.KAboutPerson]=None,category:QString=None,iconName:QString=None,license:QString=None,licenseText:QString=None,copyrightText:QString=None,pluginId:QString=None,version:QString=None,website:QString=None,bugReportUrl:QString=None,mimeTypes:QStringList=None,formFactors:QStringList=None,isEnabledByDefault:bool=None)",
    "0:KCoreAddons.KPluginMetaData(self,pluginFile:QString,options:KCoreAddons.KPluginMetaData.KPluginMetaDataOption={},*:KeywordOnly=None,isValid:bool=None,isHidden:bool=None,fileName:QString=None,rawData:QJsonObject=None,name:QString=None,description:QString=None,authors:QList[KCoreAddons.KAboutPerson]=None,translators:QList[KCoreAddons.KAboutPerson]=None,otherContributors:QList[KCoreAddons.KAboutPerson]=None,category:QString=None,iconName:QString=None,license:QString=None,licenseText:QString=None,copyrightText:QString=None,pluginId:QString=None,version:QString=None,website:QString=None,bugReportUrl:QString=None,mimeTypes:QStringList=None,formFactors:QStringList=None,isEnabledByDefault:bool=None)",
    "KCoreAddons.KPluginMetaData.authors(self)->QList[KCoreAddons.KAboutPerson]",
    "KCoreAddons.KPluginMetaData.bugReportUrl(self)->QString",
    "KCoreAddons.KPluginMetaData.category(self)->QString",
    "KCoreAddons.KPluginMetaData.copyrightText(self)->QString",
    "KCoreAddons.KPluginMetaData.description(self)->QString",
    "KCoreAddons.KPluginMetaData.fileName(self)->QString",
    "KCoreAddons.KPluginMetaData.findPluginById(directory:QString,pluginId:QString,options:KCoreAddons.KPluginMetaData.KPluginMetaDataOption={})->KCoreAddons.KPluginMetaData",
    "KCoreAddons.KPluginMetaData.findPlugins(directory:QString)->QList[KCoreAddons.KPluginMetaData]",
    "KCoreAddons.KPluginMetaData.formFactors(self)->QStringList",
    "KCoreAddons.KPluginMetaData.fromJsonFile(jsonFile:QString)->KCoreAddons.KPluginMetaData",
    "KCoreAddons.KPluginMetaData.iconName(self)->QString",
    "KCoreAddons.KPluginMetaData.isEnabledByDefault(self)->bool",
    "KCoreAddons.KPluginMetaData.isHidden(self)->bool",
    "KCoreAddons.KPluginMetaData.isStaticPlugin(self)->bool",
    "KCoreAddons.KPluginMetaData.isValid(self)->bool",
    "KCoreAddons.KPluginMetaData.license(self)->QString",
    "KCoreAddons.KPluginMetaData.licenseText(self)->QString",
    "KCoreAddons.KPluginMetaData.mimeTypes(self)->QStringList",
    "KCoreAddons.KPluginMetaData.name(self)->QString",
    "KCoreAddons.KPluginMetaData.otherContributors(self)->QList[KCoreAddons.KAboutPerson]",
    "KCoreAddons.KPluginMetaData.pluginId(self)->QString",
    "KCoreAddons.KPluginMetaData.rawData(self)->QJsonObject",
    "KCoreAddons.KPluginMetaData.supportsMimeType(self,mimeType:QString)->bool",
    "KCoreAddons.KPluginMetaData.translators(self)->QList[KCoreAddons.KAboutPerson]",
    "7:KCoreAddons.KPluginMetaData.value(self,key:QString,defaultValue:bool)->bool",
    "6:KCoreAddons.KPluginMetaData.value(self,key:QString,defaultValue:QString=QString())->QString",
    "5:KCoreAddons.KPluginMetaData.value(self,key:QString,defaultValue:QStringList)->QStringList",
    "4:KCoreAddons.KPluginMetaData.value(self,key:QString,defaultValue:int)->int",
    "3:KCoreAddons.KPluginMetaData.value(self,key:QString,defaultValue:bool)->bool",
    "2:KCoreAddons.KPluginMetaData.value(self,key:QString,defaultValue:QString=QString())->QString",
    "1:KCoreAddons.KPluginMetaData.value(self,key:QString,defaultValue:QStringList)->QStringList",
    "0:KCoreAddons.KPluginMetaData.value(self,key:QString,defaultValue:int)->int",
    "KCoreAddons.KPluginMetaData.version(self)->QString",
    "KCoreAddons.KPluginMetaData.website(self)->QString",
    "KCoreAddons.KPluginMetaData.__ne__(self,other:KCoreAddons.KPluginMetaData)->bool",
    "KCoreAddons.KPluginMetaData.__eq__(self,other:KCoreAddons.KPluginMetaData)->bool",
    "KCoreAddons.KPluginMetaData.__hash__(self)->int",
    nullptr}; // Sentinel
#else
static constexpr size_t KPluginMetaData_SignatureByteSize = 688;
static constexpr uint8_t KPluginMetaData_SignatureBytes[688] = {
    0x78, 0xda, 0xed, 0x98, 0xdf, 0x6f, 0xda, 0x30, 0x10, 0xc7, 0xdf, 0xf7, 0x97, 0xc0, 0xc4, 0xaa,
    0xd2, 0x75, 0x9d, 0x14, 0xa9, 0x93, 0xfa, 0x63, 0xd5, 0x3a, 0xda, 0x02, 0xa3, 0xeb, 0xcb, 0x34,
    0x45, 0x4e, 0x7c, 0x80, 0x3b, 0x63, 0x33, 0xdb, 0x29, 0x8b, 0xa6, 0xfd, 0xef, 0x4b, 0x62, 0x07,
    0x12, 0x52, 0x39, 0x78, 0xa4, 0xd2, 0x1e, 0xf2, 0x52, 0x9a, 0x3b, 0x7f, 0x8f, 0xf3, 0xdd, 0xc7,
    0x67, 0xe0, 0xd8, 0x1b, 0x5c, 0x70, 0x01, 0x67, 0x18, 0x73, 0x26, 0x0f, 0x06, 0x23, 0x1a, 0xcd,
    0x08, 0xbb, 0x05, 0x85, 0x2e, 0x91, 0x42, 0x1d, 0x09, 0x74, 0xda, 0x7b, 0xed, 0x0d, 0x20, 0x5e,
    0x71, 0x81, 0x87, 0x8c, 0xc6, 0xa7, 0x77, 0x9c, 0x41, 0x8f, 0xc8, 0x07, 0x44, 0x09, 0xf6, 0x02,
    0xce, 0x69, 0x6e, 0xf9, 0x44, 0x30, 0x06, 0x56, 0x30, 0x4d, 0x09, 0x85, 0x3b, 0xb4, 0x00, 0x6f,
    0x3c, 0x51, 0x82, 0xb0, 0x99, 0xb6, 0x0a, 0xb4, 0x4a, 0x43, 0x7b, 0xe3, 0xcf, 0x92, 0xb3, 0x61,
    0xf0, 0x08, 0xa1, 0xd2, 0x0e, 0x56, 0x59, 0x8a, 0x41, 0x86, 0x82, 0x2c, 0x15, 0xe1, 0xac, 0xec,
    0x40, 0x91, 0x9a, 0x73, 0x21, 0xbd, 0xf1, 0x0d, 0x91, 0xea, 0x5b, 0x69, 0x03, 0x67, 0x01, 0x8f,
    0xd4, 0x08, 0x44, 0x12, 0xfc, 0xbb, 0x5e, 0xac, 0x04, 0x62, 0x92, 0x22, 0xb5, 0xb3, 0x80, 0xab,
    0x39, 0x88, 0x0b, 0xce, 0x92, 0x37, 0x0c, 0xa2, 0xdd, 0x65, 0x21, 0x52, 0x30, 0xe3, 0x22, 0x2e,
    0xa7, 0x4a, 0x42, 0xce, 0xaa, 0x45, 0xa0, 0x24, 0x04, 0x26, 0x9f, 0x37, 0xde, 0xc3, 0x2f, 0x55,
    0x76, 0x84, 0x7c, 0x19, 0x0b, 0x32, 0x9b, 0xab, 0xaa, 0x6b, 0x99, 0xf5, 0xeb, 0x1a, 0x97, 0xad,
    0x4f, 0x49, 0x5e, 0x95, 0xa2, 0xad, 0x20, 0x90, 0x44, 0x6d, 0xbd, 0x67, 0x10, 0xcd, 0xbe, 0xc0,
    0x92, 0x0b, 0xf5, 0x55, 0xd0, 0xb2, 0x67, 0x41, 0x16, 0x70, 0x1f, 0x2f, 0x41, 0xe6, 0xe6, 0xb4,
    0x06, 0xa6, 0xb1, 0x5c, 0x2c, 0xae, 0x50, 0xa8, 0x4b, 0xb3, 0xed, 0x24, 0xf2, 0x23, 0x43, 0x01,
    0x05, 0x7c, 0x1e, 0x5f, 0xc2, 0x14, 0x45, 0x54, 0x6d, 0x90, 0xe8, 0xbe, 0x7a, 0x5b, 0x8f, 0x1b,
    0x12, 0x33, 0xdf, 0xef, 0xdb, 0xd6, 0xb5, 0x44, 0xb6, 0x44, 0x36, 0x46, 0xe4, 0x51, 0x3d, 0x91,
    0x0b, 0xf3, 0x54, 0x24, 0xa4, 0xc2, 0x52, 0x0b, 0x65, 0x0b, 0x65, 0x63, 0x50, 0xf6, 0xeb, 0xa1,
    0xa4, 0x1c, 0x61, 0x10, 0xde, 0x28, 0x9e, 0x10, 0x0c, 0x27, 0x07, 0x63, 0x95, 0x0a, 0x0e, 0xc6,
    0x7a, 0xe9, 0x4d, 0xe6, 0xec, 0xf1, 0x0c, 0x0a, 0x69, 0x0b, 0xb6, 0xfd, 0x3c, 0xcc, 0x24, 0xa7,
    0xbf, 0xff, 0xb4, 0x3c, 0xb7, 0x3c, 0x37, 0xc6, 0xf3, 0x61, 0x3d, 0xcf, 0x7a, 0x4b, 0x57, 0x09,
    0x3c, 0xeb, 0x89, 0xda, 0xe2, 0xdb, 0xe2, 0xfb, 0x5f, 0xe0, 0x6b, 0x03, 0xd0, 0x74, 0x35, 0x83,
    0xb8, 0xfb, 0xe6, 0x43, 0x4d, 0xd1, 0xad, 0xa1, 0x8a, 0xdb, 0x5a, 0xc7, 0xd3, 0x99, 0x5a, 0x75,
    0x79, 0x0f, 0x9d, 0x34, 0xc5, 0xee, 0xb8, 0x08, 0x0b, 0x78, 0xbb, 0xc8, 0xf2, 0x63, 0xe5, 0xa6,
    0x61, 0x58, 0x9b, 0xce, 0xe3, 0x6b, 0xdc, 0xc1, 0x44, 0x40, 0xda, 0xbe, 0x35, 0xab, 0x15, 0x8e,
    0xf6, 0x9a, 0x18, 0x49, 0x52, 0x16, 0xd9, 0x8e, 0x89, 0xca, 0x6a, 0x96, 0xcf, 0x43, 0x51, 0x8e,
    0x60, 0xe7, 0xa2, 0x40, 0xee, 0x56, 0xf9, 0xd2, 0xb8, 0x76, 0xa9, 0xe0, 0x8b, 0x74, 0x64, 0xa5,
    0x73, 0xb5, 0xf3, 0x68, 0xfe, 0x29, 0x64, 0xf6, 0xaf, 0x3b, 0xce, 0x07, 0x84, 0x4b, 0x3b, 0xab,
    0x67, 0x2c, 0x57, 0xa7, 0x47, 0xad, 0x46, 0xaa, 0xe7, 0xb4, 0x83, 0x60, 0xa2, 0x90, 0x22, 0xa1,
    0x36, 0x3b, 0xc8, 0xb2, 0x1b, 0x62, 0xe7, 0xf5, 0x66, 0xf8, 0xb9, 0x54, 0xa1, 0x30, 0x2f, 0x5d,
    0x64, 0xeb, 0xc1, 0xe6, 0x4a, 0x00, 0x73, 0xec, 0x52, 0xe5, 0x1e, 0x69, 0x62, 0xb2, 0xe5, 0x07,
    0xd5, 0x25, 0x11, 0x73, 0xe5, 0xae, 0x25, 0x9b, 0x9b, 0xd7, 0x2a, 0x93, 0xd1, 0x32, 0x1d, 0xa1,
    0xf2, 0xd6, 0x14, 0xcc, 0x7c, 0x85, 0x33, 0x4f, 0x05, 0xf4, 0x6b, 0x9b, 0x5b, 0xb8, 0x82, 0x77,
    0xad, 0xc1, 0x7b, 0xeb, 0xe4, 0x79, 0x42, 0x34, 0x32, 0xf9, 0xfc, 0x80, 0xcd, 0x14, 0xc3, 0xfa,
    0x30, 0x3c, 0xa4, 0xde, 0xec, 0xd6, 0xc9, 0x93, 0x3b, 0xd9, 0x3b, 0x5a, 0x7e, 0x37, 0x9a, 0xd7,
    0x4e, 0xb7, 0x50, 0xfb, 0x77, 0x4d, 0x45, 0x4f, 0x6b, 0xb2, 0x05, 0xe4, 0xf1, 0xde, 0xb1, 0x09,
    0x4b, 0x63, 0x26, 0x7f, 0xed, 0x3f, 0x19, 0x39, 0xd7, 0xf4, 0xe8, 0x45, 0x6b, 0xda, 0x7f, 0xc1,
    0x9a, 0x1e, 0x36, 0x58, 0x53, 0x6b, 0x24, 0xfd, 0x31, 0xcc, 0xe5, 0xa8, 0x9a, 0x0f, 0x69, 0x2e,
    0x12, 0xdf, 0x67, 0xe0, 0xfb, 0x3a, 0xe1, 0x6c, 0xe4, 0xd8, 0x76, 0xb7, 0xcb, 0x69, 0xf5, 0x7d,
    0xf8, 0xd9, 0x70, 0xc0, 0x39, 0x92, 0x73, 0x13, 0xd2, 0xd4, 0xed, 0x2f, 0x58, 0xe0, 0x98, 0xd1
};
#endif

PyTypeObject *init_KPluginMetaData(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX].type;

    Shiboken::AutoDecRef Sbk_KPluginMetaData_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KPluginMetaData_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KPluginMetaData",
        "KPluginMetaData*",
        &Sbk_KPluginMetaData_spec,
        &Shiboken::callCppDestructor< ::KPluginMetaData >,
        Sbk_KPluginMetaData_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KPluginMetaData_Type; // references _Sbk_KPluginMetaData_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KPluginMetaData_SignatureStrings);
#else
    InitSignatureBytes(pyType, KPluginMetaData_SignatureBytes, KPluginMetaData_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KPluginMetaData_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KPluginMetaData_PythonToCpp_KPluginMetaData_PTR,
        is_KPluginMetaData_PythonToCpp_KPluginMetaData_PTR_Convertible,
        KPluginMetaData_PTR_CppToPython_KPluginMetaData);

    Shiboken::Conversions::registerConverterName(converter, "KPluginMetaData");
    Shiboken::Conversions::registerConverterName(converter, "KPluginMetaData*");
    Shiboken::Conversions::registerConverterName(converter, "KPluginMetaData&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KPluginMetaData).name());

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KPluginMetaData_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'KPluginMetaDataOption'.
    const char *KPluginMetaDataOption_Initializer[] = {
        "AllowEmptyMetaData",
        "CacheMetaData",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t KPluginMetaDataOption_InitializerValues[] = {
        uint8_t(KPluginMetaData::KPluginMetaDataOption::AllowEmptyMetaData), //  0x01  1
        uint8_t(KPluginMetaData::KPluginMetaDataOption::CacheMetaData)       //  0x02  2
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KPluginMetaData_TypeF(),
        "1:KCoreAddons.KPluginMetaData.KPluginMetaDataOption",
        KPluginMetaDataOption_Initializer, KPluginMetaDataOption_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_KPluginMetaDataOption_IDX].type = EType;
    // PYSIDE-1735: Mapping the flags class to the same enum class.
    SbkKCoreAddonsTypeStructs[SBK_QFlags_KPluginMetaData_KPluginMetaDataOption_IDX].type =
        EType;
    // Register converter for enum 'KPluginMetaData::KPluginMetaDataOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KPluginMetaData_KPluginMetaDataOption_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KPluginMetaData_KPluginMetaDataOption,
            is_Enum_PythonToCpp_KPluginMetaData_KPluginMetaDataOption_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KPluginMetaData::KPluginMetaDataOption");
        Shiboken::Conversions::registerConverterAlias(converter, "KPluginMetaDataOption");
        SbkConverter *flagsConverter = Shiboken::Conversions::createConverter(EType,
            KPluginMetaData_KPluginMetaDataOption_CppToPython_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(flagsConverter,
            Flag_PythonToCpp_KPluginMetaData_KPluginMetaDataOption,
            is_Enum_PythonToCpp_KPluginMetaData_KPluginMetaDataOption_Convertible);
        // Register converter for flag 'QFlags<KPluginMetaData::KPluginMetaDataOption>'.
        Shiboken::Conversions::registerConverterName(flagsConverter, "QFlags<KPluginMetaData::KPluginMetaDataOption>");
        Shiboken::Conversions::registerConverterName(flagsConverter, "KPluginMetaData::KPluginMetaDataOptions");
        Shiboken::Enum::setTypeConverter(EType, converter, flagsConverter);
    }
    // End of 'KPluginMetaDataOption' enum/flags.

    qRegisterMetaType< ::KPluginMetaData *>();
    qRegisterMetaType< ::KPluginMetaData::KPluginMetaDataOption >("KPluginMetaData::KPluginMetaDataOption");

    return pyType;
}
