
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kguiaddons_python.h"

// main header
#include "kjobwindows_wrapper.h"

// Argument includes
#include <qobject.h>
#include <qwindow.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KJobWindows_Type = nullptr;
static PyTypeObject *Sbk_KJobWindows_TypeF(void)
{
    return _Sbk_KJobWindows_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KJobWindows_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNamespace("KJobWindows");
    return -1;
}

static PyObject *Sbk_KJobWindowsFunc_setWindow(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setWindow", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KJobWindows::setWindow(QObject*,QWindow*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QWindow_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setWindow(QObject*,QWindow*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setWindow", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKJobWindows_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QWindow *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setWindow(QObject*,QWindow*)
            ::KJobWindows::setWindow(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobWindowsFunc_window(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KJobWindows::window(QObject*)->QWindow*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArg)))) {
        overloadId = 0; // window(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "window", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKJobWindows_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // window(QObject*)
            QWindow * cppResult = ::KJobWindows::window(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QWindow_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KJobWindows_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KJobWindows_methods[] = {
    {"setWindow", reinterpret_cast<PyCFunction>(Sbk_KJobWindowsFunc_setWindow), METH_VARARGS|METH_STATIC, nullptr},
    {"window", reinterpret_cast<PyCFunction>(Sbk_KJobWindowsFunc_window), METH_O|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KJobWindows_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KJobWindows_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KJobWindows_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KJobWindows_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KJobWindows_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KJobWindows_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KJobWindows_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KJobWindows_spec = {
    "1:KGuiAddons.KJobWindows",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KJobWindows_slots
};

} //extern "C"

// Type conversion functions.

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KGuiAddonsKJobWindows_SignatureStrings[] = {
    "KGuiAddons.KJobWindows.setWindow(job:PySide6.QtCore.QObject,window:PySide6.QtGui.QWindow)",
    "KGuiAddons.KJobWindows.window(job:PySide6.QtCore.QObject)->PySide6.QtGui.QWindow",
    nullptr}; // Sentinel
#else
static constexpr size_t KGuiAddonsKJobWindows_SignatureByteSize = 90;
static constexpr uint8_t KGuiAddonsKJobWindows_SignatureBytes[90] = {
    0x78, 0xda, 0xf3, 0x76, 0x2f, 0xcd, 0x74, 0x4c, 0x49, 0xc9, 0xcf, 0x2b, 0xd6, 0xf3, 0xf6, 0xca,
    0x4f, 0x0a, 0xcf, 0xcc, 0x4b, 0xc9, 0x2f, 0x2f, 0xd6, 0x2b, 0x4e, 0x2d, 0x81, 0x30, 0x35, 0xb2,
    0xf2, 0x93, 0xac, 0x02, 0x2a, 0x83, 0x33, 0x53, 0x52, 0xcd, 0xf4, 0x02, 0x4b, 0x9c, 0xf3, 0x8b,
    0x52, 0xf5, 0x02, 0xfd, 0x93, 0xb2, 0x52, 0x93, 0x4b, 0x74, 0xca, 0xc1, 0x2a, 0x90, 0x64, 0x81,
    0x66, 0xe9, 0x05, 0x42, 0xf4, 0x69, 0x72, 0x79, 0x63, 0x37, 0xb9, 0x9c, 0x90, 0xb1, 0x9a, 0xba,
    0x76, 0x58, 0x4d, 0xe4, 0x02, 0x00, 0xd7, 0xfb, 0x3d, 0x24
};
#endif

PyTypeObject *init_KGuiAddonsKJobWindows(PyObject *module)
{
    if (SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKJobWindows_IDX].type != nullptr)
        return SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKJobWindows_IDX].type;

    Shiboken::AutoDecRef Sbk_KJobWindows_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KJobWindows_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KJobWindows",
        "KJobWindows",
        &Sbk_KJobWindows_spec,
        nullptr,
        Sbk_KJobWindows_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KJobWindows_Type; // references _Sbk_KJobWindows_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KGuiAddonsKJobWindows_SignatureStrings);
#else
    InitSignatureBytes(pyType, KGuiAddonsKJobWindows_SignatureBytes, KGuiAddonsKJobWindows_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KJobWindows_PropertyStrings);
    SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKJobWindows_IDX].type = pyType;



    return pyType;
}
