
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kjobwidgets_python.h"

// main header
#include "kuiserverv2jobtracker_wrapper.h"

// Wrappers providing overrides
#include "knotificationjobuidelegate_wrapper.h"
#include "kuiserverv2jobtracker_wrapper.h"

// Argument includes
#include <QString>
#include <kjob.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <utility>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KUiServerV2JobTracker_Type = nullptr;
static PyTypeObject *Sbk_KUiServerV2JobTracker_TypeF(void)
{
    return _Sbk_KUiServerV2JobTracker_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KUiServerV2JobTrackerWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KUiServerV2JobTrackerWrapper::KUiServerV2JobTrackerWrapper(::QObject * parent) : KUiServerV2JobTracker(parent)
{
}

void KUiServerV2JobTrackerWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerV2JobTracker_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_childEvent("KUiServerV2JobTracker", funcName, gil, pyOverride, event);
}

void KUiServerV2JobTrackerWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerV2JobTracker_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_connectNotify("KUiServerV2JobTracker", funcName, gil, pyOverride, signal);
}

void KUiServerV2JobTrackerWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerV2JobTracker_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_customEvent("KUiServerV2JobTracker", funcName, gil, pyOverride, event);
}

void KUiServerV2JobTrackerWrapper::description(::KJob * job, const ::QString & title, const ::std::pair<QString,QString> & field1, const ::std::pair<QString,QString> & field2)
{
    static const char *funcName = "description";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerV2JobTracker_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::KUiServerV2JobTracker::description(job, title, field1, field2);
    }
    sbk_o_description("KUiServerV2JobTracker", funcName, gil, pyOverride, job, title, field1, field2);
}

void KUiServerV2JobTrackerWrapper::sbk_o_description(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::KJob * job, const ::QString & title, const ::std::pair<QString,QString> & field1, const ::std::pair<QString,QString> & field2)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[4] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), job),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &title),
        Shiboken::Conversions::copyToPython(SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_std_pair_QString_QString_IDX], &field1),
        Shiboken::Conversions::copyToPython(SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_std_pair_QString_QString_IDX], &field2)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNNN)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), job),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &title),
        Shiboken::Conversions::copyToPython(SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_std_pair_QString_QString_IDX], &field1),
        Shiboken::Conversions::copyToPython(SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_std_pair_QString_QString_IDX], &field2)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 4, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
    Py_DECREF(pyArgArray[3]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KUiServerV2JobTrackerWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerV2JobTracker_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_connectNotify("KUiServerV2JobTracker", funcName, gil, pyOverride, signal);
}

bool KUiServerV2JobTrackerWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerV2JobTracker_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KNotificationJobUiDelegateWrapper::sbk_o_event("KUiServerV2JobTracker", funcName, gil, pyOverride, event);
}

bool KUiServerV2JobTrackerWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerV2JobTracker_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KNotificationJobUiDelegateWrapper::sbk_o_eventFilter("KUiServerV2JobTracker", funcName, gil, pyOverride, watched, event);
}

void KUiServerV2JobTrackerWrapper::finished(::KJob * job)
{
    static const char *funcName = "finished";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerV2JobTracker_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::KUiServerV2JobTracker::finished(job);
    }
    sbk_o_finished("KUiServerV2JobTracker", funcName, gil, pyOverride, job);
}

void KUiServerV2JobTrackerWrapper::sbk_o_finished(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::KJob * job)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), job)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), job)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KUiServerV2JobTrackerWrapper::infoMessage(::KJob * job, const ::QString & message)
{
    static const char *funcName = "infoMessage";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerV2JobTracker_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::KUiServerV2JobTracker::infoMessage(job, message);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_slotWarning("KUiServerV2JobTracker", funcName, gil, pyOverride, job, message);
}

void KUiServerV2JobTrackerWrapper::percent(::KJob * job, unsigned long percent)
{
    static const char *funcName = "percent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerV2JobTracker_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::KUiServerV2JobTracker::percent(job, percent);
    }
    sbk_o_percent("KUiServerV2JobTracker", funcName, gil, pyOverride, job, percent);
}

void KUiServerV2JobTrackerWrapper::sbk_o_percent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::KJob * job, unsigned long percent)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), job),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), &percent)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), job),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), &percent)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KUiServerV2JobTrackerWrapper::processedAmount(::KJob * job, ::KJob::Unit unit, qulonglong amount)
{
    static const char *funcName = "processedAmount";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerV2JobTracker_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::KUiServerV2JobTracker::processedAmount(job, unit, amount);
    }
    sbk_o_processedAmount("KUiServerV2JobTracker", funcName, gil, pyOverride, job, unit, amount);
}

void KUiServerV2JobTrackerWrapper::sbk_o_processedAmount(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::KJob * job, ::KJob::Unit unit, qulonglong amount)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[3] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), job),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_Unit_IDX])))->converter, &unit),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qulonglong>(), &amount)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNK)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), job),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_Unit_IDX])))->converter, &unit),
        amount
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 3, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KUiServerV2JobTrackerWrapper::registerJob(::KJob * job)
{
    static const char *funcName = "registerJob";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerV2JobTracker_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::KUiServerV2JobTracker::registerJob(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KUiServerV2JobTracker", funcName, gil, pyOverride, job);
}

void KUiServerV2JobTrackerWrapper::resumed(::KJob * job)
{
    static const char *funcName = "resumed";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerV2JobTracker_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::KUiServerV2JobTracker::resumed(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KUiServerV2JobTracker", funcName, gil, pyOverride, job);
}

void KUiServerV2JobTrackerWrapper::speed(::KJob * job, unsigned long value)
{
    static const char *funcName = "speed";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerV2JobTracker_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::KUiServerV2JobTracker::speed(job, value);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_percent("KUiServerV2JobTracker", funcName, gil, pyOverride, job, value);
}

void KUiServerV2JobTrackerWrapper::suspended(::KJob * job)
{
    static const char *funcName = "suspended";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerV2JobTracker_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::KUiServerV2JobTracker::suspended(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KUiServerV2JobTracker", funcName, gil, pyOverride, job);
}

void KUiServerV2JobTrackerWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerV2JobTracker_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_timerEvent("KUiServerV2JobTracker", funcName, gil, pyOverride, event);
}

void KUiServerV2JobTrackerWrapper::totalAmount(::KJob * job, ::KJob::Unit unit, qulonglong amount)
{
    static const char *funcName = "totalAmount";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerV2JobTracker_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::KUiServerV2JobTracker::totalAmount(job, unit, amount);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_processedAmount("KUiServerV2JobTracker", funcName, gil, pyOverride, job, unit, amount);
}

void KUiServerV2JobTrackerWrapper::unregisterJob(::KJob * job)
{
    static const char *funcName = "unregisterJob";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerV2JobTracker_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::KUiServerV2JobTracker::unregisterJob(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KUiServerV2JobTracker", funcName, gil, pyOverride, job);
}

void KUiServerV2JobTrackerWrapper::warning(::KJob * job, const ::QString & message)
{
    static const char *funcName = "warning";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerV2JobTracker_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::warning(job, message);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_slotWarning("KUiServerV2JobTracker", funcName, gil, pyOverride, job, message);
}

const QMetaObject *KUiServerV2JobTrackerWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KUiServerV2JobTracker::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KUiServerV2JobTrackerWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KUiServerV2JobTracker::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KUiServerV2JobTrackerWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KUiServerV2JobTrackerWrapper *>(this));
    }
    return KUiServerV2JobTracker::qt_metacast(_clname);
}

KUiServerV2JobTrackerWrapper::~KUiServerV2JobTrackerWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KUiServerV2JobTracker_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KUiServerV2JobTracker_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KUiServerV2JobTracker >()))
        return -1;

    KUiServerV2JobTrackerWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KUiServerV2JobTracker", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KUiServerV2JobTracker::KUiServerV2JobTracker(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // KUiServerV2JobTracker(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KUiServerV2JobTracker(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KUiServerV2JobTracker(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KUiServerV2JobTrackerWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KUiServerV2JobTrackerWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KUiServerV2JobTracker >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KUiServerV2JobTrackerFunc_description(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUiServerV2JobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "description", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::description(KJob*,QString,std::pair<QString,QString>,std::pair<QString,QString>)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_std_pair_QString_QString_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_std_pair_QString_QString_IDX], (pyArgs[3])))) {
        overloadId = 0; // description(KJob*,QString,std::pair<QString,QString>,std::pair<QString,QString>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "description", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        std::pair<QString,QString> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        std::pair<QString,QString> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // description(KJob*,QString,std::pair<QString,QString>,std::pair<QString,QString>)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KUiServerV2JobTracker::description(cppArg0, cppArg1, cppArg2, cppArg3)
                : cppSelf->description(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUiServerV2JobTrackerFunc_finished(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUiServerV2JobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobTrackerInterface::finished(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // finished(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "finished", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // finished(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KUiServerV2JobTracker::finished(cppArg0)
                : cppSelf->finished(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUiServerV2JobTrackerFunc_infoMessage(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUiServerV2JobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "infoMessage", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::infoMessage(KJob*,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // infoMessage(KJob*,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "infoMessage", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // infoMessage(KJob*,QString)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KUiServerV2JobTracker::infoMessage(cppArg0, cppArg1)
                : cppSelf->infoMessage(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUiServerV2JobTrackerFunc_percent(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUiServerV2JobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "percent", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::percent(KJob*,ulong)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), (pyArgs[1])))) {
        overloadId = 0; // percent(KJob*,ulong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "percent", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned long cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // percent(KJob*,ulong)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KUiServerV2JobTracker::percent(cppArg0, cppArg1)
                : cppSelf->percent(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUiServerV2JobTrackerFunc_processedAmount(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUiServerV2JobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "processedAmount", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::processedAmount(KJob*,KJob::Unit,qulonglong)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_Unit_IDX])))->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qulonglong>(), (pyArgs[2])))) {
        overloadId = 0; // processedAmount(KJob*,KJob::Unit,qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "processedAmount", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::KJob::Unit cppArg1{KJob::Bytes};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        qulonglong cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // processedAmount(KJob*,KJob::Unit,qulonglong)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KUiServerV2JobTracker::processedAmount(cppArg0, cppArg1, cppArg2)
                : cppSelf->processedAmount(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUiServerV2JobTrackerFunc_registerJob(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUiServerV2JobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobTrackerInterface::registerJob(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // registerJob(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "registerJob", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // registerJob(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KUiServerV2JobTracker::registerJob(cppArg0)
                : cppSelf->registerJob(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUiServerV2JobTrackerFunc_resumed(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUiServerV2JobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobTrackerInterface::resumed(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // resumed(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "resumed", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // resumed(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KUiServerV2JobTracker::resumed(cppArg0)
                : cppSelf->resumed(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUiServerV2JobTrackerFunc_speed(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUiServerV2JobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "speed", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::speed(KJob*,ulong)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), (pyArgs[1])))) {
        overloadId = 0; // speed(KJob*,ulong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "speed", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned long cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // speed(KJob*,ulong)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KUiServerV2JobTracker::speed(cppArg0, cppArg1)
                : cppSelf->speed(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUiServerV2JobTrackerFunc_suspended(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUiServerV2JobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobTrackerInterface::suspended(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // suspended(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "suspended", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // suspended(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KUiServerV2JobTracker::suspended(cppArg0)
                : cppSelf->suspended(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUiServerV2JobTrackerFunc_totalAmount(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUiServerV2JobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "totalAmount", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::totalAmount(KJob*,KJob::Unit,qulonglong)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_Unit_IDX])))->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qulonglong>(), (pyArgs[2])))) {
        overloadId = 0; // totalAmount(KJob*,KJob::Unit,qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "totalAmount", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::KJob::Unit cppArg1{KJob::Bytes};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        qulonglong cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // totalAmount(KJob*,KJob::Unit,qulonglong)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KUiServerV2JobTracker::totalAmount(cppArg0, cppArg1, cppArg2)
                : cppSelf->totalAmount(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUiServerV2JobTrackerFunc_unregisterJob(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUiServerV2JobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobTrackerInterface::unregisterJob(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // unregisterJob(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "unregisterJob", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // unregisterJob(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KUiServerV2JobTracker::unregisterJob(cppArg0)
                : cppSelf->unregisterJob(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KUiServerV2JobTracker_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KUiServerV2JobTracker_methods[] = {
    {"description", reinterpret_cast<PyCFunction>(Sbk_KUiServerV2JobTrackerFunc_description), METH_VARARGS, nullptr},
    {"finished", reinterpret_cast<PyCFunction>(Sbk_KUiServerV2JobTrackerFunc_finished), METH_O, nullptr},
    {"infoMessage", reinterpret_cast<PyCFunction>(Sbk_KUiServerV2JobTrackerFunc_infoMessage), METH_VARARGS, nullptr},
    {"percent", reinterpret_cast<PyCFunction>(Sbk_KUiServerV2JobTrackerFunc_percent), METH_VARARGS, nullptr},
    {"processedAmount", reinterpret_cast<PyCFunction>(Sbk_KUiServerV2JobTrackerFunc_processedAmount), METH_VARARGS, nullptr},
    {"registerJob", reinterpret_cast<PyCFunction>(Sbk_KUiServerV2JobTrackerFunc_registerJob), METH_O, nullptr},
    {"resumed", reinterpret_cast<PyCFunction>(Sbk_KUiServerV2JobTrackerFunc_resumed), METH_O, nullptr},
    {"speed", reinterpret_cast<PyCFunction>(Sbk_KUiServerV2JobTrackerFunc_speed), METH_VARARGS, nullptr},
    {"suspended", reinterpret_cast<PyCFunction>(Sbk_KUiServerV2JobTrackerFunc_suspended), METH_O, nullptr},
    {"totalAmount", reinterpret_cast<PyCFunction>(Sbk_KUiServerV2JobTrackerFunc_totalAmount), METH_VARARGS, nullptr},
    {"unregisterJob", reinterpret_cast<PyCFunction>(Sbk_KUiServerV2JobTrackerFunc_unregisterJob), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KUiServerV2JobTracker_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KUiServerV2JobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KUiServerV2JobTrackerWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KUiServerV2JobTracker_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KUiServerV2JobTracker_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KUiServerV2JobTracker_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KUiServerV2JobTracker_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KUiServerV2JobTracker_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KUiServerV2JobTracker_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KUiServerV2JobTracker_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KUiServerV2JobTracker_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KUiServerV2JobTracker_spec = {
    "1:KJobWidgets.KUiServerV2JobTracker",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KUiServerV2JobTracker_slots
};

} //extern "C"

static void *Sbk_KUiServerV2JobTracker_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KUiServerV2JobTracker *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KUiServerV2JobTracker_PythonToCpp_KUiServerV2JobTracker_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KUiServerV2JobTracker_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KUiServerV2JobTracker_PythonToCpp_KUiServerV2JobTracker_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KUiServerV2JobTracker_TypeF()))
        return KUiServerV2JobTracker_PythonToCpp_KUiServerV2JobTracker_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KUiServerV2JobTracker_PTR_CppToPython_KUiServerV2JobTracker(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KUiServerV2JobTracker *>(const_cast<void *>(cppIn)), Sbk_KUiServerV2JobTracker_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KUiServerV2JobTracker_SignatureStrings[] = {
    "KJobWidgets.KUiServerV2JobTracker(self,parent:PySide6.QtCore.QObject=nullptr)",
    "KJobWidgets.KUiServerV2JobTracker.description(self,job:KCoreAddons.KJob,title:QString,field1:std.pair[QString, QString],field2:std.pair[QString, QString])",
    "KJobWidgets.KUiServerV2JobTracker.finished(self,job:KCoreAddons.KJob)",
    "KJobWidgets.KUiServerV2JobTracker.infoMessage(self,job:KCoreAddons.KJob,message:QString)",
    "KJobWidgets.KUiServerV2JobTracker.percent(self,job:KCoreAddons.KJob,percent:unsigned long)",
    "KJobWidgets.KUiServerV2JobTracker.processedAmount(self,job:KCoreAddons.KJob,unit:KCoreAddons.KJob.Unit,amount:qulonglong)",
    "KJobWidgets.KUiServerV2JobTracker.registerJob(self,job:KCoreAddons.KJob)",
    "KJobWidgets.KUiServerV2JobTracker.resumed(self,job:KCoreAddons.KJob)",
    "KJobWidgets.KUiServerV2JobTracker.speed(self,job:KCoreAddons.KJob,value:unsigned long)",
    "KJobWidgets.KUiServerV2JobTracker.suspended(self,job:KCoreAddons.KJob)",
    "KJobWidgets.KUiServerV2JobTracker.totalAmount(self,job:KCoreAddons.KJob,unit:KCoreAddons.KJob.Unit,amount:qulonglong)",
    "KJobWidgets.KUiServerV2JobTracker.unregisterJob(self,job:KCoreAddons.KJob)",
    nullptr}; // Sentinel
#else
static constexpr size_t KUiServerV2JobTracker_SignatureByteSize = 276;
static constexpr uint8_t KUiServerV2JobTracker_SignatureBytes[276] = {
    0x78, 0xda, 0xbd, 0x91, 0x31, 0x4f, 0xc3, 0x30, 0x10, 0x85, 0x77, 0x7e, 0x45, 0x47, 0x90, 0x22,
    0x4b, 0x74, 0x60, 0xb0, 0xc4, 0x50, 0xb1, 0x11, 0x21, 0x88, 0x42, 0x61, 0x40, 0x0c, 0x4e, 0x7c,
    0x09, 0x57, 0x1c, 0x3b, 0xdc, 0x9d, 0x2b, 0xf1, 0xef, 0x71, 0x49, 0x3b, 0x21, 0x82, 0x51, 0xa5,
    0x6e, 0xd6, 0xd3, 0xf3, 0x77, 0xef, 0xee, 0x95, 0xb7, 0xa1, 0x79, 0x46, 0xdb, 0x83, 0xb0, 0x2a,
    0xd7, 0x58, 0x03, 0x6d, 0x81, 0x9e, 0x96, 0x49, 0x7d, 0x24, 0xd3, 0xbe, 0x03, 0x9d, 0x33, 0xb8,
    0xae, 0x18, 0x0d, 0x81, 0x17, 0xfd, 0xf0, 0x59, 0xa3, 0x85, 0x2b, 0x55, 0xc9, 0x4d, 0x20, 0x50,
    0xd5, 0x7d, 0xb3, 0x81, 0x56, 0xae, 0x7d, 0x74, 0x6e, 0x14, 0xba, 0x38, 0x2b, 0xff, 0xa2, 0x29,
    0x0b, 0xdc, 0x12, 0x8e, 0x82, 0xc1, 0x4f, 0xe4, 0x4d, 0x68, 0x74, 0xb9, 0xa3, 0xad, 0xac, 0x0d,
    0x3e, 0x7d, 0x4b, 0xe6, 0x42, 0x50, 0x1c, 0xe8, 0xaa, 0x16, 0x42, 0xdf, 0x17, 0x1d, 0x82, 0xb3,
    0x97, 0x9a, 0xc5, 0xaa, 0xd1, 0x20, 0xbd, 0x1c, 0xf4, 0xc5, 0xfe, 0xf1, 0x3a, 0x39, 0x96, 0x33,
    0x8e, 0x9c, 0x68, 0x1d, 0x7a, 0xe4, 0x37, 0xb0, 0xbf, 0xe7, 0xca, 0xa1, 0xa0, 0xef, 0xc2, 0x1d,
    0x30, 0x9b, 0x1e, 0x66, 0x16, 0x1c, 0x26, 0xc7, 0x61, 0xc5, 0x1c, 0xf0, 0x08, 0xd4, 0xa6, 0x0e,
    0x66, 0xa0, 0x7b, 0x87, 0x8e, 0x9e, 0xb1, 0xf7, 0x60, 0x17, 0x2e, 0x64, 0xa2, 0x29, 0xb4, 0x29,
    0x10, 0xd8, 0xd5, 0x10, 0xe2, 0xec, 0x88, 0xe8, 0x51, 0x7e, 0xa8, 0x6a, 0x9d, 0xd4, 0xc2, 0x7c,
    0xff, 0xd5, 0x1f, 0x71, 0x37, 0x35, 0x77, 0x32, 0x41, 0x8f, 0x2c, 0x40, 0x49, 0x3a, 0xee, 0xec,
    0x04, 0x1c, 0x87, 0x63, 0xbb, 0xe3, 0x11, 0xe6, 0x10, 0xc5, 0xd6, 0xb8, 0x08, 0xff, 0x3f, 0x2f,
    0xc7, 0x04, 0xf6, 0xf6, 0xd8, 0x74, 0x12, 0xc4, 0xb8, 0x93, 0x37, 0x14, 0x7d, 0x66, 0x47, 0x5f,
    0x11, 0x4a, 0x90, 0xca
};
#endif

PyTypeObject *init_KUiServerV2JobTracker(PyObject *module)
{
    if (SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX].type != nullptr)
        return SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX].type;

    Shiboken::AutoDecRef Sbk_KUiServerV2JobTracker_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]))));

    _Sbk_KUiServerV2JobTracker_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KUiServerV2JobTracker",
        "KUiServerV2JobTracker*",
        &Sbk_KUiServerV2JobTracker_spec,
        &Shiboken::callCppDestructor< KUiServerV2JobTracker >,
        Sbk_KUiServerV2JobTracker_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KUiServerV2JobTracker_Type; // references _Sbk_KUiServerV2JobTracker_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KUiServerV2JobTracker_SignatureStrings);
#else
    InitSignatureBytes(pyType, KUiServerV2JobTracker_SignatureBytes, KUiServerV2JobTracker_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KUiServerV2JobTracker_PropertyStrings);
    SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KUiServerV2JobTracker_PythonToCpp_KUiServerV2JobTracker_PTR,
        is_KUiServerV2JobTracker_PythonToCpp_KUiServerV2JobTracker_PTR_Convertible,
        KUiServerV2JobTracker_PTR_CppToPython_KUiServerV2JobTracker);

    Shiboken::Conversions::registerConverterName(converter, "KUiServerV2JobTracker");
    Shiboken::Conversions::registerConverterName(converter, "KUiServerV2JobTracker*");
    Shiboken::Conversions::registerConverterName(converter, "KUiServerV2JobTracker&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KUiServerV2JobTracker).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KUiServerV2JobTrackerWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KUiServerV2JobTracker_TypeF(), &Sbk_KUiServerV2JobTracker_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KUiServerV2JobTracker::staticMetaObject, sizeof(KUiServerV2JobTrackerWrapper));

    return pyType;
}
