// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: plan.proto

package planning

import (
	bytes "bytes"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strconv "strconv"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// FIXME: should we just use a generic integer for this? Adding this enum here seems to fly in the face of the
// decoupling goal of not using a oneof above.
type NodeType int32

const (
	NODE_TYPE_UNKNOWN              NodeType = 0
	NODE_TYPE_VECTOR_SELECTOR      NodeType = 1
	NODE_TYPE_MATRIX_SELECTOR      NodeType = 2
	NODE_TYPE_AGGREGATE_EXPRESSION NodeType = 3
	NODE_TYPE_BINARY_EXPRESSION    NodeType = 4
	NODE_TYPE_FUNCTION_CALL        NodeType = 5
	NODE_TYPE_NUMBER_LITERAL       NodeType = 6
	NODE_TYPE_STRING_LITERAL       NodeType = 7
	NODE_TYPE_UNARY_EXPRESSION     NodeType = 8
	NODE_TYPE_SUBQUERY             NodeType = 9
	NODE_TYPE_DUPLICATE            NodeType = 10
)

var NodeType_name = map[int32]string{
	0:  "NODE_TYPE_UNKNOWN",
	1:  "NODE_TYPE_VECTOR_SELECTOR",
	2:  "NODE_TYPE_MATRIX_SELECTOR",
	3:  "NODE_TYPE_AGGREGATE_EXPRESSION",
	4:  "NODE_TYPE_BINARY_EXPRESSION",
	5:  "NODE_TYPE_FUNCTION_CALL",
	6:  "NODE_TYPE_NUMBER_LITERAL",
	7:  "NODE_TYPE_STRING_LITERAL",
	8:  "NODE_TYPE_UNARY_EXPRESSION",
	9:  "NODE_TYPE_SUBQUERY",
	10: "NODE_TYPE_DUPLICATE",
}

var NodeType_value = map[string]int32{
	"NODE_TYPE_UNKNOWN":              0,
	"NODE_TYPE_VECTOR_SELECTOR":      1,
	"NODE_TYPE_MATRIX_SELECTOR":      2,
	"NODE_TYPE_AGGREGATE_EXPRESSION": 3,
	"NODE_TYPE_BINARY_EXPRESSION":    4,
	"NODE_TYPE_FUNCTION_CALL":        5,
	"NODE_TYPE_NUMBER_LITERAL":       6,
	"NODE_TYPE_STRING_LITERAL":       7,
	"NODE_TYPE_UNARY_EXPRESSION":     8,
	"NODE_TYPE_SUBQUERY":             9,
	"NODE_TYPE_DUPLICATE":            10,
}

func (NodeType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_2d655ab2f7683c23, []int{0}
}

type EncodedQueryPlan struct {
	TimeRange EncodedQueryTimeRange `protobuf:"bytes,1,opt,name=timeRange,proto3" json:"timeRange"`
	Nodes     []*EncodedNode        `protobuf:"bytes,2,rep,name=nodes,proto3" json:"nodes,omitempty"`
	RootNode  int64                 `protobuf:"varint,3,opt,name=rootNode,proto3" json:"rootNode,omitempty"`
	// The original PromQL expression for this query.
	// May not accurately represent the query being executed if this query was built from a query plan representing a subexpression of a query.
	OriginalExpression string `protobuf:"bytes,4,opt,name=originalExpression,proto3" json:"originalExpression,omitempty"`
}

func (m *EncodedQueryPlan) Reset()      { *m = EncodedQueryPlan{} }
func (*EncodedQueryPlan) ProtoMessage() {}
func (*EncodedQueryPlan) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d655ab2f7683c23, []int{0}
}
func (m *EncodedQueryPlan) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EncodedQueryPlan) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EncodedQueryPlan.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EncodedQueryPlan) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EncodedQueryPlan.Merge(m, src)
}
func (m *EncodedQueryPlan) XXX_Size() int {
	return m.Size()
}
func (m *EncodedQueryPlan) XXX_DiscardUnknown() {
	xxx_messageInfo_EncodedQueryPlan.DiscardUnknown(m)
}

var xxx_messageInfo_EncodedQueryPlan proto.InternalMessageInfo

func (m *EncodedQueryPlan) GetTimeRange() EncodedQueryTimeRange {
	if m != nil {
		return m.TimeRange
	}
	return EncodedQueryTimeRange{}
}

func (m *EncodedQueryPlan) GetNodes() []*EncodedNode {
	if m != nil {
		return m.Nodes
	}
	return nil
}

func (m *EncodedQueryPlan) GetRootNode() int64 {
	if m != nil {
		return m.RootNode
	}
	return 0
}

func (m *EncodedQueryPlan) GetOriginalExpression() string {
	if m != nil {
		return m.OriginalExpression
	}
	return ""
}

type EncodedQueryTimeRange struct {
	StartT               int64 `protobuf:"varint,1,opt,name=startT,proto3" json:"startT,omitempty"`
	EndT                 int64 `protobuf:"varint,2,opt,name=endT,proto3" json:"endT,omitempty"`
	IntervalMilliseconds int64 `protobuf:"varint,3,opt,name=intervalMilliseconds,proto3" json:"intervalMilliseconds,omitempty"`
	IsInstant            bool  `protobuf:"varint,4,opt,name=isInstant,proto3" json:"isInstant,omitempty"`
}

func (m *EncodedQueryTimeRange) Reset()      { *m = EncodedQueryTimeRange{} }
func (*EncodedQueryTimeRange) ProtoMessage() {}
func (*EncodedQueryTimeRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d655ab2f7683c23, []int{1}
}
func (m *EncodedQueryTimeRange) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EncodedQueryTimeRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EncodedQueryTimeRange.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EncodedQueryTimeRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EncodedQueryTimeRange.Merge(m, src)
}
func (m *EncodedQueryTimeRange) XXX_Size() int {
	return m.Size()
}
func (m *EncodedQueryTimeRange) XXX_DiscardUnknown() {
	xxx_messageInfo_EncodedQueryTimeRange.DiscardUnknown(m)
}

var xxx_messageInfo_EncodedQueryTimeRange proto.InternalMessageInfo

func (m *EncodedQueryTimeRange) GetStartT() int64 {
	if m != nil {
		return m.StartT
	}
	return 0
}

func (m *EncodedQueryTimeRange) GetEndT() int64 {
	if m != nil {
		return m.EndT
	}
	return 0
}

func (m *EncodedQueryTimeRange) GetIntervalMilliseconds() int64 {
	if m != nil {
		return m.IntervalMilliseconds
	}
	return 0
}

func (m *EncodedQueryTimeRange) GetIsInstant() bool {
	if m != nil {
		return m.IsInstant
	}
	return false
}

type EncodedNode struct {
	// Why use this rather than a oneof field?
	// This allows us to define nodes in multiple packages without creating dependencies between them,
	// and allows us to define new kinds of nodes in other repositories (eg. the one used for Grafana Cloud Metrics).
	// Why use this rather than a Any value?
	// Any encodes the type name as a string (eg. 'type.googleapis.com/BinaryExpressionDetails'),
	// which means that the encoded form of an expression can be many times the size of the original PromQL expression.
	NodeType NodeType `protobuf:"varint,1,opt,name=nodeType,proto3,enum=planning.NodeType" json:"nodeType,omitempty"`
	Details  []byte   `protobuf:"bytes,2,opt,name=details,proto3" json:"details,omitempty"`
	Children []int64  `protobuf:"varint,3,rep,packed,name=children,proto3" json:"children,omitempty"`
	// The following fields will only be populated if this plan was generated with descriptions enabled.
	Type           string   `protobuf:"bytes,4,opt,name=type,proto3" json:"type,omitempty"`
	Description    string   `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	ChildrenLabels []string `protobuf:"bytes,6,rep,name=childrenLabels,proto3" json:"childrenLabels,omitempty"`
}

func (m *EncodedNode) Reset()      { *m = EncodedNode{} }
func (*EncodedNode) ProtoMessage() {}
func (*EncodedNode) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d655ab2f7683c23, []int{2}
}
func (m *EncodedNode) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EncodedNode) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EncodedNode.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EncodedNode) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EncodedNode.Merge(m, src)
}
func (m *EncodedNode) XXX_Size() int {
	return m.Size()
}
func (m *EncodedNode) XXX_DiscardUnknown() {
	xxx_messageInfo_EncodedNode.DiscardUnknown(m)
}

var xxx_messageInfo_EncodedNode proto.InternalMessageInfo

func (m *EncodedNode) GetNodeType() NodeType {
	if m != nil {
		return m.NodeType
	}
	return NODE_TYPE_UNKNOWN
}

func (m *EncodedNode) GetDetails() []byte {
	if m != nil {
		return m.Details
	}
	return nil
}

func (m *EncodedNode) GetChildren() []int64 {
	if m != nil {
		return m.Children
	}
	return nil
}

func (m *EncodedNode) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *EncodedNode) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *EncodedNode) GetChildrenLabels() []string {
	if m != nil {
		return m.ChildrenLabels
	}
	return nil
}

func init() {
	proto.RegisterEnum("planning.NodeType", NodeType_name, NodeType_value)
	proto.RegisterType((*EncodedQueryPlan)(nil), "planning.EncodedQueryPlan")
	proto.RegisterType((*EncodedQueryTimeRange)(nil), "planning.EncodedQueryTimeRange")
	proto.RegisterType((*EncodedNode)(nil), "planning.EncodedNode")
}

func init() { proto.RegisterFile("plan.proto", fileDescriptor_2d655ab2f7683c23) }

var fileDescriptor_2d655ab2f7683c23 = []byte{
	// 607 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x6c, 0x93, 0xcf, 0x6e, 0xd3, 0x4c,
	0x14, 0xc5, 0x3d, 0x71, 0x9a, 0x26, 0x37, 0x9f, 0x2a, 0x7f, 0x43, 0xff, 0x98, 0xb6, 0x4c, 0xad,
	0x2c, 0x50, 0x04, 0x52, 0x90, 0x02, 0x2f, 0xe0, 0xa4, 0x43, 0x64, 0xe1, 0x3a, 0xe9, 0xc4, 0x81,
	0x76, 0x15, 0xb9, 0xf1, 0x28, 0x58, 0x32, 0xe3, 0xc8, 0x36, 0x88, 0xee, 0x78, 0x04, 0x36, 0xbc,
	0x03, 0x8f, 0xd2, 0x15, 0x0a, 0xbb, 0xae, 0x10, 0x75, 0x37, 0x2c, 0xfb, 0x08, 0xc8, 0x4e, 0x53,
	0xbb, 0x25, 0xbb, 0x7b, 0xcf, 0xef, 0xf8, 0xce, 0xbd, 0x47, 0x32, 0xc0, 0xcc, 0x77, 0x44, 0x6b,
	0x16, 0x06, 0x71, 0x80, 0xab, 0x69, 0x2d, 0x3c, 0x31, 0xdd, 0xdd, 0x9c, 0x06, 0xd3, 0x20, 0x13,
	0x5f, 0xa4, 0xd5, 0x82, 0x37, 0xe6, 0x08, 0x14, 0x2a, 0x26, 0x81, 0xcb, 0xdd, 0xe3, 0x8f, 0x3c,
	0x3c, 0x1f, 0xf8, 0x8e, 0xc0, 0x5d, 0xa8, 0xc5, 0xde, 0x07, 0xce, 0x1c, 0x31, 0xe5, 0x2a, 0xd2,
	0x50, 0xb3, 0xde, 0x3e, 0x68, 0x2d, 0x07, 0xb5, 0x8a, 0x76, 0x7b, 0x69, 0xeb, 0x94, 0x2f, 0x7e,
	0x1d, 0x48, 0x2c, 0xff, 0x0e, 0x3f, 0x87, 0x35, 0x11, 0xb8, 0x3c, 0x52, 0x4b, 0x9a, 0xdc, 0xac,
	0xb7, 0xb7, 0xfe, 0x19, 0x60, 0x05, 0x2e, 0x67, 0x0b, 0x0f, 0xde, 0x85, 0x6a, 0x18, 0x04, 0x71,
	0x2a, 0xa9, 0xb2, 0x86, 0x9a, 0x32, 0xbb, 0xeb, 0x71, 0x0b, 0x70, 0x10, 0x7a, 0x53, 0x4f, 0x38,
	0x3e, 0xfd, 0x3c, 0x0b, 0x79, 0x14, 0x79, 0x81, 0x50, 0xcb, 0x1a, 0x6a, 0xd6, 0xd8, 0x0a, 0xd2,
	0xf8, 0x86, 0x60, 0x6b, 0xe5, 0x8e, 0x78, 0x1b, 0x2a, 0x51, 0xec, 0x84, 0xb1, 0x9d, 0x1d, 0x25,
	0xb3, 0xdb, 0x0e, 0x63, 0x28, 0x73, 0xe1, 0xda, 0x6a, 0x29, 0x53, 0xb3, 0x1a, 0xb7, 0x61, 0xd3,
	0x13, 0x31, 0x0f, 0x3f, 0x39, 0xfe, 0x91, 0xe7, 0xfb, 0x5e, 0xc4, 0x27, 0x81, 0x70, 0xa3, 0xdb,
	0xed, 0x56, 0x32, 0xbc, 0x0f, 0x35, 0x2f, 0x32, 0x44, 0x14, 0x3b, 0x22, 0xce, 0x16, 0xac, 0xb2,
	0x5c, 0x68, 0xfc, 0x44, 0x50, 0x2f, 0x9c, 0x8e, 0x5b, 0x50, 0x4d, 0x8f, 0xb7, 0xcf, 0x67, 0x8b,
	0x90, 0x37, 0xda, 0x38, 0xcf, 0xc8, 0xba, 0x25, 0xec, 0xce, 0x83, 0x55, 0x58, 0x77, 0x79, 0xec,
	0x78, 0x7e, 0x94, 0x2d, 0xfa, 0x1f, 0x5b, 0xb6, 0x69, 0x7a, 0x93, 0xf7, 0x9e, 0xef, 0x86, 0x5c,
	0xa8, 0xb2, 0x26, 0xa7, 0xe9, 0x2d, 0xfb, 0xf4, 0xb6, 0x38, 0x7d, 0x61, 0x91, 0x57, 0x56, 0x63,
	0x0d, 0xea, 0x2e, 0x8f, 0x26, 0xa1, 0x37, 0x8b, 0xd3, 0x28, 0xd7, 0x32, 0x54, 0x94, 0xf0, 0x53,
	0xd8, 0x58, 0x4e, 0x30, 0x9d, 0x33, 0xee, 0x47, 0x6a, 0x45, 0x93, 0x9b, 0x35, 0xf6, 0x40, 0x7d,
	0xf6, 0xa3, 0x04, 0xd5, 0xe5, 0xaa, 0x78, 0x0b, 0xfe, 0xb7, 0xfa, 0x87, 0x74, 0x6c, 0x9f, 0x0e,
	0xe8, 0x78, 0x64, 0xbd, 0xb1, 0xfa, 0xef, 0x2c, 0x45, 0xc2, 0x4f, 0xe0, 0x71, 0x2e, 0xbf, 0xa5,
	0x5d, 0xbb, 0xcf, 0xc6, 0x43, 0x6a, 0x66, 0x85, 0x82, 0xee, 0xe3, 0x23, 0xdd, 0x66, 0xc6, 0x49,
	0x8e, 0x4b, 0xb8, 0x01, 0x24, 0xc7, 0x7a, 0xaf, 0xc7, 0x68, 0x4f, 0xb7, 0xe9, 0x98, 0x9e, 0x0c,
	0x18, 0x1d, 0x0e, 0x8d, 0xbe, 0xa5, 0xc8, 0xf8, 0x00, 0xf6, 0x72, 0x4f, 0xc7, 0xb0, 0x74, 0x76,
	0x5a, 0x34, 0x94, 0xf1, 0x1e, 0xec, 0xe4, 0x86, 0xd7, 0x23, 0xab, 0x6b, 0x1b, 0x7d, 0x6b, 0xdc,
	0xd5, 0x4d, 0x53, 0x59, 0xc3, 0xfb, 0xa0, 0xe6, 0xd0, 0x1a, 0x1d, 0x75, 0x28, 0x1b, 0x9b, 0x86,
	0x4d, 0x99, 0x6e, 0x2a, 0x95, 0xfb, 0x74, 0x68, 0x33, 0xc3, 0xea, 0xdd, 0xd1, 0x75, 0x4c, 0x60,
	0xb7, 0x78, 0xf2, 0x83, 0x87, 0xab, 0x78, 0x1b, 0x70, 0xe1, 0xeb, 0x51, 0xe7, 0x78, 0x44, 0xd9,
	0xa9, 0x52, 0xc3, 0x3b, 0xf0, 0x28, 0xd7, 0x0f, 0x47, 0x03, 0xd3, 0xe8, 0xea, 0x36, 0x55, 0xa0,
	0xf3, 0x6a, 0x7e, 0x45, 0xa4, 0xcb, 0x2b, 0x22, 0xdd, 0x5c, 0x11, 0xf4, 0x25, 0x21, 0xe8, 0x7b,
	0x42, 0xd0, 0x45, 0x42, 0xd0, 0x3c, 0x21, 0xe8, 0x77, 0x42, 0xd0, 0x9f, 0x84, 0x48, 0x37, 0x09,
	0x41, 0x5f, 0xaf, 0x89, 0x34, 0xbf, 0x26, 0xd2, 0xe5, 0x35, 0x91, 0xce, 0x2a, 0xd9, 0xcf, 0xfc,
	0xf2, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x0d, 0x77, 0xd5, 0x67, 0xfa, 0x03, 0x00, 0x00,
}

func (x NodeType) String() string {
	s, ok := NodeType_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (this *EncodedQueryPlan) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*EncodedQueryPlan)
	if !ok {
		that2, ok := that.(EncodedQueryPlan)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.TimeRange.Equal(&that1.TimeRange) {
		return false
	}
	if len(this.Nodes) != len(that1.Nodes) {
		return false
	}
	for i := range this.Nodes {
		if !this.Nodes[i].Equal(that1.Nodes[i]) {
			return false
		}
	}
	if this.RootNode != that1.RootNode {
		return false
	}
	if this.OriginalExpression != that1.OriginalExpression {
		return false
	}
	return true
}
func (this *EncodedQueryTimeRange) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*EncodedQueryTimeRange)
	if !ok {
		that2, ok := that.(EncodedQueryTimeRange)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.StartT != that1.StartT {
		return false
	}
	if this.EndT != that1.EndT {
		return false
	}
	if this.IntervalMilliseconds != that1.IntervalMilliseconds {
		return false
	}
	if this.IsInstant != that1.IsInstant {
		return false
	}
	return true
}
func (this *EncodedNode) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*EncodedNode)
	if !ok {
		that2, ok := that.(EncodedNode)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NodeType != that1.NodeType {
		return false
	}
	if !bytes.Equal(this.Details, that1.Details) {
		return false
	}
	if len(this.Children) != len(that1.Children) {
		return false
	}
	for i := range this.Children {
		if this.Children[i] != that1.Children[i] {
			return false
		}
	}
	if this.Type != that1.Type {
		return false
	}
	if this.Description != that1.Description {
		return false
	}
	if len(this.ChildrenLabels) != len(that1.ChildrenLabels) {
		return false
	}
	for i := range this.ChildrenLabels {
		if this.ChildrenLabels[i] != that1.ChildrenLabels[i] {
			return false
		}
	}
	return true
}
func (this *EncodedQueryPlan) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&planning.EncodedQueryPlan{")
	s = append(s, "TimeRange: "+strings.Replace(this.TimeRange.GoString(), `&`, ``, 1)+",\n")
	if this.Nodes != nil {
		s = append(s, "Nodes: "+fmt.Sprintf("%#v", this.Nodes)+",\n")
	}
	s = append(s, "RootNode: "+fmt.Sprintf("%#v", this.RootNode)+",\n")
	s = append(s, "OriginalExpression: "+fmt.Sprintf("%#v", this.OriginalExpression)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *EncodedQueryTimeRange) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&planning.EncodedQueryTimeRange{")
	s = append(s, "StartT: "+fmt.Sprintf("%#v", this.StartT)+",\n")
	s = append(s, "EndT: "+fmt.Sprintf("%#v", this.EndT)+",\n")
	s = append(s, "IntervalMilliseconds: "+fmt.Sprintf("%#v", this.IntervalMilliseconds)+",\n")
	s = append(s, "IsInstant: "+fmt.Sprintf("%#v", this.IsInstant)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *EncodedNode) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&planning.EncodedNode{")
	s = append(s, "NodeType: "+fmt.Sprintf("%#v", this.NodeType)+",\n")
	s = append(s, "Details: "+fmt.Sprintf("%#v", this.Details)+",\n")
	s = append(s, "Children: "+fmt.Sprintf("%#v", this.Children)+",\n")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "Description: "+fmt.Sprintf("%#v", this.Description)+",\n")
	s = append(s, "ChildrenLabels: "+fmt.Sprintf("%#v", this.ChildrenLabels)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringPlan(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *EncodedQueryPlan) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EncodedQueryPlan) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EncodedQueryPlan) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.OriginalExpression) > 0 {
		i -= len(m.OriginalExpression)
		copy(dAtA[i:], m.OriginalExpression)
		i = encodeVarintPlan(dAtA, i, uint64(len(m.OriginalExpression)))
		i--
		dAtA[i] = 0x22
	}
	if m.RootNode != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.RootNode))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Nodes) > 0 {
		for iNdEx := len(m.Nodes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Nodes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlan(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	{
		size, err := m.TimeRange.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintPlan(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *EncodedQueryTimeRange) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EncodedQueryTimeRange) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EncodedQueryTimeRange) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.IsInstant {
		i--
		if m.IsInstant {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.IntervalMilliseconds != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.IntervalMilliseconds))
		i--
		dAtA[i] = 0x18
	}
	if m.EndT != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.EndT))
		i--
		dAtA[i] = 0x10
	}
	if m.StartT != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.StartT))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *EncodedNode) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EncodedNode) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EncodedNode) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ChildrenLabels) > 0 {
		for iNdEx := len(m.ChildrenLabels) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ChildrenLabels[iNdEx])
			copy(dAtA[i:], m.ChildrenLabels[iNdEx])
			i = encodeVarintPlan(dAtA, i, uint64(len(m.ChildrenLabels[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintPlan(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintPlan(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Children) > 0 {
		dAtA3 := make([]byte, len(m.Children)*10)
		var j2 int
		for _, num1 := range m.Children {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA3[j2] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j2++
			}
			dAtA3[j2] = uint8(num)
			j2++
		}
		i -= j2
		copy(dAtA[i:], dAtA3[:j2])
		i = encodeVarintPlan(dAtA, i, uint64(j2))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Details) > 0 {
		i -= len(m.Details)
		copy(dAtA[i:], m.Details)
		i = encodeVarintPlan(dAtA, i, uint64(len(m.Details)))
		i--
		dAtA[i] = 0x12
	}
	if m.NodeType != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.NodeType))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintPlan(dAtA []byte, offset int, v uint64) int {
	offset -= sovPlan(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *EncodedQueryPlan) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.TimeRange.Size()
	n += 1 + l + sovPlan(uint64(l))
	if len(m.Nodes) > 0 {
		for _, e := range m.Nodes {
			l = e.Size()
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	if m.RootNode != 0 {
		n += 1 + sovPlan(uint64(m.RootNode))
	}
	l = len(m.OriginalExpression)
	if l > 0 {
		n += 1 + l + sovPlan(uint64(l))
	}
	return n
}

func (m *EncodedQueryTimeRange) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StartT != 0 {
		n += 1 + sovPlan(uint64(m.StartT))
	}
	if m.EndT != 0 {
		n += 1 + sovPlan(uint64(m.EndT))
	}
	if m.IntervalMilliseconds != 0 {
		n += 1 + sovPlan(uint64(m.IntervalMilliseconds))
	}
	if m.IsInstant {
		n += 2
	}
	return n
}

func (m *EncodedNode) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NodeType != 0 {
		n += 1 + sovPlan(uint64(m.NodeType))
	}
	l = len(m.Details)
	if l > 0 {
		n += 1 + l + sovPlan(uint64(l))
	}
	if len(m.Children) > 0 {
		l = 0
		for _, e := range m.Children {
			l += sovPlan(uint64(e))
		}
		n += 1 + sovPlan(uint64(l)) + l
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovPlan(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovPlan(uint64(l))
	}
	if len(m.ChildrenLabels) > 0 {
		for _, s := range m.ChildrenLabels {
			l = len(s)
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	return n
}

func sovPlan(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozPlan(x uint64) (n int) {
	return sovPlan(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *EncodedQueryPlan) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForNodes := "[]*EncodedNode{"
	for _, f := range this.Nodes {
		repeatedStringForNodes += strings.Replace(f.String(), "EncodedNode", "EncodedNode", 1) + ","
	}
	repeatedStringForNodes += "}"
	s := strings.Join([]string{`&EncodedQueryPlan{`,
		`TimeRange:` + strings.Replace(strings.Replace(this.TimeRange.String(), "EncodedQueryTimeRange", "EncodedQueryTimeRange", 1), `&`, ``, 1) + `,`,
		`Nodes:` + repeatedStringForNodes + `,`,
		`RootNode:` + fmt.Sprintf("%v", this.RootNode) + `,`,
		`OriginalExpression:` + fmt.Sprintf("%v", this.OriginalExpression) + `,`,
		`}`,
	}, "")
	return s
}
func (this *EncodedQueryTimeRange) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&EncodedQueryTimeRange{`,
		`StartT:` + fmt.Sprintf("%v", this.StartT) + `,`,
		`EndT:` + fmt.Sprintf("%v", this.EndT) + `,`,
		`IntervalMilliseconds:` + fmt.Sprintf("%v", this.IntervalMilliseconds) + `,`,
		`IsInstant:` + fmt.Sprintf("%v", this.IsInstant) + `,`,
		`}`,
	}, "")
	return s
}
func (this *EncodedNode) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&EncodedNode{`,
		`NodeType:` + fmt.Sprintf("%v", this.NodeType) + `,`,
		`Details:` + fmt.Sprintf("%v", this.Details) + `,`,
		`Children:` + fmt.Sprintf("%v", this.Children) + `,`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Description:` + fmt.Sprintf("%v", this.Description) + `,`,
		`ChildrenLabels:` + fmt.Sprintf("%v", this.ChildrenLabels) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringPlan(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *EncodedQueryPlan) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EncodedQueryPlan: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EncodedQueryPlan: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TimeRange.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nodes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Nodes = append(m.Nodes, &EncodedNode{})
			if err := m.Nodes[len(m.Nodes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RootNode", wireType)
			}
			m.RootNode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RootNode |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginalExpression", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OriginalExpression = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EncodedQueryTimeRange) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EncodedQueryTimeRange: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EncodedQueryTimeRange: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartT", wireType)
			}
			m.StartT = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartT |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndT", wireType)
			}
			m.EndT = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndT |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntervalMilliseconds", wireType)
			}
			m.IntervalMilliseconds = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IntervalMilliseconds |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsInstant", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsInstant = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EncodedNode) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EncodedNode: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EncodedNode: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeType", wireType)
			}
			m.NodeType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeType |= NodeType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Details", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Details = append(m.Details[:0], dAtA[iNdEx:postIndex]...)
			if m.Details == nil {
				m.Details = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType == 0 {
				var v int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Children = append(m.Children, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthPlan
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthPlan
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.Children) == 0 {
					m.Children = make([]int64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPlan
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Children = append(m.Children, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Children", wireType)
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChildrenLabels", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ChildrenLabels = append(m.ChildrenLabels, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipPlan(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthPlan
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupPlan
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthPlan
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthPlan        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowPlan          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupPlan = fmt.Errorf("proto: unexpected end of group")
)
